<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Grado;
use App\Models\Sede;
use Illuminate\Http\Request;

class GradoController extends Controller
{
    public function index()
    {
        $grados = Grado::with('sede')->withCount('users')->orderBy('sede_id')->orderBy('nivel')->get();
        return view('admin.grados.index', compact('grados'));
    }

    public function create()
    {
        $sedes = Sede::where('activa', true)->get();
        return view('admin.grados.create', compact('sedes'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'sede_id' => 'required|exists:sedes,id',
            'nombre' => 'required|string|max:255',
            'nivel' => 'required|integer|min:1|max:12',
        ]);

        Grado::create([
            'sede_id' => $request->sede_id,
            'nombre' => $request->nombre,
            'nivel' => $request->nivel,
        ]);

        return redirect()->route('admin.grados.index')
            ->with('success', 'Grado creado exitosamente.');
    }

    public function edit(Grado $grado)
    {
        $sedes = Sede::where('activa', true)->get();
        return view('admin.grados.edit', compact('grado', 'sedes'));
    }

    public function update(Request $request, Grado $grado)
    {
        $request->validate([
            'sede_id' => 'required|exists:sedes,id',
            'nombre' => 'required|string|max:255',
            'nivel' => 'required|integer|min:1|max:12',
        ]);

        $grado->update([
            'sede_id' => $request->sede_id,
            'nombre' => $request->nombre,
            'nivel' => $request->nivel,
        ]);

        return redirect()->route('admin.grados.index')
            ->with('success', 'Grado actualizado exitosamente.');
    }

    public function destroy(Grado $grado)
    {
        if ($grado->users()->count() > 0) {
            return redirect()->route('admin.grados.index')
                ->with('error', 'No se puede eliminar el grado porque tiene estudiantes asignados.');
        }

        $grado->delete();
        
        return redirect()->route('admin.grados.index')
            ->with('success', 'Grado eliminado exitosamente.');
    }
}
