<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Sede;
use Illuminate\Http\Request;

class SedeController extends Controller
{
    public function index()
    {
        $sedes = Sede::withCount(['grados', 'candidatos'])->get();
        return view('admin.sedes.index', compact('sedes'));
    }

    public function create()
    {
        return view('admin.sedes.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:sedes,slug|regex:/^[a-z0-9\-]+$/',
            'direccion' => 'nullable|string|max:255',
        ]);

        Sede::create([
            'nombre' => $request->nombre,
            'slug' => $request->slug,
            'direccion' => $request->direccion,
            'activa' => true,
        ]);

        return redirect()->route('admin.sedes.index')
            ->with('success', 'Sede creada exitosamente. Link: /sede/' . $request->slug);
    }

    public function edit(Sede $sede)
    {
        return view('admin.sedes.edit', compact('sede'));
    }

    public function update(Request $request, Sede $sede)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:sedes,slug,' . $sede->id . '|regex:/^[a-z0-9\-]+$/',
            'direccion' => 'nullable|string|max:255',
            'activa' => 'boolean',
        ]);

        $sede->update([
            'nombre' => $request->nombre,
            'slug' => $request->slug,
            'direccion' => $request->direccion,
            'activa' => $request->has('activa'),
        ]);

        return redirect()->route('admin.sedes.index')
            ->with('success', 'Sede actualizada exitosamente.');
    }

    public function destroy(Sede $sede)
    {
        $sede->delete();
        
        return redirect()->route('admin.sedes.index')
            ->with('success', 'Sede eliminada exitosamente.');
    }
}
