<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Sede;
use Illuminate\Http\Request;

class SedeApiController extends Controller
{
    public function index()
    {
        $sedes = Sede::withCount(['grados', 'candidatos'])->get();
        return response()->json($sedes);
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:sedes',
            'activa' => 'boolean',
        ]);

        $sede = Sede::create($request->only(['nombre', 'slug', 'activa']));

        return response()->json($sede, 201);
    }

    public function show(Sede $sede)
    {
        return response()->json($sede->load(['grados', 'candidatos']));
    }

    public function update(Request $request, Sede $sede)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'slug' => 'required|string|max:255|unique:sedes,slug,' . $sede->id,
            'activa' => 'boolean',
        ]);

        $sede->update($request->only(['nombre', 'slug', 'activa']));

        return response()->json($sede);
    }

    public function destroy(Sede $sede)
    {
        $sede->delete();
        return response()->json(['message' => 'Sede eliminada correctamente']);
    }
}
