<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Grado extends Model
{
    use HasFactory;

    protected $fillable = [
        'sede_id',
        'nombre',
        'nivel',
    ];

    /**
     * Sede a la que pertenece este grado
     */
    public function sede(): BelongsTo
    {
        return $this->belongsTo(Sede::class);
    }

    /**
     * Estudiantes de este grado
     */
    public function estudiantes(): HasMany
    {
        return $this->hasMany(User::class);
    }

    /**
     * Alias para estudiantes (para withCount)
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
