<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Sede extends Model
{
    use HasFactory;

    protected $fillable = [
        'nombre',
        'slug',
        'direccion',
        'activa',
    ];

    protected $casts = [
        'activa' => 'boolean',
    ];

    /**
     * Resolve route binding by id (default) or slug
     */
    public function resolveRouteBinding($value, $field = null)
    {
        if ($field === 'slug' || !is_numeric($value)) {
            return $this->where('slug', $value)->firstOrFail();
        }
        return $this->where('id', $value)->firstOrFail();
    }

    /**
     * Grados de esta sede
     */
    public function grados(): HasMany
    {
        return $this->hasMany(Grado::class);
    }

    /**
     * Candidatos de esta sede
     */
    public function candidatos(): HasMany
    {
        return $this->hasMany(Candidato::class);
    }

    /**
     * Candidatos tipo personero de esta sede
     */
    public function personeros(): HasMany
    {
        return $this->hasMany(Candidato::class)->where('tipo', 'personero');
    }

    /**
     * Candidatos tipo contralor de esta sede
     */
    public function contralores(): HasMany
    {
        return $this->hasMany(Candidato::class)->where('tipo', 'contralor');
    }
}
