<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Voto extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'candidato_id',
    ];

    /**
     * Usuario que emitió el voto
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Candidato que recibió el voto
     */
    public function candidato(): BelongsTo
    {
        return $this->belongsTo(Candidato::class);
    }
}
