<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('grado_id')->nullable()->after('id')->constrained('grados')->onDelete('set null');
            $table->string('documento')->nullable()->unique()->after('name');
            $table->enum('role', ['admin', 'estudiante'])->default('estudiante')->after('email');
            $table->boolean('habilitado')->default(false)->after('role');
            $table->boolean('ha_votado_personero')->default(false)->after('habilitado');
            $table->boolean('ha_votado_contralor')->default(false)->after('ha_votado_personero');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['grado_id']);
            $table->dropColumn(['grado_id', 'documento', 'role', 'habilitado', 'ha_votado_personero', 'ha_votado_contralor']);
        });
    }
};
