<?php

namespace Database\Seeders;

use App\Models\Candidato;
use App\Models\Grado;
use App\Models\Sede;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Crear sede principal
        $sedePrincipal = Sede::create([
            'nombre' => 'Sede Principal - Las Huacas',
            'direccion' => 'Vereda Las Huacas',
            'activa' => true,
        ]);

        // Crear grados (6° a 11°)
        $grados = [];
        for ($nivel = 6; $nivel <= 11; $nivel++) {
            $grados[$nivel] = Grado::create([
                'sede_id' => $sedePrincipal->id,
                'nombre' => "Grado {$nivel}°",
                'nivel' => $nivel,
            ]);
        }

        // Crear candidatos de ejemplo para Personero
        Candidato::create([
            'sede_id' => $sedePrincipal->id,
            'nombre' => 'Carlos Mendoza',
            'tipo' => 'personero',
            'propuestas' => 'Mejorar las instalaciones deportivas. Crear más espacios de recreación. Promover actividades culturales.',
            'activo' => true,
        ]);

        Candidato::create([
            'sede_id' => $sedePrincipal->id,
            'nombre' => 'María García',
            'tipo' => 'personero',
            'propuestas' => 'Implementar programas de tutorías. Crear comités estudiantiles. Mejorar la comunicación con los docentes.',
            'activo' => true,
        ]);

        // Crear candidatos de ejemplo para Contralor
        Candidato::create([
            'sede_id' => $sedePrincipal->id,
            'nombre' => 'Andrés López',
            'tipo' => 'contralor',
            'propuestas' => 'Fiscalizar el uso de recursos. Promover la transparencia. Crear informes mensuales de gestión.',
            'activo' => true,
        ]);

        Candidato::create([
            'sede_id' => $sedePrincipal->id,
            'nombre' => 'Laura Martínez',
            'tipo' => 'contralor',
            'propuestas' => 'Vigilar el cumplimiento del manual de convivencia. Supervisar proyectos escolares. Fomentar la participación estudiantil.',
            'activo' => true,
        ]);

        // Crear usuario administrador
        User::create([
            'name' => 'Administrador',
            'email' => 'admin@ielashuacas.edu.co',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'habilitado' => true,
        ]);

        // Crear algunos estudiantes de ejemplo
        $estudiantes = [
            ['name' => 'Juan Pérez', 'documento' => '1001234567', 'grado' => 10],
            ['name' => 'Ana Rodríguez', 'documento' => '1001234568', 'grado' => 11],
            ['name' => 'Pedro Sánchez', 'documento' => '1001234569', 'grado' => 9],
            ['name' => 'Sofía Hernández', 'documento' => '1001234570', 'grado' => 8],
            ['name' => 'Diego Ramírez', 'documento' => '1001234571', 'grado' => 7],
        ];

        foreach ($estudiantes as $est) {
            User::create([
                'name' => $est['name'],
                'email' => strtolower(str_replace(' ', '.', $est['name'])) . '@estudiante.edu.co',
                'documento' => $est['documento'],
                'password' => Hash::make($est['documento']), // Contraseña = documento
                'grado_id' => $grados[$est['grado']]->id,
                'role' => 'estudiante',
                'habilitado' => true,
            ]);
        }
    }
}
