function _mergeNamespaces(n, m) {
	m.forEach(function (e) {
		e && typeof e !== 'string' && !Array.isArray(e) && Object.keys(e).forEach(function (k) {
			if (k !== 'default' && !(k in n)) {
				var d = Object.getOwnPropertyDescriptor(e, k);
				Object.defineProperty(n, k, d.get ? d : {
					enumerable: true,
					get: function () { return e[k]; }
				});
			}
		});
	});
	return Object.freeze(n);
}

var commonjsGlobal$1 = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof undefined !== 'undefined' ? undefined : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs$1 (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (Object.prototype.hasOwnProperty.call(n, '__esModule')) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			var isInstance = false;
      try {
        isInstance = this instanceof a;
      } catch {}
			if (isInstance) {
        return Reflect.construct(f, arguments, this.constructor);
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var lib$2 = {exports: {}};

var Stats = {};

var constants$2 = {};

var hasRequiredConstants$2;

function requireConstants$2 () {
	if (hasRequiredConstants$2) return constants$2;
	hasRequiredConstants$2 = 1;
	Object.defineProperty(constants$2, "__esModule", { value: true });
	constants$2.constants = void 0;
	constants$2.constants = {
	    O_RDONLY: 0,
	    O_WRONLY: 1,
	    O_RDWR: 2,
	    S_IFMT: 61440,
	    S_IFREG: 32768,
	    S_IFDIR: 16384,
	    S_IFCHR: 8192,
	    S_IFBLK: 24576,
	    S_IFIFO: 4096,
	    S_IFLNK: 40960,
	    S_IFSOCK: 49152,
	    O_CREAT: 64,
	    O_EXCL: 128,
	    O_NOCTTY: 256,
	    O_TRUNC: 512,
	    O_APPEND: 1024,
	    O_DIRECTORY: 65536,
	    O_NOATIME: 262144,
	    O_NOFOLLOW: 131072,
	    O_SYNC: 1052672,
	    O_SYMLINK: 2097152,
	    O_DIRECT: 16384,
	    O_NONBLOCK: 2048,
	    S_IRWXU: 448,
	    S_IRUSR: 256,
	    S_IWUSR: 128,
	    S_IXUSR: 64,
	    S_IRWXG: 56,
	    S_IRGRP: 32,
	    S_IWGRP: 16,
	    S_IXGRP: 8,
	    S_IRWXO: 7,
	    S_IROTH: 4,
	    S_IWOTH: 2,
	    S_IXOTH: 1,
	    F_OK: 0,
	    R_OK: 4,
	    W_OK: 2,
	    X_OK: 1,
	    UV_FS_SYMLINK_DIR: 1,
	    UV_FS_SYMLINK_JUNCTION: 2,
	    UV_FS_COPYFILE_EXCL: 1,
	    UV_FS_COPYFILE_FICLONE: 2,
	    UV_FS_COPYFILE_FICLONE_FORCE: 4,
	    COPYFILE_EXCL: 1,
	    COPYFILE_FICLONE: 2,
	    COPYFILE_FICLONE_FORCE: 4,
	};
	
	return constants$2;
}

var hasRequiredStats;

function requireStats () {
	if (hasRequiredStats) return Stats;
	hasRequiredStats = 1;
	Object.defineProperty(Stats, "__esModule", { value: true });
	Stats.Stats = void 0;
	const constants_1 = requireConstants$2();
	const { S_IFMT, S_IFDIR, S_IFREG, S_IFBLK, S_IFCHR, S_IFLNK, S_IFIFO, S_IFSOCK } = constants_1.constants;
	/**
	 * Statistics about a file/directory, like `fs.Stats`.
	 */
	let Stats$1 = class Stats {
	    static build(node, bigint = false) {
	        const stats = new Stats();
	        const { uid, gid, atime, mtime, ctime } = node;
	        const getStatNumber = !bigint ? number => number : number => BigInt(number);
	        // Copy all values on Stats from Node, so that if Node values
	        // change, values on Stats would still be the old ones,
	        // just like in Node fs.
	        stats.uid = getStatNumber(uid);
	        stats.gid = getStatNumber(gid);
	        stats.rdev = getStatNumber(node.rdev);
	        stats.blksize = getStatNumber(4096);
	        stats.ino = getStatNumber(node.ino);
	        stats.size = getStatNumber(node.getSize());
	        stats.blocks = getStatNumber(1);
	        stats.atime = atime;
	        stats.mtime = mtime;
	        stats.ctime = ctime;
	        stats.birthtime = ctime;
	        stats.atimeMs = getStatNumber(atime.getTime());
	        stats.mtimeMs = getStatNumber(mtime.getTime());
	        const ctimeMs = getStatNumber(ctime.getTime());
	        stats.ctimeMs = ctimeMs;
	        stats.birthtimeMs = ctimeMs;
	        if (bigint) {
	            stats.atimeNs = BigInt(atime.getTime()) * BigInt(1000000);
	            stats.mtimeNs = BigInt(mtime.getTime()) * BigInt(1000000);
	            const ctimeNs = BigInt(ctime.getTime()) * BigInt(1000000);
	            stats.ctimeNs = ctimeNs;
	            stats.birthtimeNs = ctimeNs;
	        }
	        stats.dev = getStatNumber(0);
	        stats.mode = getStatNumber(node.mode);
	        stats.nlink = getStatNumber(node.nlink);
	        return stats;
	    }
	    _checkModeProperty(property) {
	        return (Number(this.mode) & S_IFMT) === property;
	    }
	    isDirectory() {
	        return this._checkModeProperty(S_IFDIR);
	    }
	    isFile() {
	        return this._checkModeProperty(S_IFREG);
	    }
	    isBlockDevice() {
	        return this._checkModeProperty(S_IFBLK);
	    }
	    isCharacterDevice() {
	        return this._checkModeProperty(S_IFCHR);
	    }
	    isSymbolicLink() {
	        return this._checkModeProperty(S_IFLNK);
	    }
	    isFIFO() {
	        return this._checkModeProperty(S_IFIFO);
	    }
	    isSocket() {
	        return this._checkModeProperty(S_IFSOCK);
	    }
	};
	Stats.Stats = Stats$1;
	Stats.default = Stats$1;
	
	return Stats;
}

var Dirent = {};

var encoding = {};

var buffer$2 = {};

var base64Js = {};

var hasRequiredBase64Js;

function requireBase64Js () {
	if (hasRequiredBase64Js) return base64Js;
	hasRequiredBase64Js = 1;

	base64Js.byteLength = byteLength;
	base64Js.toByteArray = toByteArray;
	base64Js.fromByteArray = fromByteArray;

	var lookup = [];
	var revLookup = [];
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

	var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	for (var i = 0, len = code.length; i < len; ++i) {
	  lookup[i] = code[i];
	  revLookup[code.charCodeAt(i)] = i;
	}

	// Support decoding URL-safe base64 strings, as Node.js does.
	// See: https://en.wikipedia.org/wiki/Base64#URL_applications
	revLookup['-'.charCodeAt(0)] = 62;
	revLookup['_'.charCodeAt(0)] = 63;

	function getLens (b64) {
	  var len = b64.length;

	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // Trim off extra bytes after placeholder bytes are found
	  // See: https://github.com/beatgammit/base64-js/issues/42
	  var validLen = b64.indexOf('=');
	  if (validLen === -1) validLen = len;

	  var placeHoldersLen = validLen === len
	    ? 0
	    : 4 - (validLen % 4);

	  return [validLen, placeHoldersLen]
	}

	// base64 is 4/3 + up to two characters of the original data
	function byteLength (b64) {
	  var lens = getLens(b64);
	  var validLen = lens[0];
	  var placeHoldersLen = lens[1];
	  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
	}

	function _byteLength (b64, validLen, placeHoldersLen) {
	  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
	}

	function toByteArray (b64) {
	  var tmp;
	  var lens = getLens(b64);
	  var validLen = lens[0];
	  var placeHoldersLen = lens[1];

	  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));

	  var curByte = 0;

	  // if there are placeholders, only get up to the last complete 4 chars
	  var len = placeHoldersLen > 0
	    ? validLen - 4
	    : validLen;

	  var i;
	  for (i = 0; i < len; i += 4) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 18) |
	      (revLookup[b64.charCodeAt(i + 1)] << 12) |
	      (revLookup[b64.charCodeAt(i + 2)] << 6) |
	      revLookup[b64.charCodeAt(i + 3)];
	    arr[curByte++] = (tmp >> 16) & 0xFF;
	    arr[curByte++] = (tmp >> 8) & 0xFF;
	    arr[curByte++] = tmp & 0xFF;
	  }

	  if (placeHoldersLen === 2) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 2) |
	      (revLookup[b64.charCodeAt(i + 1)] >> 4);
	    arr[curByte++] = tmp & 0xFF;
	  }

	  if (placeHoldersLen === 1) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 10) |
	      (revLookup[b64.charCodeAt(i + 1)] << 4) |
	      (revLookup[b64.charCodeAt(i + 2)] >> 2);
	    arr[curByte++] = (tmp >> 8) & 0xFF;
	    arr[curByte++] = tmp & 0xFF;
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] +
	    lookup[num >> 12 & 0x3F] +
	    lookup[num >> 6 & 0x3F] +
	    lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp;
	  var output = [];
	  for (var i = start; i < end; i += 3) {
	    tmp =
	      ((uint8[i] << 16) & 0xFF0000) +
	      ((uint8[i + 1] << 8) & 0xFF00) +
	      (uint8[i + 2] & 0xFF);
	    output.push(tripletToBase64(tmp));
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  var tmp;
	  var len = uint8.length;
	  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
	  var parts = [];
	  var maxChunkLength = 16383; // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1];
	    parts.push(
	      lookup[tmp >> 2] +
	      lookup[(tmp << 4) & 0x3F] +
	      '=='
	    );
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
	    parts.push(
	      lookup[tmp >> 10] +
	      lookup[(tmp >> 4) & 0x3F] +
	      lookup[(tmp << 2) & 0x3F] +
	      '='
	    );
	  }

	  return parts.join('')
	}
	return base64Js;
}

var base64JsExports = requireBase64Js();

var ieee754 = {};

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredIeee754;

function requireIeee754 () {
	if (hasRequiredIeee754) return ieee754;
	hasRequiredIeee754 = 1;
	ieee754.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	};

	ieee754.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = ((value * c) - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	};
	return ieee754;
}

var ieee754Exports = requireIeee754();

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

const customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol['for'] === 'function') // eslint-disable-line dot-notation
    ? Symbol['for']('nodejs.util.inspect.custom') // eslint-disable-line dot-notation
    : null;

const INSPECT_MAX_BYTES = 50;

const K_MAX_LENGTH = 0x7fffffff;
const kMaxLength = K_MAX_LENGTH;

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  );
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    const arr = new Uint8Array(1);
    const proto = { foo: function () { return 42 } };
    Object.setPrototypeOf(proto, Uint8Array.prototype);
    Object.setPrototypeOf(arr, proto);
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
});

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
});

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  const buf = new Uint8Array(length);
  Object.setPrototypeOf(buf, Buffer.prototype);
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192; // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof SharedArrayBuffer !== 'undefined' &&
      (isInstance(value, SharedArrayBuffer) ||
      (value && isInstance(value.buffer, SharedArrayBuffer)))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  const valueOf = value.valueOf && value.valueOf();
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  const b = fromObject(value);
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length)
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
};

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype);
Object.setPrototypeOf(Buffer, Uint8Array);

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size);
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpreted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
};

function allocUnsafe (size) {
  assertSize(size);
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
};
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
};

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8';
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  const length = byteLength(string, encoding) | 0;
  let buf = createBuffer(length);

  const actual = buf.write(string, encoding);

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual);
  }

  return buf
}

function fromArrayLike (array) {
  const length = array.length < 0 ? 0 : checked(array.length) | 0;
  const buf = createBuffer(length);
  for (let i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255;
  }
  return buf
}

function fromArrayView (arrayView) {
  if (isInstance(arrayView, Uint8Array)) {
    const copy = new Uint8Array(arrayView);
    return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength)
  }
  return fromArrayLike(arrayView)
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  let buf;
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array);
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset);
  } else {
    buf = new Uint8Array(array, byteOffset, length);
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype);

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    const len = checked(obj.length) | 0;
    const buf = createBuffer(len);

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len);
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0;
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
};

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  let x = a.length;
  let y = b.length;

  for (let i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
};

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  let i;
  if (length === undefined) {
    length = 0;
    for (i = 0; i < list.length; ++i) {
      length += list[i].length;
    }
  }

  const buffer = Buffer.allocUnsafe(length);
  let pos = 0;
  for (i = 0; i < list.length; ++i) {
    let buf = list[i];
    if (isInstance(buf, Uint8Array)) {
      if (pos + buf.length > buffer.length) {
        if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf);
        buf.copy(buffer, pos);
      } else {
        Uint8Array.prototype.set.call(
          buffer,
          buf,
          pos
        );
      }
    } else if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    } else {
      buf.copy(buffer, pos);
    }
    pos += buf.length;
  }
  return buffer
};

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  const len = string.length;
  const mustMatch = (arguments.length > 2 && arguments[2] === true);
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  let loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer.byteLength = byteLength;

function slowToString (encoding, start, end) {
  let loweredCase = false;

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0;
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length;
  }

  if (end <= 0) {
    return ''
  }

  // Force coercion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0;
  start >>>= 0;

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8';

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase();
        loweredCase = true;
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true;

function swap (b, n, m) {
  const i = b[n];
  b[n] = b[m];
  b[m] = i;
}

Buffer.prototype.swap16 = function swap16 () {
  const len = this.length;
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (let i = 0; i < len; i += 2) {
    swap(this, i, i + 1);
  }
  return this
};

Buffer.prototype.swap32 = function swap32 () {
  const len = this.length;
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (let i = 0; i < len; i += 4) {
    swap(this, i, i + 3);
    swap(this, i + 1, i + 2);
  }
  return this
};

Buffer.prototype.swap64 = function swap64 () {
  const len = this.length;
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (let i = 0; i < len; i += 8) {
    swap(this, i, i + 7);
    swap(this, i + 1, i + 6);
    swap(this, i + 2, i + 5);
    swap(this, i + 3, i + 4);
  }
  return this
};

Buffer.prototype.toString = function toString () {
  const length = this.length;
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
};

Buffer.prototype.toLocaleString = Buffer.prototype.toString;

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
};

Buffer.prototype.inspect = function inspect () {
  let str = '';
  const max = INSPECT_MAX_BYTES;
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
  if (this.length > max) str += ' ... ';
  return '<Buffer ' + str + '>'
};
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect;
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength);
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0;
  }
  if (end === undefined) {
    end = target ? target.length : 0;
  }
  if (thisStart === undefined) {
    thisStart = 0;
  }
  if (thisEnd === undefined) {
    thisEnd = this.length;
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0;
  end >>>= 0;
  thisStart >>>= 0;
  thisEnd >>>= 0;

  if (this === target) return 0

  let x = thisEnd - thisStart;
  let y = end - start;
  const len = Math.min(x, y);

  const thisCopy = this.slice(thisStart, thisEnd);
  const targetCopy = target.slice(start, end);

  for (let i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i];
      y = targetCopy[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset;
    byteOffset = 0;
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff;
  } else if (byteOffset < -2147483648) {
    byteOffset = -2147483648;
  }
  byteOffset = +byteOffset; // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1);
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1;
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0;
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding);
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF; // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  let indexSize = 1;
  let arrLength = arr.length;
  let valLength = val.length;

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase();
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2;
      arrLength /= 2;
      valLength /= 2;
      byteOffset /= 2;
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  let i;
  if (dir) {
    let foundIndex = -1;
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i;
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex;
        foundIndex = -1;
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
    for (i = byteOffset; i >= 0; i--) {
      let found = true;
      for (let j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false;
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
};

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
};

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
};

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0;
  const remaining = buf.length - offset;
  if (!length) {
    length = remaining;
  } else {
    length = Number(length);
    if (length > remaining) {
      length = remaining;
    }
  }

  const strLen = string.length;

  if (length > strLen / 2) {
    length = strLen / 2;
  }
  let i;
  for (i = 0; i < length; ++i) {
    const parsed = parseInt(string.substr(i * 2, 2), 16);
    if (numberIsNaN(parsed)) return i
    buf[offset + i] = parsed;
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8';
    length = this.length;
    offset = 0;
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset;
    length = this.length;
    offset = 0;
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0;
    if (isFinite(length)) {
      length = length >>> 0;
      if (encoding === undefined) encoding = 'utf8';
    } else {
      encoding = length;
      length = undefined;
    }
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  const remaining = this.length - offset;
  if (length === undefined || length > remaining) length = remaining;

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8';

  let loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
      case 'latin1':
      case 'binary':
        return asciiWrite(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
};

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
};

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64JsExports.fromByteArray(buf)
  } else {
    return base64JsExports.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end);
  const res = [];

  let i = start;
  while (i < end) {
    const firstByte = buf[i];
    let codePoint = null;
    let bytesPerSequence = (firstByte > 0xEF)
      ? 4
      : (firstByte > 0xDF)
          ? 3
          : (firstByte > 0xBF)
              ? 2
              : 1;

    if (i + bytesPerSequence <= end) {
      let secondByte, thirdByte, fourthByte, tempCodePoint;

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte;
          }
          break
        case 2:
          secondByte = buf[i + 1];
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 3:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 4:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          fourthByte = buf[i + 3];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint;
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD;
      bytesPerSequence = 1;
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000;
      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
      codePoint = 0xDC00 | codePoint & 0x3FF;
    }

    res.push(codePoint);
    i += bytesPerSequence;
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
const MAX_ARGUMENTS_LENGTH = 0x1000;

function decodeCodePointsArray (codePoints) {
  const len = codePoints.length;
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  let res = '';
  let i = 0;
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    );
  }
  return res
}

function asciiSlice (buf, start, end) {
  let ret = '';
  end = Math.min(buf.length, end);

  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F);
  }
  return ret
}

function latin1Slice (buf, start, end) {
  let ret = '';
  end = Math.min(buf.length, end);

  for (let i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i]);
  }
  return ret
}

function hexSlice (buf, start, end) {
  const len = buf.length;

  if (!start || start < 0) start = 0;
  if (!end || end < 0 || end > len) end = len;

  let out = '';
  for (let i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]];
  }
  return out
}

function utf16leSlice (buf, start, end) {
  const bytes = buf.slice(start, end);
  let res = '';
  // If bytes.length is odd, the last 8 bits must be ignored (same as node.js)
  for (let i = 0; i < bytes.length - 1; i += 2) {
    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256));
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  const len = this.length;
  start = ~~start;
  end = end === undefined ? len : ~~end;

  if (start < 0) {
    start += len;
    if (start < 0) start = 0;
  } else if (start > len) {
    start = len;
  }

  if (end < 0) {
    end += len;
    if (end < 0) end = 0;
  } else if (end > len) {
    end = len;
  }

  if (end < start) end = start;

  const newBuf = this.subarray(start, end);
  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(newBuf, Buffer.prototype);

  return newBuf
};

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUintLE =
Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  let val = this[offset];
  let mul = 1;
  let i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }

  return val
};

Buffer.prototype.readUintBE =
Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length);
  }

  let val = this[offset + --byteLength];
  let mul = 1;
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul;
  }

  return val
};

Buffer.prototype.readUint8 =
Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  return this[offset]
};

Buffer.prototype.readUint16LE =
Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] | (this[offset + 1] << 8)
};

Buffer.prototype.readUint16BE =
Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return (this[offset] << 8) | this[offset + 1]
};

Buffer.prototype.readUint32LE =
Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
};

Buffer.prototype.readUint32BE =
Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
};

Buffer.prototype.readBigUInt64LE = defineBigIntMethod(function readBigUInt64LE (offset) {
  offset = offset >>> 0;
  validateNumber(offset, 'offset');
  const first = this[offset];
  const last = this[offset + 7];
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8);
  }

  const lo = first +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 24;

  const hi = this[++offset] +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    last * 2 ** 24;

  return BigInt(lo) + (BigInt(hi) << BigInt(32))
});

Buffer.prototype.readBigUInt64BE = defineBigIntMethod(function readBigUInt64BE (offset) {
  offset = offset >>> 0;
  validateNumber(offset, 'offset');
  const first = this[offset];
  const last = this[offset + 7];
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8);
  }

  const hi = first * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    this[++offset];

  const lo = this[++offset] * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    last;

  return (BigInt(hi) << BigInt(32)) + BigInt(lo)
});

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  let val = this[offset];
  let mul = 1;
  let i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  let i = byteLength;
  let mul = 1;
  let val = this[offset + --i];
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
};

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  const val = this[offset] | (this[offset + 1] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  const val = this[offset + 1] | (this[offset] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
};

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
};

Buffer.prototype.readBigInt64LE = defineBigIntMethod(function readBigInt64LE (offset) {
  offset = offset >>> 0;
  validateNumber(offset, 'offset');
  const first = this[offset];
  const last = this[offset + 7];
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8);
  }

  const val = this[offset + 4] +
    this[offset + 5] * 2 ** 8 +
    this[offset + 6] * 2 ** 16 +
    (last << 24); // Overflow

  return (BigInt(val) << BigInt(32)) +
    BigInt(first +
    this[++offset] * 2 ** 8 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 24)
});

Buffer.prototype.readBigInt64BE = defineBigIntMethod(function readBigInt64BE (offset) {
  offset = offset >>> 0;
  validateNumber(offset, 'offset');
  const first = this[offset];
  const last = this[offset + 7];
  if (first === undefined || last === undefined) {
    boundsError(offset, this.length - 8);
  }

  const val = (first << 24) + // Overflow
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    this[++offset];

  return (BigInt(val) << BigInt(32)) +
    BigInt(this[++offset] * 2 ** 24 +
    this[++offset] * 2 ** 16 +
    this[++offset] * 2 ** 8 +
    last)
});

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return ieee754Exports.read(this, offset, true, 23, 4)
};

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return ieee754Exports.read(this, offset, false, 23, 4)
};

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return ieee754Exports.read(this, offset, true, 52, 8)
};

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return ieee754Exports.read(this, offset, false, 52, 8)
};

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUintLE =
Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  let mul = 1;
  let i = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUintBE =
Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    const maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  let i = byteLength - 1;
  let mul = 1;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUint8 =
Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
  this[offset] = (value & 0xff);
  return offset + 1
};

Buffer.prototype.writeUint16LE =
Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  this[offset] = (value & 0xff);
  this[offset + 1] = (value >>> 8);
  return offset + 2
};

Buffer.prototype.writeUint16BE =
Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  this[offset] = (value >>> 8);
  this[offset + 1] = (value & 0xff);
  return offset + 2
};

Buffer.prototype.writeUint32LE =
Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  this[offset + 3] = (value >>> 24);
  this[offset + 2] = (value >>> 16);
  this[offset + 1] = (value >>> 8);
  this[offset] = (value & 0xff);
  return offset + 4
};

Buffer.prototype.writeUint32BE =
Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  this[offset] = (value >>> 24);
  this[offset + 1] = (value >>> 16);
  this[offset + 2] = (value >>> 8);
  this[offset + 3] = (value & 0xff);
  return offset + 4
};

function wrtBigUInt64LE (buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7);

  let lo = Number(value & BigInt(0xffffffff));
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  lo = lo >> 8;
  buf[offset++] = lo;
  let hi = Number(value >> BigInt(32) & BigInt(0xffffffff));
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  hi = hi >> 8;
  buf[offset++] = hi;
  return offset
}

function wrtBigUInt64BE (buf, value, offset, min, max) {
  checkIntBI(value, min, max, buf, offset, 7);

  let lo = Number(value & BigInt(0xffffffff));
  buf[offset + 7] = lo;
  lo = lo >> 8;
  buf[offset + 6] = lo;
  lo = lo >> 8;
  buf[offset + 5] = lo;
  lo = lo >> 8;
  buf[offset + 4] = lo;
  let hi = Number(value >> BigInt(32) & BigInt(0xffffffff));
  buf[offset + 3] = hi;
  hi = hi >> 8;
  buf[offset + 2] = hi;
  hi = hi >> 8;
  buf[offset + 1] = hi;
  hi = hi >> 8;
  buf[offset] = hi;
  return offset + 8
}

Buffer.prototype.writeBigUInt64LE = defineBigIntMethod(function writeBigUInt64LE (value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt('0xffffffffffffffff'))
});

Buffer.prototype.writeBigUInt64BE = defineBigIntMethod(function writeBigUInt64BE (value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt('0xffffffffffffffff'))
});

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    const limit = Math.pow(2, (8 * byteLength) - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  let i = 0;
  let mul = 1;
  let sub = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    const limit = Math.pow(2, (8 * byteLength) - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  let i = byteLength - 1;
  let mul = 1;
  let sub = 0;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -128);
  if (value < 0) value = 0xff + value + 1;
  this[offset] = (value & 0xff);
  return offset + 1
};

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
  this[offset] = (value & 0xff);
  this[offset + 1] = (value >>> 8);
  return offset + 2
};

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
  this[offset] = (value >>> 8);
  this[offset + 1] = (value & 0xff);
  return offset + 2
};

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
  this[offset] = (value & 0xff);
  this[offset + 1] = (value >>> 8);
  this[offset + 2] = (value >>> 16);
  this[offset + 3] = (value >>> 24);
  return offset + 4
};

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
  if (value < 0) value = 0xffffffff + value + 1;
  this[offset] = (value >>> 24);
  this[offset + 1] = (value >>> 16);
  this[offset + 2] = (value >>> 8);
  this[offset + 3] = (value & 0xff);
  return offset + 4
};

Buffer.prototype.writeBigInt64LE = defineBigIntMethod(function writeBigInt64LE (value, offset = 0) {
  return wrtBigUInt64LE(this, value, offset, -BigInt('0x8000000000000000'), BigInt('0x7fffffffffffffff'))
});

Buffer.prototype.writeBigInt64BE = defineBigIntMethod(function writeBigInt64BE (value, offset = 0) {
  return wrtBigUInt64BE(this, value, offset, -BigInt('0x8000000000000000'), BigInt('0x7fffffffffffffff'))
});

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4);
  }
  ieee754Exports.write(buf, value, offset, littleEndian, 23, 4);
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
};

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
};

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8);
  }
  ieee754Exports.write(buf, value, offset, littleEndian, 52, 8);
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
};

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
};

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
  if (!start) start = 0;
  if (!end && end !== 0) end = this.length;
  if (targetStart >= target.length) targetStart = target.length;
  if (!targetStart) targetStart = 0;
  if (end > 0 && end < start) end = start;

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length;
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start;
  }

  const len = end - start;

  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end);
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    );
  }

  return len
};

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start;
      start = 0;
      end = this.length;
    } else if (typeof end === 'string') {
      encoding = end;
      end = this.length;
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
    if (val.length === 1) {
      const code = val.charCodeAt(0);
      if ((encoding === 'utf8' && code < 128) ||
          encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code;
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255;
  } else if (typeof val === 'boolean') {
    val = Number(val);
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0;
  end = end === undefined ? this.length : end >>> 0;

  if (!val) val = 0;

  let i;
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val;
    }
  } else {
    const bytes = Buffer.isBuffer(val)
      ? val
      : Buffer.from(val, encoding);
    const len = bytes.length;
    if (len === 0) {
      throw new TypeError('The value "' + val +
        '" is invalid for argument "value"')
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len];
    }
  }

  return this
};

// CUSTOM ERRORS
// =============

// Simplified versions from Node, changed for Buffer-only usage
const errors$3 = {};
function E (sym, getMessage, Base) {
  errors$3[sym] = class NodeError extends Base {
    constructor () {
      super();

      Object.defineProperty(this, 'message', {
        value: getMessage.apply(this, arguments),
        writable: true,
        configurable: true
      });

      // Add the error code to the name to include it in the stack trace.
      this.name = `${this.name} [${sym}]`;
      // Access the stack to generate the error message including the error code
      // from the name.
      this.stack; // eslint-disable-line no-unused-expressions
      // Reset the name to the actual name.
      delete this.name;
    }

    get code () {
      return sym
    }

    set code (value) {
      Object.defineProperty(this, 'code', {
        configurable: true,
        enumerable: true,
        value,
        writable: true
      });
    }

    toString () {
      return `${this.name} [${sym}]: ${this.message}`
    }
  };
}

E('ERR_BUFFER_OUT_OF_BOUNDS',
  function (name) {
    if (name) {
      return `${name} is outside of buffer bounds`
    }

    return 'Attempt to access memory outside buffer bounds'
  }, RangeError);
E('ERR_INVALID_ARG_TYPE',
  function (name, actual) {
    return `The "${name}" argument must be of type number. Received type ${typeof actual}`
  }, TypeError);
E('ERR_OUT_OF_RANGE',
  function (str, range, input) {
    let msg = `The value of "${str}" is out of range.`;
    let received = input;
    if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
      received = addNumericalSeparator(String(input));
    } else if (typeof input === 'bigint') {
      received = String(input);
      if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
        received = addNumericalSeparator(received);
      }
      received += 'n';
    }
    msg += ` It must be ${range}. Received ${received}`;
    return msg
  }, RangeError);

function addNumericalSeparator (val) {
  let res = '';
  let i = val.length;
  const start = val[0] === '-' ? 1 : 0;
  for (; i >= start + 4; i -= 3) {
    res = `_${val.slice(i - 3, i)}${res}`;
  }
  return `${val.slice(0, i)}${res}`
}

// CHECK FUNCTIONS
// ===============

function checkBounds (buf, offset, byteLength) {
  validateNumber(offset, 'offset');
  if (buf[offset] === undefined || buf[offset + byteLength] === undefined) {
    boundsError(offset, buf.length - (byteLength + 1));
  }
}

function checkIntBI (value, min, max, buf, offset, byteLength) {
  if (value > max || value < min) {
    const n = typeof min === 'bigint' ? 'n' : '';
    let range;
    {
      if (min === 0 || min === BigInt(0)) {
        range = `>= 0${n} and < 2${n} ** ${(byteLength + 1) * 8}${n}`;
      } else {
        range = `>= -(2${n} ** ${(byteLength + 1) * 8 - 1}${n}) and < 2 ** ` +
                `${(byteLength + 1) * 8 - 1}${n}`;
      }
    }
    throw new errors$3.ERR_OUT_OF_RANGE('value', range, value)
  }
  checkBounds(buf, offset, byteLength);
}

function validateNumber (value, name) {
  if (typeof value !== 'number') {
    throw new errors$3.ERR_INVALID_ARG_TYPE(name, 'number', value)
  }
}

function boundsError (value, length, type) {
  if (Math.floor(value) !== value) {
    validateNumber(value, type);
    throw new errors$3.ERR_OUT_OF_RANGE('offset', 'an integer', value)
  }

  if (length < 0) {
    throw new errors$3.ERR_BUFFER_OUT_OF_BOUNDS()
  }

  throw new errors$3.ERR_OUT_OF_RANGE('offset',
                                    `>= ${0} and <= ${length}`,
                                    value)
}

// HELPER FUNCTIONS
// ================

const INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;

function base64clean (str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0];
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '');
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '=';
  }
  return str
}

function utf8ToBytes (string, units) {
  units = units || Infinity;
  let codePoint;
  const length = string.length;
  let leadSurrogate = null;
  const bytes = [];

  for (let i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i);

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        }

        // valid lead
        leadSurrogate = codePoint;

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        leadSurrogate = codePoint;
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
    }

    leadSurrogate = null;

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint);
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  const byteArray = [];
  for (let i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF);
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  let c, hi, lo;
  const byteArray = [];
  for (let i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i);
    hi = c >> 8;
    lo = c % 256;
    byteArray.push(lo);
    byteArray.push(hi);
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64JsExports.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  let i;
  for (i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i];
  }
  return i
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance (obj, type) {
  return obj instanceof type ||
    (obj != null && obj.constructor != null && obj.constructor.name != null &&
      obj.constructor.name === type.name)
}
function numberIsNaN (obj) {
  // For IE11 support
  return obj !== obj // eslint-disable-line no-self-compare
}

// Create lookup table for `toString('hex')`
// See: https://github.com/feross/buffer/issues/219
const hexSliceLookupTable = (function () {
  const alphabet = '0123456789abcdef';
  const table = new Array(256);
  for (let i = 0; i < 16; ++i) {
    const i16 = i * 16;
    for (let j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j];
    }
  }
  return table
})();

// Return not function with Error if BigInt not supported
function defineBigIntMethod (fn) {
  return typeof BigInt === 'undefined' ? BufferBigIntNotDefined : fn
}

function BufferBigIntNotDefined () {
  throw new Error('BigInt not supported')
}

var buffer$1 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	Buffer: Buffer,
	INSPECT_MAX_BYTES: INSPECT_MAX_BYTES,
	SlowBuffer: SlowBuffer,
	kMaxLength: kMaxLength
});

var require$$0$2 = /*@__PURE__*/getAugmentedNamespace(buffer$1);

var hasRequiredBuffer$1;

function requireBuffer$1 () {
	if (hasRequiredBuffer$1) return buffer$2;
	hasRequiredBuffer$1 = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.bufferFrom = exports.bufferAllocUnsafe = exports.Buffer = void 0;
		const buffer_1 = require$$0$2;
		Object.defineProperty(exports, "Buffer", { enumerable: true, get: function () { return buffer_1.Buffer; } });
		function bufferV0P12Ponyfill(arg0, ...args) {
		    return new buffer_1.Buffer(arg0, ...args);
		}
		const bufferAllocUnsafe = buffer_1.Buffer.allocUnsafe || bufferV0P12Ponyfill;
		exports.bufferAllocUnsafe = bufferAllocUnsafe;
		const bufferFrom = buffer_1.Buffer.from || bufferV0P12Ponyfill;
		exports.bufferFrom = bufferFrom;
		
	} (buffer$2));
	return buffer$2;
}

var errors$2 = {};

var assert$1 = {exports: {}};

var hasRequiredAssert;

function requireAssert () {
	if (hasRequiredAssert) return assert$1.exports;
	hasRequiredAssert = 1;
	function assert(condition, message) {
	  if (!condition) {
	    throw new Error(message || 'Assertion failed')
	  }
	}

	assert$1.exports = assert;

	assert$1.exports.strictEqual = function strictEqual(a, b) {
	  if (a !== b) {
	    throw new Error(`Expected ${a} to strict equal ${b}`)
	  }
	};
	return assert$1.exports;
}

var browser$2 = {exports: {}};

var hasRequiredBrowser$2;

function requireBrowser$2 () {
	if (hasRequiredBrowser$2) return browser$2.exports;
	hasRequiredBrowser$2 = 1;
	// shim for using process in browser
	var process = browser$2.exports = {};

	// cached from whatever undefined is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.

	var cachedSetTimeout;
	var cachedClearTimeout;

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	(function () {
	    try {
	        if (typeof setTimeout === 'function') {
	            cachedSetTimeout = setTimeout;
	        } else {
	            cachedSetTimeout = defaultSetTimout;
	        }
	    } catch (e) {
	        cachedSetTimeout = defaultSetTimout;
	    }
	    try {
	        if (typeof clearTimeout === 'function') {
	            cachedClearTimeout = clearTimeout;
	        } else {
	            cachedClearTimeout = defaultClearTimeout;
	        }
	    } catch (e) {
	        cachedClearTimeout = defaultClearTimeout;
	    }
	} ());
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the undefined object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the undefined object for 'this', hopfully our context correct otherwise it will throw a undefined error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the undefined object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the undefined object for 'this', hopfully our context correct otherwise it will throw a undefined error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}

	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};

	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};

	function noop() {}

	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	process.prependListener = noop;
	process.prependOnceListener = noop;

	process.listeners = function (name) { return [] };

	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};

	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };
	return browser$2.exports;
}

var browserExports = requireBrowser$2();
var process$1 = /*@__PURE__*/getDefaultExportFromCjs$1(browserExports);

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var primordials$1 = {exports: {}};

// back-patch in primordials in user-land

const createSafeIterator = (factory, next) => {
  class SafeIterator {
    constructor(iterable) {
      this._iterator = factory(iterable);
    }
    next() {
      return next(this._iterator);
    }
    [Symbol.iterator]() {
      return this;
    }
  }
  Object.setPrototypeOf(SafeIterator.prototype, null);
  Object.freeze(SafeIterator.prototype);
  Object.freeze(SafeIterator);
  return SafeIterator;
};

function getGetter(cls, getter) {
  // TODO: __lookupGetter__ is deprecated, but Object.getOwnPropertyDescriptor
  // doesn't work on built-ins like Typed Arrays.
  return Function.prototype.call.bind(cls.prototype.__lookupGetter__(getter));
}

function getterCaller(getter) {
  return (val) => {
    return val.constructor.prototype.__lookupGetter__(getter).call(val);
  };
}

function uncurryThis(func) {
  return Function.prototype.call.bind(func);
}

const copyProps = (src, dest) => {
  Array.prototype.forEach.call(Reflect.ownKeys(src), (key) => {
    if (!Reflect.getOwnPropertyDescriptor(dest, key)) {
      Reflect.defineProperty(
        dest,
        key,
        Reflect.getOwnPropertyDescriptor(src, key));
    }
  });
};

const makeSafe = (unsafe, safe) => {
  if (Symbol.iterator in unsafe.prototype) {
    const dummy = new unsafe();
    let next; // We can reuse the same `next` method.

    Array.prototype.forEach.call(Reflect.ownKeys(unsafe.prototype), (key) => {
      if (!Reflect.getOwnPropertyDescriptor(safe.prototype, key)) {
        const desc = Reflect.getOwnPropertyDescriptor(unsafe.prototype, key);
        if (typeof desc.value === 'function' && desc.value.length === 0) {
            const called = Function.prototype.call.call(desc.value, dummy) || {};
            if (Symbol.iterator in (typeof called === "object" ? called : {})) {
                const createIterator = uncurryThis(desc.value);
                if (next == null) {
                    next = uncurryThis(createIterator(dummy).next);
                }
                const SafeIterator = createSafeIterator(createIterator, next);
                desc.value = function() {
                    return new SafeIterator(this);
                };
            }
        }
        Reflect.defineProperty(safe.prototype, key, desc);
      }
    });
  } else {
    copyProps(unsafe.prototype, safe.prototype);
  }
  copyProps(unsafe, safe);

  Object.setPrototypeOf(safe.prototype, null);
  Object.freeze(safe.prototype);
  Object.freeze(safe);
  return safe;
};

const StringIterator =
  Function.prototype.call.bind(String.prototype[Symbol.iterator]);
const StringIteratorPrototype = Reflect.getPrototypeOf(StringIterator(''));

function ErrorCaptureStackTrace(targetObject) {
  const stack = new Error().stack;
  // Remove the second line, which is this function
  targetObject.stack = stack.replace(/.*\n.*/, '$1');
}

primordials$1.exports = {
  makeSafe, // exported for testing
  internalBinding(mod) {
    if (mod === 'config') {
      return {
        hasIntl: false,
      };
    }
    throw new Error(`unknown module: "${mod}"`);
  },
  Array,
  ArrayIsArray: Array.isArray,
  ArrayPrototypeFilter: Function.prototype.call.bind(Array.prototype.filter),
  ArrayPrototypeForEach: Function.prototype.call.bind(Array.prototype.forEach),
  ArrayPrototypeIncludes:
    Function.prototype.call.bind(Array.prototype.includes),
  ArrayPrototypeIndexOf: Function.prototype.call.bind(Array.prototype.indexOf),
  ArrayPrototypeJoin: Function.prototype.call.bind(Array.prototype.join),
  ArrayPrototypeMap: Function.prototype.call.bind(Array.prototype.map),
  ArrayPrototypePop: Function.prototype.call.bind(Array.prototype.pop),
  ArrayPrototypePush: Function.prototype.call.bind(Array.prototype.push),
  ArrayPrototypePushApply: Function.apply.bind(Array.prototype.push),
  ArrayPrototypeSlice: Function.prototype.call.bind(Array.prototype.slice),
  ArrayPrototypeSort: Function.prototype.call.bind(Array.prototype.sort),
  ArrayPrototypeSplice: Function.prototype.call.bind(Array.prototype.splice),
  ArrayPrototypeUnshift: Function.prototype.call.bind(Array.prototype.unshift),
  BigIntPrototypeValueOf:
    Function.prototype.call.bind(BigInt.prototype.valueOf),
  BooleanPrototypeValueOf:
    Function.prototype.call.bind(Boolean.prototype.valueOf),
  DatePrototypeGetTime: Function.prototype.call.bind(Date.prototype.getTime),
  DatePrototypeToISOString:
    Function.prototype.call.bind(Date.prototype.toISOString),
  DatePrototypeToString:
    Function.prototype.call.bind(Date.prototype.toString),
  ErrorCaptureStackTrace,
  ErrorPrototypeToString:
    Function.prototype.call.bind(Error.prototype.toString),
  FunctionPrototypeBind: Function.prototype.call.bind(Function.prototype.bind),
  FunctionPrototypeCall:
    Function.prototype.call.bind(Function.prototype.call),
  FunctionPrototypeToString:
    Function.prototype.call.bind(Function.prototype.toString),
  globalThis: (typeof globalThis === 'undefined') ? commonjsGlobal : globalThis,
  JSONStringify: JSON.stringify,
  MapPrototypeGetSize: getGetter(Map, 'size'),
  MapPrototypeEntries: Function.prototype.call.bind(Map.prototype.entries),
  MathFloor: Math.floor,
  MathMax: Math.max,
  MathMin: Math.min,
  MathRound: Math.round,
  MathSqrt: Math.sqrt,
  MathTrunc: Math.trunc,
  Number,
  NumberIsFinite: Number.isFinite,
  NumberIsNaN: Number.isNaN,
  NumberParseFloat: Number.parseFloat,
  NumberParseInt: Number.parseInt,
  NumberPrototypeToString: Function.prototype.call.bind(Number.prototype.toString),
  NumberPrototypeValueOf:
    Function.prototype.call.bind(Number.prototype.valueOf),
  Object,
  ObjectAssign: Object.assign,
  ObjectCreate: Object.create,
  ObjectDefineProperty: Object.defineProperty,
  ObjectGetOwnPropertyDescriptor: Object.getOwnPropertyDescriptor,
  ObjectGetOwnPropertyNames: Object.getOwnPropertyNames,
  ObjectGetOwnPropertySymbols: Object.getOwnPropertySymbols,
  ObjectGetPrototypeOf: Object.getPrototypeOf,
  ObjectIs: Object.is,
  ObjectKeys: Object.keys,
  ObjectPrototypeHasOwnProperty:
    Function.prototype.call.bind(Object.prototype.hasOwnProperty),
  ObjectPrototypePropertyIsEnumerable:
    Function.prototype.call.bind(Object.prototype.propertyIsEnumerable),
  ObjectSeal: Object.seal,
  ObjectSetPrototypeOf: Object.setPrototypeOf,
  ReflectApply: Reflect.apply,
  ReflectOwnKeys: Reflect.ownKeys,
  RegExp,
  RegExpPrototypeExec: Function.prototype.call.bind(RegExp.prototype.exec),
  RegExpPrototypeSymbolReplace: Function.prototype.call.bind(RegExp.prototype[Symbol.replace]),
  RegExpPrototypeSymbolSplit: Function.prototype.call.bind(RegExp.prototype[Symbol.split]),
  RegExpPrototypeTest: Function.prototype.call.bind(RegExp.prototype.test),
  RegExpPrototypeToString:
    Function.prototype.call.bind(RegExp.prototype.toString),
  SafeStringIterator: createSafeIterator(
    StringIterator,
    Function.prototype.call.bind(StringIteratorPrototype.next),
  ),
  SafeMap: makeSafe(
    Map,
    class SafeMap extends Map {
      constructor(i) { super(i); } // eslint-disable-line no-useless-constructor
    }),
  SafeSet: makeSafe(
    Set,
    class SafeSet extends Set {
      constructor(i) { super(i); } // eslint-disable-line no-useless-constructor
    }),
  SetPrototypeGetSize: getGetter(Set, 'size'),
  SetPrototypeValues: Function.prototype.call.bind(Set.prototype.values),
  String,
  StringPrototypeCharCodeAt:
    Function.prototype.call.bind(String.prototype.charCodeAt),
  StringPrototypeCodePointAt:
    Function.prototype.call.bind(String.prototype.codePointAt),
  StringPrototypeEndsWith:
    Function.prototype.call.bind(String.prototype.endsWith),
  StringPrototypeIncludes:
    Function.prototype.call.bind(String.prototype.includes),
  StringPrototypeIndexOf:
    Function.prototype.call.bind(String.prototype.indexOf),
  StringPrototypeLastIndexOf:
    Function.prototype.call.bind(String.prototype.lastIndexOf),
  StringPrototypeNormalize:
    Function.prototype.call.bind(String.prototype.normalize),
  StringPrototypePadEnd:
    Function.prototype.call.bind(String.prototype.padEnd),
  StringPrototypePadStart:
    Function.prototype.call.bind(String.prototype.padStart),
  StringPrototypeRepeat: Function.prototype.call.bind(String.prototype.repeat),
  StringPrototypeReplace:
    Function.prototype.call.bind(String.prototype.replace),
  StringPrototypeReplaceAll:
    Function.prototype.call.bind(String.prototype.replaceAll),
  StringPrototypeSlice: Function.prototype.call.bind(String.prototype.slice),
  StringPrototypeSplit: Function.prototype.call.bind(String.prototype.split),
  StringPrototypeStartsWith: Function.prototype.call.bind(String.prototype.startsWith),
  StringPrototypeToLowerCase:
    Function.prototype.call.bind(String.prototype.toLowerCase),
  StringPrototypeTrim: Function.prototype.call.bind(String.prototype.trim),
  StringPrototypeValueOf:
    Function.prototype.call.bind(String.prototype.valueOf),
  SymbolPrototypeToString:
    Function.prototype.call.bind(Symbol.prototype.toString),
  SymbolPrototypeValueOf:
    Function.prototype.call.bind(Symbol.prototype.valueOf),
  SymbolIterator: Symbol.iterator,
  SymbolFor: Symbol.for,
  SymbolToStringTag: Symbol.toStringTag,
  TypedArrayPrototypeGetLength: getterCaller('length'),
  Uint8Array,
  uncurryThis,
};

// Node 14
/* c8 ignore start */
if (!String.prototype.replaceAll) {
  // Lifted and simplified from core-js for the moment.  Will remove when we
  // drop node 14 support.

  function requireObjectCoercible(it) {
    if (it == null) throw new TypeError("Can't call method on " + it);
    return it;
  }

  function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
    const tailPos = position + matched.length;
    const m = captures.length;
    let symbols = /\$([$&'`]|\d{1,2})/;
    return replacement.replace(symbols, (match, ch) => {
      let capture;
      switch (ch.charAt(0)) {
        case '$': return '$';
        case '&': return matched;
        case '`': return str.slice(0, position);
        case "'": return str.slice(tailPos);
        case '<':
          capture = namedCaptures[ch.slice(1, -1)];
          break;
        default: { // \d\d?
          const n = +ch;
          if (n === 0) return match;
          if (n > m) {
            const f = Math.floor(n / 10);
            if (f === 0) return match;
            if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
            return match;
          }
          capture = captures[n - 1];
        }
      }
      return capture === undefined ? '' : capture;
    });
  }

  primordials$1.exports.StringPrototypeReplaceAll = (str, searchValue, replaceValue) => {
    const O = requireObjectCoercible(str);
    let IS_REG_EXP, flags, replacer, replacement;
    let position = 0;
    let endOfLastMatch = 0;
    let result = '';
    if (searchValue != null) {
      IS_REG_EXP = searchValue instanceof RegExp;
      if (IS_REG_EXP) {
        flags = searchValue.flags;
        if (!~flags.indexOf('g')) {
          throw new TypeError('`.replaceAll` does not allow non-undefined regexes');
        }
      }
      replacer = searchValue[Symbol.replace];
      if (replacer) {
        return replacer.call(searchValue, O, replaceValue);
      }
    }
    const string = String(O);
    const searchString = String(searchValue);
    const functionalReplace = (typeof replaceValue === 'function');
    if (!functionalReplace) replaceValue = String(replaceValue);
    const searchLength = searchString.length;
    const advanceBy = Math.max(1, searchLength);
    position = string.indexOf(searchString, 0);
    while (position !== -1) {
      replacement = functionalReplace ?
        String(replaceValue(searchString, position, string)) :
        getSubstitution(searchString, string, position, [], undefined, replaceValue);
      result += string.slice(endOfLastMatch, position) + replacement;
      endOfLastMatch = position + searchLength;
      position = string.indexOf(searchString, position + advanceBy);
    }
    if (endOfLastMatch < string.length) {
      result += string.slice(endOfLastMatch);
    }
    return result;
  };
}
/* c8 ignore stop */

var primordialsExports = primordials$1.exports;

const ALL_PROXIES = new WeakMap();

// Wrap Proxy's to remember their details.
class Prxy {
  constructor(target, handler) {
    const p = new Proxy(target, handler);
    ALL_PROXIES.set(p, [target, handler]);
    // eslint-disable-next-line no-constructor-return
    return p;
  }
  static getProxyDetails(obj, getFullProxy = true) {
    const deets = ALL_PROXIES.get(obj);
    if (!deets) {
      return undefined;
    }
    if (getFullProxy) {
      return deets;
    }
    return deets[0];
  }
  static revocable(target, handler) {
    const p = Proxy.revocable(target, handler);
    ALL_PROXIES.set(p.proxy, [target, handler]);
    const revoke = p.revoke;
    p.revoke = () => {
      ALL_PROXIES.set(p.proxy, [null, null]);
      revoke();
    };
    return p;
  }
}

var proxy = {
  getProxyDetails: Prxy.getProxyDetails.bind(Prxy),
  Proxy: Prxy,
};

const prxy = proxy;
const ALL_PROPERTIES = 0;
const ONLY_ENUMERABLE = 2;
const kPending = Symbol('kPending');
const kRejected = Symbol('kRejected');

function getOwnNonIndexProperties(a, filter = ONLY_ENUMERABLE) {
  const desc = Object.getOwnPropertyDescriptors(a);
  const ret = [];
  for (const [k, v] of Object.entries(desc)) {
    if (!/^(0|[1-9][0-9]*)$/.test(k) ||
        (parseInt(k, 10) >= (2 ** 32 - 1))) { // Arrays are limited in size
      if ((filter === ONLY_ENUMERABLE) && !v.enumerable) {
        continue;
      }
      ret.push(k);
    }
  }
  for (const s of Object.getOwnPropertySymbols(a)) {
    const v = Object.getOwnPropertyDescriptor(a, s);
    if ((filter === ONLY_ENUMERABLE) && !v.enumerable) {
      continue;
    }
    ret.push(s);
  }
  return ret;
}

var util$1$1 = {
  constants: {
    kPending,
    kRejected,
    ALL_PROPERTIES,
    ONLY_ENUMERABLE,
  },
  getOwnNonIndexProperties,
  getPromiseDetails() { return [kPending, undefined]; },
  getProxyDetails: prxy.getProxyDetails,
  Proxy: prxy.Proxy,
  previewEntries(val) {
    return [[], false];
  },
  getConstructorName(val) {
    if (!val || typeof val !== 'object') {
      throw new Error('Invalid object');
    }
    if (val.constructor && val.constructor.name) {
      return val.constructor.name;
    }
    const str = Object.prototype.toString.call(val);
    // e.g. [object Boolean]
    const m = str.match(/^\[object ([^\]]+)\]/);
    if (m) {
      return m[1];
    }
    return 'Object';
  },
  getExternalValue() { return BigInt(0); },
};

// eslint-disable-next-line no-control-regex
const colorRegExp = /\u001b\[\d\d?m/g;

var util$4 = {
  customInspectSymbol: Symbol.for('nodejs.util.inspect.custom'),
  isError(e) {
    return e instanceof Error;
  },
  join: Array.prototype.join.call.bind(Array.prototype.join),
  removeColors(str) {
    return String.prototype.replace.call(str, colorRegExp, '');
  },
};

function assert(p) {
  if (!p) {
    throw new Error('Assertion failed');
  }
}

assert.fail = function fail(message) {
  throw new Error(message);
};

var assert_1 = assert;

/* eslint node-core/documented-errors: "error" */

var errors$1;
var hasRequiredErrors$2;

function requireErrors$2 () {
	if (hasRequiredErrors$2) return errors$1;
	hasRequiredErrors$2 = 1;

	// The whole point behind this internal module is to allow Node.js to no
	// longer be forced to treat every error message change as a semver-major
	// change. The NodeError classes here all expose a `code` property whose
	// value statically and permanently identifies the error. While the error
	// message may change, the code should not.

	const {
	  ArrayIsArray,
	  ArrayPrototypeIncludes,
	  ArrayPrototypeIndexOf,
	  ArrayPrototypeJoin,
	  ArrayPrototypePop,
	  ArrayPrototypePush,
	  ArrayPrototypeSplice,
	  ErrorCaptureStackTrace,
	  ObjectDefineProperty,
	  ReflectApply,
	  RegExpPrototypeTest,
	  SafeMap,
	  StringPrototypeEndsWith,
	  StringPrototypeIncludes,
	  StringPrototypeSlice,
	  StringPrototypeToLowerCase,
	} = primordialsExports;

	const messages = new SafeMap();
	const codes = {};

	const classRegExp = /^([A-Z][a-z0-9]*)+$/;
	// Sorted by a rough estimate on most frequently used entries.
	const kTypes = [
	  'string',
	  'function',
	  'number',
	  'object',
	  // Accept 'Function' and 'Object' as alternative to the lower cased version.
	  'Function',
	  'Object',
	  'boolean',
	  'bigint',
	  'symbol',
	];

	let userStackTraceLimit;
	const nodeInternalPrefix = '__node_internal_';

	// Lazily loaded
	let assert;
	let internalUtilInspect = null;
	function lazyInternalUtilInspect() {
	  if (!internalUtilInspect) {
	    internalUtilInspect = requireInspect$1();
	  }
	  return internalUtilInspect;
	}

	const addCodeToName = hideStackFrames(function addCodeToName(err, name, code) {
	  // Set the stack
	  err = captureLargerStackTrace(err);
	  // Add the error code to the name to include it in the stack trace.
	  err.name = `${name} [${code}]`;
	  // Access the stack to generate the error message including the error code
	  // from the name.
	  err.stack; // eslint-disable-line no-unused-expressions
	  // Reset the name to the actual name.
	  delete err.name;
	});

	function makeNodeErrorWithCode(Base, key) {
	  return function NodeError(...args) {
	    const limit = Error.stackTraceLimit;
	    Error.stackTraceLimit = 0;
	    const error = new Base();
	    // Reset the limit and setting the name property.
	    Error.stackTraceLimit = limit;
	    const message = getMessage(key, args, error);
	    ObjectDefineProperty(error, 'message', {
	      value: message,
	      enumerable: false,
	      writable: true,
	      configurable: true,
	    });
	    ObjectDefineProperty(error, 'toString', {
	      value() {
	        return `${this.name} [${key}]: ${this.message}`;
	      },
	      enumerable: false,
	      writable: true,
	      configurable: true,
	    });
	    addCodeToName(error, Base.name, key);
	    error.code = key;
	    return error;
	  };
	}

	// This function removes unnecessary frames from Node.js core errors.
	function hideStackFrames(fn) {
	  // We rename the functions that will be hidden to cut off the stacktrace
	  // at the outermost one
	  const hidden = nodeInternalPrefix + fn.name;
	  ObjectDefineProperty(fn, 'name', { value: hidden });
	  return fn;
	}

	// Utility function for registering the error codes. Only used here. Exported
	// *only* to allow for testing.
	function E(sym, val, def) {
	  // Special case for SystemError that formats the error message differently
	  // The SystemErrors only have SystemError as their base classes.
	  messages.set(sym, val);
	  codes[sym] = makeNodeErrorWithCode(def, sym);
	}

	function getMessage(key, args, self) {
	  const msg = messages.get(key);

	  if (assert === undefined) assert = assert_1;

	  assert(typeof msg === 'function');
	  assert(
	    msg.length <= args.length, // Default options do not count.
	    `Code: ${key}; The provided arguments length (${args.length}) does not ` +
	      `match the required ones (${msg.length}).`,
	  );
	  return ReflectApply(msg, self, args);
	}

	const captureLargerStackTrace = hideStackFrames(
	  function captureLargerStackTrace(err) {
	    userStackTraceLimit = Error.stackTraceLimit;
	    Error.stackTraceLimit = Infinity;
	    ErrorCaptureStackTrace(err);
	    // Reset the limit
	    Error.stackTraceLimit = userStackTraceLimit;

	    return err;
	  });

	let maxStack_ErrorName;
	let maxStack_ErrorMessage;
	/**
	 * Returns true if `err.name` and `err.message` are equal to engine-specific
	 * values indicating max call stack size has been exceeded.
	 * "Maximum call stack size exceeded" in V8.
	 * @param {Error} err
	 * @returns {boolean}
	 */
	function isStackOverflowError(err) {
	  if (maxStack_ErrorMessage === undefined) {
	    try {
	      function overflowStack() { overflowStack(); }
	      overflowStack();
	    } catch (err) {
	      maxStack_ErrorMessage = err.message;
	      maxStack_ErrorName = err.name;
	    }
	  }

	  return err && err.name === maxStack_ErrorName &&
	         err.message === maxStack_ErrorMessage;
	}

	errors$1 = {
	  codes,
	  hideStackFrames,
	  isStackOverflowError,
	};

	E('ERR_INVALID_ARG_TYPE',
	  (name, expected, actual) => {
	    assert(typeof name === 'string', "'name' must be a string");
	    if (!ArrayIsArray(expected)) {
	      expected = [expected];
	    }

	    let msg = 'The ';
	    if (StringPrototypeEndsWith(name, ' argument')) {
	      // For cases like 'first argument'
	      msg += `${name} `;
	    } else {
	      const type = StringPrototypeIncludes(name, '.') ? 'property' : 'argument';
	      msg += `"${name}" ${type} `;
	    }
	    msg += 'must be ';

	    const types = [];
	    const instances = [];
	    const other = [];

	    for (const value of expected) {
	      assert(typeof value === 'string',
	             'All expected entries have to be of type string');
	      if (ArrayPrototypeIncludes(kTypes, value)) {
	        ArrayPrototypePush(types, StringPrototypeToLowerCase(value));
	      } else if (RegExpPrototypeTest(classRegExp, value)) {
	        ArrayPrototypePush(instances, value);
	      } else {
	        assert(value !== 'object',
	               'The value "object" should be written as "Object"');
	        ArrayPrototypePush(other, value);
	      }
	    }

	    // Special handle `object` in case other instances are allowed to outline
	    // the differences between each other.
	    if (instances.length > 0) {
	      const pos = ArrayPrototypeIndexOf(types, 'object');
	      if (pos !== -1) {
	        ArrayPrototypeSplice(types, pos, 1);
	        ArrayPrototypePush(instances, 'Object');
	      }
	    }

	    if (types.length > 0) {
	      if (types.length > 2) {
	        const last = ArrayPrototypePop(types);
	        msg += `one of type ${ArrayPrototypeJoin(types, ', ')}, or ${last}`;
	      } else if (types.length === 2) {
	        msg += `one of type ${types[0]} or ${types[1]}`;
	      } else {
	        msg += `of type ${types[0]}`;
	      }
	      if (instances.length > 0 || other.length > 0)
	        msg += ' or ';
	    }

	    if (instances.length > 0) {
	      if (instances.length > 2) {
	        const last = ArrayPrototypePop(instances);
	        msg +=
	          `an instance of ${ArrayPrototypeJoin(instances, ', ')}, or ${last}`;
	      } else {
	        msg += `an instance of ${instances[0]}`;
	        if (instances.length === 2) {
	          msg += ` or ${instances[1]}`;
	        }
	      }
	      if (other.length > 0)
	        msg += ' or ';
	    }

	    if (other.length > 0) {
	      if (other.length > 2) {
	        const last = ArrayPrototypePop(other);
	        msg += `one of ${ArrayPrototypeJoin(other, ', ')}, or ${last}`;
	      } else if (other.length === 2) {
	        msg += `one of ${other[0]} or ${other[1]}`;
	      } else {
	        if (StringPrototypeToLowerCase(other[0]) !== other[0])
	          msg += 'an ';
	        msg += `${other[0]}`;
	      }
	    }

	    if (actual == null) {
	      msg += `. Received ${actual}`;
	    } else if (typeof actual === 'function' && actual.name) {
	      msg += `. Received function ${actual.name}`;
	    } else if (typeof actual === 'object') {
	      if (actual.constructor && actual.constructor.name) {
	        msg += `. Received an instance of ${actual.constructor.name}`;
	      } else {
	        const inspected = lazyInternalUtilInspect()
	          .inspect(actual, { depth: -1 });
	        msg += `. Received ${inspected}`;
	      }
	    } else {
	      let inspected = lazyInternalUtilInspect()
	        .inspect(actual, { colors: false });
	      if (inspected.length > 25)
	        inspected = `${StringPrototypeSlice(inspected, 0, 25)}...`;
	      msg += `. Received type ${typeof actual} (${inspected})`;
	    }
	    return msg;
	  }, TypeError);
	return errors$1;
}

const { getConstructorName } = util$1$1;

// From https://mathiasbynens.be/notes/globalthis
/* c8 ignore start */ // only needed for node 10
(function() {
  if (typeof globalThis === 'object') return;
  Object.defineProperty(Object.prototype, '__magic__', {
    get: function() {
      return this;
    },
    configurable: true,
  });
  // eslint-disable-next-line no-undef
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
}());
/* c8 ignore stop */

function constructorNamed(val, ...name) {
  // Pass in names rather than types, in case SharedArrayBuffer (e.g.) isn't
  // in your browser
  for (const n of name) {
    const typ = globalThis[n];
    if (typ) {
      if (val instanceof typ) {
        return true;
      }
    }
  }
  // instanceOf doesn't work across vm boundaries, so check the whole
  // inheritance chain
  while (val) {
    if (typeof val !== 'object') {
      return false;
    }
    if (name.indexOf(getConstructorName(val)) >= 0) {
      return true;
    }
    val = Object.getPrototypeOf(val);
  }
  return false;
}

function checkBox(cls) {
  return (val) => {
    if (!constructorNamed(val, cls.name)) {
      return false;
    }
    try {
      cls.prototype.valueOf.call(val);
    } catch {
      return false;
    }
    return true;
  };
}

const isStringObject = checkBox(String);
const isNumberObject = checkBox(Number);
const isBooleanObject = checkBox(Boolean);
const isBigIntObject = checkBox(BigInt);
const isSymbolObject = checkBox(Symbol);

var types = {
  isAsyncFunction(val) {
    return (typeof val === 'function') &&
      Function.prototype.toString.call(val).startsWith('async');
  },
  isGeneratorFunction(val) {
    return (typeof val === 'function') &&
      Function.prototype.toString.call(val).match(/^(async\s+)?function *\*/);
  },
  isAnyArrayBuffer(val) {
    return constructorNamed(val, 'ArrayBuffer', 'SharedArrayBuffer');
  },
  isArrayBuffer(val) {
    return constructorNamed(val, 'ArrayBuffer');
  },
  isArgumentsObject(val) {
    const cond = (val !== null) &&
      (typeof val === 'object') &&
      !Array.isArray(val) &&
      (typeof val.length === 'number') &&
      (val.length === (val.length | 0)) &&
      (val.length >= 0);
    if (cond) {
      const prop = Object.getOwnPropertyDescriptor(val, 'callee');
      return prop && !prop.enumerable;
    }
    return false;
  },
  isBoxedPrimitive(val) {
    return isNumberObject(val) ||
      isStringObject(val) ||
      isBooleanObject(val) ||
      isBigIntObject(val) ||
      isSymbolObject(val);
  },
  isDataView(val) {
    return constructorNamed(val, 'DataView');
  },
  isExternal(val) {
    return (typeof val === 'object') &&
      (Object.isFrozen(val)) &&
      (Object.getPrototypeOf(val) == null);
  },
  isMap(val) {
    if (!constructorNamed(val, 'Map')) {
      return false;
    }
    try {
      val.has();
    } catch {
      return false;
    }
    return true;
  },
  isMapIterator(val) {
    return Object.prototype.toString.call(Object.getPrototypeOf(val)) ===
      '[object Map Iterator]';
  },
  isModuleNamespaceObject(val) {
    // TODO: this is weak and easily faked
    return val &&
      (typeof val === 'object') &&
      (val[Symbol.toStringTag] === 'Module');
  },
  isNativeError(val) {
    return (val instanceof Error) && constructorNamed(
      val,
      'Error',
      'EvalError',
      'RangeError',
      'ReferenceError',
      'SyntaxError',
      'TypeError',
      'URIError',
      'AggregateError');
  },
  isPromise(val) {
    return constructorNamed(val, 'Promise');
  },
  isSet(val) {
    if (!constructorNamed(val, 'Set')) {
      return false;
    }
    try {
      val.has();
    } catch {
      return false;
    }
    return true;
  },
  isSetIterator(val) {
    return Object.prototype.toString.call(Object.getPrototypeOf(val)) ===
      '[object Set Iterator]';
  },
  isWeakMap(val) {
    return constructorNamed(val, 'WeakMap');
  },
  isWeakSet(val) {
    return constructorNamed(val, 'WeakSet');
  },
  isRegExp(val) {
    return constructorNamed(val, 'RegExp');
  },
  isDate(val) {
    if (constructorNamed(val, 'Date')) {
      try {
        Date.prototype.getTime.call(val); // Throws for pseudo-dates
        return true;
      } catch {
        // Ignored
      }
    }
    return false;
  },
  isTypedArray(val) {
    return constructorNamed(
      val,
      'Int8Array',
      'Uint8Array',
      'Uint8ClampedArray',
      'Int16Array',
      'Uint16Array',
      'Int32Array',
      'Uint32Array',
      'Float32Array',
      'Float64Array',
      'BigInt64Array',
      'BigUint64Array',
    );
  },
  isStringObject,
  isNumberObject,
  isBooleanObject,
  isBigIntObject};

var realm = {};

// This is a snapshot from node 18.11.0
const builtinModules = [
  '_http_agent',
  '_http_client',
  '_http_common',
  '_http_incoming',
  '_http_outgoing',
  '_http_server',
  '_stream_duplex',
  '_stream_passthrough',
  '_stream_readable',
  '_stream_transform',
  '_stream_wrap',
  '_stream_writable',
  '_tls_common',
  '_tls_wrap',
  'assert',
  'assert/strict',
  'async_hooks',
  'buffer',
  'child_process',
  'cluster',
  'console',
  'constants',
  'crypto',
  'dgram',
  'diagnostics_channel',
  'dns',
  'dns/promises',
  'domain',
  'events',
  'fs',
  'fs/promises',
  'http',
  'http2',
  'https',
  'inspector',
  'module',
  'Module',
  'net',
  'os',
  'path',
  'path/posix',
  'path/win32',
  'perf_hooks',
  'process',
  'punycode',
  'querystring',
  'readline',
  'readline/promises',
  'repl',
  'stream',
  'stream/consumers',
  'stream/promises',
  'stream/web',
  'string_decoder',
  'sys',
  'timers',
  'timers/promises',
  'tls',
  'trace_events',
  'tty',
  'url',
  'util',
  'util/types',
  'v8',
  'vm',
  'wasi',
  'worker_threads',
  'zlib',
];

realm.BuiltinModule = {
  exists(s) {
    return s.startsWith('internal/') || builtinModules.indexOf(s) !== -1;
  },
};

var validators$1;
var hasRequiredValidators$1;

function requireValidators$1 () {
	if (hasRequiredValidators$1) return validators$1;
	hasRequiredValidators$1 = 1;

	const {
	  ArrayIsArray,
	} = primordialsExports;

	const {
	  hideStackFrames,
	  codes: {
	    ERR_INVALID_ARG_TYPE,
	  },
	} = requireErrors$2();

	/**
	 * @param {unknown} value
	 * @param {string} name
	 * @param {{
	 *   allowArray?: boolean,
	 *   allowFunction?: boolean,
	 *   nullable?: boolean
	 * }} [options]
	 */
	const validateObject = hideStackFrames(
	  (value, name, options) => {
	    const useDefaultOptions = options == null;
	    const allowArray = useDefaultOptions ? false : options.allowArray;
	    const allowFunction = useDefaultOptions ? false : options.allowFunction;
	    const nullable = useDefaultOptions ? false : options.nullable;
	    if ((!nullable && value === null) ||
	        (!allowArray && ArrayIsArray(value)) ||
	        (typeof value !== 'object' && (
	          !allowFunction || typeof value !== 'function'
	        ))) {
	      throw new ERR_INVALID_ARG_TYPE(name, 'Object', value);
	    }
	  });

	function validateString(value, name) {
	  if (typeof value !== 'string')
	    throw new ERR_INVALID_ARG_TYPE(name, 'string', value);
	}

	validators$1 = {
	  validateObject,
	  validateString,
	};
	return validators$1;
}

var constants$1;
var hasRequiredConstants$1;

function requireConstants$1 () {
	if (hasRequiredConstants$1) return constants$1;
	hasRequiredConstants$1 = 1;

	constants$1 = {
	  // Non-alphabetic chars.
	  CHAR_DOT: 46, /* . */
	  CHAR_FORWARD_SLASH: 47, /* / */
	  CHAR_BACKWARD_SLASH: 92, /* \ */
	};
	return constants$1;
}

var path;
var hasRequiredPath;

function requirePath () {
	if (hasRequiredPath) return path;
	hasRequiredPath = 1;

	const {
	  StringPrototypeCharCodeAt,
	  StringPrototypeLastIndexOf,
	  StringPrototypeSlice,
	} = primordialsExports;

	const {
	  CHAR_DOT,
	  CHAR_FORWARD_SLASH,
	} = requireConstants$1();
	const {
	  validateString,
	} = requireValidators$1();

	function posixCwd() {
	  return '/'; // Fake for the web case
	}

	function isPosixPathSeparator(code) {
	  return code === CHAR_FORWARD_SLASH;
	}

	// Resolves . and .. elements in a path with directory names
	function normalizeString(path, allowAboveRoot, separator, isPathSeparator) {
	  let res = '';
	  let lastSegmentLength = 0;
	  let lastSlash = -1;
	  let dots = 0;
	  let code = 0;
	  for (let i = 0; i <= path.length; ++i) {
	    if (i < path.length)
	      code = StringPrototypeCharCodeAt(path, i);
	    else if (isPathSeparator(code))
	      break;
	    else
	      code = CHAR_FORWARD_SLASH;

	    if (isPathSeparator(code)) {
	      if (lastSlash === i - 1 || dots === 1) ; else if (dots === 2) {
	        if (res.length < 2 || lastSegmentLength !== 2 ||
	            StringPrototypeCharCodeAt(res, res.length - 1) !== CHAR_DOT ||
	            StringPrototypeCharCodeAt(res, res.length - 2) !== CHAR_DOT) {
	          if (res.length > 2) {
	            const lastSlashIndex = StringPrototypeLastIndexOf(res, separator);
	            if (lastSlashIndex === -1) {
	              res = '';
	              lastSegmentLength = 0;
	            } else {
	              res = StringPrototypeSlice(res, 0, lastSlashIndex);
	              lastSegmentLength =
	                res.length - 1 - StringPrototypeLastIndexOf(res, separator);
	            }
	            lastSlash = i;
	            dots = 0;
	            continue;
	          } else if (res.length !== 0) {
	            res = '';
	            lastSegmentLength = 0;
	            lastSlash = i;
	            dots = 0;
	            continue;
	          }
	        }
	        if (allowAboveRoot) {
	          res += res.length > 0 ? `${separator}..` : '..';
	          lastSegmentLength = 2;
	        }
	      } else {
	        if (res.length > 0)
	          res += `${separator}${StringPrototypeSlice(path, lastSlash + 1, i)}`;
	        else
	          res = StringPrototypeSlice(path, lastSlash + 1, i);
	        lastSegmentLength = i - lastSlash - 1;
	      }
	      lastSlash = i;
	      dots = 0;
	    } else if (code === CHAR_DOT && dots !== -1) {
	      ++dots;
	    } else {
	      dots = -1;
	    }
	  }
	  return res;
	}

	function resolve(...args) {
	  let resolvedPath = '';
	  let resolvedAbsolute = false;

	  for (let i = args.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	    const path = i >= 0 ? args[i] : posixCwd();

	    validateString(path, 'path');

	    // Skip empty entries
	    if (path.length === 0) {
	      continue;
	    }

	    resolvedPath = `${path}/${resolvedPath}`;
	    resolvedAbsolute =
	      StringPrototypeCharCodeAt(path, 0) === CHAR_FORWARD_SLASH;
	  }

	  // At this point the path should be resolved to a full absolute path, but
	  // handle relative paths to be safe (might happen when process.cwd() fails)

	  // Normalize the path
	  resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, '/',
	                                 isPosixPathSeparator);

	  if (resolvedAbsolute) {
	    return `/${resolvedPath}`;
	  }
	  return resolvedPath.length > 0 ? resolvedPath : '.';
	}

	path = {
	  resolve,
	};
	return path;
}

var url$1;
var hasRequiredUrl$1;

function requireUrl$1 () {
	if (hasRequiredUrl$1) return url$1;
	hasRequiredUrl$1 = 1;

	// The main use case is browsers, and I rarely test on Windows, so all of the
	// Windows-specific stuff is removed.

	const {
	  StringPrototypeCharCodeAt,
	  StringPrototypeIncludes,
	  StringPrototypeReplace,
	} = primordialsExports;

	const {
	  CHAR_FORWARD_SLASH,
	} = requireConstants$1();
	const path = requirePath();

	const percentRegEx = /%/g;
	const backslashRegEx = /\\/g;
	const newlineRegEx = /\n/g;
	const carriageReturnRegEx = /\r/g;
	const tabRegEx = /\t/g;

	function encodePathChars(filepath) {
	  if (StringPrototypeIncludes(filepath, '%'))
	    filepath = StringPrototypeReplace(filepath, percentRegEx, '%25');
	  // In posix, backslash is a valid character in paths:
	  if (StringPrototypeIncludes(filepath, '\\'))
	    filepath = StringPrototypeReplace(filepath, backslashRegEx, '%5C');
	  if (StringPrototypeIncludes(filepath, '\n'))
	    filepath = StringPrototypeReplace(filepath, newlineRegEx, '%0A');
	  if (StringPrototypeIncludes(filepath, '\r'))
	    filepath = StringPrototypeReplace(filepath, carriageReturnRegEx, '%0D');
	  if (StringPrototypeIncludes(filepath, '\t'))
	    filepath = StringPrototypeReplace(filepath, tabRegEx, '%09');
	  return filepath;
	}

	function pathToFileURL(filepath) {
	  const outURL = new URL('file://');

	  let resolved = path.resolve(filepath);
	  // path.resolve strips trailing slashes so we must add them back
	  const filePathLast = StringPrototypeCharCodeAt(filepath,
	                                                 filepath.length - 1);
	  if ((filePathLast === CHAR_FORWARD_SLASH) &&
	      resolved[resolved.length - 1] !== path.sep)
	    resolved += '/';
	  outURL.pathname = encodePathChars(resolved);

	  return outURL;
	}

	url$1 = {
	  pathToFileURL,
	};
	return url$1;
}

var buffer = {};

var hasRequiredBuffer;

function requireBuffer () {
	if (hasRequiredBuffer) return buffer;
	hasRequiredBuffer = 1;

	class Buffer {
	  hexSlice(start = 0, end) {
	    return Array.prototype.map.call(
	      this.slice(start, end),
	      (x) => ('00' + x.toString(16)).slice(-2))
	      .join('');
	  }
	}

	buffer.Buffer = Buffer;
	return buffer;
}

var inspect_1;
var hasRequiredInspect$1;

function requireInspect$1 () {
	if (hasRequiredInspect$1) return inspect_1;
	hasRequiredInspect$1 = 1;

	const primordials = primordialsExports;
	const {
	  internalBinding,
	  Array,
	  ArrayIsArray,
	  ArrayPrototypeFilter,
	  ArrayPrototypeForEach,
	  ArrayPrototypeIncludes,
	  ArrayPrototypeIndexOf,
	  ArrayPrototypeJoin,
	  ArrayPrototypeMap,
	  ArrayPrototypePop,
	  ArrayPrototypePush,
	  ArrayPrototypePushApply,
	  ArrayPrototypeSlice,
	  ArrayPrototypeSplice,
	  ArrayPrototypeSort,
	  ArrayPrototypeUnshift,
	  BigIntPrototypeValueOf,
	  BooleanPrototypeValueOf,
	  DatePrototypeGetTime,
	  DatePrototypeToISOString,
	  DatePrototypeToString,
	  ErrorPrototypeToString,
	  FunctionPrototypeBind,
	  FunctionPrototypeCall,
	  FunctionPrototypeToString,
	  JSONStringify,
	  MapPrototypeGetSize,
	  MapPrototypeEntries,
	  MathFloor,
	  MathMax,
	  MathMin,
	  MathRound,
	  MathSqrt,
	  MathTrunc,
	  Number,
	  NumberIsFinite,
	  NumberIsNaN,
	  NumberParseFloat,
	  NumberParseInt,
	  NumberPrototypeToString,
	  NumberPrototypeValueOf,
	  Object,
	  ObjectAssign,
	  ObjectDefineProperty,
	  ObjectGetOwnPropertyDescriptor,
	  ObjectGetOwnPropertyNames,
	  ObjectGetOwnPropertySymbols,
	  ObjectGetPrototypeOf,
	  ObjectIs,
	  ObjectKeys,
	  ObjectPrototypeHasOwnProperty,
	  ObjectPrototypePropertyIsEnumerable,
	  ObjectSeal,
	  ObjectSetPrototypeOf,
	  ReflectApply,
	  ReflectOwnKeys,
	  RegExp,
	  RegExpPrototypeExec,
	  RegExpPrototypeSymbolReplace,
	  RegExpPrototypeSymbolSplit,
	  RegExpPrototypeToString,
	  SafeStringIterator,
	  SafeMap,
	  SafeSet,
	  SetPrototypeGetSize,
	  SetPrototypeValues,
	  String,
	  StringPrototypeCharCodeAt,
	  StringPrototypeCodePointAt,
	  StringPrototypeIncludes,
	  StringPrototypeIndexOf,
	  StringPrototypeLastIndexOf,
	  StringPrototypeNormalize,
	  StringPrototypePadEnd,
	  StringPrototypePadStart,
	  StringPrototypeRepeat,
	  StringPrototypeReplaceAll,
	  StringPrototypeSlice,
	  StringPrototypeSplit,
	  StringPrototypeEndsWith,
	  StringPrototypeStartsWith,
	  StringPrototypeToLowerCase,
	  StringPrototypeTrim,
	  StringPrototypeValueOf,
	  SymbolPrototypeToString,
	  SymbolPrototypeValueOf,
	  SymbolIterator,
	  SymbolToStringTag,
	  TypedArrayPrototypeGetLength,
	  TypedArrayPrototypeGetSymbolToStringTag,
	  Uint8Array,
	  globalThis,
	  uncurryThis,
	} = primordials;

	const {
	  constants: {
	    ALL_PROPERTIES,
	    ONLY_ENUMERABLE,
	    kPending,
	    kRejected,
	  },
	  getOwnNonIndexProperties,
	  getPromiseDetails,
	  getProxyDetails,
	  previewEntries,
	  getConstructorName: internalGetConstructorName,
	  getExternalValue,
	  Proxy,
	} = util$1$1;

	const {
	  customInspectSymbol,
	  isError,
	  join,
	  removeColors,
	} = util$4;

	const {
	  isStackOverflowError,
	} = requireErrors$2();

	const {
	  isAsyncFunction,
	  isGeneratorFunction,
	  isAnyArrayBuffer,
	  isArrayBuffer,
	  isArgumentsObject,
	  isBoxedPrimitive,
	  isDataView,
	  isExternal,
	  isMap,
	  isMapIterator,
	  isModuleNamespaceObject,
	  isNativeError,
	  isPromise,
	  isSet,
	  isSetIterator,
	  isWeakMap,
	  isWeakSet,
	  isRegExp,
	  isDate,
	  isTypedArray,
	  isStringObject,
	  isNumberObject,
	  isBooleanObject,
	  isBigIntObject,
	} = types;

	const assert = assert_1;

	const { BuiltinModule } = realm;
	const {
	  validateObject,
	  validateString,
	} = requireValidators$1();

	let hexSlice;
	let internalUrl;

	function pathToFileUrlHref(filepath) {
	  // Maintain node 14 compat
	  // internalUrl ??= require('./internal/url');
	  internalUrl = (internalUrl == null) ? requireUrl$1() : internalUrl;
	  return internalUrl.pathToFileURL(filepath).href;
	}

	const builtInObjects = new SafeSet(
	  ArrayPrototypeFilter(
	    ObjectGetOwnPropertyNames(globalThis),
	    (e) => RegExpPrototypeExec(/^[A-Z][a-zA-Z0-9]+$/, e) !== null,
	  ),
	);

	// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
	const isUndetectableObject = (v) => typeof v === 'undefined' && v !== undefined;

	// These options must stay in sync with `getUserOptions`. So if any option will
	// be added or removed, `getUserOptions` must also be updated accordingly.
	const inspectDefaultOptions = ObjectSeal({
	  showHidden: false,
	  depth: 2,
	  colors: false,
	  customInspect: true,
	  showProxy: false,
	  maxArrayLength: 100,
	  maxStringLength: 10000,
	  breakLength: 80,
	  compact: 3,
	  sorted: false,
	  getters: false,
	  numericSeparator: false,
	});

	const kObjectType = 0;
	const kArrayType = 1;
	const kArrayExtrasType = 2;

	/* eslint-disable no-control-regex */
	// Work-arounds for Safari not implementing negative look-behinds.
	// Remove all of this once Safari 16.4 is rolled out "enough".
	let strEscapeSequencesRegExp,
	  strEscapeSequencesReplacer,
	  strEscapeSequencesRegExpSingle,
	  strEscapeSequencesReplacerSingle,
	  extractedSplitNewLines;
	try {
	  // Change from regex literals to RegExp constructors to avoid unrecoverable
	  // syntax error at load time.
	  strEscapeSequencesRegExp =
	    // eslint-disable-next-line max-len
	    new RegExp('[\\x00-\\x1f\\x27\\x5c\\x7f-\\x9f]|[\\ud800-\\udbff](?![\\udc00-\\udfff])|(?<![\\ud800-\\udbff])[\\udc00-\\udfff]');
	  strEscapeSequencesReplacer =
	    new RegExp(
	      // eslint-disable-next-line max-len
	      '[\x00-\\x1f\\x27\\x5c\\x7f-\\x9f]|[\\ud800-\\udbff](?![\\udc00-\\udfff])|(?<![\\ud800-\\udbff])[\\udc00-\\udfff]',
	      'g',
	    );
	  strEscapeSequencesRegExpSingle =
	    // eslint-disable-next-line max-len
	    new RegExp('[\\x00-\\x1f\\x5c\\x7f-\\x9f]|[\\ud800-\\udbff](?![\\udc00-\\udfff])|(?<![\\ud800-\\udbff])[\\udc00-\\udfff]');
	  strEscapeSequencesReplacerSingle =
	    // eslint-disable-next-line max-len
	    new RegExp('[\\x00-\\x1f\\x5c\\x7f-\\x9f]|[\\ud800-\\udbff](?![\\udc00-\\udfff])|(?<![\\ud800-\\udbff])[\\udc00-\\udfff]', 'g');
	  const extractedNewLineRe = new RegExp('(?<=\\n)');
	  extractedSplitNewLines = (value) => RegExpPrototypeSymbolSplit(extractedNewLineRe, value);
	  /* c8 ignore start */
	  // CI doesn't run in an elderly runtime
	} catch {
	  // These are from a previous version of node,
	  // see commit 76372607a6743cc75eae50ca58657c9e8a654428
	  // dated 2021-12-06
	  strEscapeSequencesRegExp = /[\x00-\x1f\x27\x5c\x7f-\x9f]/;
	  strEscapeSequencesReplacer = /[\x00-\x1f\x27\x5c\x7f-\x9f]/g;
	  strEscapeSequencesRegExpSingle = /[\x00-\x1f\x5c\x7f-\x9f]/;
	  strEscapeSequencesReplacerSingle = /[\x00-\x1f\x5c\x7f-\x9f]/g;
	  extractedSplitNewLines = (value) => {
	    const lines = RegExpPrototypeSymbolSplit(/\n/, value);
	    const last = ArrayPrototypePop(lines);
	    const nlLines = ArrayPrototypeMap(lines, (line) => line + '\n');
	    if (last !== '') {
	      nlLines.push(last);
	    }
	    return nlLines;
	  };
	}
	/* c8 ignore stop */
	/* eslint-enable no-control-regex */

	const keyStrRegExp = /^[a-zA-Z_][a-zA-Z_0-9]*$/;
	const numberRegExp = /^(0|[1-9][0-9]*)$/;

	const coreModuleRegExp = /^ {4}at (?:[^/\\(]+ \(|)node:(.+):\d+:\d+\)?$/;
	const nodeModulesRegExp = /[/\\]node_modules[/\\](.+?)(?=[/\\])/g;

	const classRegExp = /^(\s+[^(]*?)\s*{/;
	// eslint-disable-next-line node-core/no-unescaped-regexp-dot
	const stripCommentsRegExp = /(\/\/.*?\n)|(\/\*(.|\n)*?\*\/)/g;

	const kMinLineLength = 16;

	// Constants to map the iterator state.
	const kWeak = 0;
	const kIterator = 1;
	const kMapEntries = 2;

	// Escaped control characters (plus the single quote and the backslash). Use
	// empty strings to fill up unused entries.
	const meta = [
	  '\\x00', '\\x01', '\\x02', '\\x03', '\\x04', '\\x05', '\\x06', '\\x07', // x07
	  '\\b', '\\t', '\\n', '\\x0B', '\\f', '\\r', '\\x0E', '\\x0F',           // x0F
	  '\\x10', '\\x11', '\\x12', '\\x13', '\\x14', '\\x15', '\\x16', '\\x17', // x17
	  '\\x18', '\\x19', '\\x1A', '\\x1B', '\\x1C', '\\x1D', '\\x1E', '\\x1F', // x1F
	  '', '', '', '', '', '', '', "\\'", '', '', '', '', '', '', '', '',      // x2F
	  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',         // x3F
	  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',         // x4F
	  '', '', '', '', '', '', '', '', '', '', '', '', '\\\\', '', '', '',     // x5F
	  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',         // x6F
	  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '\\x7F',    // x7F
	  '\\x80', '\\x81', '\\x82', '\\x83', '\\x84', '\\x85', '\\x86', '\\x87', // x87
	  '\\x88', '\\x89', '\\x8A', '\\x8B', '\\x8C', '\\x8D', '\\x8E', '\\x8F', // x8F
	  '\\x90', '\\x91', '\\x92', '\\x93', '\\x94', '\\x95', '\\x96', '\\x97', // x97
	  '\\x98', '\\x99', '\\x9A', '\\x9B', '\\x9C', '\\x9D', '\\x9E', '\\x9F', // x9F
	];

	// Regex used for ansi escape code splitting
	// Adopted from https://github.com/chalk/ansi-regex/blob/HEAD/index.js
	// License: MIT, authors: @sindresorhus, Qix-, arjunmehta and LitoMore
	// Matches all ansi escape code sequences in a string
	const ansiPattern = '[\\u001B\\u009B][[\\]()#;?]*' +
	  '(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*' +
	  '|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)' +
	  '|(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))';
	const ansi = new RegExp(ansiPattern, 'g');

	let getStringWidth;

	function getUserOptions(ctx, isCrossContext) {
	  const ret = {
	    stylize: ctx.stylize,
	    showHidden: ctx.showHidden,
	    depth: ctx.depth,
	    colors: ctx.colors,
	    customInspect: ctx.customInspect,
	    showProxy: ctx.showProxy,
	    maxArrayLength: ctx.maxArrayLength,
	    maxStringLength: ctx.maxStringLength,
	    breakLength: ctx.breakLength,
	    compact: ctx.compact,
	    sorted: ctx.sorted,
	    getters: ctx.getters,
	    numericSeparator: ctx.numericSeparator,
	    ...ctx.userOptions,
	  };

	  // Typically, the target value will be an instance of `Object`. If that is
	  // *not* the case, the object may come from another vm.Context, and we want
	  // to avoid passing it objects from this Context in that case, so we remove
	  // the prototype from the returned object itself + the `stylize()` function,
	  // and remove all other non-primitives, including non-primitive user options.
	  if (isCrossContext) {
	    ObjectSetPrototypeOf(ret, null);
	    for (const key of ObjectKeys(ret)) {
	      if ((typeof ret[key] === 'object' || typeof ret[key] === 'function') &&
	          ret[key] !== null) {
	        delete ret[key];
	      }
	    }
	    ret.stylize = ObjectSetPrototypeOf((value, flavour) => {
	      let stylized;
	      try {
	        stylized = `${ctx.stylize(value, flavour)}`;
	      } catch {
	        // Continue regardless of error.
	      }

	      if (typeof stylized !== 'string') return value;
	      // `stylized` is a string as it should be, which is safe to pass along.
	      return stylized;
	    }, null);
	  }

	  return ret;
	}

	/**
	 * Echos the value of any input. Tries to print the value out
	 * in the best way possible given the different types.
	 * @param {any} value The value to print out.
	 * @param {object} opts Optional options object that alters the output.
	 */
	/* Legacy: value, showHidden, depth, colors */
	function inspect(value, opts) {
	  // Default options
	  const ctx = {
	    budget: {},
	    indentationLvl: 0,
	    seen: [],
	    currentDepth: 0,
	    stylize: stylizeNoColor,
	    showHidden: inspectDefaultOptions.showHidden,
	    depth: inspectDefaultOptions.depth,
	    colors: inspectDefaultOptions.colors,
	    customInspect: inspectDefaultOptions.customInspect,
	    showProxy: inspectDefaultOptions.showProxy,
	    maxArrayLength: inspectDefaultOptions.maxArrayLength,
	    maxStringLength: inspectDefaultOptions.maxStringLength,
	    breakLength: inspectDefaultOptions.breakLength,
	    compact: inspectDefaultOptions.compact,
	    sorted: inspectDefaultOptions.sorted,
	    getters: inspectDefaultOptions.getters,
	    numericSeparator: inspectDefaultOptions.numericSeparator,
	  };
	  if (arguments.length > 1) {
	    // Legacy...
	    if (arguments.length > 2) {
	      if (arguments[2] !== undefined) {
	        ctx.depth = arguments[2];
	      }
	      if (arguments.length > 3 && arguments[3] !== undefined) {
	        ctx.colors = arguments[3];
	      }
	    }
	    // Set user-specified options
	    if (typeof opts === 'boolean') {
	      ctx.showHidden = opts;
	    } else if (opts) {
	      const optKeys = ObjectKeys(opts);
	      for (let i = 0; i < optKeys.length; ++i) {
	        const key = optKeys[i];
	        // TODO(BridgeAR): Find a solution what to do about stylize. Either make
	        // this function public or add a new API with a similar or better
	        // functionality.
	        if (
	          ObjectPrototypeHasOwnProperty(inspectDefaultOptions, key) ||
	          key === 'stylize') {
	          ctx[key] = opts[key];
	        } else if (ctx.userOptions === undefined) {
	          // This is required to pass through the actual user input.
	          ctx.userOptions = opts;
	        }
	      }
	    }
	  }
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  if (ctx.maxArrayLength === null) ctx.maxArrayLength = Infinity;
	  if (ctx.maxStringLength === null) ctx.maxStringLength = Infinity;
	  return formatValue(ctx, value, 0);
	}
	inspect.custom = customInspectSymbol;

	ObjectDefineProperty(inspect, 'defaultOptions', {
	  __proto__: null,
	  get() {
	    return inspectDefaultOptions;
	  },
	  set(options) {
	    validateObject(options, 'options');
	    return ObjectAssign(inspectDefaultOptions, options);
	  },
	});

	// Set Graphics Rendition https://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	// Each color consists of an array with the color code as first entry and the
	// reset code as second entry.
	const defaultFG = 39;
	const defaultBG = 49;
	inspect.colors = {
	  __proto__: null,
	  reset: [0, 0],
	  bold: [1, 22],
	  dim: [2, 22], // Alias: faint
	  italic: [3, 23],
	  underline: [4, 24],
	  blink: [5, 25],
	  // Swap foreground and background colors
	  inverse: [7, 27], // Alias: swapcolors, swapColors
	  hidden: [8, 28], // Alias: conceal
	  strikethrough: [9, 29], // Alias: strikeThrough, crossedout, crossedOut
	  doubleunderline: [21, 24], // Alias: doubleUnderline
	  black: [30, defaultFG],
	  red: [31, defaultFG],
	  green: [32, defaultFG],
	  yellow: [33, defaultFG],
	  blue: [34, defaultFG],
	  magenta: [35, defaultFG],
	  cyan: [36, defaultFG],
	  white: [37, defaultFG],
	  bgBlack: [40, defaultBG],
	  bgRed: [41, defaultBG],
	  bgGreen: [42, defaultBG],
	  bgYellow: [43, defaultBG],
	  bgBlue: [44, defaultBG],
	  bgMagenta: [45, defaultBG],
	  bgCyan: [46, defaultBG],
	  bgWhite: [47, defaultBG],
	  framed: [51, 54],
	  overlined: [53, 55],
	  gray: [90, defaultFG], // Alias: grey, blackBright
	  redBright: [91, defaultFG],
	  greenBright: [92, defaultFG],
	  yellowBright: [93, defaultFG],
	  blueBright: [94, defaultFG],
	  magentaBright: [95, defaultFG],
	  cyanBright: [96, defaultFG],
	  whiteBright: [97, defaultFG],
	  bgGray: [100, defaultBG], // Alias: bgGrey, bgBlackBright
	  bgRedBright: [101, defaultBG],
	  bgGreenBright: [102, defaultBG],
	  bgYellowBright: [103, defaultBG],
	  bgBlueBright: [104, defaultBG],
	  bgMagentaBright: [105, defaultBG],
	  bgCyanBright: [106, defaultBG],
	  bgWhiteBright: [107, defaultBG],
	};

	function defineColorAlias(target, alias) {
	  ObjectDefineProperty(inspect.colors, alias, {
	    __proto__: null,
	    get() {
	      return this[target];
	    },
	    set(value) {
	      this[target] = value;
	    },
	    configurable: true,
	    enumerable: false,
	  });
	}

	defineColorAlias('gray', 'grey');
	defineColorAlias('gray', 'blackBright');
	defineColorAlias('bgGray', 'bgGrey');
	defineColorAlias('bgGray', 'bgBlackBright');
	defineColorAlias('dim', 'faint');
	defineColorAlias('strikethrough', 'crossedout');
	defineColorAlias('strikethrough', 'strikeThrough');
	defineColorAlias('strikethrough', 'crossedOut');
	defineColorAlias('hidden', 'conceal');
	defineColorAlias('inverse', 'swapColors');
	defineColorAlias('inverse', 'swapcolors');
	defineColorAlias('doubleunderline', 'doubleUnderline');

	// TODO(BridgeAR): Add function style support for more complex styles.
	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = ObjectAssign({ __proto__: null }, {
	  special: 'cyan',
	  number: 'yellow',
	  bigint: 'yellow',
	  boolean: 'yellow',
	  undefined: 'grey',
	  null: 'bold',
	  string: 'green',
	  symbol: 'green',
	  date: 'magenta',
	  // "name": intentionally not styling
	  // TODO(BridgeAR): Highlight regular expressions properly.
	  regexp: 'red',
	  module: 'underline',
	});

	function addQuotes(str, quotes) {
	  if (quotes === -1) {
	    return `"${str}"`;
	  }
	  if (quotes === -2) {
	    return `\`${str}\``;
	  }
	  return `'${str}'`;
	}

	function escapeFn(str) {
	  const charCode = StringPrototypeCharCodeAt(str);
	  return meta.length > charCode ? meta[charCode] : `\\u${NumberPrototypeToString(charCode, 16)}`;
	}

	// Escape control characters, single quotes and the backslash.
	// This is similar to JSON stringify escaping.
	function strEscape(str) {
	  let escapeTest = strEscapeSequencesRegExp;
	  let escapeReplace = strEscapeSequencesReplacer;
	  let singleQuote = 39;

	  // Check for double quotes. If not present, do not escape single quotes and
	  // instead wrap the text in double quotes. If double quotes exist, check for
	  // backticks. If they do not exist, use those as fallback instead of the
	  // double quotes.
	  if (StringPrototypeIncludes(str, "'")) {
	    // This invalidates the charCode and therefore can not be matched for
	    // anymore.
	    if (!StringPrototypeIncludes(str, '"')) {
	      singleQuote = -1;
	    } else if (!StringPrototypeIncludes(str, '`') &&
	               !StringPrototypeIncludes(str, '${')) {
	      singleQuote = -2;
	    }
	    if (singleQuote !== 39) {
	      escapeTest = strEscapeSequencesRegExpSingle;
	      escapeReplace = strEscapeSequencesReplacerSingle;
	    }
	  }

	  // Some magic numbers that worked out fine while benchmarking with v8 6.0
	  if (str.length < 5000 && RegExpPrototypeExec(escapeTest, str) === null)
	    return addQuotes(str, singleQuote);
	  if (str.length > 100) {
	    str = RegExpPrototypeSymbolReplace(escapeReplace, str, escapeFn);
	    return addQuotes(str, singleQuote);
	  }

	  let result = '';
	  let last = 0;
	  for (let i = 0; i < str.length; i++) {
	    const point = StringPrototypeCharCodeAt(str, i);
	    if (point === singleQuote ||
	        point === 92 ||
	        point < 32 ||
	        (point > 126 && point < 160)) {
	      if (last === i) {
	        result += meta[point];
	      } else {
	        result += `${StringPrototypeSlice(str, last, i)}${meta[point]}`;
	      }
	      last = i + 1;
	    } else if (point >= 0xd800 && point <= 0xdfff) {
	      if (point <= 0xdbff && i + 1 < str.length) {
	        const point = StringPrototypeCharCodeAt(str, i + 1);
	        if (point >= 0xdc00 && point <= 0xdfff) {
	          i++;
	          continue;
	        }
	      }
	      result += `${StringPrototypeSlice(str, last, i)}\\u${NumberPrototypeToString(point, 16)}`;
	      last = i + 1;
	    }
	  }

	  if (last !== str.length) {
	    result += StringPrototypeSlice(str, last);
	  }
	  return addQuotes(result, singleQuote);
	}

	function stylizeWithColor(str, styleType) {
	  const style = inspect.styles[styleType];
	  if (style !== undefined) {
	    const color = inspect.colors[style];
	    if (color !== undefined)
	      return `\u001b[${color[0]}m${str}\u001b[${color[1]}m`;
	  }
	  return str;
	}

	function stylizeNoColor(str) {
	  return str;
	}

	// Return a new empty array to push in the results of the default formatter.
	function getEmptyFormatArray() {
	  return [];
	}

	function isInstanceof(object, proto) {
	  try {
	    return object instanceof proto;
	  } catch {
	    return false;
	  }
	}

	function getConstructorName(obj, ctx, recurseTimes, protoProps) {
	  let firstProto;
	  const tmp = obj;
	  while (obj || isUndetectableObject(obj)) {
	    const descriptor = ObjectGetOwnPropertyDescriptor(obj, 'constructor');
	    if (descriptor !== undefined &&
	        typeof descriptor.value === 'function' &&
	        descriptor.value.name !== '' &&
	        isInstanceof(tmp, descriptor.value)) {
	      if (protoProps !== undefined &&
	         (firstProto !== obj ||
	         !builtInObjects.has(descriptor.value.name))) {
	        addPrototypeProperties(
	          ctx, tmp, firstProto || tmp, recurseTimes, protoProps);
	      }
	      return String(descriptor.value.name);
	    }

	    obj = ObjectGetPrototypeOf(obj);
	    if (firstProto === undefined) {
	      firstProto = obj;
	    }
	  }

	  if (firstProto === null) {
	    return null;
	  }

	  const res = internalGetConstructorName(tmp);

	  if (recurseTimes > ctx.depth && ctx.depth !== null) {
	    return `${res} <Complex prototype>`;
	  }

	  const protoConstr = getConstructorName(
	    firstProto, ctx, recurseTimes + 1, protoProps);

	  if (protoConstr === null) {
	    return `${res} <${inspect(firstProto, {
	      ...ctx,
	      customInspect: false,
	      depth: -1,
	    })}>`;
	  }

	  return `${res} <${protoConstr}>`;
	}

	// This function has the side effect of adding prototype properties to the
	// `output` argument (which is an array). This is intended to highlight user
	// defined prototype properties.
	function addPrototypeProperties(ctx, main, obj, recurseTimes, output) {
	  let depth = 0;
	  let keys;
	  let keySet;
	  do {
	    if (depth !== 0 || main === obj) {
	      obj = ObjectGetPrototypeOf(obj);
	      // Stop as soon as a null prototype is encountered.
	      if (obj === null) {
	        return;
	      }
	      // Stop as soon as a built-in object type is detected.
	      const descriptor = ObjectGetOwnPropertyDescriptor(obj, 'constructor');
	      if (descriptor !== undefined &&
	          typeof descriptor.value === 'function' &&
	          builtInObjects.has(descriptor.value.name)) {
	        return;
	      }
	    }

	    if (depth === 0) {
	      keySet = new SafeSet();
	    } else {
	      ArrayPrototypeForEach(keys, (key) => keySet.add(key));
	    }
	    // Get all own property names and symbols.
	    keys = ReflectOwnKeys(obj);
	    ArrayPrototypePush(ctx.seen, main);
	    for (const key of keys) {
	      // Ignore the `constructor` property and keys that exist on layers above.
	      if (key === 'constructor' ||
	          ObjectPrototypeHasOwnProperty(main, key) ||
	          (depth !== 0 && keySet.has(key))) {
	        continue;
	      }
	      const desc = ObjectGetOwnPropertyDescriptor(obj, key);
	      if (typeof desc.value === 'function') {
	        continue;
	      }
	      const value = formatProperty(
	        ctx, obj, recurseTimes, key, kObjectType, desc, main);
	      if (ctx.colors) {
	        // Faint!
	        ArrayPrototypePush(output, `\u001b[2m${value}\u001b[22m`);
	      } else {
	        ArrayPrototypePush(output, value);
	      }
	    }
	    ArrayPrototypePop(ctx.seen);
	  // Limit the inspection to up to three prototype layers. Using `recurseTimes`
	  // is not a good choice here, because it's as if the properties are declared
	  // on the current object from the users perspective.
	  } while (++depth !== 3);
	}

	function getPrefix(constructor, tag, fallback, size = '') {
	  if (constructor === null) {
	    if (tag !== '' && fallback !== tag) {
	      return `[${fallback}${size}: null prototype] [${tag}] `;
	    }
	    return `[${fallback}${size}: null prototype] `;
	  }

	  if (tag !== '' && constructor !== tag) {
	    return `${constructor}${size} [${tag}] `;
	  }
	  return `${constructor}${size} `;
	}

	// Look up the keys of the object.
	function getKeys(value, showHidden) {
	  let keys;
	  const symbols = ObjectGetOwnPropertySymbols(value);
	  if (showHidden) {
	    keys = ObjectGetOwnPropertyNames(value);
	    if (symbols.length !== 0)
	      ArrayPrototypePushApply(keys, symbols);
	  } else {
	    // This might throw if `value` is a Module Namespace Object from an
	    // unevaluated module, but we don't want to perform the actual type
	    // check because it's expensive.
	    // TODO(devsnek): track https://github.com/tc39/ecma262/issues/1209
	    // and modify this logic as needed.
	    try {
	      keys = ObjectKeys(value);
	    } catch (err) {
	      assert(isNativeError(err) && err.name === 'ReferenceError' &&
	             isModuleNamespaceObject(value));
	      keys = ObjectGetOwnPropertyNames(value);
	    }
	    if (symbols.length !== 0) {
	      const filter = (key) => ObjectPrototypePropertyIsEnumerable(value, key);
	      ArrayPrototypePushApply(keys, ArrayPrototypeFilter(symbols, filter));
	    }
	  }
	  return keys;
	}

	function getCtxStyle(value, constructor, tag) {
	  let fallback = '';
	  if (constructor === null) {
	    fallback = internalGetConstructorName(value);
	    if (fallback === tag) {
	      fallback = 'Object';
	    }
	  }
	  return getPrefix(constructor, tag, fallback);
	}

	function formatProxy(ctx, proxy, recurseTimes) {
	  if (recurseTimes > ctx.depth && ctx.depth !== null) {
	    return ctx.stylize('Proxy [Array]', 'special');
	  }
	  recurseTimes += 1;
	  ctx.indentationLvl += 2;
	  const res = [
	    formatValue(ctx, proxy[0], recurseTimes),
	    formatValue(ctx, proxy[1], recurseTimes),
	  ];
	  ctx.indentationLvl -= 2;
	  return reduceToSingleString(
	    ctx, res, '', ['Proxy [', ']'], kArrayExtrasType, recurseTimes);
	}

	// Note: using `formatValue` directly requires the indentation level to be
	// corrected by setting `ctx.indentationLvL += diff` and then to decrease the
	// value afterwards again.
	function formatValue(ctx, value, recurseTimes, typedArray) {
	  // Primitive types cannot have properties.
	  if (typeof value !== 'object' &&
	      typeof value !== 'function' &&
	      !isUndetectableObject(value)) {
	    return formatPrimitive(ctx.stylize, value, ctx);
	  }
	  if (value === null) {
	    return ctx.stylize('null', 'null');
	  }

	  // Memorize the context for custom inspection on proxies.
	  const context = value;
	  // Always check for proxies to prevent side effects and to prevent triggering
	  // any proxy handlers.
	  const proxy = getProxyDetails(value, !!ctx.showProxy);
	  if (proxy !== undefined) {
	    if (proxy === null || proxy[0] === null) {
	      return ctx.stylize('<Revoked Proxy>', 'special');
	    }
	    if (ctx.showProxy) {
	      return formatProxy(ctx, proxy, recurseTimes);
	    }
	    value = proxy;
	  }

	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it.
	  if (ctx.customInspect) {
	    const maybeCustom = value[customInspectSymbol];
	    if (typeof maybeCustom === 'function' &&
	        // Filter out the util module, its inspect function is special.
	        maybeCustom !== inspect &&
	        // Also filter out any prototype objects using the circular check.
	        !(value.constructor && value.constructor.prototype === value)) {
	      // This makes sure the recurseTimes are reported as before while using
	      // a counter internally.
	      const depth = ctx.depth === null ? null : ctx.depth - recurseTimes;
	      const isCrossContext =
	        proxy !== undefined || !(context instanceof Object);
	      const ret = FunctionPrototypeCall(
	        maybeCustom,
	        context,
	        depth,
	        getUserOptions(ctx, isCrossContext),
	        inspect,
	      );
	      // If the custom inspection method returned `this`, don't go into
	      // infinite recursion.
	      if (ret !== context) {
	        if (typeof ret !== 'string') {
	          return formatValue(ctx, ret, recurseTimes);
	        }
	        return StringPrototypeReplaceAll(ret, '\n', `\n${StringPrototypeRepeat(' ', ctx.indentationLvl)}`);
	      }
	    }
	  }

	  // Using an array here is actually better for the average case than using
	  // a Set. `seen` will only check for the depth and will never grow too large.
	  if (ctx.seen.includes(value)) {
	    let index = 1;
	    if (ctx.circular === undefined) {
	      ctx.circular = new SafeMap();
	      ctx.circular.set(value, index);
	    } else {
	      index = ctx.circular.get(value);
	      if (index === undefined) {
	        index = ctx.circular.size + 1;
	        ctx.circular.set(value, index);
	      }
	    }
	    return ctx.stylize(`[Circular *${index}]`, 'special');
	  }

	  return formatRaw(ctx, value, recurseTimes, typedArray);
	}

	function formatRaw(ctx, value, recurseTimes, typedArray) {
	  let keys;
	  let protoProps;
	  if (ctx.showHidden && (recurseTimes <= ctx.depth || ctx.depth === null)) {
	    protoProps = [];
	  }

	  const constructor = getConstructorName(value, ctx, recurseTimes, protoProps);
	  // Reset the variable to check for this later on.
	  if (protoProps !== undefined && protoProps.length === 0) {
	    protoProps = undefined;
	  }

	  let tag = value[SymbolToStringTag];
	  // Only list the tag in case it's non-enumerable / not an own property.
	  // Otherwise we'd print this twice.
	  if (typeof tag !== 'string' ||
	      (tag !== '' &&
	      (ctx.showHidden ?
	        ObjectPrototypeHasOwnProperty :
	        ObjectPrototypePropertyIsEnumerable)(
	        value, SymbolToStringTag,
	      ))) {
	    tag = '';
	  }
	  let base = '';
	  let formatter = getEmptyFormatArray;
	  let braces;
	  let noIterator = true;
	  let i = 0;
	  const filter = ctx.showHidden ? ALL_PROPERTIES : ONLY_ENUMERABLE;

	  let extrasType = kObjectType;

	  // Iterators and the rest are split to reduce checks.
	  // We have to check all values in case the constructor is set to null.
	  // Otherwise it would not possible to identify all types properly.
	  if (SymbolIterator in value || constructor === null) {
	    noIterator = false;
	    if (ArrayIsArray(value)) {
	      // Only set the constructor for non ordinary ("Array [...]") arrays.
	      const prefix = (constructor !== 'Array' || tag !== '') ?
	        getPrefix(constructor, tag, 'Array', `(${value.length})`) :
	        '';
	      keys = getOwnNonIndexProperties(value, filter);
	      braces = [`${prefix}[`, ']'];
	      if (value.length === 0 && keys.length === 0 && protoProps === undefined)
	        return `${braces[0]}]`;
	      extrasType = kArrayExtrasType;
	      formatter = formatArray;
	    } else if (isSet(value)) {
	      const size = SetPrototypeGetSize(value);
	      const prefix = getPrefix(constructor, tag, 'Set', `(${size})`);
	      keys = getKeys(value, ctx.showHidden);
	      formatter = constructor !== null ?
	        FunctionPrototypeBind(formatSet, null, value) :
	        FunctionPrototypeBind(formatSet, null, SetPrototypeValues(value));
	      if (size === 0 && keys.length === 0 && protoProps === undefined)
	        return `${prefix}{}`;
	      braces = [`${prefix}{`, '}'];
	    } else if (isMap(value)) {
	      const size = MapPrototypeGetSize(value);
	      const prefix = getPrefix(constructor, tag, 'Map', `(${size})`);
	      keys = getKeys(value, ctx.showHidden);
	      formatter = constructor !== null ?
	        FunctionPrototypeBind(formatMap, null, value) :
	        FunctionPrototypeBind(formatMap, null, MapPrototypeEntries(value));
	      if (size === 0 && keys.length === 0 && protoProps === undefined)
	        return `${prefix}{}`;
	      braces = [`${prefix}{`, '}'];
	    } else if (isTypedArray(value)) {
	      keys = getOwnNonIndexProperties(value, filter);
	      let bound = value;
	      let fallback = '';
	      if (constructor === null) {
	        fallback = TypedArrayPrototypeGetSymbolToStringTag(value);
	        // Reconstruct the array information.
	        bound = new primordials[fallback](value);
	      }
	      const size = TypedArrayPrototypeGetLength(value);
	      const prefix = getPrefix(constructor, tag, fallback, `(${size})`);
	      braces = [`${prefix}[`, ']'];
	      if (value.length === 0 && keys.length === 0 && !ctx.showHidden)
	        return `${braces[0]}]`;
	      // Special handle the value. The original value is required below. The
	      // bound function is required to reconstruct missing information.
	      formatter = FunctionPrototypeBind(formatTypedArray, null, bound, size);
	      extrasType = kArrayExtrasType;
	    } else if (isMapIterator(value)) {
	      keys = getKeys(value, ctx.showHidden);
	      braces = getIteratorBraces('Map', tag);
	      // Add braces to the formatter parameters.
	      formatter = FunctionPrototypeBind(formatIterator, null, braces);
	    } else if (isSetIterator(value)) {
	      keys = getKeys(value, ctx.showHidden);
	      braces = getIteratorBraces('Set', tag);
	      // Add braces to the formatter parameters.
	      formatter = FunctionPrototypeBind(formatIterator, null, braces);
	    } else {
	      noIterator = true;
	    }
	  }
	  if (noIterator) {
	    keys = getKeys(value, ctx.showHidden);
	    braces = ['{', '}'];
	    if (constructor === 'Object') {
	      if (isArgumentsObject(value)) {
	        braces[0] = '[Arguments] {';
	      } else if (tag !== '') {
	        braces[0] = `${getPrefix(constructor, tag, 'Object')}{`;
	      }
	      if (keys.length === 0 && protoProps === undefined) {
	        return `${braces[0]}}`;
	      }
	    } else if (typeof value === 'function') {
	      base = getFunctionBase(value, constructor, tag);
	      if (keys.length === 0 && protoProps === undefined)
	        return ctx.stylize(base, 'special');
	    } else if (isRegExp(value)) {
	      // Make RegExps say that they are RegExps
	      base = RegExpPrototypeToString(
	        constructor !== null ? value : new RegExp(value),
	      );
	      const prefix = getPrefix(constructor, tag, 'RegExp');
	      if (prefix !== 'RegExp ')
	        base = `${prefix}${base}`;
	      if ((keys.length === 0 && protoProps === undefined) ||
	          (recurseTimes > ctx.depth && ctx.depth !== null)) {
	        return ctx.stylize(base, 'regexp');
	      }
	    } else if (isDate(value)) {
	      // Make dates with properties first say the date
	      base = NumberIsNaN(DatePrototypeGetTime(value)) ?
	        DatePrototypeToString(value) :
	        DatePrototypeToISOString(value);
	      const prefix = getPrefix(constructor, tag, 'Date');
	      if (prefix !== 'Date ')
	        base = `${prefix}${base}`;
	      if (keys.length === 0 && protoProps === undefined) {
	        return ctx.stylize(base, 'date');
	      }
	    } else if (isError(value)) {
	      base = formatError(value, constructor, tag, ctx, keys);
	      if (keys.length === 0 && protoProps === undefined)
	        return base;
	    } else if (isAnyArrayBuffer(value)) {
	      // Fast path for ArrayBuffer and SharedArrayBuffer.
	      // Can't do the same for DataView because it has a non-primitive
	      // .buffer property that we need to recurse for.
	      const arrayType = isArrayBuffer(value) ? 'ArrayBuffer' :
	        'SharedArrayBuffer';
	      const prefix = getPrefix(constructor, tag, arrayType);
	      if (typedArray === undefined) {
	        formatter = formatArrayBuffer;
	      } else if (keys.length === 0 && protoProps === undefined) {
	        return prefix +
	              `{ byteLength: ${formatNumber(ctx.stylize, value.byteLength, false)} }`;
	      }
	      braces[0] = `${prefix}{`;
	      ArrayPrototypeUnshift(keys, 'byteLength');
	    } else if (isDataView(value)) {
	      braces[0] = `${getPrefix(constructor, tag, 'DataView')}{`;
	      // .buffer goes last, it's not a primitive like the others.
	      ArrayPrototypeUnshift(keys, 'byteLength', 'byteOffset', 'buffer');
	    } else if (isPromise(value)) {
	      braces[0] = `${getPrefix(constructor, tag, 'Promise')}{`;
	      formatter = formatPromise;
	    } else if (isWeakSet(value)) {
	      braces[0] = `${getPrefix(constructor, tag, 'WeakSet')}{`;
	      formatter = ctx.showHidden ? formatWeakSet : formatWeakCollection;
	    } else if (isWeakMap(value)) {
	      braces[0] = `${getPrefix(constructor, tag, 'WeakMap')}{`;
	      formatter = ctx.showHidden ? formatWeakMap : formatWeakCollection;
	    } else if (isModuleNamespaceObject(value)) {
	      braces[0] = `${getPrefix(constructor, tag, 'Module')}{`;
	      // Special handle keys for namespace objects.
	      formatter = formatNamespaceObject.bind(null, keys);
	    } else if (isBoxedPrimitive(value)) {
	      base = getBoxedBase(value, ctx, keys, constructor, tag);
	      if (keys.length === 0 && protoProps === undefined) {
	        return base;
	      }
	    } else {
	      if (keys.length === 0 && protoProps === undefined) {
	        if (isExternal(value)) {
	          const address = getExternalValue(value).toString(16);
	          return ctx.stylize(`[External: ${address}]`, 'special');
	        }
	        return `${getCtxStyle(value, constructor, tag)}{}`;
	      }
	      braces[0] = `${getCtxStyle(value, constructor, tag)}{`;
	    }
	  }

	  if (recurseTimes > ctx.depth && ctx.depth !== null) {
	    let constructorName = StringPrototypeSlice(getCtxStyle(value, constructor, tag), 0, -1);
	    if (constructor !== null)
	      constructorName = `[${constructorName}]`;
	    return ctx.stylize(constructorName, 'special');
	  }
	  recurseTimes += 1;

	  ctx.seen.push(value);
	  ctx.currentDepth = recurseTimes;
	  let output;
	  const indentationLvl = ctx.indentationLvl;
	  try {
	    output = formatter(ctx, value, recurseTimes);
	    for (i = 0; i < keys.length; i++) {
	      ArrayPrototypePush(
	        output,
	        formatProperty(ctx, value, recurseTimes, keys[i], extrasType),
	      );
	    }
	    if (protoProps !== undefined) {
	      ArrayPrototypePushApply(output, protoProps);
	    }
	  } catch (err) {
	    const constructorName = StringPrototypeSlice(getCtxStyle(value, constructor, tag), 0, -1);
	    return handleMaxCallStackSize(ctx, err, constructorName, indentationLvl);
	  }
	  if (ctx.circular !== undefined) {
	    const index = ctx.circular.get(value);
	    if (index !== undefined) {
	      const reference = ctx.stylize(`<ref *${index}>`, 'special');
	      // Add reference always to the very beginning of the output.
	      if (ctx.compact !== true) {
	        base = base === '' ? reference : `${reference} ${base}`;
	      } else {
	        braces[0] = `${reference} ${braces[0]}`;
	      }
	    }
	  }
	  ctx.seen.pop();

	  if (ctx.sorted) {
	    const comparator = ctx.sorted === true ? undefined : ctx.sorted;
	    if (extrasType === kObjectType) {
	      ArrayPrototypeSort(output, comparator);
	    } else if (keys.length > 1) {
	      const sorted = ArrayPrototypeSort(ArrayPrototypeSlice(output, output.length - keys.length), comparator);
	      ArrayPrototypeUnshift(sorted, output, output.length - keys.length, keys.length);
	      ReflectApply(ArrayPrototypeSplice, null, sorted);
	    }
	  }

	  const res = reduceToSingleString(
	    ctx, output, base, braces, extrasType, recurseTimes, value);
	  const budget = ctx.budget[ctx.indentationLvl] || 0;
	  const newLength = budget + res.length;
	  ctx.budget[ctx.indentationLvl] = newLength;
	  // If any indentationLvl exceeds this limit, limit further inspecting to the
	  // minimum. Otherwise the recursive algorithm might continue inspecting the
	  // object even though the maximum string size (~2 ** 28 on 32 bit systems and
	  // ~2 ** 30 on 64 bit systems) exceeded. The actual output is not limited at
	  // exactly 2 ** 27 but a bit higher. This depends on the object shape.
	  // This limit also makes sure that huge objects don't block the event loop
	  // significantly.
	  if (newLength > 2 ** 27) {
	    ctx.depth = -1;
	  }
	  return res;
	}

	function getIteratorBraces(type, tag) {
	  if (tag !== `${type} Iterator`) {
	    if (tag !== '')
	      tag += '] [';
	    tag += `${type} Iterator`;
	  }
	  return [`[${tag}] {`, '}'];
	}

	function getBoxedBase(value, ctx, keys, constructor, tag) {
	  let fn;
	  let type;
	  if (isNumberObject(value)) {
	    fn = NumberPrototypeValueOf;
	    type = 'Number';
	  } else if (isStringObject(value)) {
	    fn = StringPrototypeValueOf;
	    type = 'String';
	    // For boxed Strings, we have to remove the 0-n indexed entries,
	    // since they just noisy up the output and are redundant
	    // Make boxed primitive Strings look like such
	    keys.splice(0, value.length);
	  } else if (isBooleanObject(value)) {
	    fn = BooleanPrototypeValueOf;
	    type = 'Boolean';
	  } else if (isBigIntObject(value)) {
	    fn = BigIntPrototypeValueOf;
	    type = 'BigInt';
	  } else {
	    fn = SymbolPrototypeValueOf;
	    type = 'Symbol';
	  }
	  let base = `[${type}`;
	  if (type !== constructor) {
	    if (constructor === null) {
	      base += ' (null prototype)';
	    } else {
	      base += ` (${constructor})`;
	    }
	  }
	  base += `: ${formatPrimitive(stylizeNoColor, fn(value), ctx)}]`;
	  if (tag !== '' && tag !== constructor) {
	    base += ` [${tag}]`;
	  }
	  if (keys.length !== 0 || ctx.stylize === stylizeNoColor)
	    return base;
	  return ctx.stylize(base, StringPrototypeToLowerCase(type));
	}

	function getClassBase(value, constructor, tag) {
	  const hasName = ObjectPrototypeHasOwnProperty(value, 'name');
	  const name = (hasName && value.name) || '(anonymous)';
	  let base = `class ${name}`;
	  if (constructor !== 'Function' && constructor !== null) {
	    base += ` [${constructor}]`;
	  }
	  if (tag !== '' && constructor !== tag) {
	    base += ` [${tag}]`;
	  }
	  if (constructor !== null) {
	    const superName = ObjectGetPrototypeOf(value).name;
	    if (superName) {
	      base += ` extends ${superName}`;
	    }
	  } else {
	    base += ' extends [null prototype]';
	  }
	  return `[${base}]`;
	}

	function getFunctionBase(value, constructor, tag) {
	  const stringified = FunctionPrototypeToString(value);
	  if (StringPrototypeStartsWith(stringified, 'class') && StringPrototypeEndsWith(stringified, '}')) {
	    const slice = StringPrototypeSlice(stringified, 5, -1);
	    const bracketIndex = StringPrototypeIndexOf(slice, '{');
	    if (bracketIndex !== -1 &&
	        (!StringPrototypeIncludes(StringPrototypeSlice(slice, 0, bracketIndex), '(') ||
	        // Slow path to guarantee that it's indeed a class.
	        RegExpPrototypeExec(classRegExp, RegExpPrototypeSymbolReplace(stripCommentsRegExp, slice)) !== null)
	    ) {
	      return getClassBase(value, constructor, tag);
	    }
	  }
	  let type = 'Function';
	  if (isGeneratorFunction(value)) {
	    type = `Generator${type}`;
	  }
	  if (isAsyncFunction(value)) {
	    type = `Async${type}`;
	  }
	  let base = `[${type}`;
	  if (constructor === null) {
	    base += ' (null prototype)';
	  }
	  if (value.name === '') {
	    base += ' (anonymous)';
	  } else {
	    base += `: ${value.name}`;
	  }
	  base += ']';
	  if (constructor !== type && constructor !== null) {
	    base += ` ${constructor}`;
	  }
	  if (tag !== '' && constructor !== tag) {
	    base += ` [${tag}]`;
	  }
	  return base;
	}

	function identicalSequenceRange(a, b) {
	  for (let i = 0; i < a.length - 3; i++) {
	    // Find the first entry of b that matches the current entry of a.
	    const pos = b.indexOf(a[i]);
	    if (pos !== -1) {
	      const rest = b.length - pos;
	      if (rest > 3) {
	        let len = 1;
	        const maxLen = MathMin(a.length - i, rest);
	        // Count the number of consecutive entries.
	        while (maxLen > len && a[i + len] === b[pos + len]) {
	          len++;
	        }
	        if (len > 3) {
	          return { len, offset: i };
	        }
	      }
	    }
	  }

	  return { len: 0, offset: 0 };
	}

	function getStackString(error) {
	  return error.stack ? String(error.stack) : ErrorPrototypeToString(error);
	}

	function getStackFrames(ctx, err, stack) {
	  const frames = StringPrototypeSplit(stack, '\n');

	  let cause;
	  try {
	    ({ cause } = err);
	  } catch {
	    // If 'cause' is a getter that throws, ignore it.
	  }

	  // Remove stack frames identical to frames in cause.
	  if (cause != null && isError(cause)) {
	    const causeStack = getStackString(cause);
	    const causeStackStart = StringPrototypeIndexOf(causeStack, '\n    at');
	    if (causeStackStart !== -1) {
	      const causeFrames = StringPrototypeSplit(StringPrototypeSlice(causeStack, causeStackStart + 1), '\n');
	      const { len, offset } = identicalSequenceRange(frames, causeFrames);
	      if (len > 0) {
	        const skipped = len - 2;
	        const msg = `    ... ${skipped} lines matching cause stack trace ...`;
	        frames.splice(offset + 1, skipped, ctx.stylize(msg, 'undefined'));
	      }
	    }
	  }
	  return frames;
	}

	function improveStack(stack, constructor, name, tag) {
	  // A stack trace may contain arbitrary data. Only manipulate the output
	  // for "regular errors" (errors that "look normal") for now.
	  let len = name.length;

	  if (constructor === null ||
	      (StringPrototypeEndsWith(name, 'Error') &&
	      StringPrototypeStartsWith(stack, name) &&
	      (stack.length === len || stack[len] === ':' || stack[len] === '\n'))) {
	    let fallback = 'Error';
	    if (constructor === null) {
	      const start = RegExpPrototypeExec(/^([A-Z][a-z_ A-Z0-9[\]()-]+)(?::|\n {4}at)/, stack) ||
	      RegExpPrototypeExec(/^([a-z_A-Z0-9-]*Error)$/, stack);
	      fallback = (start && start[1]) || '';
	      len = fallback.length;
	      fallback = fallback || 'Error';
	    }
	    const prefix = StringPrototypeSlice(getPrefix(constructor, tag, fallback), 0, -1);
	    if (name !== prefix) {
	      if (StringPrototypeIncludes(prefix, name)) {
	        if (len === 0) {
	          stack = `${prefix}: ${stack}`;
	        } else {
	          stack = `${prefix}${StringPrototypeSlice(stack, len)}`;
	        }
	      } else {
	        stack = `${prefix} [${name}]${StringPrototypeSlice(stack, len)}`;
	      }
	    }
	  }
	  return stack;
	}

	function removeDuplicateErrorKeys(ctx, keys, err, stack) {
	  if (!ctx.showHidden && keys.length !== 0) {
	    for (const name of ['name', 'message', 'stack']) {
	      const index = ArrayPrototypeIndexOf(keys, name);
	      // Only hide the property in case it's part of the original stack
	      if (index !== -1 && StringPrototypeIncludes(stack, err[name])) {
	        ArrayPrototypeSplice(keys, index, 1);
	      }
	    }
	  }
	}

	function markNodeModules(ctx, line) {
	  let tempLine = '';
	  let nodeModule;
	  let pos = 0;
	  while ((nodeModule = nodeModulesRegExp.exec(line)) !== null) {
	    // '/node_modules/'.length === 14
	    tempLine += StringPrototypeSlice(line, pos, nodeModule.index + 14);
	    tempLine += ctx.stylize(nodeModule[1], 'module');
	    pos = nodeModule.index + nodeModule[0].length;
	  }
	  if (pos !== 0) {
	    line = tempLine + StringPrototypeSlice(line, pos);
	  }
	  return line;
	}

	function markCwd(ctx, line, workingDirectory) {
	  let cwdStartPos = StringPrototypeIndexOf(line, workingDirectory);
	  let tempLine = '';
	  let cwdLength = workingDirectory.length;
	  if (cwdStartPos !== -1) {
	    if (StringPrototypeSlice(line, cwdStartPos - 7, cwdStartPos) === 'file://') {
	      cwdLength += 7;
	      cwdStartPos -= 7;
	    }
	    const start = line[cwdStartPos - 1] === '(' ? cwdStartPos - 1 : cwdStartPos;
	    const end = start !== cwdStartPos && StringPrototypeEndsWith(line, ')') ? -1 : line.length;
	    const workingDirectoryEndPos = cwdStartPos + cwdLength + 1;
	    const cwdSlice = StringPrototypeSlice(line, start, workingDirectoryEndPos);

	    tempLine += StringPrototypeSlice(line, 0, start);
	    tempLine += ctx.stylize(cwdSlice, 'undefined');
	    tempLine += StringPrototypeSlice(line, workingDirectoryEndPos, end);
	    if (end === -1) {
	      tempLine += ctx.stylize(')', 'undefined');
	    }
	  } else {
	    tempLine += line;
	  }
	  return tempLine;
	}

	function safeGetCWD() {
	  let workingDirectory;
	  try {
	    workingDirectory = process$1.cwd();
	  } catch {
	    return;
	  }
	  return workingDirectory;
	}

	function formatError(err, constructor, tag, ctx, keys) {
	  const name = err.name != null ? String(err.name) : 'Error';
	  let stack = getStackString(err);

	  removeDuplicateErrorKeys(ctx, keys, err, stack);

	  if ('cause' in err &&
	      (keys.length === 0 || !ArrayPrototypeIncludes(keys, 'cause'))) {
	    ArrayPrototypePush(keys, 'cause');
	  }

	  // Print errors aggregated into AggregateError
	  if (ArrayIsArray(err.errors) &&
	      (keys.length === 0 || !ArrayPrototypeIncludes(keys, 'errors'))) {
	    ArrayPrototypePush(keys, 'errors');
	  }

	  stack = improveStack(stack, constructor, name, tag);

	  // Ignore the error message if it's contained in the stack.
	  let pos = (err.message && StringPrototypeIndexOf(stack, err.message)) || -1;
	  if (pos !== -1)
	    pos += err.message.length;
	  // Wrap the error in brackets in case it has no stack trace.
	  const stackStart = StringPrototypeIndexOf(stack, '\n    at', pos);
	  if (stackStart === -1) {
	    stack = `[${stack}]`;
	  } else {
	    let newStack = StringPrototypeSlice(stack, 0, stackStart);
	    const stackFramePart = StringPrototypeSlice(stack, stackStart + 1);
	    const lines = getStackFrames(ctx, err, stackFramePart);
	    if (ctx.colors) {
	      // Highlight userland code and node modules.
	      const workingDirectory = safeGetCWD();
	      let esmWorkingDirectory;
	      for (let line of lines) {
	        const core = RegExpPrototypeExec(coreModuleRegExp, line);
	        if (core !== null && BuiltinModule.exists(core[1])) {
	          newStack += `\n${ctx.stylize(line, 'undefined')}`;
	        } else {
	          newStack += '\n';

	          line = markNodeModules(ctx, line);
	          if (workingDirectory !== undefined) {
	            let newLine = markCwd(ctx, line, workingDirectory);
	            if (newLine === line) {
	              // Maintain node 14 compat
	              // esmWorkingDirectory ??= pathToFileUrlHref(workingDirectory);
	              esmWorkingDirectory =
	                (esmWorkingDirectory == null) ? pathToFileUrlHref(workingDirectory) : esmWorkingDirectory;
	              newLine = markCwd(ctx, line, esmWorkingDirectory);
	            }
	            line = newLine;
	          }

	          newStack += line;
	        }
	      }
	    } else {
	      newStack += `\n${ArrayPrototypeJoin(lines, '\n')}`;
	    }
	    stack = newStack;
	  }
	  // The message and the stack have to be indented as well!
	  if (ctx.indentationLvl !== 0) {
	    const indentation = StringPrototypeRepeat(' ', ctx.indentationLvl);
	    stack = StringPrototypeReplaceAll(stack, '\n', `\n${indentation}`);
	  }
	  return stack;
	}

	function groupArrayElements(ctx, output, value) {
	  let totalLength = 0;
	  let maxLength = 0;
	  let i = 0;
	  let outputLength = output.length;
	  if (ctx.maxArrayLength < output.length) {
	    // This makes sure the "... n more items" part is not taken into account.
	    outputLength--;
	  }
	  const separatorSpace = 2; // Add 1 for the space and 1 for the separator.
	  const dataLen = new Array(outputLength);
	  // Calculate the total length of all output entries and the individual max
	  // entries length of all output entries. We have to remove colors first,
	  // otherwise the length would not be calculated properly.
	  for (; i < outputLength; i++) {
	    const len = getStringWidth(output[i], ctx.colors);
	    dataLen[i] = len;
	    totalLength += len + separatorSpace;
	    if (maxLength < len)
	      maxLength = len;
	  }
	  // Add two to `maxLength` as we add a single whitespace character plus a comma
	  // in-between two entries.
	  const actualMax = maxLength + separatorSpace;
	  // Check if at least three entries fit next to each other and prevent grouping
	  // of arrays that contains entries of very different length (i.e., if a single
	  // entry is longer than 1/5 of all other entries combined). Otherwise the
	  // space in-between small entries would be enormous.
	  if (actualMax * 3 + ctx.indentationLvl < ctx.breakLength &&
	      (totalLength / actualMax > 5 || maxLength <= 6)) {

	    const approxCharHeights = 2.5;
	    const averageBias = MathSqrt(actualMax - totalLength / output.length);
	    const biasedMax = MathMax(actualMax - 3 - averageBias, 1);
	    // Dynamically check how many columns seem possible.
	    const columns = MathMin(
	      // Ideally a square should be drawn. We expect a character to be about 2.5
	      // times as high as wide. This is the area formula to calculate a square
	      // which contains n rectangles of size `actualMax * approxCharHeights`.
	      // Divide that by `actualMax` to receive the correct number of columns.
	      // The added bias increases the columns for short entries.
	      MathRound(
	        MathSqrt(
	          approxCharHeights * biasedMax * outputLength,
	        ) / biasedMax,
	      ),
	      // Do not exceed the breakLength.
	      MathFloor((ctx.breakLength - ctx.indentationLvl) / actualMax),
	      // Limit array grouping for small `compact` modes as the user requested
	      // minimal grouping.
	      ctx.compact * 4,
	      // Limit the columns to a maximum of fifteen.
	      15,
	    );
	    // Return with the original output if no grouping should happen.
	    if (columns <= 1) {
	      return output;
	    }
	    const tmp = [];
	    const maxLineLength = [];
	    for (let i = 0; i < columns; i++) {
	      let lineMaxLength = 0;
	      for (let j = i; j < output.length; j += columns) {
	        if (dataLen[j] > lineMaxLength)
	          lineMaxLength = dataLen[j];
	      }
	      lineMaxLength += separatorSpace;
	      maxLineLength[i] = lineMaxLength;
	    }
	    let order = StringPrototypePadStart;
	    if (value !== undefined) {
	      for (let i = 0; i < output.length; i++) {
	        if (typeof value[i] !== 'number' && typeof value[i] !== 'bigint') {
	          order = StringPrototypePadEnd;
	          break;
	        }
	      }
	    }
	    // Each iteration creates a single line of grouped entries.
	    for (let i = 0; i < outputLength; i += columns) {
	      // The last lines may contain less entries than columns.
	      const max = MathMin(i + columns, outputLength);
	      let str = '';
	      let j = i;
	      for (; j < max - 1; j++) {
	        // Calculate extra color padding in case it's active. This has to be
	        // done line by line as some lines might contain more colors than
	        // others.
	        const padding = maxLineLength[j - i] + output[j].length - dataLen[j];
	        str += order(`${output[j]}, `, padding, ' ');
	      }
	      if (order === StringPrototypePadStart) {
	        const padding = maxLineLength[j - i] +
	                        output[j].length -
	                        dataLen[j] -
	                        separatorSpace;
	        str += StringPrototypePadStart(output[j], padding, ' ');
	      } else {
	        str += output[j];
	      }
	      ArrayPrototypePush(tmp, str);
	    }
	    if (ctx.maxArrayLength < output.length) {
	      ArrayPrototypePush(tmp, output[outputLength]);
	    }
	    output = tmp;
	  }
	  return output;
	}

	function handleMaxCallStackSize(ctx, err, constructorName, indentationLvl) {
	  if (isStackOverflowError(err)) {
	    ctx.seen.pop();
	    ctx.indentationLvl = indentationLvl;
	    return ctx.stylize(
	      `[${constructorName}: Inspection interrupted ` +
	        'prematurely. Maximum call stack size exceeded.]',
	      'special',
	    );
	  }
	  assert.fail(err.stack);
	}

	function addNumericSeparator(integerString) {
	  let result = '';
	  let i = integerString.length;
	  const start = StringPrototypeStartsWith(integerString, '-') ? 1 : 0;
	  for (; i >= start + 4; i -= 3) {
	    result = `_${StringPrototypeSlice(integerString, i - 3, i)}${result}`;
	  }
	  return i === integerString.length ?
	    integerString :
	    `${StringPrototypeSlice(integerString, 0, i)}${result}`;
	}

	function addNumericSeparatorEnd(integerString) {
	  let result = '';
	  let i = 0;
	  for (; i < integerString.length - 3; i += 3) {
	    result += `${StringPrototypeSlice(integerString, i, i + 3)}_`;
	  }
	  return i === 0 ?
	    integerString :
	    `${result}${StringPrototypeSlice(integerString, i)}`;
	}

	const remainingText = (remaining) => `... ${remaining} more item${remaining > 1 ? 's' : ''}`;

	function formatNumber(fn, number, numericSeparator) {
	  if (!numericSeparator) {
	    // Format -0 as '-0'. Checking `number === -0` won't distinguish 0 from -0.
	    if (ObjectIs(number, -0)) {
	      return fn('-0', 'number');
	    }
	    return fn(`${number}`, 'number');
	  }
	  const integer = MathTrunc(number);
	  const string = String(integer);
	  if (integer === number) {
	    if (!NumberIsFinite(number) || StringPrototypeIncludes(string, 'e')) {
	      return fn(string, 'number');
	    }
	    return fn(`${addNumericSeparator(string)}`, 'number');
	  }
	  if (NumberIsNaN(number)) {
	    return fn(string, 'number');
	  }
	  return fn(`${
	    addNumericSeparator(string)
	  }.${
	    addNumericSeparatorEnd(
	      StringPrototypeSlice(String(number), string.length + 1),
	    )
	  }`, 'number');
	}

	function formatBigInt(fn, bigint, numericSeparator) {
	  const string = String(bigint);
	  if (!numericSeparator) {
	    return fn(`${string}n`, 'bigint');
	  }
	  return fn(`${addNumericSeparator(string)}n`, 'bigint');
	}

	function formatPrimitive(fn, value, ctx) {
	  if (typeof value === 'string') {
	    let trailer = '';
	    if (value.length > ctx.maxStringLength) {
	      const remaining = value.length - ctx.maxStringLength;
	      value = StringPrototypeSlice(value, 0, ctx.maxStringLength);
	      trailer = `... ${remaining} more character${remaining > 1 ? 's' : ''}`;
	    }
	    if (ctx.compact !== true &&
	        // We do not support handling unicode characters width with
	        // the readline getStringWidth function as there are
	        // performance implications.
	        value.length > kMinLineLength &&
	        value.length > ctx.breakLength - ctx.indentationLvl - 4) {
	      return ArrayPrototypeJoin(
	        ArrayPrototypeMap(
	          extractedSplitNewLines(value),
	          (line) => fn(strEscape(line), 'string'),
	        ),
	        ` +\n${StringPrototypeRepeat(' ', ctx.indentationLvl + 2)}`,
	      ) + trailer;
	    }
	    return fn(strEscape(value), 'string') + trailer;
	  }
	  if (typeof value === 'number')
	    return formatNumber(fn, value, ctx.numericSeparator);
	  if (typeof value === 'bigint')
	    return formatBigInt(fn, value, ctx.numericSeparator);
	  if (typeof value === 'boolean')
	    return fn(`${value}`, 'boolean');
	  if (typeof value === 'undefined')
	    return fn('undefined', 'undefined');
	  // es6 symbol primitive
	  return fn(SymbolPrototypeToString(value), 'symbol');
	}

	function formatNamespaceObject(keys, ctx, value, recurseTimes) {
	  const output = new Array(keys.length);
	  for (let i = 0; i < keys.length; i++) {
	    try {
	      output[i] = formatProperty(ctx, value, recurseTimes, keys[i],
	                                 kObjectType);
	    } catch (err) {
	      assert(isNativeError(err) && err.name === 'ReferenceError');
	      // Use the existing functionality. This makes sure the indentation and
	      // line breaks are always correct. Otherwise it is very difficult to keep
	      // this aligned, even though this is a hacky way of dealing with this.
	      const tmp = { [keys[i]]: '' };
	      output[i] = formatProperty(ctx, tmp, recurseTimes, keys[i], kObjectType);
	      const pos = StringPrototypeLastIndexOf(output[i], ' ');
	      // We have to find the last whitespace and have to replace that value as
	      // it will be visualized as a regular string.
	      output[i] = StringPrototypeSlice(output[i], 0, pos + 1) +
	                  ctx.stylize('<uninitialized>', 'special');
	    }
	  }
	  // Reset the keys to an empty array. This prevents duplicated inspection.
	  keys.length = 0;
	  return output;
	}

	// The array is sparse and/or has extra keys
	function formatSpecialArray(ctx, value, recurseTimes, maxLength, output, i) {
	  const keys = ObjectKeys(value);
	  let index = i;
	  for (; i < keys.length && output.length < maxLength; i++) {
	    const key = keys[i];
	    const tmp = +key;
	    // Arrays can only have up to 2^32 - 1 entries
	    if (tmp > 2 ** 32 - 2) {
	      break;
	    }
	    if (`${index}` !== key) {
	      if (RegExpPrototypeExec(numberRegExp, key) === null) {
	        break;
	      }
	      const emptyItems = tmp - index;
	      const ending = emptyItems > 1 ? 's' : '';
	      const message = `<${emptyItems} empty item${ending}>`;
	      ArrayPrototypePush(output, ctx.stylize(message, 'undefined'));
	      index = tmp;
	      if (output.length === maxLength) {
	        break;
	      }
	    }
	    ArrayPrototypePush(output, formatProperty(ctx, value, recurseTimes, key, kArrayType));
	    index++;
	  }
	  const remaining = value.length - index;
	  if (output.length !== maxLength) {
	    if (remaining > 0) {
	      const ending = remaining > 1 ? 's' : '';
	      const message = `<${remaining} empty item${ending}>`;
	      ArrayPrototypePush(output, ctx.stylize(message, 'undefined'));
	    }
	  } else if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  return output;
	}

	function formatArrayBuffer(ctx, value) {
	  let buffer;
	  try {
	    buffer = new Uint8Array(value);
	  } catch {
	    return [ctx.stylize('(detached)', 'special')];
	  }
	  if (hexSlice === undefined)
	    hexSlice = uncurryThis(requireBuffer().Buffer.prototype.hexSlice);
	  let str = StringPrototypeTrim(RegExpPrototypeSymbolReplace(
	    /(.{2})/g,
	    hexSlice(buffer, 0, MathMin(ctx.maxArrayLength, buffer.length)),
	    '$1 ',
	  ));
	  const remaining = buffer.length - ctx.maxArrayLength;
	  if (remaining > 0)
	    str += ` ... ${remaining} more byte${remaining > 1 ? 's' : ''}`;
	  return [`${ctx.stylize('[Uint8Contents]', 'special')}: <${str}>`];
	}

	function formatArray(ctx, value, recurseTimes) {
	  const valLen = value.length;
	  const len = MathMin(MathMax(0, ctx.maxArrayLength), valLen);

	  const remaining = valLen - len;
	  const output = [];
	  for (let i = 0; i < len; i++) {
	    // Special handle sparse arrays.
	    if (!ObjectPrototypeHasOwnProperty(value, i)) {
	      return formatSpecialArray(ctx, value, recurseTimes, len, output, i);
	    }
	    ArrayPrototypePush(output, formatProperty(ctx, value, recurseTimes, i, kArrayType));
	  }
	  if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  return output;
	}

	function formatTypedArray(value, length, ctx, ignored, recurseTimes) {
	  const maxLength = MathMin(MathMax(0, ctx.maxArrayLength), length);
	  const remaining = value.length - maxLength;
	  const output = new Array(maxLength);
	  const elementFormatter = value.length > 0 && typeof value[0] === 'number' ?
	    formatNumber :
	    formatBigInt;
	  for (let i = 0; i < maxLength; ++i) {
	    output[i] = elementFormatter(ctx.stylize, value[i], ctx.numericSeparator);
	  }
	  if (remaining > 0) {
	    output[maxLength] = remainingText(remaining);
	  }
	  if (ctx.showHidden) {
	    // .buffer goes last, it's not a primitive like the others.
	    // All besides `BYTES_PER_ELEMENT` are actually getters.
	    ctx.indentationLvl += 2;
	    for (const key of [
	      'BYTES_PER_ELEMENT',
	      'length',
	      'byteLength',
	      'byteOffset',
	      'buffer',
	    ]) {
	      const str = formatValue(ctx, value[key], recurseTimes, true);
	      ArrayPrototypePush(output, `[${key}]: ${str}`);
	    }
	    ctx.indentationLvl -= 2;
	  }
	  return output;
	}

	function formatSet(value, ctx, ignored, recurseTimes) {
	  const length = value.size;
	  const maxLength = MathMin(MathMax(0, ctx.maxArrayLength), length);
	  const remaining = length - maxLength;
	  const output = [];
	  ctx.indentationLvl += 2;
	  let i = 0;
	  for (const v of value) {
	    if (i >= maxLength) break;
	    ArrayPrototypePush(output, formatValue(ctx, v, recurseTimes));
	    i++;
	  }
	  if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  ctx.indentationLvl -= 2;
	  return output;
	}

	function formatMap(value, ctx, ignored, recurseTimes) {
	  const length = value.size;
	  const maxLength = MathMin(MathMax(0, ctx.maxArrayLength), length);
	  const remaining = length - maxLength;
	  const output = [];
	  ctx.indentationLvl += 2;
	  let i = 0;
	  for (const { 0: k, 1: v } of value) {
	    if (i >= maxLength) break;
	    ArrayPrototypePush(
	      output,
	      `${formatValue(ctx, k, recurseTimes)} => ${formatValue(ctx, v, recurseTimes)}`,
	    );
	    i++;
	  }
	  if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  ctx.indentationLvl -= 2;
	  return output;
	}

	function formatSetIterInner(ctx, recurseTimes, entries, state) {
	  const maxArrayLength = MathMax(ctx.maxArrayLength, 0);
	  const maxLength = MathMin(maxArrayLength, entries.length);
	  const output = new Array(maxLength);
	  ctx.indentationLvl += 2;
	  for (let i = 0; i < maxLength; i++) {
	    output[i] = formatValue(ctx, entries[i], recurseTimes);
	  }
	  ctx.indentationLvl -= 2;
	  if (state === kWeak && !ctx.sorted) {
	    // Sort all entries to have a halfway reliable output (if more entries than
	    // retrieved ones exist, we can not reliably return the same output) if the
	    // output is not sorted anyway.
	    ArrayPrototypeSort(output);
	  }
	  const remaining = entries.length - maxLength;
	  if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  return output;
	}

	function formatMapIterInner(ctx, recurseTimes, entries, state) {
	  const maxArrayLength = MathMax(ctx.maxArrayLength, 0);
	  // Entries exist as [key1, val1, key2, val2, ...]
	  const len = entries.length / 2;
	  const remaining = len - maxArrayLength;
	  const maxLength = MathMin(maxArrayLength, len);
	  const output = new Array(maxLength);
	  let i = 0;
	  ctx.indentationLvl += 2;
	  if (state === kWeak) {
	    for (; i < maxLength; i++) {
	      const pos = i * 2;
	      output[i] =
	        `${formatValue(ctx, entries[pos], recurseTimes)} => ${formatValue(ctx, entries[pos + 1], recurseTimes)}`;
	    }
	    // Sort all entries to have a halfway reliable output (if more entries than
	    // retrieved ones exist, we can not reliably return the same output) if the
	    // output is not sorted anyway.
	    if (!ctx.sorted)
	      ArrayPrototypeSort(output);
	  } else {
	    for (; i < maxLength; i++) {
	      const pos = i * 2;
	      const res = [
	        formatValue(ctx, entries[pos], recurseTimes),
	        formatValue(ctx, entries[pos + 1], recurseTimes),
	      ];
	      output[i] = reduceToSingleString(
	        ctx, res, '', ['[', ']'], kArrayExtrasType, recurseTimes);
	    }
	  }
	  ctx.indentationLvl -= 2;
	  if (remaining > 0) {
	    ArrayPrototypePush(output, remainingText(remaining));
	  }
	  return output;
	}

	function formatWeakCollection(ctx) {
	  return [ctx.stylize('<items unknown>', 'special')];
	}

	function formatWeakSet(ctx, value, recurseTimes) {
	  const entries = previewEntries(value);
	  return formatSetIterInner(ctx, recurseTimes, entries, kWeak);
	}

	function formatWeakMap(ctx, value, recurseTimes) {
	  const entries = previewEntries(value);
	  return formatMapIterInner(ctx, recurseTimes, entries, kWeak);
	}

	function formatIterator(braces, ctx, value, recurseTimes) {
	  const { 0: entries, 1: isKeyValue } = previewEntries(value, true);
	  if (isKeyValue) {
	    // Mark entry iterators as such.
	    braces[0] = RegExpPrototypeSymbolReplace(/ Iterator] {$/, braces[0], ' Entries] {');
	    return formatMapIterInner(ctx, recurseTimes, entries, kMapEntries);
	  }

	  return formatSetIterInner(ctx, recurseTimes, entries, kIterator);
	}

	function formatPromise(ctx, value, recurseTimes) {
	  let output;
	  const { 0: state, 1: result } = getPromiseDetails(value);
	  if (state === kPending) {
	    output = [ctx.stylize('<pending>', 'special')];
	  } else {
	    ctx.indentationLvl += 2;
	    const str = formatValue(ctx, result, recurseTimes);
	    ctx.indentationLvl -= 2;
	    output = [
	      state === kRejected ?
	        `${ctx.stylize('<rejected>', 'special')} ${str}` :
	        str,
	    ];
	  }
	  return output;
	}

	function formatProperty(ctx, value, recurseTimes, key, type, desc,
	                        original = value) {
	  let name, str;
	  let extra = ' ';
	  desc = desc || ObjectGetOwnPropertyDescriptor(value, key) ||
	    { value: value[key], enumerable: true };
	  if (desc.value !== undefined) {
	    const diff = (ctx.compact !== true || type !== kObjectType) ? 2 : 3;
	    ctx.indentationLvl += diff;
	    str = formatValue(ctx, desc.value, recurseTimes);
	    if (diff === 3 && ctx.breakLength < getStringWidth(str, ctx.colors)) {
	      extra = `\n${StringPrototypeRepeat(' ', ctx.indentationLvl)}`;
	    }
	    ctx.indentationLvl -= diff;
	  } else if (desc.get !== undefined) {
	    const label = desc.set !== undefined ? 'Getter/Setter' : 'Getter';
	    const s = ctx.stylize;
	    const sp = 'special';
	    if (ctx.getters && (ctx.getters === true ||
	          (ctx.getters === 'get' && desc.set === undefined) ||
	          (ctx.getters === 'set' && desc.set !== undefined))) {
	      try {
	        const tmp = FunctionPrototypeCall(desc.get, original);
	        ctx.indentationLvl += 2;
	        if (tmp === null) {
	          str = `${s(`[${label}:`, sp)} ${s('null', 'null')}${s(']', sp)}`;
	        } else if (typeof tmp === 'object') {
	          str = `${s(`[${label}]`, sp)} ${formatValue(ctx, tmp, recurseTimes)}`;
	        } else {
	          const primitive = formatPrimitive(s, tmp, ctx);
	          str = `${s(`[${label}:`, sp)} ${primitive}${s(']', sp)}`;
	        }
	        ctx.indentationLvl -= 2;
	      } catch (err) {
	        const message = `<Inspection threw (${err.message})>`;
	        str = `${s(`[${label}:`, sp)} ${message}${s(']', sp)}`;
	      }
	    } else {
	      str = ctx.stylize(`[${label}]`, sp);
	    }
	  } else if (desc.set !== undefined) {
	    str = ctx.stylize('[Setter]', 'special');
	  } else {
	    str = ctx.stylize('undefined', 'undefined');
	  }
	  if (type === kArrayType) {
	    return str;
	  }
	  if (typeof key === 'symbol') {
	    const tmp = RegExpPrototypeSymbolReplace(
	      strEscapeSequencesReplacer,
	      SymbolPrototypeToString(key),
	      escapeFn,
	    );
	    name = `[${ctx.stylize(tmp, 'symbol')}]`;
	  } else if (key === '__proto__') {
	    name = "['__proto__']";
	  } else if (desc.enumerable === false) {
	    const tmp = RegExpPrototypeSymbolReplace(
	      strEscapeSequencesReplacer,
	      key,
	      escapeFn,
	    );
	    name = `[${tmp}]`;
	  } else if (RegExpPrototypeExec(keyStrRegExp, key) !== null) {
	    name = ctx.stylize(key, 'name');
	  } else {
	    name = ctx.stylize(strEscape(key), 'string');
	  }
	  return `${name}:${extra}${str}`;
	}

	function isBelowBreakLength(ctx, output, start, base) {
	  // Each entry is separated by at least a comma. Thus, we start with a total
	  // length of at least `output.length`. In addition, some cases have a
	  // whitespace in-between each other that is added to the total as well.
	  // TODO(BridgeAR): Add unicode support. Use the readline getStringWidth
	  // function. Check the performance overhead and make it an opt-in in case it's
	  // significant.
	  let totalLength = output.length + start;
	  if (totalLength + output.length > ctx.breakLength)
	    return false;
	  for (let i = 0; i < output.length; i++) {
	    if (ctx.colors) {
	      totalLength += removeColors(output[i]).length;
	    } else {
	      totalLength += output[i].length;
	    }
	    if (totalLength > ctx.breakLength) {
	      return false;
	    }
	  }
	  // Do not line up properties on the same line if `base` contains line breaks.
	  return base === '' || !StringPrototypeIncludes(base, '\n');
	}

	function reduceToSingleString(
	  ctx, output, base, braces, extrasType, recurseTimes, value) {
	  if (ctx.compact !== true) {
	    if (typeof ctx.compact === 'number' && ctx.compact >= 1) {
	      // Memorize the original output length. In case the output is grouped,
	      // prevent lining up the entries on a single line.
	      const entries = output.length;
	      // Group array elements together if the array contains at least six
	      // separate entries.
	      if (extrasType === kArrayExtrasType && entries > 6) {
	        output = groupArrayElements(ctx, output, value);
	      }
	      // `ctx.currentDepth` is set to the most inner depth of the currently
	      // inspected object part while `recurseTimes` is the actual current depth
	      // that is inspected.
	      //
	      // Example:
	      //
	      // const a = { first: [ 1, 2, 3 ], second: { inner: [ 1, 2, 3 ] } }
	      //
	      // The deepest depth of `a` is 2 (a.second.inner) and `a.first` has a max
	      // depth of 1.
	      //
	      // Consolidate all entries of the local most inner depth up to
	      // `ctx.compact`, as long as the properties are smaller than
	      // `ctx.breakLength`.
	      if (ctx.currentDepth - recurseTimes < ctx.compact &&
	          entries === output.length) {
	        // Line up all entries on a single line in case the entries do not
	        // exceed `breakLength`. Add 10 as constant to start next to all other
	        // factors that may reduce `breakLength`.
	        const start = output.length + ctx.indentationLvl +
	                      braces[0].length + base.length + 10;
	        if (isBelowBreakLength(ctx, output, start, base)) {
	          const joinedOutput = join(output, ', ');
	          if (!StringPrototypeIncludes(joinedOutput, '\n')) {
	            return `${base ? `${base} ` : ''}${braces[0]} ${joinedOutput}` +
	              ` ${braces[1]}`;
	          }
	        }
	      }
	    }
	    // Line up each entry on an individual line.
	    const indentation = `\n${StringPrototypeRepeat(' ', ctx.indentationLvl)}`;
	    return `${base ? `${base} ` : ''}${braces[0]}${indentation}  ` +
	      `${join(output, `,${indentation}  `)}${indentation}${braces[1]}`;
	  }
	  // Line up all entries on a single line in case the entries do not exceed
	  // `breakLength`.
	  if (isBelowBreakLength(ctx, output, 0, base)) {
	    return `${braces[0]}${base ? ` ${base}` : ''} ${join(output, ', ')} ` +
	      braces[1];
	  }
	  const indentation = StringPrototypeRepeat(' ', ctx.indentationLvl);
	  // If the opening "brace" is too large, like in the case of "Set {",
	  // we need to force the first item to be on the next line or the
	  // items will not line up correctly.
	  const ln = base === '' && braces[0].length === 1 ?
	    ' ' : `${base ? ` ${base}` : ''}\n${indentation}  `;
	  // Line up each entry on an individual line.
	  return `${braces[0]}${ln}${join(output, `,\n${indentation}  `)} ${braces[1]}`;
	}

	function hasBuiltInToString(value) {
	  // Prevent triggering proxy traps.
	  const getFullProxy = false;
	  const proxyTarget = getProxyDetails(value, getFullProxy);
	  if (proxyTarget !== undefined) {
	    if (proxyTarget === null) {
	      return true;
	    }
	    value = proxyTarget;
	  }

	  // Count objects that have no `toString` function as built-in.
	  if (typeof value.toString !== 'function') {
	    return true;
	  }

	  // The object has a own `toString` property. Thus it's not not a built-in one.
	  if (ObjectPrototypeHasOwnProperty(value, 'toString')) {
	    return false;
	  }

	  // Find the object that has the `toString` property as own property in the
	  // prototype chain.
	  let pointer = value;
	  do {
	    pointer = ObjectGetPrototypeOf(pointer);
	  } while (!ObjectPrototypeHasOwnProperty(pointer, 'toString'));

	  // Check closer if the object is a built-in.
	  const descriptor = ObjectGetOwnPropertyDescriptor(pointer, 'constructor');
	  return descriptor !== undefined &&
	    typeof descriptor.value === 'function' &&
	    builtInObjects.has(descriptor.value.name);
	}

	const firstErrorLine = (error) => StringPrototypeSplit(error.message, '\n', 1)[0];
	let CIRCULAR_ERROR_MESSAGE;
	function tryStringify(arg) {
	  try {
	    return JSONStringify(arg);
	  } catch (err) {
	    // Populate the circular error message lazily
	    if (!CIRCULAR_ERROR_MESSAGE) {
	      try {
	        const a = {};
	        a.a = a;
	        JSONStringify(a);
	      } catch (circularError) {
	        CIRCULAR_ERROR_MESSAGE = firstErrorLine(circularError);
	      }
	    }
	    if (err.name === 'TypeError' &&
	        firstErrorLine(err) === CIRCULAR_ERROR_MESSAGE) {
	      return '[Circular]';
	    }
	    throw err;
	  }
	}

	function format(...args) {
	  return formatWithOptionsInternal(undefined, args);
	}

	function formatWithOptions(inspectOptions, ...args) {
	  validateObject(inspectOptions, 'inspectOptions', { allowArray: true });
	  return formatWithOptionsInternal(inspectOptions, args);
	}

	function formatNumberNoColor(number, options) {
	  return formatNumber(
	    stylizeNoColor,
	    number,
	    options?.numericSeparator ?? inspectDefaultOptions.numericSeparator,
	  );
	}

	function formatBigIntNoColor(bigint, options) {
	  return formatBigInt(
	    stylizeNoColor,
	    bigint,
	    options?.numericSeparator ?? inspectDefaultOptions.numericSeparator,
	  );
	}

	function formatWithOptionsInternal(inspectOptions, args) {
	  const first = args[0];
	  let a = 0;
	  let str = '';
	  let join = '';

	  if (typeof first === 'string') {
	    if (args.length === 1) {
	      return first;
	    }
	    let tempStr;
	    let lastPos = 0;

	    for (let i = 0; i < first.length - 1; i++) {
	      if (StringPrototypeCharCodeAt(first, i) === 37) { // '%'
	        const nextChar = StringPrototypeCharCodeAt(first, ++i);
	        if (a + 1 !== args.length) {
	          switch (nextChar) {
	            case 115: { // 's'
	              const tempArg = args[++a];
	              if (typeof tempArg === 'number') {
	                tempStr = formatNumberNoColor(tempArg, inspectOptions);
	              } else if (typeof tempArg === 'bigint') {
	                tempStr = formatBigIntNoColor(tempArg, inspectOptions);
	              } else if (typeof tempArg !== 'object' ||
	                         tempArg === null ||
	                         !hasBuiltInToString(tempArg)) {
	                tempStr = String(tempArg);
	              } else {
	                tempStr = inspect(tempArg, {
	                  ...inspectOptions,
	                  compact: 3,
	                  colors: false,
	                  depth: 0,
	                });
	              }
	              break;
	            }
	            case 106: // 'j'
	              tempStr = tryStringify(args[++a]);
	              break;
	            case 100: { // 'd'
	              const tempNum = args[++a];
	              if (typeof tempNum === 'bigint') {
	                tempStr = formatBigIntNoColor(tempNum, inspectOptions);
	              } else if (typeof tempNum === 'symbol') {
	                tempStr = 'NaN';
	              } else {
	                tempStr = formatNumberNoColor(Number(tempNum), inspectOptions);
	              }
	              break;
	            }
	            case 79: // 'O'
	              tempStr = inspect(args[++a], inspectOptions);
	              break;
	            case 111: // 'o'
	              tempStr = inspect(args[++a], {
	                ...inspectOptions,
	                showHidden: true,
	                showProxy: true,
	                depth: 4,
	              });
	              break;
	            case 105: { // 'i'
	              const tempInteger = args[++a];
	              if (typeof tempInteger === 'bigint') {
	                tempStr = formatBigIntNoColor(tempInteger, inspectOptions);
	              } else if (typeof tempInteger === 'symbol') {
	                tempStr = 'NaN';
	              } else {
	                tempStr = formatNumberNoColor(
	                  NumberParseInt(tempInteger), inspectOptions);
	              }
	              break;
	            }
	            case 102: { // 'f'
	              const tempFloat = args[++a];
	              if (typeof tempFloat === 'symbol') {
	                tempStr = 'NaN';
	              } else {
	                tempStr = formatNumberNoColor(
	                  NumberParseFloat(tempFloat), inspectOptions);
	              }
	              break;
	            }
	            case 99: // 'c'
	              a += 1;
	              tempStr = '';
	              break;
	            case 37: // '%'
	              str += StringPrototypeSlice(first, lastPos, i);
	              lastPos = i + 1;
	              continue;
	            default: // Any other character is not a correct placeholder
	              continue;
	          }
	          if (lastPos !== i - 1) {
	            str += StringPrototypeSlice(first, lastPos, i - 1);
	          }
	          str += tempStr;
	          lastPos = i + 1;
	        } else if (nextChar === 37) {
	          str += StringPrototypeSlice(first, lastPos, i);
	          lastPos = i + 1;
	        }
	      }
	    }
	    if (lastPos !== 0) {
	      a++;
	      join = ' ';
	      if (lastPos < first.length) {
	        str += StringPrototypeSlice(first, lastPos);
	      }
	    }
	  }

	  while (a < args.length) {
	    const value = args[a];
	    str += join;
	    str += typeof value !== 'string' ? inspect(value, inspectOptions) : value;
	    join = ' ';
	    a++;
	  }
	  return str;
	}

	function isZeroWidthCodePoint(code) {
	  return code <= 0x1F || // C0 control codes
	    (code >= 0x7F && code <= 0x9F) || // C1 control codes
	    (code >= 0x300 && code <= 0x36F) || // Combining Diacritical Marks
	    (code >= 0x200B && code <= 0x200F) || // Modifying Invisible Characters
	    // Combining Diacritical Marks for Symbols
	    (code >= 0x20D0 && code <= 0x20FF) ||
	    (code >= 0xFE00 && code <= 0xFE0F) || // Variation Selectors
	    (code >= 0xFE20 && code <= 0xFE2F) || // Combining Half Marks
	    (code >= 0xE0100 && code <= 0xE01EF); // Variation Selectors
	}

	/* c8 ignore start */
	if (internalBinding('config').hasIntl) {
	  assert(false);
	  // Can't use node internals
	  // const icu = internalBinding('icu');
	  // // icu.getStringWidth(string, ambiguousAsFullWidth, expandEmojiSequence)
	  // // Defaults: ambiguousAsFullWidth = false; expandEmojiSequence = true;
	  // // TODO(BridgeAR): Expose the options to the user. That is probably the
	  // // best thing possible at the moment, since it's difficult to know what
	  // // the receiving end supports.
	  // getStringWidth = function getStringWidth(str, removeControlChars = true) {
	  //   let width = 0;

	  //   if (removeControlChars) {
	  //     str = stripVTControlCharacters(str);
	  //   }
	  //   for (let i = 0; i < str.length; i++) {
	  //     // Try to avoid calling into C++ by first handling the ASCII portion of
	  //     // the string. If it is fully ASCII, we skip the C++ part.
	  //     const code = str.charCodeAt(i);
	  //     if (code >= 127) {
	  //       width += icu.getStringWidth(StringPrototypeNormalize(StringPrototypeSlice(str, i), 'NFC'));
	  //       break;
	  //     }
	  //     width += code >= 32 ? 1 : 0;
	  //   }
	  //   return width;
	  // };
	  /* c8 ignore stop */
	} else {
	  /**
	   * Returns the number of columns required to display the given string.
	   */
	  getStringWidth = function getStringWidth(str, removeControlChars = true) {
	    let width = 0;

	    if (removeControlChars)
	      str = stripVTControlCharacters(str);
	    str = StringPrototypeNormalize(str, 'NFC');
	    for (const char of new SafeStringIterator(str)) {
	      const code = StringPrototypeCodePointAt(char, 0);
	      if (isFullWidthCodePoint(code)) {
	        width += 2;
	      } else if (!isZeroWidthCodePoint(code)) {
	        width++;
	      }
	    }

	    return width;
	  };

	  /**
	   * Returns true if the character represented by a given
	   * Unicode code point is full-width. Otherwise returns false.
	   */
	  const isFullWidthCodePoint = (code) => {
	    // Code points are partially derived from:
	    // https://www.unicode.org/Public/UNIDATA/EastAsianWidth.txt
	    return code >= 0x1100 && (
	      code <= 0x115f ||  // Hangul Jamo
	      code === 0x2329 || // LEFT-POINTING ANGLE BRACKET
	      code === 0x232a || // RIGHT-POINTING ANGLE BRACKET
	      // CJK Radicals Supplement .. Enclosed CJK Letters and Months
	      (code >= 0x2e80 && code <= 0x3247 && code !== 0x303f) ||
	      // Enclosed CJK Letters and Months .. CJK Unified Ideographs Extension A
	      (code >= 0x3250 && code <= 0x4dbf) ||
	      // CJK Unified Ideographs .. Yi Radicals
	      (code >= 0x4e00 && code <= 0xa4c6) ||
	      // Hangul Jamo Extended-A
	      (code >= 0xa960 && code <= 0xa97c) ||
	      // Hangul Syllables
	      (code >= 0xac00 && code <= 0xd7a3) ||
	      // CJK Compatibility Ideographs
	      (code >= 0xf900 && code <= 0xfaff) ||
	      // Vertical Forms
	      (code >= 0xfe10 && code <= 0xfe19) ||
	      // CJK Compatibility Forms .. Small Form Variants
	      (code >= 0xfe30 && code <= 0xfe6b) ||
	      // Halfwidth and Fullwidth Forms
	      (code >= 0xff01 && code <= 0xff60) ||
	      (code >= 0xffe0 && code <= 0xffe6) ||
	      // Kana Supplement
	      (code >= 0x1b000 && code <= 0x1b001) ||
	      // Enclosed Ideographic Supplement
	      (code >= 0x1f200 && code <= 0x1f251) ||
	      // Miscellaneous Symbols and Pictographs 0x1f300 - 0x1f5ff
	      // Emoticons 0x1f600 - 0x1f64f
	      (code >= 0x1f300 && code <= 0x1f64f) ||
	      // CJK Unified Ideographs Extension B .. Tertiary Ideographic Plane
	      (code >= 0x20000 && code <= 0x3fffd)
	    );
	  };

	}

	/**
	 * Remove all VT control characters. Use to estimate displayed string width.
	 */
	function stripVTControlCharacters(str) {
	  validateString(str, 'str');
	  return RegExpPrototypeSymbolReplace(ansi, str, '');
	}

	const entities = {
	  34: '&quot;',
	  38: '&amp;',
	  39: '&apos;',
	  60: '&lt;',
	  62: '&gt;',
	  160: '&nbsp;',
	};

	function escapeHTML(str) {
	  return str.replace(
	    // eslint-disable-next-line no-control-regex
	    /[\u0000-\u002F\u003A-\u0040\u005B-\u0060\u007B-\u00FF]/g,
	    (c) => {
	      const code = String(c.charCodeAt(0));
	      const ent = entities[code];
	      return ent || ('&#' + code + ';');
	    },
	  );
	}

	inspect_1 = {
	  identicalSequenceRange,
	  inspect,
	  inspectDefaultOptions,
	  format,
	  formatWithOptions,
	  getStringWidth,
	  stripVTControlCharacters,
	  isZeroWidthCodePoint,
	  stylizeWithColor,
	  stylizeWithHTML(str, styleType) {
	    const style = inspect.styles[styleType];
	    if (style !== undefined) {
	      return `<span style="color:${style};">${escapeHTML(str)}</span>`;
	    }
	    return escapeHTML(str);
	  },
	  Proxy,
	};
	return inspect_1;
}

var inspectExports = requireInspect$1();
var inspect$2 = /*@__PURE__*/getDefaultExportFromCjs(inspectExports);

const {
  // The commented out things are not visible from normal node's util.
  // identicalSequenceRange,
  inspect: inspect$1,
  // inspectDefaultOptions,
  format,
  formatWithOptions,
  // getStringWidth,
  stripVTControlCharacters,
  // isZeroWidthCodePoint,
  stylizeWithColor,
  stylizeWithHTML,
  Proxy: Proxy$1,
} = inspect$2;

function isBuffer(arg) {
  return (
    arg &&
    typeof arg === 'object' &&
    typeof arg.copy === 'function' &&
    typeof arg.fill === 'function' &&
    typeof arg.readUInt8 === 'function'
  )
}

// borrow from https://github.com/isaacs/inherits
function inherits(ctor, superCtor) {
  if (superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true,
      },
    });
  }
}

var util$3 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	format: format,
	inherits: inherits,
	inspect: inspect$1,
	isBuffer: isBuffer
});

var require$$13 = /*@__PURE__*/getAugmentedNamespace(util$3);

var hasRequiredErrors$1;

function requireErrors$1 () {
	if (hasRequiredErrors$1) return errors$2;
	hasRequiredErrors$1 = 1;
	(function (exports) {
		// The whole point behind this internal module is to allow Node.js to no
		// longer be forced to treat every error message change as a semver-major
		// change. The NodeError classes here all expose a `code` property whose
		// value statically and permanently identifies the error. While the error
		// message may change, the code should not.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.AssertionError = exports.RangeError = exports.TypeError = exports.Error = void 0;
		exports.message = message;
		exports.E = E;
		const assert = requireAssert();
		const util = require$$13;
		const kCode = typeof Symbol === 'undefined' ? '_kCode' : Symbol('code');
		const messages = {}; // new Map();
		function makeNodeError(Base) {
		    return class NodeError extends Base {
		        constructor(key, ...args) {
		            super(message(key, args));
		            this.code = key;
		            this[kCode] = key;
		            this.name = `${super.name} [${this[kCode]}]`;
		        }
		    };
		}
		const g = typeof globalThis !== 'undefined' ? globalThis : commonjsGlobal$1;
		class AssertionError extends g.Error {
		    constructor(options) {
		        if (typeof options !== 'object' || options === null) {
		            throw new exports.TypeError('ERR_INVALID_ARG_TYPE', 'options', 'object');
		        }
		        if (options.message) {
		            super(options.message);
		        }
		        else {
		            super(`${util.inspect(options.actual).slice(0, 128)} ` +
		                `${options.operator} ${util.inspect(options.expected).slice(0, 128)}`);
		        }
		        this.generatedMessage = !options.message;
		        this.name = 'AssertionError [ERR_ASSERTION]';
		        this.code = 'ERR_ASSERTION';
		        this.actual = options.actual;
		        this.expected = options.expected;
		        this.operator = options.operator;
		        exports.Error.captureStackTrace(this, options.stackStartFunction);
		    }
		}
		exports.AssertionError = AssertionError;
		function message(key, args) {
		    assert.strictEqual(typeof key, 'string');
		    // const msg = messages.get(key);
		    const msg = messages[key];
		    assert(msg, `An invalid error message key was used: ${key}.`);
		    let fmt;
		    if (typeof msg === 'function') {
		        fmt = msg;
		    }
		    else {
		        fmt = util.format;
		        if (args === undefined || args.length === 0)
		            return msg;
		        args.unshift(msg);
		    }
		    return String(fmt.apply(null, args));
		}
		// Utility function for registering the error codes. Only used here. Exported
		// *only* to allow for testing.
		function E(sym, val) {
		    messages[sym] = typeof val === 'function' ? val : String(val);
		}
		exports.Error = makeNodeError(g.Error);
		exports.TypeError = makeNodeError(g.TypeError);
		exports.RangeError = makeNodeError(g.RangeError);
		// To declare an error message, use the E(sym, val) function above. The sym
		// must be an upper case string. The val can be either a function or a string.
		// The return value of the function must be a string.
		// Examples:
		// E('EXAMPLE_KEY1', 'This is the error value');
		// E('EXAMPLE_KEY2', (a, b) => return `${a} ${b}`);
		//
		// Once an error code has been assigned, the code itself MUST NOT change and
		// any given error code must never be reused to identify a different error.
		//
		// Any error code added here should also be added to the documentation
		//
		// Note: Please try to keep these in alphabetical order
		E('ERR_ARG_NOT_ITERABLE', '%s must be iterable');
		E('ERR_ASSERTION', '%s');
		E('ERR_BUFFER_OUT_OF_BOUNDS', bufferOutOfBounds);
		E('ERR_CHILD_CLOSED_BEFORE_REPLY', 'Child closed before reply received');
		E('ERR_CONSOLE_WRITABLE_STREAM', 'Console expects a writable stream instance for %s');
		E('ERR_CPU_USAGE', 'Unable to obtain cpu usage %s');
		E('ERR_DNS_SET_SERVERS_FAILED', (err, servers) => `c-ares failed to set servers: "${err}" [${servers}]`);
		E('ERR_FALSY_VALUE_REJECTION', 'Promise was rejected with falsy value');
		E('ERR_ENCODING_NOT_SUPPORTED', enc => `The "${enc}" encoding is not supported`);
		E('ERR_ENCODING_INVALID_ENCODED_DATA', enc => `The encoded data was not valid for encoding ${enc}`);
		E('ERR_HTTP_HEADERS_SENT', 'Cannot render headers after they are sent to the client');
		E('ERR_HTTP_INVALID_STATUS_CODE', 'Invalid status code: %s');
		E('ERR_HTTP_TRAILER_INVALID', 'Trailers are invalid with this transfer encoding');
		E('ERR_INDEX_OUT_OF_RANGE', 'Index out of range');
		E('ERR_INVALID_ARG_TYPE', invalidArgType);
		E('ERR_INVALID_ARRAY_LENGTH', (name, len, actual) => {
		    assert.strictEqual(typeof actual, 'number');
		    return `The array "${name}" (length ${actual}) must be of length ${len}.`;
		});
		E('ERR_INVALID_BUFFER_SIZE', 'Buffer size must be a multiple of %s');
		E('ERR_INVALID_CALLBACK', 'Callback must be a function');
		E('ERR_INVALID_CHAR', 'Invalid character in %s');
		E('ERR_INVALID_CURSOR_POS', 'Cannot set cursor row without setting its column');
		E('ERR_INVALID_FD', '"fd" must be a positive integer: %s');
		E('ERR_INVALID_FILE_URL_HOST', 'File URL host must be "localhost" or empty on %s');
		E('ERR_INVALID_FILE_URL_PATH', 'File URL path %s');
		E('ERR_INVALID_HANDLE_TYPE', 'This handle type cannot be sent');
		E('ERR_INVALID_IP_ADDRESS', 'Invalid IP address: %s');
		E('ERR_INVALID_OPT_VALUE', (name, value) => {
		    return `The value "${String(value)}" is invalid for option "${name}"`;
		});
		E('ERR_INVALID_OPT_VALUE_ENCODING', value => `The value "${String(value)}" is invalid for option "encoding"`);
		E('ERR_INVALID_REPL_EVAL_CONFIG', 'Cannot specify both "breakEvalOnSigint" and "eval" for REPL');
		E('ERR_INVALID_SYNC_FORK_INPUT', 'Asynchronous forks do not support Buffer, Uint8Array or string input: %s');
		E('ERR_INVALID_THIS', 'Value of "this" must be of type %s');
		E('ERR_INVALID_TUPLE', '%s must be an iterable %s tuple');
		E('ERR_INVALID_URL', 'Invalid URL: %s');
		E('ERR_INVALID_URL_SCHEME', expected => `The URL must be ${oneOf(expected, 'scheme')}`);
		E('ERR_IPC_CHANNEL_CLOSED', 'Channel closed');
		E('ERR_IPC_DISCONNECTED', 'IPC channel is already disconnected');
		E('ERR_IPC_ONE_PIPE', 'Child process can have only one IPC pipe');
		E('ERR_IPC_SYNC_FORK', 'IPC cannot be used with synchronous forks');
		E('ERR_MISSING_ARGS', missingArgs);
		E('ERR_MULTIPLE_CALLBACK', 'Callback called multiple times');
		E('ERR_NAPI_CONS_FUNCTION', 'Constructor must be a function');
		E('ERR_NAPI_CONS_PROTOTYPE_OBJECT', 'Constructor.prototype must be an object');
		E('ERR_NO_CRYPTO', 'Node.js is not compiled with OpenSSL crypto support');
		E('ERR_NO_LONGER_SUPPORTED', '%s is no longer supported');
		E('ERR_PARSE_HISTORY_DATA', 'Could not parse history data in %s');
		E('ERR_SOCKET_ALREADY_BOUND', 'Socket is already bound');
		E('ERR_SOCKET_BAD_PORT', 'Port should be > 0 and < 65536');
		E('ERR_SOCKET_BAD_TYPE', 'Bad socket type specified. Valid types are: udp4, udp6');
		E('ERR_SOCKET_CANNOT_SEND', 'Unable to send data');
		E('ERR_SOCKET_CLOSED', 'Socket is closed');
		E('ERR_SOCKET_DGRAM_NOT_RUNNING', 'Not running');
		E('ERR_STDERR_CLOSE', 'process.stderr cannot be closed');
		E('ERR_STDOUT_CLOSE', 'process.stdout cannot be closed');
		E('ERR_STREAM_WRAP', 'Stream has StringDecoder set or is in objectMode');
		E('ERR_TLS_CERT_ALTNAME_INVALID', "Hostname/IP does not match certificate's altnames: %s");
		E('ERR_TLS_DH_PARAM_SIZE', size => `DH parameter size ${size} is less than 2048`);
		E('ERR_TLS_HANDSHAKE_TIMEOUT', 'TLS handshake timeout');
		E('ERR_TLS_RENEGOTIATION_FAILED', 'Failed to renegotiate');
		E('ERR_TLS_REQUIRED_SERVER_NAME', '"servername" is required parameter for Server.addContext');
		E('ERR_TLS_SESSION_ATTACK', 'TSL session renegotiation attack detected');
		E('ERR_TRANSFORM_ALREADY_TRANSFORMING', 'Calling transform done when still transforming');
		E('ERR_TRANSFORM_WITH_LENGTH_0', 'Calling transform done when writableState.length != 0');
		E('ERR_UNKNOWN_ENCODING', 'Unknown encoding: %s');
		E('ERR_UNKNOWN_SIGNAL', 'Unknown signal: %s');
		E('ERR_UNKNOWN_STDIN_TYPE', 'Unknown stdin file type');
		E('ERR_UNKNOWN_STREAM_TYPE', 'Unknown stream file type');
		E('ERR_V8BREAKITERATOR', 'Full ICU data not installed. ' + 'See https://github.com/nodejs/node/wiki/Intl');
		function invalidArgType(name, expected, actual) {
		    assert(name, 'name is required');
		    // determiner: 'must be' or 'must not be'
		    let determiner;
		    if (expected.includes('not ')) {
		        determiner = 'must not be';
		        expected = expected.split('not ')[1];
		    }
		    else {
		        determiner = 'must be';
		    }
		    let msg;
		    if (Array.isArray(name)) {
		        const names = name.map(val => `"${val}"`).join(', ');
		        msg = `The ${names} arguments ${determiner} ${oneOf(expected, 'type')}`;
		    }
		    else if (name.includes(' argument')) {
		        // for the case like 'first argument'
		        msg = `The ${name} ${determiner} ${oneOf(expected, 'type')}`;
		    }
		    else {
		        const type = name.includes('.') ? 'property' : 'argument';
		        msg = `The "${name}" ${type} ${determiner} ${oneOf(expected, 'type')}`;
		    }
		    // if actual value received, output it
		    if (arguments.length >= 3) {
		        msg += `. Received type ${actual !== null ? typeof actual : 'null'}`;
		    }
		    return msg;
		}
		function missingArgs(...args) {
		    assert(args.length > 0, 'At least one arg needs to be specified');
		    let msg = 'The ';
		    const len = args.length;
		    args = args.map(a => `"${a}"`);
		    switch (len) {
		        case 1:
		            msg += `${args[0]} argument`;
		            break;
		        case 2:
		            msg += `${args[0]} and ${args[1]} arguments`;
		            break;
		        default:
		            msg += args.slice(0, len - 1).join(', ');
		            msg += `, and ${args[len - 1]} arguments`;
		            break;
		    }
		    return `${msg} must be specified`;
		}
		function oneOf(expected, thing) {
		    assert(expected, 'expected is required');
		    assert(typeof thing === 'string', 'thing is required');
		    if (Array.isArray(expected)) {
		        const len = expected.length;
		        assert(len > 0, 'At least one expected value needs to be specified');
		        // tslint:disable-next-line
		        expected = expected.map(i => String(i));
		        if (len > 2) {
		            return `one of ${thing} ${expected.slice(0, len - 1).join(', ')}, or ` + expected[len - 1];
		        }
		        else if (len === 2) {
		            return `one of ${thing} ${expected[0]} or ${expected[1]}`;
		        }
		        else {
		            return `of ${thing} ${expected[0]}`;
		        }
		    }
		    else {
		        return `of ${thing} ${String(expected)}`;
		    }
		}
		function bufferOutOfBounds(name, isWriting) {
		    if (isWriting) {
		        return 'Attempt to write outside buffer bounds';
		    }
		    else {
		        return `"${name}" is outside of buffer bounds`;
		    }
		}
		
	} (errors$2));
	return errors$2;
}

var hasRequiredEncoding;

function requireEncoding () {
	if (hasRequiredEncoding) return encoding;
	hasRequiredEncoding = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.ENCODING_UTF8 = void 0;
		exports.assertEncoding = assertEncoding;
		exports.strToEncoding = strToEncoding;
		const buffer_1 = requireBuffer$1();
		const errors = requireErrors$1();
		exports.ENCODING_UTF8 = 'utf8';
		function assertEncoding(encoding) {
		    if (encoding && !buffer_1.Buffer.isEncoding(encoding))
		        throw new errors.TypeError('ERR_INVALID_OPT_VALUE_ENCODING', encoding);
		}
		function strToEncoding(str, encoding) {
		    if (!encoding || encoding === exports.ENCODING_UTF8)
		        return str; // UTF-8
		    if (encoding === 'buffer')
		        return new buffer_1.Buffer(str); // `buffer` encoding
		    return new buffer_1.Buffer(str).toString(encoding); // Custom encoding
		}
		
	} (encoding));
	return encoding;
}

var hasRequiredDirent;

function requireDirent () {
	if (hasRequiredDirent) return Dirent;
	hasRequiredDirent = 1;
	Object.defineProperty(Dirent, "__esModule", { value: true });
	Dirent.Dirent = void 0;
	const constants_1 = requireConstants$2();
	const encoding_1 = requireEncoding();
	const { S_IFMT, S_IFDIR, S_IFREG, S_IFBLK, S_IFCHR, S_IFLNK, S_IFIFO, S_IFSOCK } = constants_1.constants;
	/**
	 * A directory entry, like `fs.Dirent`.
	 */
	let Dirent$1 = class Dirent {
	    constructor() {
	        this.name = '';
	        this.path = '';
	        this.parentPath = '';
	        this.mode = 0;
	    }
	    static build(link, encoding) {
	        const dirent = new Dirent();
	        const { mode } = link.getNode();
	        dirent.name = (0, encoding_1.strToEncoding)(link.getName(), encoding);
	        dirent.mode = mode;
	        dirent.path = link.getParentPath();
	        dirent.parentPath = dirent.path;
	        return dirent;
	    }
	    _checkModeProperty(property) {
	        return (this.mode & S_IFMT) === property;
	    }
	    isDirectory() {
	        return this._checkModeProperty(S_IFDIR);
	    }
	    isFile() {
	        return this._checkModeProperty(S_IFREG);
	    }
	    isBlockDevice() {
	        return this._checkModeProperty(S_IFBLK);
	    }
	    isCharacterDevice() {
	        return this._checkModeProperty(S_IFCHR);
	    }
	    isSymbolicLink() {
	        return this._checkModeProperty(S_IFLNK);
	    }
	    isFIFO() {
	        return this._checkModeProperty(S_IFIFO);
	    }
	    isSocket() {
	        return this._checkModeProperty(S_IFSOCK);
	    }
	};
	Dirent.Dirent = Dirent$1;
	Dirent.default = Dirent$1;
	
	return Dirent;
}

var volume = {};

var pathBrowserify;
var hasRequiredPathBrowserify;

function requirePathBrowserify () {
	if (hasRequiredPathBrowserify) return pathBrowserify;
	hasRequiredPathBrowserify = 1;

	function assertPath(path) {
	  if (typeof path !== 'string') {
	    throw new TypeError('Path must be a string. Received ' + JSON.stringify(path));
	  }
	}

	// Resolves . and .. elements in a path with directory names
	function normalizeStringPosix(path, allowAboveRoot) {
	  var res = '';
	  var lastSegmentLength = 0;
	  var lastSlash = -1;
	  var dots = 0;
	  var code;
	  for (var i = 0; i <= path.length; ++i) {
	    if (i < path.length)
	      code = path.charCodeAt(i);
	    else if (code === 47 /*/*/)
	      break;
	    else
	      code = 47 /*/*/;
	    if (code === 47 /*/*/) {
	      if (lastSlash === i - 1 || dots === 1) ; else if (lastSlash !== i - 1 && dots === 2) {
	        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 /*.*/ || res.charCodeAt(res.length - 2) !== 46 /*.*/) {
	          if (res.length > 2) {
	            var lastSlashIndex = res.lastIndexOf('/');
	            if (lastSlashIndex !== res.length - 1) {
	              if (lastSlashIndex === -1) {
	                res = '';
	                lastSegmentLength = 0;
	              } else {
	                res = res.slice(0, lastSlashIndex);
	                lastSegmentLength = res.length - 1 - res.lastIndexOf('/');
	              }
	              lastSlash = i;
	              dots = 0;
	              continue;
	            }
	          } else if (res.length === 2 || res.length === 1) {
	            res = '';
	            lastSegmentLength = 0;
	            lastSlash = i;
	            dots = 0;
	            continue;
	          }
	        }
	        if (allowAboveRoot) {
	          if (res.length > 0)
	            res += '/..';
	          else
	            res = '..';
	          lastSegmentLength = 2;
	        }
	      } else {
	        if (res.length > 0)
	          res += '/' + path.slice(lastSlash + 1, i);
	        else
	          res = path.slice(lastSlash + 1, i);
	        lastSegmentLength = i - lastSlash - 1;
	      }
	      lastSlash = i;
	      dots = 0;
	    } else if (code === 46 /*.*/ && dots !== -1) {
	      ++dots;
	    } else {
	      dots = -1;
	    }
	  }
	  return res;
	}

	function _format(sep, pathObject) {
	  var dir = pathObject.dir || pathObject.root;
	  var base = pathObject.base || (pathObject.name || '') + (pathObject.ext || '');
	  if (!dir) {
	    return base;
	  }
	  if (dir === pathObject.root) {
	    return dir + base;
	  }
	  return dir + sep + base;
	}

	var posix = {
	  // path.resolve([from ...], to)
	  resolve: function resolve() {
	    var resolvedPath = '';
	    var resolvedAbsolute = false;
	    var cwd;

	    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	      var path;
	      if (i >= 0)
	        path = arguments[i];
	      else {
	        if (cwd === undefined)
	          cwd = process$1.cwd();
	        path = cwd;
	      }

	      assertPath(path);

	      // Skip empty entries
	      if (path.length === 0) {
	        continue;
	      }

	      resolvedPath = path + '/' + resolvedPath;
	      resolvedAbsolute = path.charCodeAt(0) === 47 /*/*/;
	    }

	    // At this point the path should be resolved to a full absolute path, but
	    // handle relative paths to be safe (might happen when process.cwd() fails)

	    // Normalize the path
	    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);

	    if (resolvedAbsolute) {
	      if (resolvedPath.length > 0)
	        return '/' + resolvedPath;
	      else
	        return '/';
	    } else if (resolvedPath.length > 0) {
	      return resolvedPath;
	    } else {
	      return '.';
	    }
	  },

	  normalize: function normalize(path) {
	    assertPath(path);

	    if (path.length === 0) return '.';

	    var isAbsolute = path.charCodeAt(0) === 47 /*/*/;
	    var trailingSeparator = path.charCodeAt(path.length - 1) === 47 /*/*/;

	    // Normalize the path
	    path = normalizeStringPosix(path, !isAbsolute);

	    if (path.length === 0 && !isAbsolute) path = '.';
	    if (path.length > 0 && trailingSeparator) path += '/';

	    if (isAbsolute) return '/' + path;
	    return path;
	  },

	  isAbsolute: function isAbsolute(path) {
	    assertPath(path);
	    return path.length > 0 && path.charCodeAt(0) === 47 /*/*/;
	  },

	  join: function join() {
	    if (arguments.length === 0)
	      return '.';
	    var joined;
	    for (var i = 0; i < arguments.length; ++i) {
	      var arg = arguments[i];
	      assertPath(arg);
	      if (arg.length > 0) {
	        if (joined === undefined)
	          joined = arg;
	        else
	          joined += '/' + arg;
	      }
	    }
	    if (joined === undefined)
	      return '.';
	    return posix.normalize(joined);
	  },

	  relative: function relative(from, to) {
	    assertPath(from);
	    assertPath(to);

	    if (from === to) return '';

	    from = posix.resolve(from);
	    to = posix.resolve(to);

	    if (from === to) return '';

	    // Trim any leading backslashes
	    var fromStart = 1;
	    for (; fromStart < from.length; ++fromStart) {
	      if (from.charCodeAt(fromStart) !== 47 /*/*/)
	        break;
	    }
	    var fromEnd = from.length;
	    var fromLen = fromEnd - fromStart;

	    // Trim any leading backslashes
	    var toStart = 1;
	    for (; toStart < to.length; ++toStart) {
	      if (to.charCodeAt(toStart) !== 47 /*/*/)
	        break;
	    }
	    var toEnd = to.length;
	    var toLen = toEnd - toStart;

	    // Compare paths to find the longest common path from root
	    var length = fromLen < toLen ? fromLen : toLen;
	    var lastCommonSep = -1;
	    var i = 0;
	    for (; i <= length; ++i) {
	      if (i === length) {
	        if (toLen > length) {
	          if (to.charCodeAt(toStart + i) === 47 /*/*/) {
	            // We get here if `from` is the exact base path for `to`.
	            // For example: from='/foo/bar'; to='/foo/bar/baz'
	            return to.slice(toStart + i + 1);
	          } else if (i === 0) {
	            // We get here if `from` is the root
	            // For example: from='/'; to='/foo'
	            return to.slice(toStart + i);
	          }
	        } else if (fromLen > length) {
	          if (from.charCodeAt(fromStart + i) === 47 /*/*/) {
	            // We get here if `to` is the exact base path for `from`.
	            // For example: from='/foo/bar/baz'; to='/foo/bar'
	            lastCommonSep = i;
	          } else if (i === 0) {
	            // We get here if `to` is the root.
	            // For example: from='/foo'; to='/'
	            lastCommonSep = 0;
	          }
	        }
	        break;
	      }
	      var fromCode = from.charCodeAt(fromStart + i);
	      var toCode = to.charCodeAt(toStart + i);
	      if (fromCode !== toCode)
	        break;
	      else if (fromCode === 47 /*/*/)
	        lastCommonSep = i;
	    }

	    var out = '';
	    // Generate the relative path based on the path difference between `to`
	    // and `from`
	    for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
	      if (i === fromEnd || from.charCodeAt(i) === 47 /*/*/) {
	        if (out.length === 0)
	          out += '..';
	        else
	          out += '/..';
	      }
	    }

	    // Lastly, append the rest of the destination (`to`) path that comes after
	    // the common path parts
	    if (out.length > 0)
	      return out + to.slice(toStart + lastCommonSep);
	    else {
	      toStart += lastCommonSep;
	      if (to.charCodeAt(toStart) === 47 /*/*/)
	        ++toStart;
	      return to.slice(toStart);
	    }
	  },

	  _makeLong: function _makeLong(path) {
	    return path;
	  },

	  dirname: function dirname(path) {
	    assertPath(path);
	    if (path.length === 0) return '.';
	    var code = path.charCodeAt(0);
	    var hasRoot = code === 47 /*/*/;
	    var end = -1;
	    var matchedSlash = true;
	    for (var i = path.length - 1; i >= 1; --i) {
	      code = path.charCodeAt(i);
	      if (code === 47 /*/*/) {
	          if (!matchedSlash) {
	            end = i;
	            break;
	          }
	        } else {
	        // We saw the first non-path separator
	        matchedSlash = false;
	      }
	    }

	    if (end === -1) return hasRoot ? '/' : '.';
	    if (hasRoot && end === 1) return '//';
	    return path.slice(0, end);
	  },

	  basename: function basename(path, ext) {
	    if (ext !== undefined && typeof ext !== 'string') throw new TypeError('"ext" argument must be a string');
	    assertPath(path);

	    var start = 0;
	    var end = -1;
	    var matchedSlash = true;
	    var i;

	    if (ext !== undefined && ext.length > 0 && ext.length <= path.length) {
	      if (ext.length === path.length && ext === path) return '';
	      var extIdx = ext.length - 1;
	      var firstNonSlashEnd = -1;
	      for (i = path.length - 1; i >= 0; --i) {
	        var code = path.charCodeAt(i);
	        if (code === 47 /*/*/) {
	            // If we reached a path separator that was not part of a set of path
	            // separators at the end of the string, stop now
	            if (!matchedSlash) {
	              start = i + 1;
	              break;
	            }
	          } else {
	          if (firstNonSlashEnd === -1) {
	            // We saw the first non-path separator, remember this index in case
	            // we need it if the extension ends up not matching
	            matchedSlash = false;
	            firstNonSlashEnd = i + 1;
	          }
	          if (extIdx >= 0) {
	            // Try to match the explicit extension
	            if (code === ext.charCodeAt(extIdx)) {
	              if (--extIdx === -1) {
	                // We matched the extension, so mark this as the end of our path
	                // component
	                end = i;
	              }
	            } else {
	              // Extension does not match, so our result is the entire path
	              // component
	              extIdx = -1;
	              end = firstNonSlashEnd;
	            }
	          }
	        }
	      }

	      if (start === end) end = firstNonSlashEnd;else if (end === -1) end = path.length;
	      return path.slice(start, end);
	    } else {
	      for (i = path.length - 1; i >= 0; --i) {
	        if (path.charCodeAt(i) === 47 /*/*/) {
	            // If we reached a path separator that was not part of a set of path
	            // separators at the end of the string, stop now
	            if (!matchedSlash) {
	              start = i + 1;
	              break;
	            }
	          } else if (end === -1) {
	          // We saw the first non-path separator, mark this as the end of our
	          // path component
	          matchedSlash = false;
	          end = i + 1;
	        }
	      }

	      if (end === -1) return '';
	      return path.slice(start, end);
	    }
	  },

	  extname: function extname(path) {
	    assertPath(path);
	    var startDot = -1;
	    var startPart = 0;
	    var end = -1;
	    var matchedSlash = true;
	    // Track the state of characters (if any) we see before our first dot and
	    // after any path separator we find
	    var preDotState = 0;
	    for (var i = path.length - 1; i >= 0; --i) {
	      var code = path.charCodeAt(i);
	      if (code === 47 /*/*/) {
	          // If we reached a path separator that was not part of a set of path
	          // separators at the end of the string, stop now
	          if (!matchedSlash) {
	            startPart = i + 1;
	            break;
	          }
	          continue;
	        }
	      if (end === -1) {
	        // We saw the first non-path separator, mark this as the end of our
	        // extension
	        matchedSlash = false;
	        end = i + 1;
	      }
	      if (code === 46 /*.*/) {
	          // If this is our first dot, mark it as the start of our extension
	          if (startDot === -1)
	            startDot = i;
	          else if (preDotState !== 1)
	            preDotState = 1;
	      } else if (startDot !== -1) {
	        // We saw a non-dot and non-path separator before our dot, so we should
	        // have a good chance at having a non-empty extension
	        preDotState = -1;
	      }
	    }

	    if (startDot === -1 || end === -1 ||
	        // We saw a non-dot character immediately before the dot
	        preDotState === 0 ||
	        // The (right-most) trimmed path component is exactly '..'
	        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
	      return '';
	    }
	    return path.slice(startDot, end);
	  },

	  format: function format(pathObject) {
	    if (pathObject === null || typeof pathObject !== 'object') {
	      throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
	    }
	    return _format('/', pathObject);
	  },

	  parse: function parse(path) {
	    assertPath(path);

	    var ret = { root: '', dir: '', base: '', ext: '', name: '' };
	    if (path.length === 0) return ret;
	    var code = path.charCodeAt(0);
	    var isAbsolute = code === 47 /*/*/;
	    var start;
	    if (isAbsolute) {
	      ret.root = '/';
	      start = 1;
	    } else {
	      start = 0;
	    }
	    var startDot = -1;
	    var startPart = 0;
	    var end = -1;
	    var matchedSlash = true;
	    var i = path.length - 1;

	    // Track the state of characters (if any) we see before our first dot and
	    // after any path separator we find
	    var preDotState = 0;

	    // Get non-dir info
	    for (; i >= start; --i) {
	      code = path.charCodeAt(i);
	      if (code === 47 /*/*/) {
	          // If we reached a path separator that was not part of a set of path
	          // separators at the end of the string, stop now
	          if (!matchedSlash) {
	            startPart = i + 1;
	            break;
	          }
	          continue;
	        }
	      if (end === -1) {
	        // We saw the first non-path separator, mark this as the end of our
	        // extension
	        matchedSlash = false;
	        end = i + 1;
	      }
	      if (code === 46 /*.*/) {
	          // If this is our first dot, mark it as the start of our extension
	          if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
	        } else if (startDot !== -1) {
	        // We saw a non-dot and non-path separator before our dot, so we should
	        // have a good chance at having a non-empty extension
	        preDotState = -1;
	      }
	    }

	    if (startDot === -1 || end === -1 ||
	    // We saw a non-dot character immediately before the dot
	    preDotState === 0 ||
	    // The (right-most) trimmed path component is exactly '..'
	    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
	      if (end !== -1) {
	        if (startPart === 0 && isAbsolute) ret.base = ret.name = path.slice(1, end);else ret.base = ret.name = path.slice(startPart, end);
	      }
	    } else {
	      if (startPart === 0 && isAbsolute) {
	        ret.name = path.slice(1, startDot);
	        ret.base = path.slice(1, end);
	      } else {
	        ret.name = path.slice(startPart, startDot);
	        ret.base = path.slice(startPart, end);
	      }
	      ret.ext = path.slice(startDot, end);
	    }

	    if (startPart > 0) ret.dir = path.slice(0, startPart - 1);else if (isAbsolute) ret.dir = '/';

	    return ret;
	  },

	  sep: '/',
	  delimiter: ':',
	  win32: null,
	  posix: null
	};

	posix.posix = posix;

	pathBrowserify = posix;
	return pathBrowserify;
}

var node = {};

var process = {};

var hasRequiredProcess;

function requireProcess () {
	if (hasRequiredProcess) return process;
	hasRequiredProcess = 1;
	// Here we mock the undefined `process` variable in case we are not in Node's environment.
	Object.defineProperty(process, "__esModule", { value: true });
	process.createProcess = createProcess;
	/**
	 * Looks to return a `process` object, if one is available.
	 *
	 * The undefined `process` is returned if defined;
	 * otherwise `require('process')` is attempted.
	 *
	 * If that fails, `undefined` is returned.
	 *
	 * @return {IProcess | undefined}
	 */
	const maybeReturnProcess = () => {
	    if (typeof process$1 !== 'undefined') {
	        return process$1;
	    }
	    try {
	        return requireBrowser$2();
	    }
	    catch (_a) {
	        return undefined;
	    }
	};
	function createProcess() {
	    const p = maybeReturnProcess() || {};
	    if (!p.cwd)
	        p.cwd = () => '/';
	    if (!p.emitWarning)
	        p.emitWarning = (message, type) => {
	            // tslint:disable-next-line:no-console
	            console.warn(`${type}${type ? ': ' : ''}${message}`);
	        };
	    if (!p.env)
	        p.env = {};
	    return p;
	}
	process.default = createProcess();
	
	return process;
}

var events = {exports: {}};

var hasRequiredEvents;

function requireEvents () {
	if (hasRequiredEvents) return events.exports;
	hasRequiredEvents = 1;

	var R = typeof Reflect === 'object' ? Reflect : null;
	var ReflectApply = R && typeof R.apply === 'function'
	  ? R.apply
	  : function ReflectApply(target, receiver, args) {
	    return Function.prototype.apply.call(target, receiver, args);
	  };

	var ReflectOwnKeys;
	if (R && typeof R.ownKeys === 'function') {
	  ReflectOwnKeys = R.ownKeys;
	} else if (Object.getOwnPropertySymbols) {
	  ReflectOwnKeys = function ReflectOwnKeys(target) {
	    return Object.getOwnPropertyNames(target)
	      .concat(Object.getOwnPropertySymbols(target));
	  };
	} else {
	  ReflectOwnKeys = function ReflectOwnKeys(target) {
	    return Object.getOwnPropertyNames(target);
	  };
	}

	function ProcessEmitWarning(warning) {
	  if (console && console.warn) console.warn(warning);
	}

	var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
	  return value !== value;
	};

	function EventEmitter() {
	  EventEmitter.init.call(this);
	}
	events.exports = EventEmitter;
	events.exports.once = once;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._eventsCount = 0;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	var defaultMaxListeners = 10;

	function checkListener(listener) {
	  if (typeof listener !== 'function') {
	    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
	  }
	}

	Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
	  enumerable: true,
	  get: function() {
	    return defaultMaxListeners;
	  },
	  set: function(arg) {
	    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
	      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
	    }
	    defaultMaxListeners = arg;
	  }
	});

	EventEmitter.init = function() {

	  if (this._events === undefined ||
	      this._events === Object.getPrototypeOf(this)._events) {
	    this._events = Object.create(null);
	    this._eventsCount = 0;
	  }

	  this._maxListeners = this._maxListeners || undefined;
	};

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
	  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
	    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
	  }
	  this._maxListeners = n;
	  return this;
	};

	function _getMaxListeners(that) {
	  if (that._maxListeners === undefined)
	    return EventEmitter.defaultMaxListeners;
	  return that._maxListeners;
	}

	EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
	  return _getMaxListeners(this);
	};

	EventEmitter.prototype.emit = function emit(type) {
	  var args = [];
	  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
	  var doError = (type === 'error');

	  var events = this._events;
	  if (events !== undefined)
	    doError = (doError && events.error === undefined);
	  else if (!doError)
	    return false;

	  // If there is no 'error' event listener then throw.
	  if (doError) {
	    var er;
	    if (args.length > 0)
	      er = args[0];
	    if (er instanceof Error) {
	      // Note: The comments on the `throw` lines are intentional, they show
	      // up in Node's output if this results in an unhandled exception.
	      throw er; // Unhandled 'error' event
	    }
	    // At least give some kind of context to the user
	    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
	    err.context = er;
	    throw err; // Unhandled 'error' event
	  }

	  var handler = events[type];

	  if (handler === undefined)
	    return false;

	  if (typeof handler === 'function') {
	    ReflectApply(handler, this, args);
	  } else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      ReflectApply(listeners[i], this, args);
	  }

	  return true;
	};

	function _addListener(target, type, listener, prepend) {
	  var m;
	  var events;
	  var existing;

	  checkListener(listener);

	  events = target._events;
	  if (events === undefined) {
	    events = target._events = Object.create(null);
	    target._eventsCount = 0;
	  } else {
	    // To avoid recursion in the case that type === "newListener"! Before
	    // adding it to the listeners, first emit "newListener".
	    if (events.newListener !== undefined) {
	      target.emit('newListener', type,
	                  listener.listener ? listener.listener : listener);

	      // Re-assign `events` because a newListener handler could have caused the
	      // this._events to be assigned to a new object
	      events = target._events;
	    }
	    existing = events[type];
	  }

	  if (existing === undefined) {
	    // Optimize the case of one listener. Don't need the extra array object.
	    existing = events[type] = listener;
	    ++target._eventsCount;
	  } else {
	    if (typeof existing === 'function') {
	      // Adding the second element, need to change to array.
	      existing = events[type] =
	        prepend ? [listener, existing] : [existing, listener];
	      // If we've already got an array, just append.
	    } else if (prepend) {
	      existing.unshift(listener);
	    } else {
	      existing.push(listener);
	    }

	    // Check for listener leak
	    m = _getMaxListeners(target);
	    if (m > 0 && existing.length > m && !existing.warned) {
	      existing.warned = true;
	      // No error code for this since it is a Warning
	      // eslint-disable-next-line no-restricted-syntax
	      var w = new Error('Possible EventEmitter memory leak detected. ' +
	                          existing.length + ' ' + String(type) + ' listeners ' +
	                          'added. Use emitter.setMaxListeners() to ' +
	                          'increase limit');
	      w.name = 'MaxListenersExceededWarning';
	      w.emitter = target;
	      w.type = type;
	      w.count = existing.length;
	      ProcessEmitWarning(w);
	    }
	  }

	  return target;
	}

	EventEmitter.prototype.addListener = function addListener(type, listener) {
	  return _addListener(this, type, listener, false);
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.prependListener =
	    function prependListener(type, listener) {
	      return _addListener(this, type, listener, true);
	    };

	function onceWrapper() {
	  if (!this.fired) {
	    this.target.removeListener(this.type, this.wrapFn);
	    this.fired = true;
	    if (arguments.length === 0)
	      return this.listener.call(this.target);
	    return this.listener.apply(this.target, arguments);
	  }
	}

	function _onceWrap(target, type, listener) {
	  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
	  var wrapped = onceWrapper.bind(state);
	  wrapped.listener = listener;
	  state.wrapFn = wrapped;
	  return wrapped;
	}

	EventEmitter.prototype.once = function once(type, listener) {
	  checkListener(listener);
	  this.on(type, _onceWrap(this, type, listener));
	  return this;
	};

	EventEmitter.prototype.prependOnceListener =
	    function prependOnceListener(type, listener) {
	      checkListener(listener);
	      this.prependListener(type, _onceWrap(this, type, listener));
	      return this;
	    };

	// Emits a 'removeListener' event if and only if the listener was removed.
	EventEmitter.prototype.removeListener =
	    function removeListener(type, listener) {
	      var list, events, position, i, originalListener;

	      checkListener(listener);

	      events = this._events;
	      if (events === undefined)
	        return this;

	      list = events[type];
	      if (list === undefined)
	        return this;

	      if (list === listener || list.listener === listener) {
	        if (--this._eventsCount === 0)
	          this._events = Object.create(null);
	        else {
	          delete events[type];
	          if (events.removeListener)
	            this.emit('removeListener', type, list.listener || listener);
	        }
	      } else if (typeof list !== 'function') {
	        position = -1;

	        for (i = list.length - 1; i >= 0; i--) {
	          if (list[i] === listener || list[i].listener === listener) {
	            originalListener = list[i].listener;
	            position = i;
	            break;
	          }
	        }

	        if (position < 0)
	          return this;

	        if (position === 0)
	          list.shift();
	        else {
	          spliceOne(list, position);
	        }

	        if (list.length === 1)
	          events[type] = list[0];

	        if (events.removeListener !== undefined)
	          this.emit('removeListener', type, originalListener || listener);
	      }

	      return this;
	    };

	EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

	EventEmitter.prototype.removeAllListeners =
	    function removeAllListeners(type) {
	      var listeners, events, i;

	      events = this._events;
	      if (events === undefined)
	        return this;

	      // not listening for removeListener, no need to emit
	      if (events.removeListener === undefined) {
	        if (arguments.length === 0) {
	          this._events = Object.create(null);
	          this._eventsCount = 0;
	        } else if (events[type] !== undefined) {
	          if (--this._eventsCount === 0)
	            this._events = Object.create(null);
	          else
	            delete events[type];
	        }
	        return this;
	      }

	      // emit removeListener for all listeners on all events
	      if (arguments.length === 0) {
	        var keys = Object.keys(events);
	        var key;
	        for (i = 0; i < keys.length; ++i) {
	          key = keys[i];
	          if (key === 'removeListener') continue;
	          this.removeAllListeners(key);
	        }
	        this.removeAllListeners('removeListener');
	        this._events = Object.create(null);
	        this._eventsCount = 0;
	        return this;
	      }

	      listeners = events[type];

	      if (typeof listeners === 'function') {
	        this.removeListener(type, listeners);
	      } else if (listeners !== undefined) {
	        // LIFO order
	        for (i = listeners.length - 1; i >= 0; i--) {
	          this.removeListener(type, listeners[i]);
	        }
	      }

	      return this;
	    };

	function _listeners(target, type, unwrap) {
	  var events = target._events;

	  if (events === undefined)
	    return [];

	  var evlistener = events[type];
	  if (evlistener === undefined)
	    return [];

	  if (typeof evlistener === 'function')
	    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

	  return unwrap ?
	    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
	}

	EventEmitter.prototype.listeners = function listeners(type) {
	  return _listeners(this, type, true);
	};

	EventEmitter.prototype.rawListeners = function rawListeners(type) {
	  return _listeners(this, type, false);
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  if (typeof emitter.listenerCount === 'function') {
	    return emitter.listenerCount(type);
	  } else {
	    return listenerCount.call(emitter, type);
	  }
	};

	EventEmitter.prototype.listenerCount = listenerCount;
	function listenerCount(type) {
	  var events = this._events;

	  if (events !== undefined) {
	    var evlistener = events[type];

	    if (typeof evlistener === 'function') {
	      return 1;
	    } else if (evlistener !== undefined) {
	      return evlistener.length;
	    }
	  }

	  return 0;
	}

	EventEmitter.prototype.eventNames = function eventNames() {
	  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
	};

	function arrayClone(arr, n) {
	  var copy = new Array(n);
	  for (var i = 0; i < n; ++i)
	    copy[i] = arr[i];
	  return copy;
	}

	function spliceOne(list, index) {
	  for (; index + 1 < list.length; index++)
	    list[index] = list[index + 1];
	  list.pop();
	}

	function unwrapListeners(arr) {
	  var ret = new Array(arr.length);
	  for (var i = 0; i < ret.length; ++i) {
	    ret[i] = arr[i].listener || arr[i];
	  }
	  return ret;
	}

	function once(emitter, name) {
	  return new Promise(function (resolve, reject) {
	    function errorListener(err) {
	      emitter.removeListener(name, resolver);
	      reject(err);
	    }

	    function resolver() {
	      if (typeof emitter.removeListener === 'function') {
	        emitter.removeListener('error', errorListener);
	      }
	      resolve([].slice.call(arguments));
	    }
	    eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
	    if (name !== 'error') {
	      addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
	    }
	  });
	}

	function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
	  if (typeof emitter.on === 'function') {
	    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
	  }
	}

	function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
	  if (typeof emitter.on === 'function') {
	    if (flags.once) {
	      emitter.once(name, listener);
	    } else {
	      emitter.on(name, listener);
	    }
	  } else if (typeof emitter.addEventListener === 'function') {
	    // EventTarget does not have `error` event semantics like Node
	    // EventEmitters, we do not listen for `error` events here.
	    emitter.addEventListener(name, function wrapListener(arg) {
	      // IE does not have builtin `{ once: true }` support so we
	      // have to do it manually.
	      if (flags.once) {
	        emitter.removeEventListener(name, wrapListener);
	      }
	      listener(arg);
	    });
	  } else {
	    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
	  }
	}
	return events.exports;
}

var hasRequiredNode;

function requireNode () {
	if (hasRequiredNode) return node;
	hasRequiredNode = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.File = exports.Link = exports.Node = exports.SEP = void 0;
		const process_1 = requireProcess();
		const buffer_1 = requireBuffer$1();
		const constants_1 = requireConstants$2();
		const events_1 = requireEvents();
		const Stats_1 = requireStats();
		const { S_IFMT, S_IFDIR, S_IFREG, S_IFLNK, S_IFCHR, O_APPEND } = constants_1.constants;
		const getuid = () => { var _a, _b; return (_b = (_a = process_1.default.getuid) === null || _a === void 0 ? void 0 : _a.call(process_1.default)) !== null && _b !== void 0 ? _b : 0; };
		const getgid = () => { var _a, _b; return (_b = (_a = process_1.default.getgid) === null || _a === void 0 ? void 0 : _a.call(process_1.default)) !== null && _b !== void 0 ? _b : 0; };
		exports.SEP = '/';
		/**
		 * Node in a file system (like i-node, v-node).
		 */
		class Node extends events_1.EventEmitter {
		    constructor(ino, mode = 0o666) {
		        super();
		        // User ID and group ID.
		        this._uid = getuid();
		        this._gid = getgid();
		        this._atime = new Date();
		        this._mtime = new Date();
		        this._ctime = new Date();
		        this.rdev = 0;
		        // Number of hard links pointing at this Node.
		        this._nlink = 1;
		        this.mode = mode;
		        this.ino = ino;
		    }
		    set ctime(ctime) {
		        this._ctime = ctime;
		    }
		    get ctime() {
		        return this._ctime;
		    }
		    set uid(uid) {
		        this._uid = uid;
		        this.ctime = new Date();
		    }
		    get uid() {
		        return this._uid;
		    }
		    set gid(gid) {
		        this._gid = gid;
		        this.ctime = new Date();
		    }
		    get gid() {
		        return this._gid;
		    }
		    set atime(atime) {
		        this._atime = atime;
		        this.ctime = new Date();
		    }
		    get atime() {
		        return this._atime;
		    }
		    set mtime(mtime) {
		        this._mtime = mtime;
		        this.ctime = new Date();
		    }
		    get mtime() {
		        return this._mtime;
		    }
		    get perm() {
		        return this.mode & ~S_IFMT;
		    }
		    set perm(perm) {
		        this.mode = (this.mode & S_IFMT) | (perm & ~S_IFMT);
		        this.ctime = new Date();
		    }
		    set nlink(nlink) {
		        this._nlink = nlink;
		        this.ctime = new Date();
		    }
		    get nlink() {
		        return this._nlink;
		    }
		    getString(encoding = 'utf8') {
		        this.atime = new Date();
		        return this.getBuffer().toString(encoding);
		    }
		    setString(str) {
		        // this.setBuffer(bufferFrom(str, 'utf8'));
		        this.buf = (0, buffer_1.bufferFrom)(str, 'utf8');
		        this.touch();
		    }
		    getBuffer() {
		        this.atime = new Date();
		        if (!this.buf)
		            this.setBuffer((0, buffer_1.bufferAllocUnsafe)(0));
		        return (0, buffer_1.bufferFrom)(this.buf); // Return a copy.
		    }
		    setBuffer(buf) {
		        this.buf = (0, buffer_1.bufferFrom)(buf); // Creates a copy of data.
		        this.touch();
		    }
		    getSize() {
		        return this.buf ? this.buf.length : 0;
		    }
		    setModeProperty(property) {
		        this.mode = property;
		    }
		    isFile() {
		        return (this.mode & S_IFMT) === S_IFREG;
		    }
		    isDirectory() {
		        return (this.mode & S_IFMT) === S_IFDIR;
		    }
		    isSymlink() {
		        // return !!this.symlink;
		        return (this.mode & S_IFMT) === S_IFLNK;
		    }
		    isCharacterDevice() {
		        return (this.mode & S_IFMT) === S_IFCHR;
		    }
		    makeSymlink(symlink) {
		        this.mode = S_IFLNK | 0o666;
		        this.symlink = symlink;
		    }
		    write(buf, off = 0, len = buf.length, pos = 0) {
		        if (!this.buf)
		            this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
		        if (pos + len > this.buf.length) {
		            const newBuf = (0, buffer_1.bufferAllocUnsafe)(pos + len);
		            this.buf.copy(newBuf, 0, 0, this.buf.length);
		            this.buf = newBuf;
		        }
		        buf.copy(this.buf, pos, off, off + len);
		        this.touch();
		        return len;
		    }
		    // Returns the number of bytes read.
		    read(buf, off = 0, len = buf.byteLength, pos = 0) {
		        this.atime = new Date();
		        if (!this.buf)
		            this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
		        let actualLen = len;
		        if (actualLen > buf.byteLength) {
		            actualLen = buf.byteLength;
		        }
		        if (actualLen + pos > this.buf.length) {
		            actualLen = this.buf.length - pos;
		        }
		        const buf2 = buf instanceof buffer_1.Buffer ? buf : buffer_1.Buffer.from(buf.buffer);
		        this.buf.copy(buf2, off, pos, pos + actualLen);
		        return actualLen;
		    }
		    truncate(len = 0) {
		        if (!len)
		            this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
		        else {
		            if (!this.buf)
		                this.buf = (0, buffer_1.bufferAllocUnsafe)(0);
		            if (len <= this.buf.length) {
		                this.buf = this.buf.slice(0, len);
		            }
		            else {
		                const buf = (0, buffer_1.bufferAllocUnsafe)(len);
		                this.buf.copy(buf);
		                buf.fill(0, this.buf.length);
		                this.buf = buf;
		            }
		        }
		        this.touch();
		    }
		    chmod(perm) {
		        this.mode = (this.mode & S_IFMT) | (perm & ~S_IFMT);
		        this.touch();
		    }
		    chown(uid, gid) {
		        this.uid = uid;
		        this.gid = gid;
		        this.touch();
		    }
		    touch() {
		        this.mtime = new Date();
		        this.emit('change', this);
		    }
		    canRead(uid = getuid(), gid = getgid()) {
		        if (this.perm & 4 /* S.IROTH */) {
		            return true;
		        }
		        if (gid === this.gid) {
		            if (this.perm & 32 /* S.IRGRP */) {
		                return true;
		            }
		        }
		        if (uid === this.uid) {
		            if (this.perm & 256 /* S.IRUSR */) {
		                return true;
		            }
		        }
		        return false;
		    }
		    canWrite(uid = getuid(), gid = getgid()) {
		        if (this.perm & 2 /* S.IWOTH */) {
		            return true;
		        }
		        if (gid === this.gid) {
		            if (this.perm & 16 /* S.IWGRP */) {
		                return true;
		            }
		        }
		        if (uid === this.uid) {
		            if (this.perm & 128 /* S.IWUSR */) {
		                return true;
		            }
		        }
		        return false;
		    }
		    canExecute(uid = getuid(), gid = getgid()) {
		        if (this.perm & 1 /* S.IXOTH */) {
		            return true;
		        }
		        if (gid === this.gid) {
		            if (this.perm & 8 /* S.IXGRP */) {
		                return true;
		            }
		        }
		        if (uid === this.uid) {
		            if (this.perm & 64 /* S.IXUSR */) {
		                return true;
		            }
		        }
		        return false;
		    }
		    del() {
		        this.emit('delete', this);
		    }
		    toJSON() {
		        return {
		            ino: this.ino,
		            uid: this.uid,
		            gid: this.gid,
		            atime: this.atime.getTime(),
		            mtime: this.mtime.getTime(),
		            ctime: this.ctime.getTime(),
		            perm: this.perm,
		            mode: this.mode,
		            nlink: this.nlink,
		            symlink: this.symlink,
		            data: this.getString(),
		        };
		    }
		}
		exports.Node = Node;
		/**
		 * Represents a hard link that points to an i-node `node`.
		 */
		class Link extends events_1.EventEmitter {
		    get steps() {
		        return this._steps;
		    }
		    // Recursively sync children steps, e.g. in case of dir rename
		    set steps(val) {
		        this._steps = val;
		        for (const [child, link] of this.children.entries()) {
		            if (child === '.' || child === '..') {
		                continue;
		            }
		            link === null || link === void 0 ? void 0 : link.syncSteps();
		        }
		    }
		    constructor(vol, parent, name) {
		        super();
		        this.children = new Map();
		        // Path to this node as Array: ['usr', 'bin', 'node'].
		        this._steps = [];
		        // "i-node" number of the node.
		        this.ino = 0;
		        // Number of children.
		        this.length = 0;
		        this.vol = vol;
		        this.parent = parent;
		        this.name = name;
		        this.syncSteps();
		    }
		    setNode(node) {
		        this.node = node;
		        this.ino = node.ino;
		    }
		    getNode() {
		        return this.node;
		    }
		    createChild(name, node = this.vol.createNode(S_IFREG | 0o666)) {
		        const link = new Link(this.vol, this, name);
		        link.setNode(node);
		        if (node.isDirectory()) {
		            link.children.set('.', link);
		            link.getNode().nlink++;
		        }
		        this.setChild(name, link);
		        return link;
		    }
		    setChild(name, link = new Link(this.vol, this, name)) {
		        this.children.set(name, link);
		        link.parent = this;
		        this.length++;
		        const node = link.getNode();
		        if (node.isDirectory()) {
		            link.children.set('..', this);
		            this.getNode().nlink++;
		        }
		        this.getNode().mtime = new Date();
		        this.emit('child:add', link, this);
		        return link;
		    }
		    deleteChild(link) {
		        const node = link.getNode();
		        if (node.isDirectory()) {
		            link.children.delete('..');
		            this.getNode().nlink--;
		        }
		        this.children.delete(link.getName());
		        this.length--;
		        this.getNode().mtime = new Date();
		        this.emit('child:delete', link, this);
		    }
		    getChild(name) {
		        this.getNode().mtime = new Date();
		        return this.children.get(name);
		    }
		    getPath() {
		        return this.steps.join(exports.SEP);
		    }
		    getParentPath() {
		        return this.steps.slice(0, -1).join(exports.SEP);
		    }
		    getName() {
		        return this.steps[this.steps.length - 1];
		    }
		    // del() {
		    //     const parent = this.parent;
		    //     if(parent) {
		    //         parent.deleteChild(link);
		    //     }
		    //     this.parent = null;
		    //     this.vol = null;
		    // }
		    toJSON() {
		        return {
		            steps: this.steps,
		            ino: this.ino,
		            children: Array.from(this.children.keys()),
		        };
		    }
		    syncSteps() {
		        this.steps = this.parent ? this.parent.steps.concat([this.name]) : [this.name];
		    }
		}
		exports.Link = Link;
		/**
		 * Represents an open file (file descriptor) that points to a `Link` (Hard-link) and a `Node`.
		 */
		class File {
		    /**
		     * Open a Link-Node pair. `node` is provided separately as that might be a different node
		     * rather the one `link` points to, because it might be a symlink.
		     * @param link
		     * @param node
		     * @param flags
		     * @param fd
		     */
		    constructor(link, node, flags, fd) {
		        this.link = link;
		        this.node = node;
		        this.flags = flags;
		        this.fd = fd;
		        this.position = 0;
		        if (this.flags & O_APPEND)
		            this.position = this.getSize();
		    }
		    getString(encoding = 'utf8') {
		        return this.node.getString();
		    }
		    setString(str) {
		        this.node.setString(str);
		    }
		    getBuffer() {
		        return this.node.getBuffer();
		    }
		    setBuffer(buf) {
		        this.node.setBuffer(buf);
		    }
		    getSize() {
		        return this.node.getSize();
		    }
		    truncate(len) {
		        this.node.truncate(len);
		    }
		    seekTo(position) {
		        this.position = position;
		    }
		    stats() {
		        return Stats_1.default.build(this.node);
		    }
		    write(buf, offset = 0, length = buf.length, position) {
		        if (typeof position !== 'number')
		            position = this.position;
		        const bytes = this.node.write(buf, offset, length, position);
		        this.position = position + bytes;
		        return bytes;
		    }
		    read(buf, offset = 0, length = buf.byteLength, position) {
		        if (typeof position !== 'number')
		            position = this.position;
		        const bytes = this.node.read(buf, offset, length, position);
		        this.position = position + bytes;
		        return bytes;
		    }
		    chmod(perm) {
		        this.node.chmod(perm);
		    }
		    chown(uid, gid) {
		        this.node.chown(uid, gid);
		    }
		}
		exports.File = File;
		
	} (node));
	return node;
}

var queueMicrotask$1 = {};

var hasRequiredQueueMicrotask;

function requireQueueMicrotask () {
	if (hasRequiredQueueMicrotask) return queueMicrotask$1;
	hasRequiredQueueMicrotask = 1;
	Object.defineProperty(queueMicrotask$1, "__esModule", { value: true });
	queueMicrotask$1.default = typeof queueMicrotask === 'function' ? queueMicrotask : (cb => Promise.resolve()
	    .then(() => cb())
	    .catch(() => { }));
	
	return queueMicrotask$1;
}

var setTimeoutUnref = {};

var hasRequiredSetTimeoutUnref;

function requireSetTimeoutUnref () {
	if (hasRequiredSetTimeoutUnref) return setTimeoutUnref;
	hasRequiredSetTimeoutUnref = 1;
	Object.defineProperty(setTimeoutUnref, "__esModule", { value: true });
	/**
	 * `setTimeoutUnref` is just like `setTimeout`,
	 * only in Node's environment it will "unref" its macro task.
	 */
	function setTimeoutUnref$1(callback, time, args) {
	    const ref = setTimeout.apply(typeof globalThis !== 'undefined' ? globalThis : commonjsGlobal$1, arguments);
	    if (ref && typeof ref === 'object' && typeof ref.unref === 'function')
	        ref.unref();
	    return ref;
	}
	setTimeoutUnref.default = setTimeoutUnref$1;
	
	return setTimeoutUnref;
}

var browser$1 = {exports: {}};

var stream = {exports: {}};

var primordials;
var hasRequiredPrimordials;

function requirePrimordials () {
	if (hasRequiredPrimordials) return primordials;
	hasRequiredPrimordials = 1;

	/*
	  This file is a reduced and adapted version of the main lib/internal/per_context/primordials.js file defined at

	  https://github.com/nodejs/node/blob/main/lib/internal/per_context/primordials.js

	  Don't try to replace with the original file and keep it up to date with the upstream file.
	*/

	// This is a simplified version of AggregateError
	class AggregateError extends Error {
	  constructor(errors) {
	    if (!Array.isArray(errors)) {
	      throw new TypeError(`Expected input to be an Array, got ${typeof errors}`)
	    }
	    let message = '';
	    for (let i = 0; i < errors.length; i++) {
	      message += `    ${errors[i].stack}\n`;
	    }
	    super(message);
	    this.name = 'AggregateError';
	    this.errors = errors;
	  }
	}
	primordials = {
	  AggregateError,
	  ArrayIsArray(self) {
	    return Array.isArray(self)
	  },
	  ArrayPrototypeIncludes(self, el) {
	    return self.includes(el)
	  },
	  ArrayPrototypeIndexOf(self, el) {
	    return self.indexOf(el)
	  },
	  ArrayPrototypeJoin(self, sep) {
	    return self.join(sep)
	  },
	  ArrayPrototypeMap(self, fn) {
	    return self.map(fn)
	  },
	  ArrayPrototypePop(self, el) {
	    return self.pop(el)
	  },
	  ArrayPrototypePush(self, el) {
	    return self.push(el)
	  },
	  ArrayPrototypeSlice(self, start, end) {
	    return self.slice(start, end)
	  },
	  Error,
	  FunctionPrototypeCall(fn, thisArgs, ...args) {
	    return fn.call(thisArgs, ...args)
	  },
	  FunctionPrototypeSymbolHasInstance(self, instance) {
	    return Function.prototype[Symbol.hasInstance].call(self, instance)
	  },
	  MathFloor: Math.floor,
	  Number,
	  NumberIsInteger: Number.isInteger,
	  NumberIsNaN: Number.isNaN,
	  NumberMAX_SAFE_INTEGER: Number.MAX_SAFE_INTEGER,
	  NumberMIN_SAFE_INTEGER: Number.MIN_SAFE_INTEGER,
	  NumberParseInt: Number.parseInt,
	  ObjectDefineProperties(self, props) {
	    return Object.defineProperties(self, props)
	  },
	  ObjectDefineProperty(self, name, prop) {
	    return Object.defineProperty(self, name, prop)
	  },
	  ObjectGetOwnPropertyDescriptor(self, name) {
	    return Object.getOwnPropertyDescriptor(self, name)
	  },
	  ObjectKeys(obj) {
	    return Object.keys(obj)
	  },
	  ObjectSetPrototypeOf(target, proto) {
	    return Object.setPrototypeOf(target, proto)
	  },
	  Promise,
	  PromisePrototypeCatch(self, fn) {
	    return self.catch(fn)
	  },
	  PromisePrototypeThen(self, thenFn, catchFn) {
	    return self.then(thenFn, catchFn)
	  },
	  PromiseReject(err) {
	    return Promise.reject(err)
	  },
	  PromiseResolve(val) {
	    return Promise.resolve(val)
	  },
	  ReflectApply: Reflect.apply,
	  RegExpPrototypeTest(self, value) {
	    return self.test(value)
	  },
	  SafeSet: Set,
	  String,
	  StringPrototypeSlice(self, start, end) {
	    return self.slice(start, end)
	  },
	  StringPrototypeToLowerCase(self) {
	    return self.toLowerCase()
	  },
	  StringPrototypeToUpperCase(self) {
	    return self.toUpperCase()
	  },
	  StringPrototypeTrim(self) {
	    return self.trim()
	  },
	  Symbol,
	  SymbolFor: Symbol.for,
	  SymbolAsyncIterator: Symbol.asyncIterator,
	  SymbolHasInstance: Symbol.hasInstance,
	  SymbolIterator: Symbol.iterator,
	  SymbolDispose: Symbol.dispose || Symbol('Symbol.dispose'),
	  SymbolAsyncDispose: Symbol.asyncDispose || Symbol('Symbol.asyncDispose'),
	  TypedArrayPrototypeSet(self, buf, len) {
	    return self.set(buf, len)
	  },
	  Boolean,
	  Uint8Array
	};
	return primordials;
}

var util$2 = {exports: {}};

var inspect;
var hasRequiredInspect;

function requireInspect () {
	if (hasRequiredInspect) return inspect;
	hasRequiredInspect = 1;

	/*
	  This file is a reduced and adapted version of the main lib/internal/util/inspect.js file defined at

	  https://github.com/nodejs/node/blob/main/lib/internal/util/inspect.js

	  Don't try to replace with the original file and keep it up to date with the upstream file.
	*/
	inspect = {
	  format(format, ...args) {
	    // Simplified version of https://nodejs.org/api/util.html#utilformatformat-args
	    return format.replace(/%([sdifj])/g, function (...[_unused, type]) {
	      const replacement = args.shift();
	      if (type === 'f') {
	        return replacement.toFixed(6)
	      } else if (type === 'j') {
	        return JSON.stringify(replacement)
	      } else if (type === 's' && typeof replacement === 'object') {
	        const ctor = replacement.constructor !== Object ? replacement.constructor.name : '';
	        return `${ctor} {}`.trim()
	      } else {
	        return replacement.toString()
	      }
	    })
	  },
	  inspect(value) {
	    // Vastly simplified version of https://nodejs.org/api/util.html#utilinspectobject-options
	    switch (typeof value) {
	      case 'string':
	        if (value.includes("'")) {
	          if (!value.includes('"')) {
	            return `"${value}"`
	          } else if (!value.includes('`') && !value.includes('${')) {
	            return `\`${value}\``
	          }
	        }
	        return `'${value}'`
	      case 'number':
	        if (isNaN(value)) {
	          return 'NaN'
	        } else if (Object.is(value, -0)) {
	          return String(value)
	        }
	        return value
	      case 'bigint':
	        return `${String(value)}n`
	      case 'boolean':
	      case 'undefined':
	        return String(value)
	      case 'object':
	        return '{}'
	    }
	  }
	};
	return inspect;
}

var errors;
var hasRequiredErrors;

function requireErrors () {
	if (hasRequiredErrors) return errors;
	hasRequiredErrors = 1;

	const { format, inspect } = requireInspect();
	const { AggregateError: CustomAggregateError } = requirePrimordials();

	/*
	  This file is a reduced and adapted version of the main lib/internal/errors.js file defined at

	  https://github.com/nodejs/node/blob/main/lib/internal/errors.js

	  Don't try to replace with the original file and keep it up to date (starting from E(...) definitions)
	  with the upstream file.
	*/

	const AggregateError = globalThis.AggregateError || CustomAggregateError;
	const kIsNodeError = Symbol('kIsNodeError');
	const kTypes = [
	  'string',
	  'function',
	  'number',
	  'object',
	  // Accept 'Function' and 'Object' as alternative to the lower cased version.
	  'Function',
	  'Object',
	  'boolean',
	  'bigint',
	  'symbol'
	];
	const classRegExp = /^([A-Z][a-z0-9]*)+$/;
	const nodeInternalPrefix = '__node_internal_';
	const codes = {};
	function assert(value, message) {
	  if (!value) {
	    throw new codes.ERR_INTERNAL_ASSERTION(message)
	  }
	}

	// Only use this for integers! Decimal numbers do not work with this function.
	function addNumericalSeparator(val) {
	  let res = '';
	  let i = val.length;
	  const start = val[0] === '-' ? 1 : 0;
	  for (; i >= start + 4; i -= 3) {
	    res = `_${val.slice(i - 3, i)}${res}`;
	  }
	  return `${val.slice(0, i)}${res}`
	}
	function getMessage(key, msg, args) {
	  if (typeof msg === 'function') {
	    assert(
	      msg.length <= args.length,
	      // Default options do not count.
	      `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${msg.length}).`
	    );
	    return msg(...args)
	  }
	  const expectedLength = (msg.match(/%[dfijoOs]/g) || []).length;
	  assert(
	    expectedLength === args.length,
	    `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${expectedLength}).`
	  );
	  if (args.length === 0) {
	    return msg
	  }
	  return format(msg, ...args)
	}
	function E(code, message, Base) {
	  if (!Base) {
	    Base = Error;
	  }
	  class NodeError extends Base {
	    constructor(...args) {
	      super(getMessage(code, message, args));
	    }
	    toString() {
	      return `${this.name} [${code}]: ${this.message}`
	    }
	  }
	  Object.defineProperties(NodeError.prototype, {
	    name: {
	      value: Base.name,
	      writable: true,
	      enumerable: false,
	      configurable: true
	    },
	    toString: {
	      value() {
	        return `${this.name} [${code}]: ${this.message}`
	      },
	      writable: true,
	      enumerable: false,
	      configurable: true
	    }
	  });
	  NodeError.prototype.code = code;
	  NodeError.prototype[kIsNodeError] = true;
	  codes[code] = NodeError;
	}
	function hideStackFrames(fn) {
	  // We rename the functions that will be hidden to cut off the stacktrace
	  // at the outermost one
	  const hidden = nodeInternalPrefix + fn.name;
	  Object.defineProperty(fn, 'name', {
	    value: hidden
	  });
	  return fn
	}
	function aggregateTwoErrors(innerError, outerError) {
	  if (innerError && outerError && innerError !== outerError) {
	    if (Array.isArray(outerError.errors)) {
	      // If `outerError` is already an `AggregateError`.
	      outerError.errors.push(innerError);
	      return outerError
	    }
	    const err = new AggregateError([outerError, innerError], outerError.message);
	    err.code = outerError.code;
	    return err
	  }
	  return innerError || outerError
	}
	class AbortError extends Error {
	  constructor(message = 'The operation was aborted', options = undefined) {
	    if (options !== undefined && typeof options !== 'object') {
	      throw new codes.ERR_INVALID_ARG_TYPE('options', 'Object', options)
	    }
	    super(message, options);
	    this.code = 'ABORT_ERR';
	    this.name = 'AbortError';
	  }
	}
	E('ERR_ASSERTION', '%s', Error);
	E(
	  'ERR_INVALID_ARG_TYPE',
	  (name, expected, actual) => {
	    assert(typeof name === 'string', "'name' must be a string");
	    if (!Array.isArray(expected)) {
	      expected = [expected];
	    }
	    let msg = 'The ';
	    if (name.endsWith(' argument')) {
	      // For cases like 'first argument'
	      msg += `${name} `;
	    } else {
	      msg += `"${name}" ${name.includes('.') ? 'property' : 'argument'} `;
	    }
	    msg += 'must be ';
	    const types = [];
	    const instances = [];
	    const other = [];
	    for (const value of expected) {
	      assert(typeof value === 'string', 'All expected entries have to be of type string');
	      if (kTypes.includes(value)) {
	        types.push(value.toLowerCase());
	      } else if (classRegExp.test(value)) {
	        instances.push(value);
	      } else {
	        assert(value !== 'object', 'The value "object" should be written as "Object"');
	        other.push(value);
	      }
	    }

	    // Special handle `object` in case other instances are allowed to outline
	    // the differences between each other.
	    if (instances.length > 0) {
	      const pos = types.indexOf('object');
	      if (pos !== -1) {
	        types.splice(types, pos, 1);
	        instances.push('Object');
	      }
	    }
	    if (types.length > 0) {
	      switch (types.length) {
	        case 1:
	          msg += `of type ${types[0]}`;
	          break
	        case 2:
	          msg += `one of type ${types[0]} or ${types[1]}`;
	          break
	        default: {
	          const last = types.pop();
	          msg += `one of type ${types.join(', ')}, or ${last}`;
	        }
	      }
	      if (instances.length > 0 || other.length > 0) {
	        msg += ' or ';
	      }
	    }
	    if (instances.length > 0) {
	      switch (instances.length) {
	        case 1:
	          msg += `an instance of ${instances[0]}`;
	          break
	        case 2:
	          msg += `an instance of ${instances[0]} or ${instances[1]}`;
	          break
	        default: {
	          const last = instances.pop();
	          msg += `an instance of ${instances.join(', ')}, or ${last}`;
	        }
	      }
	      if (other.length > 0) {
	        msg += ' or ';
	      }
	    }
	    switch (other.length) {
	      case 0:
	        break
	      case 1:
	        if (other[0].toLowerCase() !== other[0]) {
	          msg += 'an ';
	        }
	        msg += `${other[0]}`;
	        break
	      case 2:
	        msg += `one of ${other[0]} or ${other[1]}`;
	        break
	      default: {
	        const last = other.pop();
	        msg += `one of ${other.join(', ')}, or ${last}`;
	      }
	    }
	    if (actual == null) {
	      msg += `. Received ${actual}`;
	    } else if (typeof actual === 'function' && actual.name) {
	      msg += `. Received function ${actual.name}`;
	    } else if (typeof actual === 'object') {
	      var _actual$constructor;
	      if (
	        (_actual$constructor = actual.constructor) !== null &&
	        _actual$constructor !== undefined &&
	        _actual$constructor.name
	      ) {
	        msg += `. Received an instance of ${actual.constructor.name}`;
	      } else {
	        const inspected = inspect(actual, {
	          depth: -1
	        });
	        msg += `. Received ${inspected}`;
	      }
	    } else {
	      let inspected = inspect(actual, {
	        colors: false
	      });
	      if (inspected.length > 25) {
	        inspected = `${inspected.slice(0, 25)}...`;
	      }
	      msg += `. Received type ${typeof actual} (${inspected})`;
	    }
	    return msg
	  },
	  TypeError
	);
	E(
	  'ERR_INVALID_ARG_VALUE',
	  (name, value, reason = 'is invalid') => {
	    let inspected = inspect(value);
	    if (inspected.length > 128) {
	      inspected = inspected.slice(0, 128) + '...';
	    }
	    const type = name.includes('.') ? 'property' : 'argument';
	    return `The ${type} '${name}' ${reason}. Received ${inspected}`
	  },
	  TypeError
	);
	E(
	  'ERR_INVALID_RETURN_VALUE',
	  (input, name, value) => {
	    var _value$constructor;
	    const type =
	      value !== null &&
	      value !== undefined &&
	      (_value$constructor = value.constructor) !== null &&
	      _value$constructor !== undefined &&
	      _value$constructor.name
	        ? `instance of ${value.constructor.name}`
	        : `type ${typeof value}`;
	    return `Expected ${input} to be returned from the "${name}"` + ` function but got ${type}.`
	  },
	  TypeError
	);
	E(
	  'ERR_MISSING_ARGS',
	  (...args) => {
	    assert(args.length > 0, 'At least one arg needs to be specified');
	    let msg;
	    const len = args.length;
	    args = (Array.isArray(args) ? args : [args]).map((a) => `"${a}"`).join(' or ');
	    switch (len) {
	      case 1:
	        msg += `The ${args[0]} argument`;
	        break
	      case 2:
	        msg += `The ${args[0]} and ${args[1]} arguments`;
	        break
	      default:
	        {
	          const last = args.pop();
	          msg += `The ${args.join(', ')}, and ${last} arguments`;
	        }
	        break
	    }
	    return `${msg} must be specified`
	  },
	  TypeError
	);
	E(
	  'ERR_OUT_OF_RANGE',
	  (str, range, input) => {
	    assert(range, 'Missing "range" argument');
	    let received;
	    if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
	      received = addNumericalSeparator(String(input));
	    } else if (typeof input === 'bigint') {
	      received = String(input);
	      const limit = BigInt(2) ** BigInt(32);
	      if (input > limit || input < -limit) {
	        received = addNumericalSeparator(received);
	      }
	      received += 'n';
	    } else {
	      received = inspect(input);
	    }
	    return `The value of "${str}" is out of range. It must be ${range}. Received ${received}`
	  },
	  RangeError
	);
	E('ERR_MULTIPLE_CALLBACK', 'Callback called multiple times', Error);
	E('ERR_METHOD_NOT_IMPLEMENTED', 'The %s method is not implemented', Error);
	E('ERR_STREAM_ALREADY_FINISHED', 'Cannot call %s after a stream was finished', Error);
	E('ERR_STREAM_CANNOT_PIPE', 'Cannot pipe, not readable', Error);
	E('ERR_STREAM_DESTROYED', 'Cannot call %s after a stream was destroyed', Error);
	E('ERR_STREAM_NULL_VALUES', 'May not write null values to stream', TypeError);
	E('ERR_STREAM_PREMATURE_CLOSE', 'Premature close', Error);
	E('ERR_STREAM_PUSH_AFTER_EOF', 'stream.push() after EOF', Error);
	E('ERR_STREAM_UNSHIFT_AFTER_END_EVENT', 'stream.unshift() after end event', Error);
	E('ERR_STREAM_WRITE_AFTER_END', 'write after end', Error);
	E('ERR_UNKNOWN_ENCODING', 'Unknown encoding: %s', TypeError);
	errors = {
	  AbortError,
	  aggregateTwoErrors: hideStackFrames(aggregateTwoErrors),
	  hideStackFrames,
	  codes
	};
	return errors;
}

var browser = {exports: {}};

/*globals self, window */

var hasRequiredBrowser$1;

function requireBrowser$1 () {
	if (hasRequiredBrowser$1) return browser.exports;
	hasRequiredBrowser$1 = 1;

	/*eslint-disable @mysticatea/prettier */
	const { AbortController, AbortSignal } =
	    typeof self !== "undefined" ? self :
	    typeof window !== "undefined" ? window :
	    /* otherwise */ undefined;
	/*eslint-enable @mysticatea/prettier */

	browser.exports = AbortController;
	browser.exports.AbortSignal = AbortSignal;
	browser.exports.default = AbortController;
	return browser.exports;
}

var hasRequiredUtil$2;

function requireUtil$2 () {
	if (hasRequiredUtil$2) return util$2.exports;
	hasRequiredUtil$2 = 1;
	(function (module) {

		const bufferModule = require$$0$2;
		const { format, inspect } = requireInspect();
		const {
		  codes: { ERR_INVALID_ARG_TYPE }
		} = requireErrors();
		const { kResistStopPropagation, AggregateError, SymbolDispose } = requirePrimordials();
		const AbortSignal = globalThis.AbortSignal || requireBrowser$1().AbortSignal;
		const AbortController = globalThis.AbortController || requireBrowser$1().AbortController;
		const AsyncFunction = Object.getPrototypeOf(async function () {}).constructor;
		const Blob = globalThis.Blob || bufferModule.Blob;
		/* eslint-disable indent */
		const isBlob =
		  typeof Blob !== 'undefined'
		    ? function isBlob(b) {
		        // eslint-disable-next-line indent
		        return b instanceof Blob
		      }
		    : function isBlob(b) {
		        return false
		      };
		/* eslint-enable indent */

		const validateAbortSignal = (signal, name) => {
		  if (signal !== undefined && (signal === null || typeof signal !== 'object' || !('aborted' in signal))) {
		    throw new ERR_INVALID_ARG_TYPE(name, 'AbortSignal', signal)
		  }
		};
		const validateFunction = (value, name) => {
		  if (typeof value !== 'function') {
		    throw new ERR_INVALID_ARG_TYPE(name, 'Function', value)
		  }
		};
		module.exports = {
		  AggregateError,
		  kEmptyObject: Object.freeze({}),
		  once(callback) {
		    let called = false;
		    return function (...args) {
		      if (called) {
		        return
		      }
		      called = true;
		      callback.apply(this, args);
		    }
		  },
		  createDeferredPromise: function () {
		    let resolve;
		    let reject;

		    // eslint-disable-next-line promise/param-names
		    const promise = new Promise((res, rej) => {
		      resolve = res;
		      reject = rej;
		    });
		    return {
		      promise,
		      resolve,
		      reject
		    }
		  },
		  promisify(fn) {
		    return new Promise((resolve, reject) => {
		      fn((err, ...args) => {
		        if (err) {
		          return reject(err)
		        }
		        return resolve(...args)
		      });
		    })
		  },
		  debuglog() {
		    return function () {}
		  },
		  format,
		  inspect,
		  types: {
		    isAsyncFunction(fn) {
		      return fn instanceof AsyncFunction
		    },
		    isArrayBufferView(arr) {
		      return ArrayBuffer.isView(arr)
		    }
		  },
		  isBlob,
		  deprecate(fn, message) {
		    return fn
		  },
		  addAbortListener:
		    requireEvents().addAbortListener ||
		    function addAbortListener(signal, listener) {
		      if (signal === undefined) {
		        throw new ERR_INVALID_ARG_TYPE('signal', 'AbortSignal', signal)
		      }
		      validateAbortSignal(signal, 'signal');
		      validateFunction(listener, 'listener');
		      let removeEventListener;
		      if (signal.aborted) {
		        queueMicrotask(() => listener());
		      } else {
		        signal.addEventListener('abort', listener, {
		          __proto__: null,
		          once: true,
		          [kResistStopPropagation]: true
		        });
		        removeEventListener = () => {
		          signal.removeEventListener('abort', listener);
		        };
		      }
		      return {
		        __proto__: null,
		        [SymbolDispose]() {
		          var _removeEventListener
		          ;(_removeEventListener = removeEventListener) === null || _removeEventListener === undefined
		            ? undefined
		            : _removeEventListener();
		        }
		      }
		    },
		  AbortSignalAny:
		    AbortSignal.any ||
		    function AbortSignalAny(signals) {
		      // Fast path if there is only one signal.
		      if (signals.length === 1) {
		        return signals[0]
		      }
		      const ac = new AbortController();
		      const abort = () => ac.abort();
		      signals.forEach((signal) => {
		        validateAbortSignal(signal, 'signals');
		        signal.addEventListener('abort', abort, {
		          once: true
		        });
		      });
		      ac.signal.addEventListener(
		        'abort',
		        () => {
		          signals.forEach((signal) => signal.removeEventListener('abort', abort));
		        },
		        {
		          once: true
		        }
		      );
		      return ac.signal
		    }
		};
		module.exports.promisify.custom = Symbol.for('nodejs.util.promisify.custom'); 
	} (util$2));
	return util$2.exports;
}

var operators = {};

/* eslint jsdoc/require-jsdoc: "error" */

var validators;
var hasRequiredValidators;

function requireValidators () {
	if (hasRequiredValidators) return validators;
	hasRequiredValidators = 1;

	const {
	  ArrayIsArray,
	  ArrayPrototypeIncludes,
	  ArrayPrototypeJoin,
	  ArrayPrototypeMap,
	  NumberIsInteger,
	  NumberIsNaN,
	  NumberMAX_SAFE_INTEGER,
	  NumberMIN_SAFE_INTEGER,
	  NumberParseInt,
	  ObjectPrototypeHasOwnProperty,
	  RegExpPrototypeExec,
	  String,
	  StringPrototypeToUpperCase,
	  StringPrototypeTrim
	} = requirePrimordials();
	const {
	  hideStackFrames,
	  codes: { ERR_SOCKET_BAD_PORT, ERR_INVALID_ARG_TYPE, ERR_INVALID_ARG_VALUE, ERR_OUT_OF_RANGE, ERR_UNKNOWN_SIGNAL }
	} = requireErrors();
	const { normalizeEncoding } = requireUtil$2();
	const { isAsyncFunction, isArrayBufferView } = requireUtil$2().types;
	const signals = {};

	/**
	 * @param {*} value
	 * @returns {boolean}
	 */
	function isInt32(value) {
	  return value === (value | 0)
	}

	/**
	 * @param {*} value
	 * @returns {boolean}
	 */
	function isUint32(value) {
	  return value === value >>> 0
	}
	const octalReg = /^[0-7]+$/;
	const modeDesc = 'must be a 32-bit unsigned integer or an octal string';

	/**
	 * Parse and validate values that will be converted into mode_t (the S_*
	 * constants). Only valid numbers and octal strings are allowed. They could be
	 * converted to 32-bit unsigned integers or non-negative signed integers in the
	 * C++ land, but any value higher than 0o777 will result in platform-specific
	 * behaviors.
	 * @param {*} value Values to be validated
	 * @param {string} name Name of the argument
	 * @param {number} [def] If specified, will be returned for invalid values
	 * @returns {number}
	 */
	function parseFileMode(value, name, def) {
	  if (typeof value === 'undefined') {
	    value = def;
	  }
	  if (typeof value === 'string') {
	    if (RegExpPrototypeExec(octalReg, value) === null) {
	      throw new ERR_INVALID_ARG_VALUE(name, value, modeDesc)
	    }
	    value = NumberParseInt(value, 8);
	  }
	  validateUint32(value, name);
	  return value
	}

	/**
	 * @callback validateInteger
	 * @param {*} value
	 * @param {string} name
	 * @param {number} [min]
	 * @param {number} [max]
	 * @returns {asserts value is number}
	 */

	/** @type {validateInteger} */
	const validateInteger = hideStackFrames((value, name, min = NumberMIN_SAFE_INTEGER, max = NumberMAX_SAFE_INTEGER) => {
	  if (typeof value !== 'number') throw new ERR_INVALID_ARG_TYPE(name, 'number', value)
	  if (!NumberIsInteger(value)) throw new ERR_OUT_OF_RANGE(name, 'an integer', value)
	  if (value < min || value > max) throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value)
	});

	/**
	 * @callback validateInt32
	 * @param {*} value
	 * @param {string} name
	 * @param {number} [min]
	 * @param {number} [max]
	 * @returns {asserts value is number}
	 */

	/** @type {validateInt32} */
	const validateInt32 = hideStackFrames((value, name, min = -2147483648, max = 2147483647) => {
	  // The defaults for min and max correspond to the limits of 32-bit integers.
	  if (typeof value !== 'number') {
	    throw new ERR_INVALID_ARG_TYPE(name, 'number', value)
	  }
	  if (!NumberIsInteger(value)) {
	    throw new ERR_OUT_OF_RANGE(name, 'an integer', value)
	  }
	  if (value < min || value > max) {
	    throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value)
	  }
	});

	/**
	 * @callback validateUint32
	 * @param {*} value
	 * @param {string} name
	 * @param {number|boolean} [positive=false]
	 * @returns {asserts value is number}
	 */

	/** @type {validateUint32} */
	const validateUint32 = hideStackFrames((value, name, positive = false) => {
	  if (typeof value !== 'number') {
	    throw new ERR_INVALID_ARG_TYPE(name, 'number', value)
	  }
	  if (!NumberIsInteger(value)) {
	    throw new ERR_OUT_OF_RANGE(name, 'an integer', value)
	  }
	  const min = positive ? 1 : 0;
	  // 2 ** 32 === 4294967296
	  const max = 4294967295;
	  if (value < min || value > max) {
	    throw new ERR_OUT_OF_RANGE(name, `>= ${min} && <= ${max}`, value)
	  }
	});

	/**
	 * @callback validateString
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is string}
	 */

	/** @type {validateString} */
	function validateString(value, name) {
	  if (typeof value !== 'string') throw new ERR_INVALID_ARG_TYPE(name, 'string', value)
	}

	/**
	 * @callback validateNumber
	 * @param {*} value
	 * @param {string} name
	 * @param {number} [min]
	 * @param {number} [max]
	 * @returns {asserts value is number}
	 */

	/** @type {validateNumber} */
	function validateNumber(value, name, min = undefined, max) {
	  if (typeof value !== 'number') throw new ERR_INVALID_ARG_TYPE(name, 'number', value)
	  if (
	    (min != null && value < min) ||
	    (max != null && value > max) ||
	    ((min != null || max != null) && NumberIsNaN(value))
	  ) {
	    throw new ERR_OUT_OF_RANGE(
	      name,
	      `${min != null ? `>= ${min}` : ''}${min != null && max != null ? ' && ' : ''}${max != null ? `<= ${max}` : ''}`,
	      value
	    )
	  }
	}

	/**
	 * @callback validateOneOf
	 * @template T
	 * @param {T} value
	 * @param {string} name
	 * @param {T[]} oneOf
	 */

	/** @type {validateOneOf} */
	const validateOneOf = hideStackFrames((value, name, oneOf) => {
	  if (!ArrayPrototypeIncludes(oneOf, value)) {
	    const allowed = ArrayPrototypeJoin(
	      ArrayPrototypeMap(oneOf, (v) => (typeof v === 'string' ? `'${v}'` : String(v))),
	      ', '
	    );
	    const reason = 'must be one of: ' + allowed;
	    throw new ERR_INVALID_ARG_VALUE(name, value, reason)
	  }
	});

	/**
	 * @callback validateBoolean
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is boolean}
	 */

	/** @type {validateBoolean} */
	function validateBoolean(value, name) {
	  if (typeof value !== 'boolean') throw new ERR_INVALID_ARG_TYPE(name, 'boolean', value)
	}

	/**
	 * @param {any} options
	 * @param {string} key
	 * @param {boolean} defaultValue
	 * @returns {boolean}
	 */
	function getOwnPropertyValueOrDefault(options, key, defaultValue) {
	  return options == null || !ObjectPrototypeHasOwnProperty(options, key) ? defaultValue : options[key]
	}

	/**
	 * @callback validateObject
	 * @param {*} value
	 * @param {string} name
	 * @param {{
	 *   allowArray?: boolean,
	 *   allowFunction?: boolean,
	 *   nullable?: boolean
	 * }} [options]
	 */

	/** @type {validateObject} */
	const validateObject = hideStackFrames((value, name, options = null) => {
	  const allowArray = getOwnPropertyValueOrDefault(options, 'allowArray', false);
	  const allowFunction = getOwnPropertyValueOrDefault(options, 'allowFunction', false);
	  const nullable = getOwnPropertyValueOrDefault(options, 'nullable', false);
	  if (
	    (!nullable && value === null) ||
	    (!allowArray && ArrayIsArray(value)) ||
	    (typeof value !== 'object' && (!allowFunction || typeof value !== 'function'))
	  ) {
	    throw new ERR_INVALID_ARG_TYPE(name, 'Object', value)
	  }
	});

	/**
	 * @callback validateDictionary - We are using the Web IDL Standard definition
	 *                                of "dictionary" here, which means any value
	 *                                whose Type is either Undefined, Null, or
	 *                                Object (which includes functions).
	 * @param {*} value
	 * @param {string} name
	 * @see https://webidl.spec.whatwg.org/#es-dictionary
	 * @see https://tc39.es/ecma262/#table-typeof-operator-results
	 */

	/** @type {validateDictionary} */
	const validateDictionary = hideStackFrames((value, name) => {
	  if (value != null && typeof value !== 'object' && typeof value !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE(name, 'a dictionary', value)
	  }
	});

	/**
	 * @callback validateArray
	 * @param {*} value
	 * @param {string} name
	 * @param {number} [minLength]
	 * @returns {asserts value is any[]}
	 */

	/** @type {validateArray} */
	const validateArray = hideStackFrames((value, name, minLength = 0) => {
	  if (!ArrayIsArray(value)) {
	    throw new ERR_INVALID_ARG_TYPE(name, 'Array', value)
	  }
	  if (value.length < minLength) {
	    const reason = `must be longer than ${minLength}`;
	    throw new ERR_INVALID_ARG_VALUE(name, value, reason)
	  }
	});

	/**
	 * @callback validateStringArray
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is string[]}
	 */

	/** @type {validateStringArray} */
	function validateStringArray(value, name) {
	  validateArray(value, name);
	  for (let i = 0; i < value.length; i++) {
	    validateString(value[i], `${name}[${i}]`);
	  }
	}

	/**
	 * @callback validateBooleanArray
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is boolean[]}
	 */

	/** @type {validateBooleanArray} */
	function validateBooleanArray(value, name) {
	  validateArray(value, name);
	  for (let i = 0; i < value.length; i++) {
	    validateBoolean(value[i], `${name}[${i}]`);
	  }
	}

	/**
	 * @callback validateAbortSignalArray
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is AbortSignal[]}
	 */

	/** @type {validateAbortSignalArray} */
	function validateAbortSignalArray(value, name) {
	  validateArray(value, name);
	  for (let i = 0; i < value.length; i++) {
	    const signal = value[i];
	    const indexedName = `${name}[${i}]`;
	    if (signal == null) {
	      throw new ERR_INVALID_ARG_TYPE(indexedName, 'AbortSignal', signal)
	    }
	    validateAbortSignal(signal, indexedName);
	  }
	}

	/**
	 * @param {*} signal
	 * @param {string} [name='signal']
	 * @returns {asserts signal is keyof signals}
	 */
	function validateSignalName(signal, name = 'signal') {
	  validateString(signal, name);
	  if (signals[signal] === undefined) {
	    if (signals[StringPrototypeToUpperCase(signal)] !== undefined) {
	      throw new ERR_UNKNOWN_SIGNAL(signal + ' (signals must use all capital letters)')
	    }
	    throw new ERR_UNKNOWN_SIGNAL(signal)
	  }
	}

	/**
	 * @callback validateBuffer
	 * @param {*} buffer
	 * @param {string} [name='buffer']
	 * @returns {asserts buffer is ArrayBufferView}
	 */

	/** @type {validateBuffer} */
	const validateBuffer = hideStackFrames((buffer, name = 'buffer') => {
	  if (!isArrayBufferView(buffer)) {
	    throw new ERR_INVALID_ARG_TYPE(name, ['Buffer', 'TypedArray', 'DataView'], buffer)
	  }
	});

	/**
	 * @param {string} data
	 * @param {string} encoding
	 */
	function validateEncoding(data, encoding) {
	  const normalizedEncoding = normalizeEncoding(encoding);
	  const length = data.length;
	  if (normalizedEncoding === 'hex' && length % 2 !== 0) {
	    throw new ERR_INVALID_ARG_VALUE('encoding', encoding, `is invalid for data of length ${length}`)
	  }
	}

	/**
	 * Check that the port number is not NaN when coerced to a number,
	 * is an integer and that it falls within the legal range of port numbers.
	 * @param {*} port
	 * @param {string} [name='Port']
	 * @param {boolean} [allowZero=true]
	 * @returns {number}
	 */
	function validatePort(port, name = 'Port', allowZero = true) {
	  if (
	    (typeof port !== 'number' && typeof port !== 'string') ||
	    (typeof port === 'string' && StringPrototypeTrim(port).length === 0) ||
	    +port !== +port >>> 0 ||
	    port > 0xffff ||
	    (port === 0 && !allowZero)
	  ) {
	    throw new ERR_SOCKET_BAD_PORT(name, port, allowZero)
	  }
	  return port | 0
	}

	/**
	 * @callback validateAbortSignal
	 * @param {*} signal
	 * @param {string} name
	 */

	/** @type {validateAbortSignal} */
	const validateAbortSignal = hideStackFrames((signal, name) => {
	  if (signal !== undefined && (signal === null || typeof signal !== 'object' || !('aborted' in signal))) {
	    throw new ERR_INVALID_ARG_TYPE(name, 'AbortSignal', signal)
	  }
	});

	/**
	 * @callback validateFunction
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is Function}
	 */

	/** @type {validateFunction} */
	const validateFunction = hideStackFrames((value, name) => {
	  if (typeof value !== 'function') throw new ERR_INVALID_ARG_TYPE(name, 'Function', value)
	});

	/**
	 * @callback validatePlainFunction
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is Function}
	 */

	/** @type {validatePlainFunction} */
	const validatePlainFunction = hideStackFrames((value, name) => {
	  if (typeof value !== 'function' || isAsyncFunction(value)) throw new ERR_INVALID_ARG_TYPE(name, 'Function', value)
	});

	/**
	 * @callback validateUndefined
	 * @param {*} value
	 * @param {string} name
	 * @returns {asserts value is undefined}
	 */

	/** @type {validateUndefined} */
	const validateUndefined = hideStackFrames((value, name) => {
	  if (value !== undefined) throw new ERR_INVALID_ARG_TYPE(name, 'undefined', value)
	});

	/**
	 * @template T
	 * @param {T} value
	 * @param {string} name
	 * @param {T[]} union
	 */
	function validateUnion(value, name, union) {
	  if (!ArrayPrototypeIncludes(union, value)) {
	    throw new ERR_INVALID_ARG_TYPE(name, `('${ArrayPrototypeJoin(union, '|')}')`, value)
	  }
	}

	/*
	  The rules for the Link header field are described here:
	  https://www.rfc-editor.org/rfc/rfc8288.html#section-3

	  This regex validates any string surrounded by angle brackets
	  (not necessarily a valid URI reference) followed by zero or more
	  link-params separated by semicolons.
	*/
	const linkValueRegExp = /^(?:<[^>]*>)(?:\s*;\s*[^;"\s]+(?:=(")?[^;"\s]*\1)?)*$/;

	/**
	 * @param {any} value
	 * @param {string} name
	 */
	function validateLinkHeaderFormat(value, name) {
	  if (typeof value === 'undefined' || !RegExpPrototypeExec(linkValueRegExp, value)) {
	    throw new ERR_INVALID_ARG_VALUE(
	      name,
	      value,
	      'must be an array or string of format "</styles.css>; rel=preload; as=style"'
	    )
	  }
	}

	/**
	 * @param {any} hints
	 * @return {string}
	 */
	function validateLinkHeaderValue(hints) {
	  if (typeof hints === 'string') {
	    validateLinkHeaderFormat(hints, 'hints');
	    return hints
	  } else if (ArrayIsArray(hints)) {
	    const hintsLength = hints.length;
	    let result = '';
	    if (hintsLength === 0) {
	      return result
	    }
	    for (let i = 0; i < hintsLength; i++) {
	      const link = hints[i];
	      validateLinkHeaderFormat(link, 'hints');
	      result += link;
	      if (i !== hintsLength - 1) {
	        result += ', ';
	      }
	    }
	    return result
	  }
	  throw new ERR_INVALID_ARG_VALUE(
	    'hints',
	    hints,
	    'must be an array or string of format "</styles.css>; rel=preload; as=style"'
	  )
	}
	validators = {
	  isInt32,
	  isUint32,
	  parseFileMode,
	  validateArray,
	  validateStringArray,
	  validateBooleanArray,
	  validateAbortSignalArray,
	  validateBoolean,
	  validateBuffer,
	  validateDictionary,
	  validateEncoding,
	  validateFunction,
	  validateInt32,
	  validateInteger,
	  validateNumber,
	  validateObject,
	  validateOneOf,
	  validatePlainFunction,
	  validatePort,
	  validateSignalName,
	  validateString,
	  validateUint32,
	  validateUndefined,
	  validateUnion,
	  validateAbortSignal,
	  validateLinkHeaderValue
	};
	return validators;
}

var endOfStream = {exports: {}};

var utils$1;
var hasRequiredUtils$1;

function requireUtils$1 () {
	if (hasRequiredUtils$1) return utils$1;
	hasRequiredUtils$1 = 1;

	const { SymbolAsyncIterator, SymbolIterator, SymbolFor } = requirePrimordials();

	// We need to use SymbolFor to make these globally available
	// for interopt with readable-stream, i.e. readable-stream
	// and node core needs to be able to read/write private state
	// from each other for proper interoperability.
	const kIsDestroyed = SymbolFor('nodejs.stream.destroyed');
	const kIsErrored = SymbolFor('nodejs.stream.errored');
	const kIsReadable = SymbolFor('nodejs.stream.readable');
	const kIsWritable = SymbolFor('nodejs.stream.writable');
	const kIsDisturbed = SymbolFor('nodejs.stream.disturbed');
	const kIsClosedPromise = SymbolFor('nodejs.webstream.isClosedPromise');
	const kControllerErrorFunction = SymbolFor('nodejs.webstream.controllerErrorFunction');
	function isReadableNodeStream(obj, strict = false) {
	  var _obj$_readableState;
	  return !!(
	    (
	      obj &&
	      typeof obj.pipe === 'function' &&
	      typeof obj.on === 'function' &&
	      (!strict || (typeof obj.pause === 'function' && typeof obj.resume === 'function')) &&
	      (!obj._writableState ||
	        ((_obj$_readableState = obj._readableState) === null || _obj$_readableState === undefined
	          ? undefined
	          : _obj$_readableState.readable) !== false) &&
	      // Duplex
	      (!obj._writableState || obj._readableState)
	    ) // Writable has .pipe.
	  )
	}
	function isWritableNodeStream(obj) {
	  var _obj$_writableState;
	  return !!(
	    (
	      obj &&
	      typeof obj.write === 'function' &&
	      typeof obj.on === 'function' &&
	      (!obj._readableState ||
	        ((_obj$_writableState = obj._writableState) === null || _obj$_writableState === undefined
	          ? undefined
	          : _obj$_writableState.writable) !== false)
	    ) // Duplex
	  )
	}
	function isDuplexNodeStream(obj) {
	  return !!(
	    obj &&
	    typeof obj.pipe === 'function' &&
	    obj._readableState &&
	    typeof obj.on === 'function' &&
	    typeof obj.write === 'function'
	  )
	}
	function isNodeStream(obj) {
	  return (
	    obj &&
	    (obj._readableState ||
	      obj._writableState ||
	      (typeof obj.write === 'function' && typeof obj.on === 'function') ||
	      (typeof obj.pipe === 'function' && typeof obj.on === 'function'))
	  )
	}
	function isReadableStream(obj) {
	  return !!(
	    obj &&
	    !isNodeStream(obj) &&
	    typeof obj.pipeThrough === 'function' &&
	    typeof obj.getReader === 'function' &&
	    typeof obj.cancel === 'function'
	  )
	}
	function isWritableStream(obj) {
	  return !!(obj && !isNodeStream(obj) && typeof obj.getWriter === 'function' && typeof obj.abort === 'function')
	}
	function isTransformStream(obj) {
	  return !!(obj && !isNodeStream(obj) && typeof obj.readable === 'object' && typeof obj.writable === 'object')
	}
	function isWebStream(obj) {
	  return isReadableStream(obj) || isWritableStream(obj) || isTransformStream(obj)
	}
	function isIterable(obj, isAsync) {
	  if (obj == null) return false
	  if (isAsync === true) return typeof obj[SymbolAsyncIterator] === 'function'
	  if (isAsync === false) return typeof obj[SymbolIterator] === 'function'
	  return typeof obj[SymbolAsyncIterator] === 'function' || typeof obj[SymbolIterator] === 'function'
	}
	function isDestroyed(stream) {
	  if (!isNodeStream(stream)) return null
	  const wState = stream._writableState;
	  const rState = stream._readableState;
	  const state = wState || rState;
	  return !!(stream.destroyed || stream[kIsDestroyed] || (state !== null && state !== undefined && state.destroyed))
	}

	// Have been end():d.
	function isWritableEnded(stream) {
	  if (!isWritableNodeStream(stream)) return null
	  if (stream.writableEnded === true) return true
	  const wState = stream._writableState;
	  if (wState !== null && wState !== undefined && wState.errored) return false
	  if (typeof (wState === null || wState === undefined ? undefined : wState.ended) !== 'boolean') return null
	  return wState.ended
	}

	// Have emitted 'finish'.
	function isWritableFinished(stream, strict) {
	  if (!isWritableNodeStream(stream)) return null
	  if (stream.writableFinished === true) return true
	  const wState = stream._writableState;
	  if (wState !== null && wState !== undefined && wState.errored) return false
	  if (typeof (wState === null || wState === undefined ? undefined : wState.finished) !== 'boolean') return null
	  return !!(wState.finished || (strict === false && wState.ended === true && wState.length === 0))
	}

	// Have been push(null):d.
	function isReadableEnded(stream) {
	  if (!isReadableNodeStream(stream)) return null
	  if (stream.readableEnded === true) return true
	  const rState = stream._readableState;
	  if (!rState || rState.errored) return false
	  if (typeof (rState === null || rState === undefined ? undefined : rState.ended) !== 'boolean') return null
	  return rState.ended
	}

	// Have emitted 'end'.
	function isReadableFinished(stream, strict) {
	  if (!isReadableNodeStream(stream)) return null
	  const rState = stream._readableState;
	  if (rState !== null && rState !== undefined && rState.errored) return false
	  if (typeof (rState === null || rState === undefined ? undefined : rState.endEmitted) !== 'boolean') return null
	  return !!(rState.endEmitted || (strict === false && rState.ended === true && rState.length === 0))
	}
	function isReadable(stream) {
	  if (stream && stream[kIsReadable] != null) return stream[kIsReadable]
	  if (typeof (stream === null || stream === undefined ? undefined : stream.readable) !== 'boolean') return null
	  if (isDestroyed(stream)) return false
	  return isReadableNodeStream(stream) && stream.readable && !isReadableFinished(stream)
	}
	function isWritable(stream) {
	  if (stream && stream[kIsWritable] != null) return stream[kIsWritable]
	  if (typeof (stream === null || stream === undefined ? undefined : stream.writable) !== 'boolean') return null
	  if (isDestroyed(stream)) return false
	  return isWritableNodeStream(stream) && stream.writable && !isWritableEnded(stream)
	}
	function isFinished(stream, opts) {
	  if (!isNodeStream(stream)) {
	    return null
	  }
	  if (isDestroyed(stream)) {
	    return true
	  }
	  if ((opts === null || opts === undefined ? undefined : opts.readable) !== false && isReadable(stream)) {
	    return false
	  }
	  if ((opts === null || opts === undefined ? undefined : opts.writable) !== false && isWritable(stream)) {
	    return false
	  }
	  return true
	}
	function isWritableErrored(stream) {
	  var _stream$_writableStat, _stream$_writableStat2;
	  if (!isNodeStream(stream)) {
	    return null
	  }
	  if (stream.writableErrored) {
	    return stream.writableErrored
	  }
	  return (_stream$_writableStat =
	    (_stream$_writableStat2 = stream._writableState) === null || _stream$_writableStat2 === undefined
	      ? undefined
	      : _stream$_writableStat2.errored) !== null && _stream$_writableStat !== undefined
	    ? _stream$_writableStat
	    : null
	}
	function isReadableErrored(stream) {
	  var _stream$_readableStat, _stream$_readableStat2;
	  if (!isNodeStream(stream)) {
	    return null
	  }
	  if (stream.readableErrored) {
	    return stream.readableErrored
	  }
	  return (_stream$_readableStat =
	    (_stream$_readableStat2 = stream._readableState) === null || _stream$_readableStat2 === undefined
	      ? undefined
	      : _stream$_readableStat2.errored) !== null && _stream$_readableStat !== undefined
	    ? _stream$_readableStat
	    : null
	}
	function isClosed(stream) {
	  if (!isNodeStream(stream)) {
	    return null
	  }
	  if (typeof stream.closed === 'boolean') {
	    return stream.closed
	  }
	  const wState = stream._writableState;
	  const rState = stream._readableState;
	  if (
	    typeof (wState === null || wState === undefined ? undefined : wState.closed) === 'boolean' ||
	    typeof (rState === null || rState === undefined ? undefined : rState.closed) === 'boolean'
	  ) {
	    return (
	      (wState === null || wState === undefined ? undefined : wState.closed) ||
	      (rState === null || rState === undefined ? undefined : rState.closed)
	    )
	  }
	  if (typeof stream._closed === 'boolean' && isOutgoingMessage(stream)) {
	    return stream._closed
	  }
	  return null
	}
	function isOutgoingMessage(stream) {
	  return (
	    typeof stream._closed === 'boolean' &&
	    typeof stream._defaultKeepAlive === 'boolean' &&
	    typeof stream._removedConnection === 'boolean' &&
	    typeof stream._removedContLen === 'boolean'
	  )
	}
	function isServerResponse(stream) {
	  return typeof stream._sent100 === 'boolean' && isOutgoingMessage(stream)
	}
	function isServerRequest(stream) {
	  var _stream$req;
	  return (
	    typeof stream._consuming === 'boolean' &&
	    typeof stream._dumped === 'boolean' &&
	    ((_stream$req = stream.req) === null || _stream$req === undefined ? undefined : _stream$req.upgradeOrConnect) ===
	      undefined
	  )
	}
	function willEmitClose(stream) {
	  if (!isNodeStream(stream)) return null
	  const wState = stream._writableState;
	  const rState = stream._readableState;
	  const state = wState || rState;
	  return (
	    (!state && isServerResponse(stream)) || !!(state && state.autoDestroy && state.emitClose && state.closed === false)
	  )
	}
	function isDisturbed(stream) {
	  var _stream$kIsDisturbed;
	  return !!(
	    stream &&
	    ((_stream$kIsDisturbed = stream[kIsDisturbed]) !== null && _stream$kIsDisturbed !== undefined
	      ? _stream$kIsDisturbed
	      : stream.readableDidRead || stream.readableAborted)
	  )
	}
	function isErrored(stream) {
	  var _ref,
	    _ref2,
	    _ref3,
	    _ref4,
	    _ref5,
	    _stream$kIsErrored,
	    _stream$_readableStat3,
	    _stream$_writableStat3,
	    _stream$_readableStat4,
	    _stream$_writableStat4;
	  return !!(
	    stream &&
	    ((_ref =
	      (_ref2 =
	        (_ref3 =
	          (_ref4 =
	            (_ref5 =
	              (_stream$kIsErrored = stream[kIsErrored]) !== null && _stream$kIsErrored !== undefined
	                ? _stream$kIsErrored
	                : stream.readableErrored) !== null && _ref5 !== undefined
	              ? _ref5
	              : stream.writableErrored) !== null && _ref4 !== undefined
	            ? _ref4
	            : (_stream$_readableStat3 = stream._readableState) === null || _stream$_readableStat3 === undefined
	            ? undefined
	            : _stream$_readableStat3.errorEmitted) !== null && _ref3 !== undefined
	          ? _ref3
	          : (_stream$_writableStat3 = stream._writableState) === null || _stream$_writableStat3 === undefined
	          ? undefined
	          : _stream$_writableStat3.errorEmitted) !== null && _ref2 !== undefined
	        ? _ref2
	        : (_stream$_readableStat4 = stream._readableState) === null || _stream$_readableStat4 === undefined
	        ? undefined
	        : _stream$_readableStat4.errored) !== null && _ref !== undefined
	      ? _ref
	      : (_stream$_writableStat4 = stream._writableState) === null || _stream$_writableStat4 === undefined
	      ? undefined
	      : _stream$_writableStat4.errored)
	  )
	}
	utils$1 = {
	  isDestroyed,
	  kIsDestroyed,
	  isDisturbed,
	  kIsDisturbed,
	  isErrored,
	  kIsErrored,
	  isReadable,
	  kIsReadable,
	  kIsClosedPromise,
	  kControllerErrorFunction,
	  kIsWritable,
	  isClosed,
	  isDuplexNodeStream,
	  isFinished,
	  isIterable,
	  isReadableNodeStream,
	  isReadableStream,
	  isReadableEnded,
	  isReadableFinished,
	  isReadableErrored,
	  isNodeStream,
	  isWebStream,
	  isWritable,
	  isWritableNodeStream,
	  isWritableStream,
	  isWritableEnded,
	  isWritableFinished,
	  isWritableErrored,
	  isServerRequest,
	  isServerResponse,
	  willEmitClose,
	  isTransformStream
	};
	return utils$1;
}

var hasRequiredEndOfStream;

function requireEndOfStream () {
	if (hasRequiredEndOfStream) return endOfStream.exports;
	hasRequiredEndOfStream = 1;

	/* replacement start */

	const process = requireBrowser$2();

	/* replacement end */

	const { AbortError, codes } = requireErrors();
	const { ERR_INVALID_ARG_TYPE, ERR_STREAM_PREMATURE_CLOSE } = codes;
	const { kEmptyObject, once } = requireUtil$2();
	const { validateAbortSignal, validateFunction, validateObject, validateBoolean } = requireValidators();
	const { Promise, PromisePrototypeThen, SymbolDispose } = requirePrimordials();
	const {
	  isClosed,
	  isReadable,
	  isReadableNodeStream,
	  isReadableStream,
	  isReadableFinished,
	  isReadableErrored,
	  isWritable,
	  isWritableNodeStream,
	  isWritableStream,
	  isWritableFinished,
	  isWritableErrored,
	  isNodeStream,
	  willEmitClose: _willEmitClose,
	  kIsClosedPromise
	} = requireUtils$1();
	let addAbortListener;
	function isRequest(stream) {
	  return stream.setHeader && typeof stream.abort === 'function'
	}
	const nop = () => {};
	function eos(stream, options, callback) {
	  var _options$readable, _options$writable;
	  if (arguments.length === 2) {
	    callback = options;
	    options = kEmptyObject;
	  } else if (options == null) {
	    options = kEmptyObject;
	  } else {
	    validateObject(options, 'options');
	  }
	  validateFunction(callback, 'callback');
	  validateAbortSignal(options.signal, 'options.signal');
	  callback = once(callback);
	  if (isReadableStream(stream) || isWritableStream(stream)) {
	    return eosWeb(stream, options, callback)
	  }
	  if (!isNodeStream(stream)) {
	    throw new ERR_INVALID_ARG_TYPE('stream', ['ReadableStream', 'WritableStream', 'Stream'], stream)
	  }
	  const readable =
	    (_options$readable = options.readable) !== null && _options$readable !== undefined
	      ? _options$readable
	      : isReadableNodeStream(stream);
	  const writable =
	    (_options$writable = options.writable) !== null && _options$writable !== undefined
	      ? _options$writable
	      : isWritableNodeStream(stream);
	  const wState = stream._writableState;
	  const rState = stream._readableState;
	  const onlegacyfinish = () => {
	    if (!stream.writable) {
	      onfinish();
	    }
	  };

	  // TODO (ronag): Improve soft detection to include core modules and
	  // common ecosystem modules that do properly emit 'close' but fail
	  // this generic check.
	  let willEmitClose =
	    _willEmitClose(stream) && isReadableNodeStream(stream) === readable && isWritableNodeStream(stream) === writable;
	  let writableFinished = isWritableFinished(stream, false);
	  const onfinish = () => {
	    writableFinished = true;
	    // Stream should not be destroyed here. If it is that
	    // means that user space is doing something differently and
	    // we cannot trust willEmitClose.
	    if (stream.destroyed) {
	      willEmitClose = false;
	    }
	    if (willEmitClose && (!stream.readable || readable)) {
	      return
	    }
	    if (!readable || readableFinished) {
	      callback.call(stream);
	    }
	  };
	  let readableFinished = isReadableFinished(stream, false);
	  const onend = () => {
	    readableFinished = true;
	    // Stream should not be destroyed here. If it is that
	    // means that user space is doing something differently and
	    // we cannot trust willEmitClose.
	    if (stream.destroyed) {
	      willEmitClose = false;
	    }
	    if (willEmitClose && (!stream.writable || writable)) {
	      return
	    }
	    if (!writable || writableFinished) {
	      callback.call(stream);
	    }
	  };
	  const onerror = (err) => {
	    callback.call(stream, err);
	  };
	  let closed = isClosed(stream);
	  const onclose = () => {
	    closed = true;
	    const errored = isWritableErrored(stream) || isReadableErrored(stream);
	    if (errored && typeof errored !== 'boolean') {
	      return callback.call(stream, errored)
	    }
	    if (readable && !readableFinished && isReadableNodeStream(stream, true)) {
	      if (!isReadableFinished(stream, false)) return callback.call(stream, new ERR_STREAM_PREMATURE_CLOSE())
	    }
	    if (writable && !writableFinished) {
	      if (!isWritableFinished(stream, false)) return callback.call(stream, new ERR_STREAM_PREMATURE_CLOSE())
	    }
	    callback.call(stream);
	  };
	  const onclosed = () => {
	    closed = true;
	    const errored = isWritableErrored(stream) || isReadableErrored(stream);
	    if (errored && typeof errored !== 'boolean') {
	      return callback.call(stream, errored)
	    }
	    callback.call(stream);
	  };
	  const onrequest = () => {
	    stream.req.on('finish', onfinish);
	  };
	  if (isRequest(stream)) {
	    stream.on('complete', onfinish);
	    if (!willEmitClose) {
	      stream.on('abort', onclose);
	    }
	    if (stream.req) {
	      onrequest();
	    } else {
	      stream.on('request', onrequest);
	    }
	  } else if (writable && !wState) {
	    // legacy streams
	    stream.on('end', onlegacyfinish);
	    stream.on('close', onlegacyfinish);
	  }

	  // Not all streams will emit 'close' after 'aborted'.
	  if (!willEmitClose && typeof stream.aborted === 'boolean') {
	    stream.on('aborted', onclose);
	  }
	  stream.on('end', onend);
	  stream.on('finish', onfinish);
	  if (options.error !== false) {
	    stream.on('error', onerror);
	  }
	  stream.on('close', onclose);
	  if (closed) {
	    process.nextTick(onclose);
	  } else if (
	    (wState !== null && wState !== undefined && wState.errorEmitted) ||
	    (rState !== null && rState !== undefined && rState.errorEmitted)
	  ) {
	    if (!willEmitClose) {
	      process.nextTick(onclosed);
	    }
	  } else if (
	    !readable &&
	    (!willEmitClose || isReadable(stream)) &&
	    (writableFinished || isWritable(stream) === false)
	  ) {
	    process.nextTick(onclosed);
	  } else if (
	    !writable &&
	    (!willEmitClose || isWritable(stream)) &&
	    (readableFinished || isReadable(stream) === false)
	  ) {
	    process.nextTick(onclosed);
	  } else if (rState && stream.req && stream.aborted) {
	    process.nextTick(onclosed);
	  }
	  const cleanup = () => {
	    callback = nop;
	    stream.removeListener('aborted', onclose);
	    stream.removeListener('complete', onfinish);
	    stream.removeListener('abort', onclose);
	    stream.removeListener('request', onrequest);
	    if (stream.req) stream.req.removeListener('finish', onfinish);
	    stream.removeListener('end', onlegacyfinish);
	    stream.removeListener('close', onlegacyfinish);
	    stream.removeListener('finish', onfinish);
	    stream.removeListener('end', onend);
	    stream.removeListener('error', onerror);
	    stream.removeListener('close', onclose);
	  };
	  if (options.signal && !closed) {
	    const abort = () => {
	      // Keep it because cleanup removes it.
	      const endCallback = callback;
	      cleanup();
	      endCallback.call(
	        stream,
	        new AbortError(undefined, {
	          cause: options.signal.reason
	        })
	      );
	    };
	    if (options.signal.aborted) {
	      process.nextTick(abort);
	    } else {
	      addAbortListener = addAbortListener || requireUtil$2().addAbortListener;
	      const disposable = addAbortListener(options.signal, abort);
	      const originalCallback = callback;
	      callback = once((...args) => {
	        disposable[SymbolDispose]();
	        originalCallback.apply(stream, args);
	      });
	    }
	  }
	  return cleanup
	}
	function eosWeb(stream, options, callback) {
	  let isAborted = false;
	  let abort = nop;
	  if (options.signal) {
	    abort = () => {
	      isAborted = true;
	      callback.call(
	        stream,
	        new AbortError(undefined, {
	          cause: options.signal.reason
	        })
	      );
	    };
	    if (options.signal.aborted) {
	      process.nextTick(abort);
	    } else {
	      addAbortListener = addAbortListener || requireUtil$2().addAbortListener;
	      const disposable = addAbortListener(options.signal, abort);
	      const originalCallback = callback;
	      callback = once((...args) => {
	        disposable[SymbolDispose]();
	        originalCallback.apply(stream, args);
	      });
	    }
	  }
	  const resolverFn = (...args) => {
	    if (!isAborted) {
	      process.nextTick(() => callback.apply(stream, args));
	    }
	  };
	  PromisePrototypeThen(stream[kIsClosedPromise].promise, resolverFn, resolverFn);
	  return nop
	}
	function finished(stream, opts) {
	  var _opts;
	  let autoCleanup = false;
	  if (opts === null) {
	    opts = kEmptyObject;
	  }
	  if ((_opts = opts) !== null && _opts !== undefined && _opts.cleanup) {
	    validateBoolean(opts.cleanup, 'cleanup');
	    autoCleanup = opts.cleanup;
	  }
	  return new Promise((resolve, reject) => {
	    const cleanup = eos(stream, opts, (err) => {
	      if (autoCleanup) {
	        cleanup();
	      }
	      if (err) {
	        reject(err);
	      } else {
	        resolve();
	      }
	    });
	  })
	}
	endOfStream.exports = eos;
	endOfStream.exports.finished = finished;
	return endOfStream.exports;
}

var destroy_1;
var hasRequiredDestroy;

function requireDestroy () {
	if (hasRequiredDestroy) return destroy_1;
	hasRequiredDestroy = 1;

	/* replacement start */

	const process = requireBrowser$2();

	/* replacement end */

	const {
	  aggregateTwoErrors,
	  codes: { ERR_MULTIPLE_CALLBACK },
	  AbortError
	} = requireErrors();
	const { Symbol } = requirePrimordials();
	const { kIsDestroyed, isDestroyed, isFinished, isServerRequest } = requireUtils$1();
	const kDestroy = Symbol('kDestroy');
	const kConstruct = Symbol('kConstruct');
	function checkError(err, w, r) {
	  if (err) {
	    // Avoid V8 leak, https://github.com/nodejs/node/pull/34103#issuecomment-652002364
	    err.stack; // eslint-disable-line no-unused-expressions

	    if (w && !w.errored) {
	      w.errored = err;
	    }
	    if (r && !r.errored) {
	      r.errored = err;
	    }
	  }
	}

	// Backwards compat. cb() is undocumented and unused in core but
	// unfortunately might be used by modules.
	function destroy(err, cb) {
	  const r = this._readableState;
	  const w = this._writableState;
	  // With duplex streams we use the writable side for state.
	  const s = w || r;
	  if ((w !== null && w !== undefined && w.destroyed) || (r !== null && r !== undefined && r.destroyed)) {
	    if (typeof cb === 'function') {
	      cb();
	    }
	    return this
	  }

	  // We set destroyed to true before firing error callbacks in order
	  // to make it re-entrance safe in case destroy() is called within callbacks
	  checkError(err, w, r);
	  if (w) {
	    w.destroyed = true;
	  }
	  if (r) {
	    r.destroyed = true;
	  }

	  // If still constructing then defer calling _destroy.
	  if (!s.constructed) {
	    this.once(kDestroy, function (er) {
	      _destroy(this, aggregateTwoErrors(er, err), cb);
	    });
	  } else {
	    _destroy(this, err, cb);
	  }
	  return this
	}
	function _destroy(self, err, cb) {
	  let called = false;
	  function onDestroy(err) {
	    if (called) {
	      return
	    }
	    called = true;
	    const r = self._readableState;
	    const w = self._writableState;
	    checkError(err, w, r);
	    if (w) {
	      w.closed = true;
	    }
	    if (r) {
	      r.closed = true;
	    }
	    if (typeof cb === 'function') {
	      cb(err);
	    }
	    if (err) {
	      process.nextTick(emitErrorCloseNT, self, err);
	    } else {
	      process.nextTick(emitCloseNT, self);
	    }
	  }
	  try {
	    self._destroy(err || null, onDestroy);
	  } catch (err) {
	    onDestroy(err);
	  }
	}
	function emitErrorCloseNT(self, err) {
	  emitErrorNT(self, err);
	  emitCloseNT(self);
	}
	function emitCloseNT(self) {
	  const r = self._readableState;
	  const w = self._writableState;
	  if (w) {
	    w.closeEmitted = true;
	  }
	  if (r) {
	    r.closeEmitted = true;
	  }
	  if ((w !== null && w !== undefined && w.emitClose) || (r !== null && r !== undefined && r.emitClose)) {
	    self.emit('close');
	  }
	}
	function emitErrorNT(self, err) {
	  const r = self._readableState;
	  const w = self._writableState;
	  if ((w !== null && w !== undefined && w.errorEmitted) || (r !== null && r !== undefined && r.errorEmitted)) {
	    return
	  }
	  if (w) {
	    w.errorEmitted = true;
	  }
	  if (r) {
	    r.errorEmitted = true;
	  }
	  self.emit('error', err);
	}
	function undestroy() {
	  const r = this._readableState;
	  const w = this._writableState;
	  if (r) {
	    r.constructed = true;
	    r.closed = false;
	    r.closeEmitted = false;
	    r.destroyed = false;
	    r.errored = null;
	    r.errorEmitted = false;
	    r.reading = false;
	    r.ended = r.readable === false;
	    r.endEmitted = r.readable === false;
	  }
	  if (w) {
	    w.constructed = true;
	    w.destroyed = false;
	    w.closed = false;
	    w.closeEmitted = false;
	    w.errored = null;
	    w.errorEmitted = false;
	    w.finalCalled = false;
	    w.prefinished = false;
	    w.ended = w.writable === false;
	    w.ending = w.writable === false;
	    w.finished = w.writable === false;
	  }
	}
	function errorOrDestroy(stream, err, sync) {
	  // We have tests that rely on errors being emitted
	  // in the same tick, so changing this is semver major.
	  // For now when you opt-in to autoDestroy we allow
	  // the error to be emitted nextTick. In a future
	  // semver major update we should change the default to this.

	  const r = stream._readableState;
	  const w = stream._writableState;
	  if ((w !== null && w !== undefined && w.destroyed) || (r !== null && r !== undefined && r.destroyed)) {
	    return this
	  }
	  if ((r !== null && r !== undefined && r.autoDestroy) || (w !== null && w !== undefined && w.autoDestroy))
	    stream.destroy(err);
	  else if (err) {
	    // Avoid V8 leak, https://github.com/nodejs/node/pull/34103#issuecomment-652002364
	    err.stack; // eslint-disable-line no-unused-expressions

	    if (w && !w.errored) {
	      w.errored = err;
	    }
	    if (r && !r.errored) {
	      r.errored = err;
	    }
	    if (sync) {
	      process.nextTick(emitErrorNT, stream, err);
	    } else {
	      emitErrorNT(stream, err);
	    }
	  }
	}
	function construct(stream, cb) {
	  if (typeof stream._construct !== 'function') {
	    return
	  }
	  const r = stream._readableState;
	  const w = stream._writableState;
	  if (r) {
	    r.constructed = false;
	  }
	  if (w) {
	    w.constructed = false;
	  }
	  stream.once(kConstruct, cb);
	  if (stream.listenerCount(kConstruct) > 1) {
	    // Duplex
	    return
	  }
	  process.nextTick(constructNT, stream);
	}
	function constructNT(stream) {
	  let called = false;
	  function onConstruct(err) {
	    if (called) {
	      errorOrDestroy(stream, err !== null && err !== undefined ? err : new ERR_MULTIPLE_CALLBACK());
	      return
	    }
	    called = true;
	    const r = stream._readableState;
	    const w = stream._writableState;
	    const s = w || r;
	    if (r) {
	      r.constructed = true;
	    }
	    if (w) {
	      w.constructed = true;
	    }
	    if (s.destroyed) {
	      stream.emit(kDestroy, err);
	    } else if (err) {
	      errorOrDestroy(stream, err, true);
	    } else {
	      process.nextTick(emitConstructNT, stream);
	    }
	  }
	  try {
	    stream._construct((err) => {
	      process.nextTick(onConstruct, err);
	    });
	  } catch (err) {
	    process.nextTick(onConstruct, err);
	  }
	}
	function emitConstructNT(stream) {
	  stream.emit(kConstruct);
	}
	function isRequest(stream) {
	  return (stream === null || stream === undefined ? undefined : stream.setHeader) && typeof stream.abort === 'function'
	}
	function emitCloseLegacy(stream) {
	  stream.emit('close');
	}
	function emitErrorCloseLegacy(stream, err) {
	  stream.emit('error', err);
	  process.nextTick(emitCloseLegacy, stream);
	}

	// Normalize destroy for legacy.
	function destroyer(stream, err) {
	  if (!stream || isDestroyed(stream)) {
	    return
	  }
	  if (!err && !isFinished(stream)) {
	    err = new AbortError();
	  }

	  // TODO: Remove isRequest branches.
	  if (isServerRequest(stream)) {
	    stream.socket = null;
	    stream.destroy(err);
	  } else if (isRequest(stream)) {
	    stream.abort();
	  } else if (isRequest(stream.req)) {
	    stream.req.abort();
	  } else if (typeof stream.destroy === 'function') {
	    stream.destroy(err);
	  } else if (typeof stream.close === 'function') {
	    // TODO: Don't lose err?
	    stream.close();
	  } else if (err) {
	    process.nextTick(emitErrorCloseLegacy, stream, err);
	  } else {
	    process.nextTick(emitCloseLegacy, stream);
	  }
	  if (!stream.destroyed) {
	    stream[kIsDestroyed] = true;
	  }
	}
	destroy_1 = {
	  construct,
	  destroyer,
	  destroy,
	  undestroy,
	  errorOrDestroy
	};
	return destroy_1;
}

var legacy;
var hasRequiredLegacy;

function requireLegacy () {
	if (hasRequiredLegacy) return legacy;
	hasRequiredLegacy = 1;

	const { ArrayIsArray, ObjectSetPrototypeOf } = requirePrimordials();
	const { EventEmitter: EE } = requireEvents();
	function Stream(opts) {
	  EE.call(this, opts);
	}
	ObjectSetPrototypeOf(Stream.prototype, EE.prototype);
	ObjectSetPrototypeOf(Stream, EE);
	Stream.prototype.pipe = function (dest, options) {
	  const source = this;
	  function ondata(chunk) {
	    if (dest.writable && dest.write(chunk) === false && source.pause) {
	      source.pause();
	    }
	  }
	  source.on('data', ondata);
	  function ondrain() {
	    if (source.readable && source.resume) {
	      source.resume();
	    }
	  }
	  dest.on('drain', ondrain);

	  // If the 'end' option is not supplied, dest.end() will be called when
	  // source gets the 'end' or 'close' events.  Only dest.end() once.
	  if (!dest._isStdio && (!options || options.end !== false)) {
	    source.on('end', onend);
	    source.on('close', onclose);
	  }
	  let didOnEnd = false;
	  function onend() {
	    if (didOnEnd) return
	    didOnEnd = true;
	    dest.end();
	  }
	  function onclose() {
	    if (didOnEnd) return
	    didOnEnd = true;
	    if (typeof dest.destroy === 'function') dest.destroy();
	  }

	  // Don't leave dangling pipes when there are errors.
	  function onerror(er) {
	    cleanup();
	    if (EE.listenerCount(this, 'error') === 0) {
	      this.emit('error', er);
	    }
	  }
	  prependListener(source, 'error', onerror);
	  prependListener(dest, 'error', onerror);

	  // Remove all the event listeners that were added.
	  function cleanup() {
	    source.removeListener('data', ondata);
	    dest.removeListener('drain', ondrain);
	    source.removeListener('end', onend);
	    source.removeListener('close', onclose);
	    source.removeListener('error', onerror);
	    dest.removeListener('error', onerror);
	    source.removeListener('end', cleanup);
	    source.removeListener('close', cleanup);
	    dest.removeListener('close', cleanup);
	  }
	  source.on('end', cleanup);
	  source.on('close', cleanup);
	  dest.on('close', cleanup);
	  dest.emit('pipe', source);

	  // Allow for unix-like usage: A.pipe(B).pipe(C)
	  return dest
	};
	function prependListener(emitter, event, fn) {
	  // Sadly this is not cacheable as some libraries bundle their own
	  // event emitter implementation with them.
	  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn)

	  // This is a hack to make sure that our error handler is attached before any
	  // userland ones.  NEVER DO THIS. This is here only because this code needs
	  // to continue to work with older versions of Node.js that do not include
	  // the prependListener() method. The goal is to eventually remove this hack.
	  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
	  else if (ArrayIsArray(emitter._events[event])) emitter._events[event].unshift(fn);
	  else emitter._events[event] = [fn, emitter._events[event]];
	}
	legacy = {
	  Stream,
	  prependListener
	};
	return legacy;
}

var addAbortSignal = {exports: {}};

var hasRequiredAddAbortSignal;

function requireAddAbortSignal () {
	if (hasRequiredAddAbortSignal) return addAbortSignal.exports;
	hasRequiredAddAbortSignal = 1;
	(function (module) {

		const { SymbolDispose } = requirePrimordials();
		const { AbortError, codes } = requireErrors();
		const { isNodeStream, isWebStream, kControllerErrorFunction } = requireUtils$1();
		const eos = requireEndOfStream();
		const { ERR_INVALID_ARG_TYPE } = codes;
		let addAbortListener;

		// This method is inlined here for readable-stream
		// It also does not allow for signal to not exist on the stream
		// https://github.com/nodejs/node/pull/36061#discussion_r533718029
		const validateAbortSignal = (signal, name) => {
		  if (typeof signal !== 'object' || !('aborted' in signal)) {
		    throw new ERR_INVALID_ARG_TYPE(name, 'AbortSignal', signal)
		  }
		};
		module.exports.addAbortSignal = function addAbortSignal(signal, stream) {
		  validateAbortSignal(signal, 'signal');
		  if (!isNodeStream(stream) && !isWebStream(stream)) {
		    throw new ERR_INVALID_ARG_TYPE('stream', ['ReadableStream', 'WritableStream', 'Stream'], stream)
		  }
		  return module.exports.addAbortSignalNoValidate(signal, stream)
		};
		module.exports.addAbortSignalNoValidate = function (signal, stream) {
		  if (typeof signal !== 'object' || !('aborted' in signal)) {
		    return stream
		  }
		  const onAbort = isNodeStream(stream)
		    ? () => {
		        stream.destroy(
		          new AbortError(undefined, {
		            cause: signal.reason
		          })
		        );
		      }
		    : () => {
		        stream[kControllerErrorFunction](
		          new AbortError(undefined, {
		            cause: signal.reason
		          })
		        );
		      };
		  if (signal.aborted) {
		    onAbort();
		  } else {
		    addAbortListener = addAbortListener || requireUtil$2().addAbortListener;
		    const disposable = addAbortListener(signal, onAbort);
		    eos(stream, disposable[SymbolDispose]);
		  }
		  return stream
		}; 
	} (addAbortSignal));
	return addAbortSignal.exports;
}

var buffer_list;
var hasRequiredBuffer_list;

function requireBuffer_list () {
	if (hasRequiredBuffer_list) return buffer_list;
	hasRequiredBuffer_list = 1;

	const { StringPrototypeSlice, SymbolIterator, TypedArrayPrototypeSet, Uint8Array } = requirePrimordials();
	const { Buffer } = require$$0$2;
	const { inspect } = requireUtil$2();
	buffer_list = class BufferList {
	  constructor() {
	    this.head = null;
	    this.tail = null;
	    this.length = 0;
	  }
	  push(v) {
	    const entry = {
	      data: v,
	      next: null
	    };
	    if (this.length > 0) this.tail.next = entry;
	    else this.head = entry;
	    this.tail = entry;
	    ++this.length;
	  }
	  unshift(v) {
	    const entry = {
	      data: v,
	      next: this.head
	    };
	    if (this.length === 0) this.tail = entry;
	    this.head = entry;
	    ++this.length;
	  }
	  shift() {
	    if (this.length === 0) return
	    const ret = this.head.data;
	    if (this.length === 1) this.head = this.tail = null;
	    else this.head = this.head.next;
	    --this.length;
	    return ret
	  }
	  clear() {
	    this.head = this.tail = null;
	    this.length = 0;
	  }
	  join(s) {
	    if (this.length === 0) return ''
	    let p = this.head;
	    let ret = '' + p.data;
	    while ((p = p.next) !== null) ret += s + p.data;
	    return ret
	  }
	  concat(n) {
	    if (this.length === 0) return Buffer.alloc(0)
	    const ret = Buffer.allocUnsafe(n >>> 0);
	    let p = this.head;
	    let i = 0;
	    while (p) {
	      TypedArrayPrototypeSet(ret, p.data, i);
	      i += p.data.length;
	      p = p.next;
	    }
	    return ret
	  }

	  // Consumes a specified amount of bytes or characters from the buffered data.
	  consume(n, hasStrings) {
	    const data = this.head.data;
	    if (n < data.length) {
	      // `slice` is the same for buffers and strings.
	      const slice = data.slice(0, n);
	      this.head.data = data.slice(n);
	      return slice
	    }
	    if (n === data.length) {
	      // First chunk is a perfect match.
	      return this.shift()
	    }
	    // Result spans more than one buffer.
	    return hasStrings ? this._getString(n) : this._getBuffer(n)
	  }
	  first() {
	    return this.head.data
	  }
	  *[SymbolIterator]() {
	    for (let p = this.head; p; p = p.next) {
	      yield p.data;
	    }
	  }

	  // Consumes a specified amount of characters from the buffered data.
	  _getString(n) {
	    let ret = '';
	    let p = this.head;
	    let c = 0;
	    do {
	      const str = p.data;
	      if (n > str.length) {
	        ret += str;
	        n -= str.length;
	      } else {
	        if (n === str.length) {
	          ret += str;
	          ++c;
	          if (p.next) this.head = p.next;
	          else this.head = this.tail = null;
	        } else {
	          ret += StringPrototypeSlice(str, 0, n);
	          this.head = p;
	          p.data = StringPrototypeSlice(str, n);
	        }
	        break
	      }
	      ++c;
	    } while ((p = p.next) !== null)
	    this.length -= c;
	    return ret
	  }

	  // Consumes a specified amount of bytes from the buffered data.
	  _getBuffer(n) {
	    const ret = Buffer.allocUnsafe(n);
	    const retLen = n;
	    let p = this.head;
	    let c = 0;
	    do {
	      const buf = p.data;
	      if (n > buf.length) {
	        TypedArrayPrototypeSet(ret, buf, retLen - n);
	        n -= buf.length;
	      } else {
	        if (n === buf.length) {
	          TypedArrayPrototypeSet(ret, buf, retLen - n);
	          ++c;
	          if (p.next) this.head = p.next;
	          else this.head = this.tail = null;
	        } else {
	          TypedArrayPrototypeSet(ret, new Uint8Array(buf.buffer, buf.byteOffset, n), retLen - n);
	          this.head = p;
	          p.data = buf.slice(n);
	        }
	        break
	      }
	      ++c;
	    } while ((p = p.next) !== null)
	    this.length -= c;
	    return ret
	  }

	  // Make sure the linked list only shows the minimal necessary information.
	  [Symbol.for('nodejs.util.inspect.custom')](_, options) {
	    return inspect(this, {
	      ...options,
	      // Only inspect one level.
	      depth: 0,
	      // It should not recurse.
	      customInspect: false
	    })
	  }
	};
	return buffer_list;
}

var state;
var hasRequiredState;

function requireState () {
	if (hasRequiredState) return state;
	hasRequiredState = 1;

	const { MathFloor, NumberIsInteger } = requirePrimordials();
	const { validateInteger } = requireValidators();
	const { ERR_INVALID_ARG_VALUE } = requireErrors().codes;
	let defaultHighWaterMarkBytes = 16 * 1024;
	let defaultHighWaterMarkObjectMode = 16;
	function highWaterMarkFrom(options, isDuplex, duplexKey) {
	  return options.highWaterMark != null ? options.highWaterMark : isDuplex ? options[duplexKey] : null
	}
	function getDefaultHighWaterMark(objectMode) {
	  return objectMode ? defaultHighWaterMarkObjectMode : defaultHighWaterMarkBytes
	}
	function setDefaultHighWaterMark(objectMode, value) {
	  validateInteger(value, 'value', 0);
	  if (objectMode) {
	    defaultHighWaterMarkObjectMode = value;
	  } else {
	    defaultHighWaterMarkBytes = value;
	  }
	}
	function getHighWaterMark(state, options, duplexKey, isDuplex) {
	  const hwm = highWaterMarkFrom(options, isDuplex, duplexKey);
	  if (hwm != null) {
	    if (!NumberIsInteger(hwm) || hwm < 0) {
	      const name = isDuplex ? `options.${duplexKey}` : 'options.highWaterMark';
	      throw new ERR_INVALID_ARG_VALUE(name, hwm)
	    }
	    return MathFloor(hwm)
	  }

	  // Default value
	  return getDefaultHighWaterMark(state.objectMode)
	}
	state = {
	  getHighWaterMark,
	  getDefaultHighWaterMark,
	  setDefaultHighWaterMark
	};
	return state;
}

var string_decoder = {};

var safeBuffer = {exports: {}};

/*! safe-buffer. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */

var hasRequiredSafeBuffer;

function requireSafeBuffer () {
	if (hasRequiredSafeBuffer) return safeBuffer.exports;
	hasRequiredSafeBuffer = 1;
	(function (module, exports) {
		/* eslint-disable node/no-deprecated-api */
		var buffer = require$$0$2;
		var Buffer = buffer.Buffer;

		// alternative to using Object.keys for old browsers
		function copyProps (src, dst) {
		  for (var key in src) {
		    dst[key] = src[key];
		  }
		}
		if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
		  module.exports = buffer;
		} else {
		  // Copy properties from require('buffer')
		  copyProps(buffer, exports);
		  exports.Buffer = SafeBuffer;
		}

		function SafeBuffer (arg, encodingOrOffset, length) {
		  return Buffer(arg, encodingOrOffset, length)
		}

		SafeBuffer.prototype = Object.create(Buffer.prototype);

		// Copy static methods from Buffer
		copyProps(Buffer, SafeBuffer);

		SafeBuffer.from = function (arg, encodingOrOffset, length) {
		  if (typeof arg === 'number') {
		    throw new TypeError('Argument must not be a number')
		  }
		  return Buffer(arg, encodingOrOffset, length)
		};

		SafeBuffer.alloc = function (size, fill, encoding) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  var buf = Buffer(size);
		  if (fill !== undefined) {
		    if (typeof encoding === 'string') {
		      buf.fill(fill, encoding);
		    } else {
		      buf.fill(fill);
		    }
		  } else {
		    buf.fill(0);
		  }
		  return buf
		};

		SafeBuffer.allocUnsafe = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return Buffer(size)
		};

		SafeBuffer.allocUnsafeSlow = function (size) {
		  if (typeof size !== 'number') {
		    throw new TypeError('Argument must be a number')
		  }
		  return buffer.SlowBuffer(size)
		}; 
	} (safeBuffer, safeBuffer.exports));
	return safeBuffer.exports;
}

var hasRequiredString_decoder;

function requireString_decoder () {
	if (hasRequiredString_decoder) return string_decoder;
	hasRequiredString_decoder = 1;

	/*<replacement>*/

	var Buffer = requireSafeBuffer().Buffer;
	/*</replacement>*/

	var isEncoding = Buffer.isEncoding || function (encoding) {
	  encoding = '' + encoding;
	  switch (encoding && encoding.toLowerCase()) {
	    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
	      return true;
	    default:
	      return false;
	  }
	};

	function _normalizeEncoding(enc) {
	  if (!enc) return 'utf8';
	  var retried;
	  while (true) {
	    switch (enc) {
	      case 'utf8':
	      case 'utf-8':
	        return 'utf8';
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return 'utf16le';
	      case 'latin1':
	      case 'binary':
	        return 'latin1';
	      case 'base64':
	      case 'ascii':
	      case 'hex':
	        return enc;
	      default:
	        if (retried) return; // undefined
	        enc = ('' + enc).toLowerCase();
	        retried = true;
	    }
	  }
	}
	// Do not cache `Buffer.isEncoding` when checking encoding names as some
	// modules monkey-patch it to support additional encodings
	function normalizeEncoding(enc) {
	  var nenc = _normalizeEncoding(enc);
	  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
	  return nenc || enc;
	}

	// StringDecoder provides an interface for efficiently splitting a series of
	// buffers into a series of JS strings without breaking apart multi-byte
	// characters.
	string_decoder.StringDecoder = StringDecoder;
	function StringDecoder(encoding) {
	  this.encoding = normalizeEncoding(encoding);
	  var nb;
	  switch (this.encoding) {
	    case 'utf16le':
	      this.text = utf16Text;
	      this.end = utf16End;
	      nb = 4;
	      break;
	    case 'utf8':
	      this.fillLast = utf8FillLast;
	      nb = 4;
	      break;
	    case 'base64':
	      this.text = base64Text;
	      this.end = base64End;
	      nb = 3;
	      break;
	    default:
	      this.write = simpleWrite;
	      this.end = simpleEnd;
	      return;
	  }
	  this.lastNeed = 0;
	  this.lastTotal = 0;
	  this.lastChar = Buffer.allocUnsafe(nb);
	}

	StringDecoder.prototype.write = function (buf) {
	  if (buf.length === 0) return '';
	  var r;
	  var i;
	  if (this.lastNeed) {
	    r = this.fillLast(buf);
	    if (r === undefined) return '';
	    i = this.lastNeed;
	    this.lastNeed = 0;
	  } else {
	    i = 0;
	  }
	  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
	  return r || '';
	};

	StringDecoder.prototype.end = utf8End;

	// Returns only complete characters in a Buffer
	StringDecoder.prototype.text = utf8Text;

	// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
	StringDecoder.prototype.fillLast = function (buf) {
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
	  this.lastNeed -= buf.length;
	};

	// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
	// continuation byte. If an invalid byte is detected, -2 is returned.
	function utf8CheckByte(byte) {
	  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
	  return byte >> 6 === 0x02 ? -1 : -2;
	}

	// Checks at most 3 bytes at the end of a Buffer in order to detect an
	// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
	// needed to complete the UTF-8 character (if applicable) are returned.
	function utf8CheckIncomplete(self, buf, i) {
	  var j = buf.length - 1;
	  if (j < i) return 0;
	  var nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 1;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) self.lastNeed = nb - 2;
	    return nb;
	  }
	  if (--j < i || nb === -2) return 0;
	  nb = utf8CheckByte(buf[j]);
	  if (nb >= 0) {
	    if (nb > 0) {
	      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
	    }
	    return nb;
	  }
	  return 0;
	}

	// Validates as many continuation bytes for a multi-byte UTF-8 character as
	// needed or are available. If we see a non-continuation byte where we expect
	// one, we "replace" the validated continuation bytes we've seen so far with
	// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
	// behavior. The continuation byte check is included three times in the case
	// where all of the continuation bytes for a character exist in the same buffer.
	// It is also done this way as a slight performance increase instead of using a
	// loop.
	function utf8CheckExtraBytes(self, buf, p) {
	  if ((buf[0] & 0xC0) !== 0x80) {
	    self.lastNeed = 0;
	    return '\ufffd';
	  }
	  if (self.lastNeed > 1 && buf.length > 1) {
	    if ((buf[1] & 0xC0) !== 0x80) {
	      self.lastNeed = 1;
	      return '\ufffd';
	    }
	    if (self.lastNeed > 2 && buf.length > 2) {
	      if ((buf[2] & 0xC0) !== 0x80) {
	        self.lastNeed = 2;
	        return '\ufffd';
	      }
	    }
	  }
	}

	// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
	function utf8FillLast(buf) {
	  var p = this.lastTotal - this.lastNeed;
	  var r = utf8CheckExtraBytes(this, buf);
	  if (r !== undefined) return r;
	  if (this.lastNeed <= buf.length) {
	    buf.copy(this.lastChar, p, 0, this.lastNeed);
	    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
	  }
	  buf.copy(this.lastChar, p, 0, buf.length);
	  this.lastNeed -= buf.length;
	}

	// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
	// partial character, the character's bytes are buffered until the required
	// number of bytes are available.
	function utf8Text(buf, i) {
	  var total = utf8CheckIncomplete(this, buf, i);
	  if (!this.lastNeed) return buf.toString('utf8', i);
	  this.lastTotal = total;
	  var end = buf.length - (total - this.lastNeed);
	  buf.copy(this.lastChar, 0, end);
	  return buf.toString('utf8', i, end);
	}

	// For UTF-8, a replacement character is added when ending on a partial
	// character.
	function utf8End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + '\ufffd';
	  return r;
	}

	// UTF-16LE typically needs two bytes per character, but even if we have an even
	// number of bytes available, we need to check if we end on a leading/high
	// surrogate. In that case, we need to wait for the next two bytes in order to
	// decode the last character properly.
	function utf16Text(buf, i) {
	  if ((buf.length - i) % 2 === 0) {
	    var r = buf.toString('utf16le', i);
	    if (r) {
	      var c = r.charCodeAt(r.length - 1);
	      if (c >= 0xD800 && c <= 0xDBFF) {
	        this.lastNeed = 2;
	        this.lastTotal = 4;
	        this.lastChar[0] = buf[buf.length - 2];
	        this.lastChar[1] = buf[buf.length - 1];
	        return r.slice(0, -1);
	      }
	    }
	    return r;
	  }
	  this.lastNeed = 1;
	  this.lastTotal = 2;
	  this.lastChar[0] = buf[buf.length - 1];
	  return buf.toString('utf16le', i, buf.length - 1);
	}

	// For UTF-16LE we do not explicitly append special replacement characters if we
	// end on a partial character, we simply let v8 handle that.
	function utf16End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) {
	    var end = this.lastTotal - this.lastNeed;
	    return r + this.lastChar.toString('utf16le', 0, end);
	  }
	  return r;
	}

	function base64Text(buf, i) {
	  var n = (buf.length - i) % 3;
	  if (n === 0) return buf.toString('base64', i);
	  this.lastNeed = 3 - n;
	  this.lastTotal = 3;
	  if (n === 1) {
	    this.lastChar[0] = buf[buf.length - 1];
	  } else {
	    this.lastChar[0] = buf[buf.length - 2];
	    this.lastChar[1] = buf[buf.length - 1];
	  }
	  return buf.toString('base64', i, buf.length - n);
	}

	function base64End(buf) {
	  var r = buf && buf.length ? this.write(buf) : '';
	  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
	  return r;
	}

	// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
	function simpleWrite(buf) {
	  return buf.toString(this.encoding);
	}

	function simpleEnd(buf) {
	  return buf && buf.length ? this.write(buf) : '';
	}
	return string_decoder;
}

var from_1;
var hasRequiredFrom;

function requireFrom () {
	if (hasRequiredFrom) return from_1;
	hasRequiredFrom = 1;

	/* replacement start */

	const process = requireBrowser$2();

	/* replacement end */

	const { PromisePrototypeThen, SymbolAsyncIterator, SymbolIterator } = requirePrimordials();
	const { Buffer } = require$$0$2;
	const { ERR_INVALID_ARG_TYPE, ERR_STREAM_NULL_VALUES } = requireErrors().codes;
	function from(Readable, iterable, opts) {
	  let iterator;
	  if (typeof iterable === 'string' || iterable instanceof Buffer) {
	    return new Readable({
	      objectMode: true,
	      ...opts,
	      read() {
	        this.push(iterable);
	        this.push(null);
	      }
	    })
	  }
	  let isAsync;
	  if (iterable && iterable[SymbolAsyncIterator]) {
	    isAsync = true;
	    iterator = iterable[SymbolAsyncIterator]();
	  } else if (iterable && iterable[SymbolIterator]) {
	    isAsync = false;
	    iterator = iterable[SymbolIterator]();
	  } else {
	    throw new ERR_INVALID_ARG_TYPE('iterable', ['Iterable'], iterable)
	  }
	  const readable = new Readable({
	    objectMode: true,
	    highWaterMark: 1,
	    // TODO(ronag): What options should be allowed?
	    ...opts
	  });

	  // Flag to protect against _read
	  // being called before last iteration completion.
	  let reading = false;
	  readable._read = function () {
	    if (!reading) {
	      reading = true;
	      next();
	    }
	  };
	  readable._destroy = function (error, cb) {
	    PromisePrototypeThen(
	      close(error),
	      () => process.nextTick(cb, error),
	      // nextTick is here in case cb throws
	      (e) => process.nextTick(cb, e || error)
	    );
	  };
	  async function close(error) {
	    const hadError = error !== undefined && error !== null;
	    const hasThrow = typeof iterator.throw === 'function';
	    if (hadError && hasThrow) {
	      const { value, done } = await iterator.throw(error);
	      await value;
	      if (done) {
	        return
	      }
	    }
	    if (typeof iterator.return === 'function') {
	      const { value } = await iterator.return();
	      await value;
	    }
	  }
	  async function next() {
	    for (;;) {
	      try {
	        const { value, done } = isAsync ? await iterator.next() : iterator.next();
	        if (done) {
	          readable.push(null);
	        } else {
	          const res = value && typeof value.then === 'function' ? await value : value;
	          if (res === null) {
	            reading = false;
	            throw new ERR_STREAM_NULL_VALUES()
	          } else if (readable.push(res)) {
	            continue
	          } else {
	            reading = false;
	          }
	        }
	      } catch (err) {
	        readable.destroy(err);
	      }
	      break
	    }
	  }
	  return readable
	}
	from_1 = from;
	return from_1;
}

var readable;
var hasRequiredReadable;

function requireReadable () {
	if (hasRequiredReadable) return readable;
	hasRequiredReadable = 1;

	/* replacement start */

	const process = requireBrowser$2();

	/* replacement end */

	const {
	  ArrayPrototypeIndexOf,
	  NumberIsInteger,
	  NumberIsNaN,
	  NumberParseInt,
	  ObjectDefineProperties,
	  ObjectKeys,
	  ObjectSetPrototypeOf,
	  Promise,
	  SafeSet,
	  SymbolAsyncDispose,
	  SymbolAsyncIterator,
	  Symbol
	} = requirePrimordials();
	readable = Readable;
	Readable.ReadableState = ReadableState;
	const { EventEmitter: EE } = requireEvents();
	const { Stream, prependListener } = requireLegacy();
	const { Buffer } = require$$0$2;
	const { addAbortSignal } = requireAddAbortSignal();
	const eos = requireEndOfStream();
	let debug = requireUtil$2().debuglog('stream', (fn) => {
	  debug = fn;
	});
	const BufferList = requireBuffer_list();
	const destroyImpl = requireDestroy();
	const { getHighWaterMark, getDefaultHighWaterMark } = requireState();
	const {
	  aggregateTwoErrors,
	  codes: {
	    ERR_INVALID_ARG_TYPE,
	    ERR_METHOD_NOT_IMPLEMENTED,
	    ERR_OUT_OF_RANGE,
	    ERR_STREAM_PUSH_AFTER_EOF,
	    ERR_STREAM_UNSHIFT_AFTER_END_EVENT
	  },
	  AbortError
	} = requireErrors();
	const { validateObject } = requireValidators();
	const kPaused = Symbol('kPaused');
	const { StringDecoder } = requireString_decoder();
	const from = requireFrom();
	ObjectSetPrototypeOf(Readable.prototype, Stream.prototype);
	ObjectSetPrototypeOf(Readable, Stream);
	const nop = () => {};
	const { errorOrDestroy } = destroyImpl;
	const kObjectMode = 1 << 0;
	const kEnded = 1 << 1;
	const kEndEmitted = 1 << 2;
	const kReading = 1 << 3;
	const kConstructed = 1 << 4;
	const kSync = 1 << 5;
	const kNeedReadable = 1 << 6;
	const kEmittedReadable = 1 << 7;
	const kReadableListening = 1 << 8;
	const kResumeScheduled = 1 << 9;
	const kErrorEmitted = 1 << 10;
	const kEmitClose = 1 << 11;
	const kAutoDestroy = 1 << 12;
	const kDestroyed = 1 << 13;
	const kClosed = 1 << 14;
	const kCloseEmitted = 1 << 15;
	const kMultiAwaitDrain = 1 << 16;
	const kReadingMore = 1 << 17;
	const kDataEmitted = 1 << 18;

	// TODO(benjamingr) it is likely slower to do it this way than with free functions
	function makeBitMapDescriptor(bit) {
	  return {
	    enumerable: false,
	    get() {
	      return (this.state & bit) !== 0
	    },
	    set(value) {
	      if (value) this.state |= bit;
	      else this.state &= ~bit;
	    }
	  }
	}
	ObjectDefineProperties(ReadableState.prototype, {
	  objectMode: makeBitMapDescriptor(kObjectMode),
	  ended: makeBitMapDescriptor(kEnded),
	  endEmitted: makeBitMapDescriptor(kEndEmitted),
	  reading: makeBitMapDescriptor(kReading),
	  // Stream is still being constructed and cannot be
	  // destroyed until construction finished or failed.
	  // Async construction is opt in, therefore we start as
	  // constructed.
	  constructed: makeBitMapDescriptor(kConstructed),
	  // A flag to be able to tell if the event 'readable'/'data' is emitted
	  // immediately, or on a later tick.  We set this to true at first, because
	  // any actions that shouldn't happen until "later" should generally also
	  // not happen before the first read call.
	  sync: makeBitMapDescriptor(kSync),
	  // Whenever we return null, then we set a flag to say
	  // that we're awaiting a 'readable' event emission.
	  needReadable: makeBitMapDescriptor(kNeedReadable),
	  emittedReadable: makeBitMapDescriptor(kEmittedReadable),
	  readableListening: makeBitMapDescriptor(kReadableListening),
	  resumeScheduled: makeBitMapDescriptor(kResumeScheduled),
	  // True if the error was already emitted and should not be thrown again.
	  errorEmitted: makeBitMapDescriptor(kErrorEmitted),
	  emitClose: makeBitMapDescriptor(kEmitClose),
	  autoDestroy: makeBitMapDescriptor(kAutoDestroy),
	  // Has it been destroyed.
	  destroyed: makeBitMapDescriptor(kDestroyed),
	  // Indicates whether the stream has finished destroying.
	  closed: makeBitMapDescriptor(kClosed),
	  // True if close has been emitted or would have been emitted
	  // depending on emitClose.
	  closeEmitted: makeBitMapDescriptor(kCloseEmitted),
	  multiAwaitDrain: makeBitMapDescriptor(kMultiAwaitDrain),
	  // If true, a maybeReadMore has been scheduled.
	  readingMore: makeBitMapDescriptor(kReadingMore),
	  dataEmitted: makeBitMapDescriptor(kDataEmitted)
	});
	function ReadableState(options, stream, isDuplex) {
	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream.
	  // These options can be provided separately as readableXXX and writableXXX.
	  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof requireDuplex();

	  // Bit map field to store ReadableState more effciently with 1 bit per field
	  // instead of a V8 slot per field.
	  this.state = kEmitClose | kAutoDestroy | kConstructed | kSync;
	  // Object stream flag. Used to make read(n) ignore n and to
	  // make all the buffer merging and length checks go away.
	  if (options && options.objectMode) this.state |= kObjectMode;
	  if (isDuplex && options && options.readableObjectMode) this.state |= kObjectMode;

	  // The point at which it stops calling _read() to fill the buffer
	  // Note: 0 is a valid value, means "don't call _read preemptively ever"
	  this.highWaterMark = options
	    ? getHighWaterMark(this, options, 'readableHighWaterMark', isDuplex)
	    : getDefaultHighWaterMark(false);

	  // A linked list is used to store data chunks instead of an array because the
	  // linked list can remove elements from the beginning faster than
	  // array.shift().
	  this.buffer = new BufferList();
	  this.length = 0;
	  this.pipes = [];
	  this.flowing = null;
	  this[kPaused] = null;

	  // Should close be emitted on destroy. Defaults to true.
	  if (options && options.emitClose === false) this.state &= ~kEmitClose;

	  // Should .destroy() be called after 'end' (and potentially 'finish').
	  if (options && options.autoDestroy === false) this.state &= ~kAutoDestroy;

	  // Indicates whether the stream has errored. When true no further
	  // _read calls, 'data' or 'readable' events should occur. This is needed
	  // since when autoDestroy is disabled we need a way to tell whether the
	  // stream has failed.
	  this.errored = null;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = (options && options.defaultEncoding) || 'utf8';

	  // Ref the piped dest which we need a drain event on it
	  // type: null | Writable | Set<Writable>.
	  this.awaitDrainWriters = null;
	  this.decoder = null;
	  this.encoding = null;
	  if (options && options.encoding) {
	    this.decoder = new StringDecoder(options.encoding);
	    this.encoding = options.encoding;
	  }
	}
	function Readable(options) {
	  if (!(this instanceof Readable)) return new Readable(options)

	  // Checking for a Stream.Duplex instance is faster here instead of inside
	  // the ReadableState constructor, at least with V8 6.5.
	  const isDuplex = this instanceof requireDuplex();
	  this._readableState = new ReadableState(options, this, isDuplex);
	  if (options) {
	    if (typeof options.read === 'function') this._read = options.read;
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	    if (typeof options.construct === 'function') this._construct = options.construct;
	    if (options.signal && !isDuplex) addAbortSignal(options.signal, this);
	  }
	  Stream.call(this, options);
	  destroyImpl.construct(this, () => {
	    if (this._readableState.needReadable) {
	      maybeReadMore(this, this._readableState);
	    }
	  });
	}
	Readable.prototype.destroy = destroyImpl.destroy;
	Readable.prototype._undestroy = destroyImpl.undestroy;
	Readable.prototype._destroy = function (err, cb) {
	  cb(err);
	};
	Readable.prototype[EE.captureRejectionSymbol] = function (err) {
	  this.destroy(err);
	};
	Readable.prototype[SymbolAsyncDispose] = function () {
	  let error;
	  if (!this.destroyed) {
	    error = this.readableEnded ? null : new AbortError();
	    this.destroy(error);
	  }
	  return new Promise((resolve, reject) => eos(this, (err) => (err && err !== error ? reject(err) : resolve(null))))
	};

	// Manually shove something into the read() buffer.
	// This returns true if the highWaterMark has not been hit yet,
	// similar to how Writable.write() returns true if you should
	// write() some more.
	Readable.prototype.push = function (chunk, encoding) {
	  return readableAddChunk(this, chunk, encoding, false)
	};

	// Unshift should *always* be something directly out of read().
	Readable.prototype.unshift = function (chunk, encoding) {
	  return readableAddChunk(this, chunk, encoding, true)
	};
	function readableAddChunk(stream, chunk, encoding, addToFront) {
	  debug('readableAddChunk', chunk);
	  const state = stream._readableState;
	  let err;
	  if ((state.state & kObjectMode) === 0) {
	    if (typeof chunk === 'string') {
	      encoding = encoding || state.defaultEncoding;
	      if (state.encoding !== encoding) {
	        if (addToFront && state.encoding) {
	          // When unshifting, if state.encoding is set, we have to save
	          // the string in the BufferList with the state encoding.
	          chunk = Buffer.from(chunk, encoding).toString(state.encoding);
	        } else {
	          chunk = Buffer.from(chunk, encoding);
	          encoding = '';
	        }
	      }
	    } else if (chunk instanceof Buffer) {
	      encoding = '';
	    } else if (Stream._isUint8Array(chunk)) {
	      chunk = Stream._uint8ArrayToBuffer(chunk);
	      encoding = '';
	    } else if (chunk != null) {
	      err = new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer', 'Uint8Array'], chunk);
	    }
	  }
	  if (err) {
	    errorOrDestroy(stream, err);
	  } else if (chunk === null) {
	    state.state &= ~kReading;
	    onEofChunk(stream, state);
	  } else if ((state.state & kObjectMode) !== 0 || (chunk && chunk.length > 0)) {
	    if (addToFront) {
	      if ((state.state & kEndEmitted) !== 0) errorOrDestroy(stream, new ERR_STREAM_UNSHIFT_AFTER_END_EVENT());
	      else if (state.destroyed || state.errored) return false
	      else addChunk(stream, state, chunk, true);
	    } else if (state.ended) {
	      errorOrDestroy(stream, new ERR_STREAM_PUSH_AFTER_EOF());
	    } else if (state.destroyed || state.errored) {
	      return false
	    } else {
	      state.state &= ~kReading;
	      if (state.decoder && !encoding) {
	        chunk = state.decoder.write(chunk);
	        if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);
	        else maybeReadMore(stream, state);
	      } else {
	        addChunk(stream, state, chunk, false);
	      }
	    }
	  } else if (!addToFront) {
	    state.state &= ~kReading;
	    maybeReadMore(stream, state);
	  }

	  // We can push more data if we are below the highWaterMark.
	  // Also, if we have no data yet, we can stand some more bytes.
	  // This is to work around cases where hwm=0, such as the repl.
	  return !state.ended && (state.length < state.highWaterMark || state.length === 0)
	}
	function addChunk(stream, state, chunk, addToFront) {
	  if (state.flowing && state.length === 0 && !state.sync && stream.listenerCount('data') > 0) {
	    // Use the guard to avoid creating `Set()` repeatedly
	    // when we have multiple pipes.
	    if ((state.state & kMultiAwaitDrain) !== 0) {
	      state.awaitDrainWriters.clear();
	    } else {
	      state.awaitDrainWriters = null;
	    }
	    state.dataEmitted = true;
	    stream.emit('data', chunk);
	  } else {
	    // Update the buffer info.
	    state.length += state.objectMode ? 1 : chunk.length;
	    if (addToFront) state.buffer.unshift(chunk);
	    else state.buffer.push(chunk);
	    if ((state.state & kNeedReadable) !== 0) emitReadable(stream);
	  }
	  maybeReadMore(stream, state);
	}
	Readable.prototype.isPaused = function () {
	  const state = this._readableState;
	  return state[kPaused] === true || state.flowing === false
	};

	// Backwards compatibility.
	Readable.prototype.setEncoding = function (enc) {
	  const decoder = new StringDecoder(enc);
	  this._readableState.decoder = decoder;
	  // If setEncoding(null), decoder.encoding equals utf8.
	  this._readableState.encoding = this._readableState.decoder.encoding;
	  const buffer = this._readableState.buffer;
	  // Iterate over current buffer to convert already stored Buffers:
	  let content = '';
	  for (const data of buffer) {
	    content += decoder.write(data);
	  }
	  buffer.clear();
	  if (content !== '') buffer.push(content);
	  this._readableState.length = content.length;
	  return this
	};

	// Don't raise the hwm > 1GB.
	const MAX_HWM = 0x40000000;
	function computeNewHighWaterMark(n) {
	  if (n > MAX_HWM) {
	    throw new ERR_OUT_OF_RANGE('size', '<= 1GiB', n)
	  } else {
	    // Get the next highest power of 2 to prevent increasing hwm excessively in
	    // tiny amounts.
	    n--;
	    n |= n >>> 1;
	    n |= n >>> 2;
	    n |= n >>> 4;
	    n |= n >>> 8;
	    n |= n >>> 16;
	    n++;
	  }
	  return n
	}

	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function howMuchToRead(n, state) {
	  if (n <= 0 || (state.length === 0 && state.ended)) return 0
	  if ((state.state & kObjectMode) !== 0) return 1
	  if (NumberIsNaN(n)) {
	    // Only flow one buffer at a time.
	    if (state.flowing && state.length) return state.buffer.first().length
	    return state.length
	  }
	  if (n <= state.length) return n
	  return state.ended ? state.length : 0
	}

	// You can override either this method, or the async _read(n) below.
	Readable.prototype.read = function (n) {
	  debug('read', n);
	  // Same as parseInt(undefined, 10), however V8 7.3 performance regressed
	  // in this scenario, so we are doing it manually.
	  if (n === undefined) {
	    n = NaN;
	  } else if (!NumberIsInteger(n)) {
	    n = NumberParseInt(n, 10);
	  }
	  const state = this._readableState;
	  const nOrig = n;

	  // If we're asking for more than the current hwm, then raise the hwm.
	  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
	  if (n !== 0) state.state &= ~kEmittedReadable;

	  // If we're doing read(0) to trigger a readable event, but we
	  // already have a bunch of data in the buffer, then just trigger
	  // the 'readable' event and move on.
	  if (
	    n === 0 &&
	    state.needReadable &&
	    ((state.highWaterMark !== 0 ? state.length >= state.highWaterMark : state.length > 0) || state.ended)
	  ) {
	    debug('read: emitReadable', state.length, state.ended);
	    if (state.length === 0 && state.ended) endReadable(this);
	    else emitReadable(this);
	    return null
	  }
	  n = howMuchToRead(n, state);

	  // If we've ended, and we're now clear, then finish it up.
	  if (n === 0 && state.ended) {
	    if (state.length === 0) endReadable(this);
	    return null
	  }

	  // All the actual chunk generation logic needs to be
	  // *below* the call to _read.  The reason is that in certain
	  // synthetic stream cases, such as passthrough streams, _read
	  // may be a completely synchronous operation which may change
	  // the state of the read buffer, providing enough data when
	  // before there was *not* enough.
	  //
	  // So, the steps are:
	  // 1. Figure out what the state of things will be after we do
	  // a read from the buffer.
	  //
	  // 2. If that resulting state will trigger a _read, then call _read.
	  // Note that this may be asynchronous, or synchronous.  Yes, it is
	  // deeply ugly to write APIs this way, but that still doesn't mean
	  // that the Readable class should behave improperly, as streams are
	  // designed to be sync/async agnostic.
	  // Take note if the _read call is sync or async (ie, if the read call
	  // has returned yet), so that we know whether or not it's safe to emit
	  // 'readable' etc.
	  //
	  // 3. Actually pull the requested chunks out of the buffer and return.

	  // if we need a readable event, then we need to do some reading.
	  let doRead = (state.state & kNeedReadable) !== 0;
	  debug('need readable', doRead);

	  // If we currently have less than the highWaterMark, then also read some.
	  if (state.length === 0 || state.length - n < state.highWaterMark) {
	    doRead = true;
	    debug('length less than watermark', doRead);
	  }

	  // However, if we've ended, then there's no point, if we're already
	  // reading, then it's unnecessary, if we're constructing we have to wait,
	  // and if we're destroyed or errored, then it's not allowed,
	  if (state.ended || state.reading || state.destroyed || state.errored || !state.constructed) {
	    doRead = false;
	    debug('reading, ended or constructing', doRead);
	  } else if (doRead) {
	    debug('do read');
	    state.state |= kReading | kSync;
	    // If the length is currently zero, then we *need* a readable event.
	    if (state.length === 0) state.state |= kNeedReadable;

	    // Call internal read method
	    try {
	      this._read(state.highWaterMark);
	    } catch (err) {
	      errorOrDestroy(this, err);
	    }
	    state.state &= ~kSync;

	    // If _read pushed data synchronously, then `reading` will be false,
	    // and we need to re-evaluate how much data we can return to the user.
	    if (!state.reading) n = howMuchToRead(nOrig, state);
	  }
	  let ret;
	  if (n > 0) ret = fromList(n, state);
	  else ret = null;
	  if (ret === null) {
	    state.needReadable = state.length <= state.highWaterMark;
	    n = 0;
	  } else {
	    state.length -= n;
	    if (state.multiAwaitDrain) {
	      state.awaitDrainWriters.clear();
	    } else {
	      state.awaitDrainWriters = null;
	    }
	  }
	  if (state.length === 0) {
	    // If we have nothing in the buffer, then we want to know
	    // as soon as we *do* get something into the buffer.
	    if (!state.ended) state.needReadable = true;

	    // If we tried to read() past the EOF, then emit end on the next tick.
	    if (nOrig !== n && state.ended) endReadable(this);
	  }
	  if (ret !== null && !state.errorEmitted && !state.closeEmitted) {
	    state.dataEmitted = true;
	    this.emit('data', ret);
	  }
	  return ret
	};
	function onEofChunk(stream, state) {
	  debug('onEofChunk');
	  if (state.ended) return
	  if (state.decoder) {
	    const chunk = state.decoder.end();
	    if (chunk && chunk.length) {
	      state.buffer.push(chunk);
	      state.length += state.objectMode ? 1 : chunk.length;
	    }
	  }
	  state.ended = true;
	  if (state.sync) {
	    // If we are sync, wait until next tick to emit the data.
	    // Otherwise we risk emitting data in the flow()
	    // the readable code triggers during a read() call.
	    emitReadable(stream);
	  } else {
	    // Emit 'readable' now to make sure it gets picked up.
	    state.needReadable = false;
	    state.emittedReadable = true;
	    // We have to emit readable now that we are EOF. Modules
	    // in the ecosystem (e.g. dicer) rely on this event being sync.
	    emitReadable_(stream);
	  }
	}

	// Don't emit readable right away in sync mode, because this can trigger
	// another read() call => stack overflow.  This way, it might trigger
	// a nextTick recursion warning, but that's not so bad.
	function emitReadable(stream) {
	  const state = stream._readableState;
	  debug('emitReadable', state.needReadable, state.emittedReadable);
	  state.needReadable = false;
	  if (!state.emittedReadable) {
	    debug('emitReadable', state.flowing);
	    state.emittedReadable = true;
	    process.nextTick(emitReadable_, stream);
	  }
	}
	function emitReadable_(stream) {
	  const state = stream._readableState;
	  debug('emitReadable_', state.destroyed, state.length, state.ended);
	  if (!state.destroyed && !state.errored && (state.length || state.ended)) {
	    stream.emit('readable');
	    state.emittedReadable = false;
	  }

	  // The stream needs another readable event if:
	  // 1. It is not flowing, as the flow mechanism will take
	  //    care of it.
	  // 2. It is not ended.
	  // 3. It is below the highWaterMark, so we can schedule
	  //    another readable later.
	  state.needReadable = !state.flowing && !state.ended && state.length <= state.highWaterMark;
	  flow(stream);
	}

	// At this point, the user has presumably seen the 'readable' event,
	// and called read() to consume some data.  that may have triggered
	// in turn another _read(n) call, in which case reading = true if
	// it's in progress.
	// However, if we're not ended, or reading, and the length < hwm,
	// then go ahead and try to read some more preemptively.
	function maybeReadMore(stream, state) {
	  if (!state.readingMore && state.constructed) {
	    state.readingMore = true;
	    process.nextTick(maybeReadMore_, stream, state);
	  }
	}
	function maybeReadMore_(stream, state) {
	  // Attempt to read more data if we should.
	  //
	  // The conditions for reading more data are (one of):
	  // - Not enough data buffered (state.length < state.highWaterMark). The loop
	  //   is responsible for filling the buffer with enough data if such data
	  //   is available. If highWaterMark is 0 and we are not in the flowing mode
	  //   we should _not_ attempt to buffer any extra data. We'll get more data
	  //   when the stream consumer calls read() instead.
	  // - No data in the buffer, and the stream is in flowing mode. In this mode
	  //   the loop below is responsible for ensuring read() is called. Failing to
	  //   call read here would abort the flow and there's no other mechanism for
	  //   continuing the flow if the stream consumer has just subscribed to the
	  //   'data' event.
	  //
	  // In addition to the above conditions to keep reading data, the following
	  // conditions prevent the data from being read:
	  // - The stream has ended (state.ended).
	  // - There is already a pending 'read' operation (state.reading). This is a
	  //   case where the stream has called the implementation defined _read()
	  //   method, but they are processing the call asynchronously and have _not_
	  //   called push() with new data. In this case we skip performing more
	  //   read()s. The execution ends in this method again after the _read() ends
	  //   up calling push() with more data.
	  while (
	    !state.reading &&
	    !state.ended &&
	    (state.length < state.highWaterMark || (state.flowing && state.length === 0))
	  ) {
	    const len = state.length;
	    debug('maybeReadMore read 0');
	    stream.read(0);
	    if (len === state.length)
	      // Didn't get any data, stop spinning.
	      break
	  }
	  state.readingMore = false;
	}

	// Abstract method.  to be overridden in specific implementation classes.
	// call cb(er, data) where data is <= n in length.
	// for virtual (non-string, non-buffer) streams, "length" is somewhat
	// arbitrary, and perhaps not very meaningful.
	Readable.prototype._read = function (n) {
	  throw new ERR_METHOD_NOT_IMPLEMENTED('_read()')
	};
	Readable.prototype.pipe = function (dest, pipeOpts) {
	  const src = this;
	  const state = this._readableState;
	  if (state.pipes.length === 1) {
	    if (!state.multiAwaitDrain) {
	      state.multiAwaitDrain = true;
	      state.awaitDrainWriters = new SafeSet(state.awaitDrainWriters ? [state.awaitDrainWriters] : []);
	    }
	  }
	  state.pipes.push(dest);
	  debug('pipe count=%d opts=%j', state.pipes.length, pipeOpts);
	  const doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
	  const endFn = doEnd ? onend : unpipe;
	  if (state.endEmitted) process.nextTick(endFn);
	  else src.once('end', endFn);
	  dest.on('unpipe', onunpipe);
	  function onunpipe(readable, unpipeInfo) {
	    debug('onunpipe');
	    if (readable === src) {
	      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
	        unpipeInfo.hasUnpiped = true;
	        cleanup();
	      }
	    }
	  }
	  function onend() {
	    debug('onend');
	    dest.end();
	  }
	  let ondrain;
	  let cleanedUp = false;
	  function cleanup() {
	    debug('cleanup');
	    // Cleanup event handlers once the pipe is broken.
	    dest.removeListener('close', onclose);
	    dest.removeListener('finish', onfinish);
	    if (ondrain) {
	      dest.removeListener('drain', ondrain);
	    }
	    dest.removeListener('error', onerror);
	    dest.removeListener('unpipe', onunpipe);
	    src.removeListener('end', onend);
	    src.removeListener('end', unpipe);
	    src.removeListener('data', ondata);
	    cleanedUp = true;

	    // If the reader is waiting for a drain event from this
	    // specific writer, then it would cause it to never start
	    // flowing again.
	    // So, if this is awaiting a drain, then we just call it now.
	    // If we don't know, then assume that we are waiting for one.
	    if (ondrain && state.awaitDrainWriters && (!dest._writableState || dest._writableState.needDrain)) ondrain();
	  }
	  function pause() {
	    // If the user unpiped during `dest.write()`, it is possible
	    // to get stuck in a permanently paused state if that write
	    // also returned false.
	    // => Check whether `dest` is still a piping destination.
	    if (!cleanedUp) {
	      if (state.pipes.length === 1 && state.pipes[0] === dest) {
	        debug('false write response, pause', 0);
	        state.awaitDrainWriters = dest;
	        state.multiAwaitDrain = false;
	      } else if (state.pipes.length > 1 && state.pipes.includes(dest)) {
	        debug('false write response, pause', state.awaitDrainWriters.size);
	        state.awaitDrainWriters.add(dest);
	      }
	      src.pause();
	    }
	    if (!ondrain) {
	      // When the dest drains, it reduces the awaitDrain counter
	      // on the source.  This would be more elegant with a .once()
	      // handler in flow(), but adding and removing repeatedly is
	      // too slow.
	      ondrain = pipeOnDrain(src, dest);
	      dest.on('drain', ondrain);
	    }
	  }
	  src.on('data', ondata);
	  function ondata(chunk) {
	    debug('ondata');
	    const ret = dest.write(chunk);
	    debug('dest.write', ret);
	    if (ret === false) {
	      pause();
	    }
	  }

	  // If the dest has an error, then stop piping into it.
	  // However, don't suppress the throwing behavior for this.
	  function onerror(er) {
	    debug('onerror', er);
	    unpipe();
	    dest.removeListener('error', onerror);
	    if (dest.listenerCount('error') === 0) {
	      const s = dest._writableState || dest._readableState;
	      if (s && !s.errorEmitted) {
	        // User incorrectly emitted 'error' directly on the stream.
	        errorOrDestroy(dest, er);
	      } else {
	        dest.emit('error', er);
	      }
	    }
	  }

	  // Make sure our error handler is attached before userland ones.
	  prependListener(dest, 'error', onerror);

	  // Both close and finish should trigger unpipe, but only once.
	  function onclose() {
	    dest.removeListener('finish', onfinish);
	    unpipe();
	  }
	  dest.once('close', onclose);
	  function onfinish() {
	    debug('onfinish');
	    dest.removeListener('close', onclose);
	    unpipe();
	  }
	  dest.once('finish', onfinish);
	  function unpipe() {
	    debug('unpipe');
	    src.unpipe(dest);
	  }

	  // Tell the dest that it's being piped to.
	  dest.emit('pipe', src);

	  // Start the flow if it hasn't been started already.

	  if (dest.writableNeedDrain === true) {
	    pause();
	  } else if (!state.flowing) {
	    debug('pipe resume');
	    src.resume();
	  }
	  return dest
	};
	function pipeOnDrain(src, dest) {
	  return function pipeOnDrainFunctionResult() {
	    const state = src._readableState;

	    // `ondrain` will call directly,
	    // `this` maybe not a reference to dest,
	    // so we use the real dest here.
	    if (state.awaitDrainWriters === dest) {
	      debug('pipeOnDrain', 1);
	      state.awaitDrainWriters = null;
	    } else if (state.multiAwaitDrain) {
	      debug('pipeOnDrain', state.awaitDrainWriters.size);
	      state.awaitDrainWriters.delete(dest);
	    }
	    if ((!state.awaitDrainWriters || state.awaitDrainWriters.size === 0) && src.listenerCount('data')) {
	      src.resume();
	    }
	  }
	}
	Readable.prototype.unpipe = function (dest) {
	  const state = this._readableState;
	  const unpipeInfo = {
	    hasUnpiped: false
	  };

	  // If we're not piping anywhere, then do nothing.
	  if (state.pipes.length === 0) return this
	  if (!dest) {
	    // remove all.
	    const dests = state.pipes;
	    state.pipes = [];
	    this.pause();
	    for (let i = 0; i < dests.length; i++)
	      dests[i].emit('unpipe', this, {
	        hasUnpiped: false
	      });
	    return this
	  }

	  // Try to find the right one.
	  const index = ArrayPrototypeIndexOf(state.pipes, dest);
	  if (index === -1) return this
	  state.pipes.splice(index, 1);
	  if (state.pipes.length === 0) this.pause();
	  dest.emit('unpipe', this, unpipeInfo);
	  return this
	};

	// Set up data events if they are asked for
	// Ensure readable listeners eventually get something.
	Readable.prototype.on = function (ev, fn) {
	  const res = Stream.prototype.on.call(this, ev, fn);
	  const state = this._readableState;
	  if (ev === 'data') {
	    // Update readableListening so that resume() may be a no-op
	    // a few lines down. This is needed to support once('readable').
	    state.readableListening = this.listenerCount('readable') > 0;

	    // Try start flowing on next tick if stream isn't explicitly paused.
	    if (state.flowing !== false) this.resume();
	  } else if (ev === 'readable') {
	    if (!state.endEmitted && !state.readableListening) {
	      state.readableListening = state.needReadable = true;
	      state.flowing = false;
	      state.emittedReadable = false;
	      debug('on readable', state.length, state.reading);
	      if (state.length) {
	        emitReadable(this);
	      } else if (!state.reading) {
	        process.nextTick(nReadingNextTick, this);
	      }
	    }
	  }
	  return res
	};
	Readable.prototype.addListener = Readable.prototype.on;
	Readable.prototype.removeListener = function (ev, fn) {
	  const res = Stream.prototype.removeListener.call(this, ev, fn);
	  if (ev === 'readable') {
	    // We need to check if there is someone still listening to
	    // readable and reset the state. However this needs to happen
	    // after readable has been emitted but before I/O (nextTick) to
	    // support once('readable', fn) cycles. This means that calling
	    // resume within the same tick will have no
	    // effect.
	    process.nextTick(updateReadableListening, this);
	  }
	  return res
	};
	Readable.prototype.off = Readable.prototype.removeListener;
	Readable.prototype.removeAllListeners = function (ev) {
	  const res = Stream.prototype.removeAllListeners.apply(this, arguments);
	  if (ev === 'readable' || ev === undefined) {
	    // We need to check if there is someone still listening to
	    // readable and reset the state. However this needs to happen
	    // after readable has been emitted but before I/O (nextTick) to
	    // support once('readable', fn) cycles. This means that calling
	    // resume within the same tick will have no
	    // effect.
	    process.nextTick(updateReadableListening, this);
	  }
	  return res
	};
	function updateReadableListening(self) {
	  const state = self._readableState;
	  state.readableListening = self.listenerCount('readable') > 0;
	  if (state.resumeScheduled && state[kPaused] === false) {
	    // Flowing needs to be set to true now, otherwise
	    // the upcoming resume will not flow.
	    state.flowing = true;

	    // Crude way to check if we should resume.
	  } else if (self.listenerCount('data') > 0) {
	    self.resume();
	  } else if (!state.readableListening) {
	    state.flowing = null;
	  }
	}
	function nReadingNextTick(self) {
	  debug('readable nexttick read 0');
	  self.read(0);
	}

	// pause() and resume() are remnants of the legacy readable stream API
	// If the user uses them, then switch into old mode.
	Readable.prototype.resume = function () {
	  const state = this._readableState;
	  if (!state.flowing) {
	    debug('resume');
	    // We flow only if there is no one listening
	    // for readable, but we still have to call
	    // resume().
	    state.flowing = !state.readableListening;
	    resume(this, state);
	  }
	  state[kPaused] = false;
	  return this
	};
	function resume(stream, state) {
	  if (!state.resumeScheduled) {
	    state.resumeScheduled = true;
	    process.nextTick(resume_, stream, state);
	  }
	}
	function resume_(stream, state) {
	  debug('resume', state.reading);
	  if (!state.reading) {
	    stream.read(0);
	  }
	  state.resumeScheduled = false;
	  stream.emit('resume');
	  flow(stream);
	  if (state.flowing && !state.reading) stream.read(0);
	}
	Readable.prototype.pause = function () {
	  debug('call pause flowing=%j', this._readableState.flowing);
	  if (this._readableState.flowing !== false) {
	    debug('pause');
	    this._readableState.flowing = false;
	    this.emit('pause');
	  }
	  this._readableState[kPaused] = true;
	  return this
	};
	function flow(stream) {
	  const state = stream._readableState;
	  debug('flow', state.flowing);
	  while (state.flowing && stream.read() !== null);
	}

	// Wrap an old-style stream as the async data source.
	// This is *not* part of the readable stream interface.
	// It is an ugly unfortunate mess of history.
	Readable.prototype.wrap = function (stream) {
	  let paused = false;

	  // TODO (ronag): Should this.destroy(err) emit
	  // 'error' on the wrapped stream? Would require
	  // a static factory method, e.g. Readable.wrap(stream).

	  stream.on('data', (chunk) => {
	    if (!this.push(chunk) && stream.pause) {
	      paused = true;
	      stream.pause();
	    }
	  });
	  stream.on('end', () => {
	    this.push(null);
	  });
	  stream.on('error', (err) => {
	    errorOrDestroy(this, err);
	  });
	  stream.on('close', () => {
	    this.destroy();
	  });
	  stream.on('destroy', () => {
	    this.destroy();
	  });
	  this._read = () => {
	    if (paused && stream.resume) {
	      paused = false;
	      stream.resume();
	    }
	  };

	  // Proxy all the other methods. Important when wrapping filters and duplexes.
	  const streamKeys = ObjectKeys(stream);
	  for (let j = 1; j < streamKeys.length; j++) {
	    const i = streamKeys[j];
	    if (this[i] === undefined && typeof stream[i] === 'function') {
	      this[i] = stream[i].bind(stream);
	    }
	  }
	  return this
	};
	Readable.prototype[SymbolAsyncIterator] = function () {
	  return streamToAsyncIterator(this)
	};
	Readable.prototype.iterator = function (options) {
	  if (options !== undefined) {
	    validateObject(options, 'options');
	  }
	  return streamToAsyncIterator(this, options)
	};
	function streamToAsyncIterator(stream, options) {
	  if (typeof stream.read !== 'function') {
	    stream = Readable.wrap(stream, {
	      objectMode: true
	    });
	  }
	  const iter = createAsyncIterator(stream, options);
	  iter.stream = stream;
	  return iter
	}
	async function* createAsyncIterator(stream, options) {
	  let callback = nop;
	  function next(resolve) {
	    if (this === stream) {
	      callback();
	      callback = nop;
	    } else {
	      callback = resolve;
	    }
	  }
	  stream.on('readable', next);
	  let error;
	  const cleanup = eos(
	    stream,
	    {
	      writable: false
	    },
	    (err) => {
	      error = err ? aggregateTwoErrors(error, err) : null;
	      callback();
	      callback = nop;
	    }
	  );
	  try {
	    while (true) {
	      const chunk = stream.destroyed ? null : stream.read();
	      if (chunk !== null) {
	        yield chunk;
	      } else if (error) {
	        throw error
	      } else if (error === null) {
	        return
	      } else {
	        await new Promise(next);
	      }
	    }
	  } catch (err) {
	    error = aggregateTwoErrors(error, err);
	    throw error
	  } finally {
	    if (
	      (error || (options === null || options === undefined ? undefined : options.destroyOnReturn) !== false) &&
	      (error === undefined || stream._readableState.autoDestroy)
	    ) {
	      destroyImpl.destroyer(stream, null);
	    } else {
	      stream.off('readable', next);
	      cleanup();
	    }
	  }
	}

	// Making it explicit these properties are not enumerable
	// because otherwise some prototype manipulation in
	// userland will fail.
	ObjectDefineProperties(Readable.prototype, {
	  readable: {
	    __proto__: null,
	    get() {
	      const r = this._readableState;
	      // r.readable === false means that this is part of a Duplex stream
	      // where the readable side was disabled upon construction.
	      // Compat. The user might manually disable readable side through
	      // deprecated setter.
	      return !!r && r.readable !== false && !r.destroyed && !r.errorEmitted && !r.endEmitted
	    },
	    set(val) {
	      // Backwards compat.
	      if (this._readableState) {
	        this._readableState.readable = !!val;
	      }
	    }
	  },
	  readableDidRead: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return this._readableState.dataEmitted
	    }
	  },
	  readableAborted: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return !!(
	        this._readableState.readable !== false &&
	        (this._readableState.destroyed || this._readableState.errored) &&
	        !this._readableState.endEmitted
	      )
	    }
	  },
	  readableHighWaterMark: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return this._readableState.highWaterMark
	    }
	  },
	  readableBuffer: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return this._readableState && this._readableState.buffer
	    }
	  },
	  readableFlowing: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return this._readableState.flowing
	    },
	    set: function (state) {
	      if (this._readableState) {
	        this._readableState.flowing = state;
	      }
	    }
	  },
	  readableLength: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState.length
	    }
	  },
	  readableObjectMode: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState ? this._readableState.objectMode : false
	    }
	  },
	  readableEncoding: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState ? this._readableState.encoding : null
	    }
	  },
	  errored: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState ? this._readableState.errored : null
	    }
	  },
	  closed: {
	    __proto__: null,
	    get() {
	      return this._readableState ? this._readableState.closed : false
	    }
	  },
	  destroyed: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState ? this._readableState.destroyed : false
	    },
	    set(value) {
	      // We ignore the value if the stream
	      // has not been initialized yet.
	      if (!this._readableState) {
	        return
	      }

	      // Backward compatibility, the user is explicitly
	      // managing destroyed.
	      this._readableState.destroyed = value;
	    }
	  },
	  readableEnded: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._readableState ? this._readableState.endEmitted : false
	    }
	  }
	});
	ObjectDefineProperties(ReadableState.prototype, {
	  // Legacy getter for `pipesCount`.
	  pipesCount: {
	    __proto__: null,
	    get() {
	      return this.pipes.length
	    }
	  },
	  // Legacy property for `paused`.
	  paused: {
	    __proto__: null,
	    get() {
	      return this[kPaused] !== false
	    },
	    set(value) {
	      this[kPaused] = !!value;
	    }
	  }
	});

	// Exposed for testing purposes only.
	Readable._fromList = fromList;

	// Pluck off n bytes from an array of buffers.
	// Length is the combined lengths of all the buffers in the list.
	// This function is designed to be inlinable, so please take care when making
	// changes to the function body.
	function fromList(n, state) {
	  // nothing buffered.
	  if (state.length === 0) return null
	  let ret;
	  if (state.objectMode) ret = state.buffer.shift();
	  else if (!n || n >= state.length) {
	    // Read it all, truncate the list.
	    if (state.decoder) ret = state.buffer.join('');
	    else if (state.buffer.length === 1) ret = state.buffer.first();
	    else ret = state.buffer.concat(state.length);
	    state.buffer.clear();
	  } else {
	    // read part of list.
	    ret = state.buffer.consume(n, state.decoder);
	  }
	  return ret
	}
	function endReadable(stream) {
	  const state = stream._readableState;
	  debug('endReadable', state.endEmitted);
	  if (!state.endEmitted) {
	    state.ended = true;
	    process.nextTick(endReadableNT, state, stream);
	  }
	}
	function endReadableNT(state, stream) {
	  debug('endReadableNT', state.endEmitted, state.length);

	  // Check that we didn't get one last unshift.
	  if (!state.errored && !state.closeEmitted && !state.endEmitted && state.length === 0) {
	    state.endEmitted = true;
	    stream.emit('end');
	    if (stream.writable && stream.allowHalfOpen === false) {
	      process.nextTick(endWritableNT, stream);
	    } else if (state.autoDestroy) {
	      // In case of duplex streams we need a way to detect
	      // if the writable side is ready for autoDestroy as well.
	      const wState = stream._writableState;
	      const autoDestroy =
	        !wState ||
	        (wState.autoDestroy &&
	          // We don't expect the writable to ever 'finish'
	          // if writable is explicitly set to false.
	          (wState.finished || wState.writable === false));
	      if (autoDestroy) {
	        stream.destroy();
	      }
	    }
	  }
	}
	function endWritableNT(stream) {
	  const writable = stream.writable && !stream.writableEnded && !stream.destroyed;
	  if (writable) {
	    stream.end();
	  }
	}
	Readable.from = function (iterable, opts) {
	  return from(Readable, iterable, opts)
	};
	let webStreamsAdapters;

	// Lazy to avoid circular references
	function lazyWebStreams() {
	  if (webStreamsAdapters === undefined) webStreamsAdapters = {};
	  return webStreamsAdapters
	}
	Readable.fromWeb = function (readableStream, options) {
	  return lazyWebStreams().newStreamReadableFromReadableStream(readableStream, options)
	};
	Readable.toWeb = function (streamReadable, options) {
	  return lazyWebStreams().newReadableStreamFromStreamReadable(streamReadable, options)
	};
	Readable.wrap = function (src, options) {
	  var _ref, _src$readableObjectMo;
	  return new Readable({
	    objectMode:
	      (_ref =
	        (_src$readableObjectMo = src.readableObjectMode) !== null && _src$readableObjectMo !== undefined
	          ? _src$readableObjectMo
	          : src.objectMode) !== null && _ref !== undefined
	        ? _ref
	        : true,
	    ...options,
	    destroy(err, callback) {
	      destroyImpl.destroyer(src, err);
	      callback(err);
	    }
	  }).wrap(src)
	};
	return readable;
}

var writable;
var hasRequiredWritable;

function requireWritable () {
	if (hasRequiredWritable) return writable;
	hasRequiredWritable = 1;

	/* replacement start */

	const process = requireBrowser$2();

	/* replacement end */

	const {
	  ArrayPrototypeSlice,
	  Error,
	  FunctionPrototypeSymbolHasInstance,
	  ObjectDefineProperty,
	  ObjectDefineProperties,
	  ObjectSetPrototypeOf,
	  StringPrototypeToLowerCase,
	  Symbol,
	  SymbolHasInstance
	} = requirePrimordials();
	writable = Writable;
	Writable.WritableState = WritableState;
	const { EventEmitter: EE } = requireEvents();
	const Stream = requireLegacy().Stream;
	const { Buffer } = require$$0$2;
	const destroyImpl = requireDestroy();
	const { addAbortSignal } = requireAddAbortSignal();
	const { getHighWaterMark, getDefaultHighWaterMark } = requireState();
	const {
	  ERR_INVALID_ARG_TYPE,
	  ERR_METHOD_NOT_IMPLEMENTED,
	  ERR_MULTIPLE_CALLBACK,
	  ERR_STREAM_CANNOT_PIPE,
	  ERR_STREAM_DESTROYED,
	  ERR_STREAM_ALREADY_FINISHED,
	  ERR_STREAM_NULL_VALUES,
	  ERR_STREAM_WRITE_AFTER_END,
	  ERR_UNKNOWN_ENCODING
	} = requireErrors().codes;
	const { errorOrDestroy } = destroyImpl;
	ObjectSetPrototypeOf(Writable.prototype, Stream.prototype);
	ObjectSetPrototypeOf(Writable, Stream);
	function nop() {}
	const kOnFinished = Symbol('kOnFinished');
	function WritableState(options, stream, isDuplex) {
	  // Duplex streams are both readable and writable, but share
	  // the same options object.
	  // However, some cases require setting options to different
	  // values for the readable and the writable sides of the duplex stream,
	  // e.g. options.readableObjectMode vs. options.writableObjectMode, etc.
	  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof requireDuplex();

	  // Object stream flag to indicate whether or not this stream
	  // contains buffers or objects.
	  this.objectMode = !!(options && options.objectMode);
	  if (isDuplex) this.objectMode = this.objectMode || !!(options && options.writableObjectMode);

	  // The point at which write() starts returning false
	  // Note: 0 is a valid value, means that we always return false if
	  // the entire buffer is not flushed immediately on write().
	  this.highWaterMark = options
	    ? getHighWaterMark(this, options, 'writableHighWaterMark', isDuplex)
	    : getDefaultHighWaterMark(false);

	  // if _final has been called.
	  this.finalCalled = false;

	  // drain event flag.
	  this.needDrain = false;
	  // At the start of calling end()
	  this.ending = false;
	  // When end() has been called, and returned.
	  this.ended = false;
	  // When 'finish' is emitted.
	  this.finished = false;

	  // Has it been destroyed
	  this.destroyed = false;

	  // Should we decode strings into buffers before passing to _write?
	  // this is here so that some node-core streams can optimize string
	  // handling at a lower level.
	  const noDecode = !!(options && options.decodeStrings === false);
	  this.decodeStrings = !noDecode;

	  // Crypto is kind of old and crusty.  Historically, its default string
	  // encoding is 'binary' so we have to make this configurable.
	  // Everything else in the universe uses 'utf8', though.
	  this.defaultEncoding = (options && options.defaultEncoding) || 'utf8';

	  // Not an actual buffer we keep track of, but a measurement
	  // of how much we're waiting to get pushed to some underlying
	  // socket or file.
	  this.length = 0;

	  // A flag to see when we're in the middle of a write.
	  this.writing = false;

	  // When true all writes will be buffered until .uncork() call.
	  this.corked = 0;

	  // A flag to be able to tell if the onwrite cb is called immediately,
	  // or on a later tick.  We set this to true at first, because any
	  // actions that shouldn't happen until "later" should generally also
	  // not happen before the first write call.
	  this.sync = true;

	  // A flag to know if we're processing previously buffered items, which
	  // may call the _write() callback in the same tick, so that we don't
	  // end up in an overlapped onwrite situation.
	  this.bufferProcessing = false;

	  // The callback that's passed to _write(chunk, cb).
	  this.onwrite = onwrite.bind(undefined, stream);

	  // The callback that the user supplies to write(chunk, encoding, cb).
	  this.writecb = null;

	  // The amount that is being written when _write is called.
	  this.writelen = 0;

	  // Storage for data passed to the afterWrite() callback in case of
	  // synchronous _write() completion.
	  this.afterWriteTickInfo = null;
	  resetBuffer(this);

	  // Number of pending user-supplied write callbacks
	  // this must be 0 before 'finish' can be emitted.
	  this.pendingcb = 0;

	  // Stream is still being constructed and cannot be
	  // destroyed until construction finished or failed.
	  // Async construction is opt in, therefore we start as
	  // constructed.
	  this.constructed = true;

	  // Emit prefinish if the only thing we're waiting for is _write cbs
	  // This is relevant for synchronous Transform streams.
	  this.prefinished = false;

	  // True if the error was already emitted and should not be thrown again.
	  this.errorEmitted = false;

	  // Should close be emitted on destroy. Defaults to true.
	  this.emitClose = !options || options.emitClose !== false;

	  // Should .destroy() be called after 'finish' (and potentially 'end').
	  this.autoDestroy = !options || options.autoDestroy !== false;

	  // Indicates whether the stream has errored. When true all write() calls
	  // should return false. This is needed since when autoDestroy
	  // is disabled we need a way to tell whether the stream has failed.
	  this.errored = null;

	  // Indicates whether the stream has finished destroying.
	  this.closed = false;

	  // True if close has been emitted or would have been emitted
	  // depending on emitClose.
	  this.closeEmitted = false;
	  this[kOnFinished] = [];
	}
	function resetBuffer(state) {
	  state.buffered = [];
	  state.bufferedIndex = 0;
	  state.allBuffers = true;
	  state.allNoop = true;
	}
	WritableState.prototype.getBuffer = function getBuffer() {
	  return ArrayPrototypeSlice(this.buffered, this.bufferedIndex)
	};
	ObjectDefineProperty(WritableState.prototype, 'bufferedRequestCount', {
	  __proto__: null,
	  get() {
	    return this.buffered.length - this.bufferedIndex
	  }
	});
	function Writable(options) {
	  // Writable ctor is applied to Duplexes, too.
	  // `realHasInstance` is necessary because using plain `instanceof`
	  // would return false, as no `_writableState` property is attached.

	  // Trying to use the custom `instanceof` for Writable here will also break the
	  // Node.js LazyTransform implementation, which has a non-trivial getter for
	  // `_writableState` that would lead to infinite recursion.

	  // Checking for a Stream.Duplex instance is faster here instead of inside
	  // the WritableState constructor, at least with V8 6.5.
	  const isDuplex = this instanceof requireDuplex();
	  if (!isDuplex && !FunctionPrototypeSymbolHasInstance(Writable, this)) return new Writable(options)
	  this._writableState = new WritableState(options, this, isDuplex);
	  if (options) {
	    if (typeof options.write === 'function') this._write = options.write;
	    if (typeof options.writev === 'function') this._writev = options.writev;
	    if (typeof options.destroy === 'function') this._destroy = options.destroy;
	    if (typeof options.final === 'function') this._final = options.final;
	    if (typeof options.construct === 'function') this._construct = options.construct;
	    if (options.signal) addAbortSignal(options.signal, this);
	  }
	  Stream.call(this, options);
	  destroyImpl.construct(this, () => {
	    const state = this._writableState;
	    if (!state.writing) {
	      clearBuffer(this, state);
	    }
	    finishMaybe(this, state);
	  });
	}
	ObjectDefineProperty(Writable, SymbolHasInstance, {
	  __proto__: null,
	  value: function (object) {
	    if (FunctionPrototypeSymbolHasInstance(this, object)) return true
	    if (this !== Writable) return false
	    return object && object._writableState instanceof WritableState
	  }
	});

	// Otherwise people can pipe Writable streams, which is just wrong.
	Writable.prototype.pipe = function () {
	  errorOrDestroy(this, new ERR_STREAM_CANNOT_PIPE());
	};
	function _write(stream, chunk, encoding, cb) {
	  const state = stream._writableState;
	  if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = state.defaultEncoding;
	  } else {
	    if (!encoding) encoding = state.defaultEncoding;
	    else if (encoding !== 'buffer' && !Buffer.isEncoding(encoding)) throw new ERR_UNKNOWN_ENCODING(encoding)
	    if (typeof cb !== 'function') cb = nop;
	  }
	  if (chunk === null) {
	    throw new ERR_STREAM_NULL_VALUES()
	  } else if (!state.objectMode) {
	    if (typeof chunk === 'string') {
	      if (state.decodeStrings !== false) {
	        chunk = Buffer.from(chunk, encoding);
	        encoding = 'buffer';
	      }
	    } else if (chunk instanceof Buffer) {
	      encoding = 'buffer';
	    } else if (Stream._isUint8Array(chunk)) {
	      chunk = Stream._uint8ArrayToBuffer(chunk);
	      encoding = 'buffer';
	    } else {
	      throw new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer', 'Uint8Array'], chunk)
	    }
	  }
	  let err;
	  if (state.ending) {
	    err = new ERR_STREAM_WRITE_AFTER_END();
	  } else if (state.destroyed) {
	    err = new ERR_STREAM_DESTROYED('write');
	  }
	  if (err) {
	    process.nextTick(cb, err);
	    errorOrDestroy(stream, err, true);
	    return err
	  }
	  state.pendingcb++;
	  return writeOrBuffer(stream, state, chunk, encoding, cb)
	}
	Writable.prototype.write = function (chunk, encoding, cb) {
	  return _write(this, chunk, encoding, cb) === true
	};
	Writable.prototype.cork = function () {
	  this._writableState.corked++;
	};
	Writable.prototype.uncork = function () {
	  const state = this._writableState;
	  if (state.corked) {
	    state.corked--;
	    if (!state.writing) clearBuffer(this, state);
	  }
	};
	Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
	  // node::ParseEncoding() requires lower case.
	  if (typeof encoding === 'string') encoding = StringPrototypeToLowerCase(encoding);
	  if (!Buffer.isEncoding(encoding)) throw new ERR_UNKNOWN_ENCODING(encoding)
	  this._writableState.defaultEncoding = encoding;
	  return this
	};

	// If we're already writing something, then just put this
	// in the queue, and wait our turn.  Otherwise, call _write
	// If we return false, then we need a drain event, so set that flag.
	function writeOrBuffer(stream, state, chunk, encoding, callback) {
	  const len = state.objectMode ? 1 : chunk.length;
	  state.length += len;

	  // stream._write resets state.length
	  const ret = state.length < state.highWaterMark;
	  // We must ensure that previous needDrain will not be reset to false.
	  if (!ret) state.needDrain = true;
	  if (state.writing || state.corked || state.errored || !state.constructed) {
	    state.buffered.push({
	      chunk,
	      encoding,
	      callback
	    });
	    if (state.allBuffers && encoding !== 'buffer') {
	      state.allBuffers = false;
	    }
	    if (state.allNoop && callback !== nop) {
	      state.allNoop = false;
	    }
	  } else {
	    state.writelen = len;
	    state.writecb = callback;
	    state.writing = true;
	    state.sync = true;
	    stream._write(chunk, encoding, state.onwrite);
	    state.sync = false;
	  }

	  // Return false if errored or destroyed in order to break
	  // any synchronous while(stream.write(data)) loops.
	  return ret && !state.errored && !state.destroyed
	}
	function doWrite(stream, state, writev, len, chunk, encoding, cb) {
	  state.writelen = len;
	  state.writecb = cb;
	  state.writing = true;
	  state.sync = true;
	  if (state.destroyed) state.onwrite(new ERR_STREAM_DESTROYED('write'));
	  else if (writev) stream._writev(chunk, state.onwrite);
	  else stream._write(chunk, encoding, state.onwrite);
	  state.sync = false;
	}
	function onwriteError(stream, state, er, cb) {
	  --state.pendingcb;
	  cb(er);
	  // Ensure callbacks are invoked even when autoDestroy is
	  // not enabled. Passing `er` here doesn't make sense since
	  // it's related to one specific write, not to the buffered
	  // writes.
	  errorBuffer(state);
	  // This can emit error, but error must always follow cb.
	  errorOrDestroy(stream, er);
	}
	function onwrite(stream, er) {
	  const state = stream._writableState;
	  const sync = state.sync;
	  const cb = state.writecb;
	  if (typeof cb !== 'function') {
	    errorOrDestroy(stream, new ERR_MULTIPLE_CALLBACK());
	    return
	  }
	  state.writing = false;
	  state.writecb = null;
	  state.length -= state.writelen;
	  state.writelen = 0;
	  if (er) {
	    // Avoid V8 leak, https://github.com/nodejs/node/pull/34103#issuecomment-652002364
	    er.stack; // eslint-disable-line no-unused-expressions

	    if (!state.errored) {
	      state.errored = er;
	    }

	    // In case of duplex streams we need to notify the readable side of the
	    // error.
	    if (stream._readableState && !stream._readableState.errored) {
	      stream._readableState.errored = er;
	    }
	    if (sync) {
	      process.nextTick(onwriteError, stream, state, er, cb);
	    } else {
	      onwriteError(stream, state, er, cb);
	    }
	  } else {
	    if (state.buffered.length > state.bufferedIndex) {
	      clearBuffer(stream, state);
	    }
	    if (sync) {
	      // It is a common case that the callback passed to .write() is always
	      // the same. In that case, we do not schedule a new nextTick(), but
	      // rather just increase a counter, to improve performance and avoid
	      // memory allocations.
	      if (state.afterWriteTickInfo !== null && state.afterWriteTickInfo.cb === cb) {
	        state.afterWriteTickInfo.count++;
	      } else {
	        state.afterWriteTickInfo = {
	          count: 1,
	          cb,
	          stream,
	          state
	        };
	        process.nextTick(afterWriteTick, state.afterWriteTickInfo);
	      }
	    } else {
	      afterWrite(stream, state, 1, cb);
	    }
	  }
	}
	function afterWriteTick({ stream, state, count, cb }) {
	  state.afterWriteTickInfo = null;
	  return afterWrite(stream, state, count, cb)
	}
	function afterWrite(stream, state, count, cb) {
	  const needDrain = !state.ending && !stream.destroyed && state.length === 0 && state.needDrain;
	  if (needDrain) {
	    state.needDrain = false;
	    stream.emit('drain');
	  }
	  while (count-- > 0) {
	    state.pendingcb--;
	    cb();
	  }
	  if (state.destroyed) {
	    errorBuffer(state);
	  }
	  finishMaybe(stream, state);
	}

	// If there's something in the buffer waiting, then invoke callbacks.
	function errorBuffer(state) {
	  if (state.writing) {
	    return
	  }
	  for (let n = state.bufferedIndex; n < state.buffered.length; ++n) {
	    var _state$errored;
	    const { chunk, callback } = state.buffered[n];
	    const len = state.objectMode ? 1 : chunk.length;
	    state.length -= len;
	    callback(
	      (_state$errored = state.errored) !== null && _state$errored !== undefined
	        ? _state$errored
	        : new ERR_STREAM_DESTROYED('write')
	    );
	  }
	  const onfinishCallbacks = state[kOnFinished].splice(0);
	  for (let i = 0; i < onfinishCallbacks.length; i++) {
	    var _state$errored2;
	    onfinishCallbacks[i](
	      (_state$errored2 = state.errored) !== null && _state$errored2 !== undefined
	        ? _state$errored2
	        : new ERR_STREAM_DESTROYED('end')
	    );
	  }
	  resetBuffer(state);
	}

	// If there's something in the buffer waiting, then process it.
	function clearBuffer(stream, state) {
	  if (state.corked || state.bufferProcessing || state.destroyed || !state.constructed) {
	    return
	  }
	  const { buffered, bufferedIndex, objectMode } = state;
	  const bufferedLength = buffered.length - bufferedIndex;
	  if (!bufferedLength) {
	    return
	  }
	  let i = bufferedIndex;
	  state.bufferProcessing = true;
	  if (bufferedLength > 1 && stream._writev) {
	    state.pendingcb -= bufferedLength - 1;
	    const callback = state.allNoop
	      ? nop
	      : (err) => {
	          for (let n = i; n < buffered.length; ++n) {
	            buffered[n].callback(err);
	          }
	        };
	    // Make a copy of `buffered` if it's going to be used by `callback` above,
	    // since `doWrite` will mutate the array.
	    const chunks = state.allNoop && i === 0 ? buffered : ArrayPrototypeSlice(buffered, i);
	    chunks.allBuffers = state.allBuffers;
	    doWrite(stream, state, true, state.length, chunks, '', callback);
	    resetBuffer(state);
	  } else {
	    do {
	      const { chunk, encoding, callback } = buffered[i];
	      buffered[i++] = null;
	      const len = objectMode ? 1 : chunk.length;
	      doWrite(stream, state, false, len, chunk, encoding, callback);
	    } while (i < buffered.length && !state.writing)
	    if (i === buffered.length) {
	      resetBuffer(state);
	    } else if (i > 256) {
	      buffered.splice(0, i);
	      state.bufferedIndex = 0;
	    } else {
	      state.bufferedIndex = i;
	    }
	  }
	  state.bufferProcessing = false;
	}
	Writable.prototype._write = function (chunk, encoding, cb) {
	  if (this._writev) {
	    this._writev(
	      [
	        {
	          chunk,
	          encoding
	        }
	      ],
	      cb
	    );
	  } else {
	    throw new ERR_METHOD_NOT_IMPLEMENTED('_write()')
	  }
	};
	Writable.prototype._writev = null;
	Writable.prototype.end = function (chunk, encoding, cb) {
	  const state = this._writableState;
	  if (typeof chunk === 'function') {
	    cb = chunk;
	    chunk = null;
	    encoding = null;
	  } else if (typeof encoding === 'function') {
	    cb = encoding;
	    encoding = null;
	  }
	  let err;
	  if (chunk !== null && chunk !== undefined) {
	    const ret = _write(this, chunk, encoding);
	    if (ret instanceof Error) {
	      err = ret;
	    }
	  }

	  // .end() fully uncorks.
	  if (state.corked) {
	    state.corked = 1;
	    this.uncork();
	  }
	  if (err) ; else if (!state.errored && !state.ending) {
	    // This is forgiving in terms of unnecessary calls to end() and can hide
	    // logic errors. However, usually such errors are harmless and causing a
	    // hard error can be disproportionately destructive. It is not always
	    // trivial for the user to determine whether end() needs to be called
	    // or not.

	    state.ending = true;
	    finishMaybe(this, state, true);
	    state.ended = true;
	  } else if (state.finished) {
	    err = new ERR_STREAM_ALREADY_FINISHED('end');
	  } else if (state.destroyed) {
	    err = new ERR_STREAM_DESTROYED('end');
	  }
	  if (typeof cb === 'function') {
	    if (err || state.finished) {
	      process.nextTick(cb, err);
	    } else {
	      state[kOnFinished].push(cb);
	    }
	  }
	  return this
	};
	function needFinish(state) {
	  return (
	    state.ending &&
	    !state.destroyed &&
	    state.constructed &&
	    state.length === 0 &&
	    !state.errored &&
	    state.buffered.length === 0 &&
	    !state.finished &&
	    !state.writing &&
	    !state.errorEmitted &&
	    !state.closeEmitted
	  )
	}
	function callFinal(stream, state) {
	  let called = false;
	  function onFinish(err) {
	    if (called) {
	      errorOrDestroy(stream, err !== null && err !== undefined ? err : ERR_MULTIPLE_CALLBACK());
	      return
	    }
	    called = true;
	    state.pendingcb--;
	    if (err) {
	      const onfinishCallbacks = state[kOnFinished].splice(0);
	      for (let i = 0; i < onfinishCallbacks.length; i++) {
	        onfinishCallbacks[i](err);
	      }
	      errorOrDestroy(stream, err, state.sync);
	    } else if (needFinish(state)) {
	      state.prefinished = true;
	      stream.emit('prefinish');
	      // Backwards compat. Don't check state.sync here.
	      // Some streams assume 'finish' will be emitted
	      // asynchronously relative to _final callback.
	      state.pendingcb++;
	      process.nextTick(finish, stream, state);
	    }
	  }
	  state.sync = true;
	  state.pendingcb++;
	  try {
	    stream._final(onFinish);
	  } catch (err) {
	    onFinish(err);
	  }
	  state.sync = false;
	}
	function prefinish(stream, state) {
	  if (!state.prefinished && !state.finalCalled) {
	    if (typeof stream._final === 'function' && !state.destroyed) {
	      state.finalCalled = true;
	      callFinal(stream, state);
	    } else {
	      state.prefinished = true;
	      stream.emit('prefinish');
	    }
	  }
	}
	function finishMaybe(stream, state, sync) {
	  if (needFinish(state)) {
	    prefinish(stream, state);
	    if (state.pendingcb === 0) {
	      if (sync) {
	        state.pendingcb++;
	        process.nextTick(
	          (stream, state) => {
	            if (needFinish(state)) {
	              finish(stream, state);
	            } else {
	              state.pendingcb--;
	            }
	          },
	          stream,
	          state
	        );
	      } else if (needFinish(state)) {
	        state.pendingcb++;
	        finish(stream, state);
	      }
	    }
	  }
	}
	function finish(stream, state) {
	  state.pendingcb--;
	  state.finished = true;
	  const onfinishCallbacks = state[kOnFinished].splice(0);
	  for (let i = 0; i < onfinishCallbacks.length; i++) {
	    onfinishCallbacks[i]();
	  }
	  stream.emit('finish');
	  if (state.autoDestroy) {
	    // In case of duplex streams we need a way to detect
	    // if the readable side is ready for autoDestroy as well.
	    const rState = stream._readableState;
	    const autoDestroy =
	      !rState ||
	      (rState.autoDestroy &&
	        // We don't expect the readable to ever 'end'
	        // if readable is explicitly set to false.
	        (rState.endEmitted || rState.readable === false));
	    if (autoDestroy) {
	      stream.destroy();
	    }
	  }
	}
	ObjectDefineProperties(Writable.prototype, {
	  closed: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.closed : false
	    }
	  },
	  destroyed: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.destroyed : false
	    },
	    set(value) {
	      // Backward compatibility, the user is explicitly managing destroyed.
	      if (this._writableState) {
	        this._writableState.destroyed = value;
	      }
	    }
	  },
	  writable: {
	    __proto__: null,
	    get() {
	      const w = this._writableState;
	      // w.writable === false means that this is part of a Duplex stream
	      // where the writable side was disabled upon construction.
	      // Compat. The user might manually disable writable side through
	      // deprecated setter.
	      return !!w && w.writable !== false && !w.destroyed && !w.errored && !w.ending && !w.ended
	    },
	    set(val) {
	      // Backwards compatible.
	      if (this._writableState) {
	        this._writableState.writable = !!val;
	      }
	    }
	  },
	  writableFinished: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.finished : false
	    }
	  },
	  writableObjectMode: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.objectMode : false
	    }
	  },
	  writableBuffer: {
	    __proto__: null,
	    get() {
	      return this._writableState && this._writableState.getBuffer()
	    }
	  },
	  writableEnded: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.ending : false
	    }
	  },
	  writableNeedDrain: {
	    __proto__: null,
	    get() {
	      const wState = this._writableState;
	      if (!wState) return false
	      return !wState.destroyed && !wState.ending && wState.needDrain
	    }
	  },
	  writableHighWaterMark: {
	    __proto__: null,
	    get() {
	      return this._writableState && this._writableState.highWaterMark
	    }
	  },
	  writableCorked: {
	    __proto__: null,
	    get() {
	      return this._writableState ? this._writableState.corked : 0
	    }
	  },
	  writableLength: {
	    __proto__: null,
	    get() {
	      return this._writableState && this._writableState.length
	    }
	  },
	  errored: {
	    __proto__: null,
	    enumerable: false,
	    get() {
	      return this._writableState ? this._writableState.errored : null
	    }
	  },
	  writableAborted: {
	    __proto__: null,
	    enumerable: false,
	    get: function () {
	      return !!(
	        this._writableState.writable !== false &&
	        (this._writableState.destroyed || this._writableState.errored) &&
	        !this._writableState.finished
	      )
	    }
	  }
	});
	const destroy = destroyImpl.destroy;
	Writable.prototype.destroy = function (err, cb) {
	  const state = this._writableState;

	  // Invoke pending callbacks.
	  if (!state.destroyed && (state.bufferedIndex < state.buffered.length || state[kOnFinished].length)) {
	    process.nextTick(errorBuffer, state);
	  }
	  destroy.call(this, err, cb);
	  return this
	};
	Writable.prototype._undestroy = destroyImpl.undestroy;
	Writable.prototype._destroy = function (err, cb) {
	  cb(err);
	};
	Writable.prototype[EE.captureRejectionSymbol] = function (err) {
	  this.destroy(err);
	};
	let webStreamsAdapters;

	// Lazy to avoid circular references
	function lazyWebStreams() {
	  if (webStreamsAdapters === undefined) webStreamsAdapters = {};
	  return webStreamsAdapters
	}
	Writable.fromWeb = function (writableStream, options) {
	  return lazyWebStreams().newStreamWritableFromWritableStream(writableStream, options)
	};
	Writable.toWeb = function (streamWritable) {
	  return lazyWebStreams().newWritableStreamFromStreamWritable(streamWritable)
	};
	return writable;
}

/* replacement start */

var duplexify;
var hasRequiredDuplexify;

function requireDuplexify () {
	if (hasRequiredDuplexify) return duplexify;
	hasRequiredDuplexify = 1;
	const process = requireBrowser$2()

	/* replacement end */

	;	const bufferModule = require$$0$2;
	const {
	  isReadable,
	  isWritable,
	  isIterable,
	  isNodeStream,
	  isReadableNodeStream,
	  isWritableNodeStream,
	  isDuplexNodeStream,
	  isReadableStream,
	  isWritableStream
	} = requireUtils$1();
	const eos = requireEndOfStream();
	const {
	  AbortError,
	  codes: { ERR_INVALID_ARG_TYPE, ERR_INVALID_RETURN_VALUE }
	} = requireErrors();
	const { destroyer } = requireDestroy();
	const Duplex = requireDuplex();
	const Readable = requireReadable();
	const Writable = requireWritable();
	const { createDeferredPromise } = requireUtil$2();
	const from = requireFrom();
	const Blob = globalThis.Blob || bufferModule.Blob;
	const isBlob =
	  typeof Blob !== 'undefined'
	    ? function isBlob(b) {
	        return b instanceof Blob
	      }
	    : function isBlob(b) {
	        return false
	      };
	const AbortController = globalThis.AbortController || requireBrowser$1().AbortController;
	const { FunctionPrototypeCall } = requirePrimordials();

	// This is needed for pre node 17.
	class Duplexify extends Duplex {
	  constructor(options) {
	    super(options);

	    // https://github.com/nodejs/node/pull/34385

	    if ((options === null || options === undefined ? undefined : options.readable) === false) {
	      this._readableState.readable = false;
	      this._readableState.ended = true;
	      this._readableState.endEmitted = true;
	    }
	    if ((options === null || options === undefined ? undefined : options.writable) === false) {
	      this._writableState.writable = false;
	      this._writableState.ending = true;
	      this._writableState.ended = true;
	      this._writableState.finished = true;
	    }
	  }
	}
	duplexify = function duplexify(body, name) {
	  if (isDuplexNodeStream(body)) {
	    return body
	  }
	  if (isReadableNodeStream(body)) {
	    return _duplexify({
	      readable: body
	    })
	  }
	  if (isWritableNodeStream(body)) {
	    return _duplexify({
	      writable: body
	    })
	  }
	  if (isNodeStream(body)) {
	    return _duplexify({
	      writable: false,
	      readable: false
	    })
	  }
	  if (isReadableStream(body)) {
	    return _duplexify({
	      readable: Readable.fromWeb(body)
	    })
	  }
	  if (isWritableStream(body)) {
	    return _duplexify({
	      writable: Writable.fromWeb(body)
	    })
	  }
	  if (typeof body === 'function') {
	    const { value, write, final, destroy } = fromAsyncGen(body);
	    if (isIterable(value)) {
	      return from(Duplexify, value, {
	        // TODO (ronag): highWaterMark?
	        objectMode: true,
	        write,
	        final,
	        destroy
	      })
	    }
	    const then = value === null || value === undefined ? undefined : value.then;
	    if (typeof then === 'function') {
	      let d;
	      const promise = FunctionPrototypeCall(
	        then,
	        value,
	        (val) => {
	          if (val != null) {
	            throw new ERR_INVALID_RETURN_VALUE('nully', 'body', val)
	          }
	        },
	        (err) => {
	          destroyer(d, err);
	        }
	      );
	      return (d = new Duplexify({
	        // TODO (ronag): highWaterMark?
	        objectMode: true,
	        readable: false,
	        write,
	        final(cb) {
	          final(async () => {
	            try {
	              await promise;
	              process.nextTick(cb, null);
	            } catch (err) {
	              process.nextTick(cb, err);
	            }
	          });
	        },
	        destroy
	      }))
	    }
	    throw new ERR_INVALID_RETURN_VALUE('Iterable, AsyncIterable or AsyncFunction', name, value)
	  }
	  if (isBlob(body)) {
	    return duplexify(body.arrayBuffer())
	  }
	  if (isIterable(body)) {
	    return from(Duplexify, body, {
	      // TODO (ronag): highWaterMark?
	      objectMode: true,
	      writable: false
	    })
	  }
	  if (
	    isReadableStream(body === null || body === undefined ? undefined : body.readable) &&
	    isWritableStream(body === null || body === undefined ? undefined : body.writable)
	  ) {
	    return Duplexify.fromWeb(body)
	  }
	  if (
	    typeof (body === null || body === undefined ? undefined : body.writable) === 'object' ||
	    typeof (body === null || body === undefined ? undefined : body.readable) === 'object'
	  ) {
	    const readable =
	      body !== null && body !== undefined && body.readable
	        ? isReadableNodeStream(body === null || body === undefined ? undefined : body.readable)
	          ? body === null || body === undefined
	            ? undefined
	            : body.readable
	          : duplexify(body.readable)
	        : undefined;
	    const writable =
	      body !== null && body !== undefined && body.writable
	        ? isWritableNodeStream(body === null || body === undefined ? undefined : body.writable)
	          ? body === null || body === undefined
	            ? undefined
	            : body.writable
	          : duplexify(body.writable)
	        : undefined;
	    return _duplexify({
	      readable,
	      writable
	    })
	  }
	  const then = body === null || body === undefined ? undefined : body.then;
	  if (typeof then === 'function') {
	    let d;
	    FunctionPrototypeCall(
	      then,
	      body,
	      (val) => {
	        if (val != null) {
	          d.push(val);
	        }
	        d.push(null);
	      },
	      (err) => {
	        destroyer(d, err);
	      }
	    );
	    return (d = new Duplexify({
	      objectMode: true,
	      writable: false,
	      read() {}
	    }))
	  }
	  throw new ERR_INVALID_ARG_TYPE(
	    name,
	    [
	      'Blob',
	      'ReadableStream',
	      'WritableStream',
	      'Stream',
	      'Iterable',
	      'AsyncIterable',
	      'Function',
	      '{ readable, writable } pair',
	      'Promise'
	    ],
	    body
	  )
	};
	function fromAsyncGen(fn) {
	  let { promise, resolve } = createDeferredPromise();
	  const ac = new AbortController();
	  const signal = ac.signal;
	  const value = fn(
	    (async function* () {
	      while (true) {
	        const _promise = promise;
	        promise = null;
	        const { chunk, done, cb } = await _promise;
	        process.nextTick(cb);
	        if (done) return
	        if (signal.aborted)
	          throw new AbortError(undefined, {
	            cause: signal.reason
	          })
	        ;({ promise, resolve } = createDeferredPromise());
	        yield chunk;
	      }
	    })(),
	    {
	      signal
	    }
	  );
	  return {
	    value,
	    write(chunk, encoding, cb) {
	      const _resolve = resolve;
	      resolve = null;
	      _resolve({
	        chunk,
	        done: false,
	        cb
	      });
	    },
	    final(cb) {
	      const _resolve = resolve;
	      resolve = null;
	      _resolve({
	        done: true,
	        cb
	      });
	    },
	    destroy(err, cb) {
	      ac.abort();
	      cb(err);
	    }
	  }
	}
	function _duplexify(pair) {
	  const r = pair.readable && typeof pair.readable.read !== 'function' ? Readable.wrap(pair.readable) : pair.readable;
	  const w = pair.writable;
	  let readable = !!isReadable(r);
	  let writable = !!isWritable(w);
	  let ondrain;
	  let onfinish;
	  let onreadable;
	  let onclose;
	  let d;
	  function onfinished(err) {
	    const cb = onclose;
	    onclose = null;
	    if (cb) {
	      cb(err);
	    } else if (err) {
	      d.destroy(err);
	    }
	  }

	  // TODO(ronag): Avoid double buffering.
	  // Implement Writable/Readable/Duplex traits.
	  // See, https://github.com/nodejs/node/pull/33515.
	  d = new Duplexify({
	    // TODO (ronag): highWaterMark?
	    readableObjectMode: !!(r !== null && r !== undefined && r.readableObjectMode),
	    writableObjectMode: !!(w !== null && w !== undefined && w.writableObjectMode),
	    readable,
	    writable
	  });
	  if (writable) {
	    eos(w, (err) => {
	      writable = false;
	      if (err) {
	        destroyer(r, err);
	      }
	      onfinished(err);
	    });
	    d._write = function (chunk, encoding, callback) {
	      if (w.write(chunk, encoding)) {
	        callback();
	      } else {
	        ondrain = callback;
	      }
	    };
	    d._final = function (callback) {
	      w.end();
	      onfinish = callback;
	    };
	    w.on('drain', function () {
	      if (ondrain) {
	        const cb = ondrain;
	        ondrain = null;
	        cb();
	      }
	    });
	    w.on('finish', function () {
	      if (onfinish) {
	        const cb = onfinish;
	        onfinish = null;
	        cb();
	      }
	    });
	  }
	  if (readable) {
	    eos(r, (err) => {
	      readable = false;
	      if (err) {
	        destroyer(r, err);
	      }
	      onfinished(err);
	    });
	    r.on('readable', function () {
	      if (onreadable) {
	        const cb = onreadable;
	        onreadable = null;
	        cb();
	      }
	    });
	    r.on('end', function () {
	      d.push(null);
	    });
	    d._read = function () {
	      while (true) {
	        const buf = r.read();
	        if (buf === null) {
	          onreadable = d._read;
	          return
	        }
	        if (!d.push(buf)) {
	          return
	        }
	      }
	    };
	  }
	  d._destroy = function (err, callback) {
	    if (!err && onclose !== null) {
	      err = new AbortError();
	    }
	    onreadable = null;
	    ondrain = null;
	    onfinish = null;
	    if (onclose === null) {
	      callback(err);
	    } else {
	      onclose = callback;
	      destroyer(w, err);
	      destroyer(r, err);
	    }
	  };
	  return d
	}
	return duplexify;
}

var duplex;
var hasRequiredDuplex;

function requireDuplex () {
	if (hasRequiredDuplex) return duplex;
	hasRequiredDuplex = 1;

	const {
	  ObjectDefineProperties,
	  ObjectGetOwnPropertyDescriptor,
	  ObjectKeys,
	  ObjectSetPrototypeOf
	} = requirePrimordials();
	duplex = Duplex;
	const Readable = requireReadable();
	const Writable = requireWritable();
	ObjectSetPrototypeOf(Duplex.prototype, Readable.prototype);
	ObjectSetPrototypeOf(Duplex, Readable);
	{
	  const keys = ObjectKeys(Writable.prototype);
	  // Allow the keys array to be GC'ed.
	  for (let i = 0; i < keys.length; i++) {
	    const method = keys[i];
	    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
	  }
	}
	function Duplex(options) {
	  if (!(this instanceof Duplex)) return new Duplex(options)
	  Readable.call(this, options);
	  Writable.call(this, options);
	  if (options) {
	    this.allowHalfOpen = options.allowHalfOpen !== false;
	    if (options.readable === false) {
	      this._readableState.readable = false;
	      this._readableState.ended = true;
	      this._readableState.endEmitted = true;
	    }
	    if (options.writable === false) {
	      this._writableState.writable = false;
	      this._writableState.ending = true;
	      this._writableState.ended = true;
	      this._writableState.finished = true;
	    }
	  } else {
	    this.allowHalfOpen = true;
	  }
	}
	ObjectDefineProperties(Duplex.prototype, {
	  writable: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writable')
	  },
	  writableHighWaterMark: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableHighWaterMark')
	  },
	  writableObjectMode: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableObjectMode')
	  },
	  writableBuffer: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableBuffer')
	  },
	  writableLength: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableLength')
	  },
	  writableFinished: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableFinished')
	  },
	  writableCorked: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableCorked')
	  },
	  writableEnded: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableEnded')
	  },
	  writableNeedDrain: {
	    __proto__: null,
	    ...ObjectGetOwnPropertyDescriptor(Writable.prototype, 'writableNeedDrain')
	  },
	  destroyed: {
	    __proto__: null,
	    get() {
	      if (this._readableState === undefined || this._writableState === undefined) {
	        return false
	      }
	      return this._readableState.destroyed && this._writableState.destroyed
	    },
	    set(value) {
	      // Backward compatibility, the user is explicitly
	      // managing destroyed.
	      if (this._readableState && this._writableState) {
	        this._readableState.destroyed = value;
	        this._writableState.destroyed = value;
	      }
	    }
	  }
	});
	let webStreamsAdapters;

	// Lazy to avoid circular references
	function lazyWebStreams() {
	  if (webStreamsAdapters === undefined) webStreamsAdapters = {};
	  return webStreamsAdapters
	}
	Duplex.fromWeb = function (pair, options) {
	  return lazyWebStreams().newStreamDuplexFromReadableWritablePair(pair, options)
	};
	Duplex.toWeb = function (duplex) {
	  return lazyWebStreams().newReadableWritablePairFromDuplex(duplex)
	};
	let duplexify;
	Duplex.from = function (body) {
	  if (!duplexify) {
	    duplexify = requireDuplexify();
	  }
	  return duplexify(body, 'body')
	};
	return duplex;
}

var transform;
var hasRequiredTransform;

function requireTransform () {
	if (hasRequiredTransform) return transform;
	hasRequiredTransform = 1;

	const { ObjectSetPrototypeOf, Symbol } = requirePrimordials();
	transform = Transform;
	const { ERR_METHOD_NOT_IMPLEMENTED } = requireErrors().codes;
	const Duplex = requireDuplex();
	const { getHighWaterMark } = requireState();
	ObjectSetPrototypeOf(Transform.prototype, Duplex.prototype);
	ObjectSetPrototypeOf(Transform, Duplex);
	const kCallback = Symbol('kCallback');
	function Transform(options) {
	  if (!(this instanceof Transform)) return new Transform(options)

	  // TODO (ronag): This should preferably always be
	  // applied but would be semver-major. Or even better;
	  // make Transform a Readable with the Writable interface.
	  const readableHighWaterMark = options ? getHighWaterMark(this, options, 'readableHighWaterMark', true) : null;
	  if (readableHighWaterMark === 0) {
	    // A Duplex will buffer both on the writable and readable side while
	    // a Transform just wants to buffer hwm number of elements. To avoid
	    // buffering twice we disable buffering on the writable side.
	    options = {
	      ...options,
	      highWaterMark: null,
	      readableHighWaterMark,
	      // TODO (ronag): 0 is not optimal since we have
	      // a "bug" where we check needDrain before calling _write and not after.
	      // Refs: https://github.com/nodejs/node/pull/32887
	      // Refs: https://github.com/nodejs/node/pull/35941
	      writableHighWaterMark: options.writableHighWaterMark || 0
	    };
	  }
	  Duplex.call(this, options);

	  // We have implemented the _read method, and done the other things
	  // that Readable wants before the first _read call, so unset the
	  // sync guard flag.
	  this._readableState.sync = false;
	  this[kCallback] = null;
	  if (options) {
	    if (typeof options.transform === 'function') this._transform = options.transform;
	    if (typeof options.flush === 'function') this._flush = options.flush;
	  }

	  // When the writable side finishes, then flush out anything remaining.
	  // Backwards compat. Some Transform streams incorrectly implement _final
	  // instead of or in addition to _flush. By using 'prefinish' instead of
	  // implementing _final we continue supporting this unfortunate use case.
	  this.on('prefinish', prefinish);
	}
	function final(cb) {
	  if (typeof this._flush === 'function' && !this.destroyed) {
	    this._flush((er, data) => {
	      if (er) {
	        if (cb) {
	          cb(er);
	        } else {
	          this.destroy(er);
	        }
	        return
	      }
	      if (data != null) {
	        this.push(data);
	      }
	      this.push(null);
	      if (cb) {
	        cb();
	      }
	    });
	  } else {
	    this.push(null);
	    if (cb) {
	      cb();
	    }
	  }
	}
	function prefinish() {
	  if (this._final !== final) {
	    final.call(this);
	  }
	}
	Transform.prototype._final = final;
	Transform.prototype._transform = function (chunk, encoding, callback) {
	  throw new ERR_METHOD_NOT_IMPLEMENTED('_transform()')
	};
	Transform.prototype._write = function (chunk, encoding, callback) {
	  const rState = this._readableState;
	  const wState = this._writableState;
	  const length = rState.length;
	  this._transform(chunk, encoding, (err, val) => {
	    if (err) {
	      callback(err);
	      return
	    }
	    if (val != null) {
	      this.push(val);
	    }
	    if (
	      wState.ended ||
	      // Backwards compat.
	      length === rState.length ||
	      // Backwards compat.
	      rState.length < rState.highWaterMark
	    ) {
	      callback();
	    } else {
	      this[kCallback] = callback;
	    }
	  });
	};
	Transform.prototype._read = function () {
	  if (this[kCallback]) {
	    const callback = this[kCallback];
	    this[kCallback] = null;
	    callback();
	  }
	};
	return transform;
}

var passthrough;
var hasRequiredPassthrough;

function requirePassthrough () {
	if (hasRequiredPassthrough) return passthrough;
	hasRequiredPassthrough = 1;

	const { ObjectSetPrototypeOf } = requirePrimordials();
	passthrough = PassThrough;
	const Transform = requireTransform();
	ObjectSetPrototypeOf(PassThrough.prototype, Transform.prototype);
	ObjectSetPrototypeOf(PassThrough, Transform);
	function PassThrough(options) {
	  if (!(this instanceof PassThrough)) return new PassThrough(options)
	  Transform.call(this, options);
	}
	PassThrough.prototype._transform = function (chunk, encoding, cb) {
	  cb(null, chunk);
	};
	return passthrough;
}

/* replacement start */

var pipeline_1;
var hasRequiredPipeline;

function requirePipeline () {
	if (hasRequiredPipeline) return pipeline_1;
	hasRequiredPipeline = 1;
	const process = requireBrowser$2()

	/* replacement end */
	// Ported from https://github.com/mafintosh/pump with
	// permission from the author, Mathias Buus (@mafintosh).

	;	const { ArrayIsArray, Promise, SymbolAsyncIterator, SymbolDispose } = requirePrimordials();
	const eos = requireEndOfStream();
	const { once } = requireUtil$2();
	const destroyImpl = requireDestroy();
	const Duplex = requireDuplex();
	const {
	  aggregateTwoErrors,
	  codes: {
	    ERR_INVALID_ARG_TYPE,
	    ERR_INVALID_RETURN_VALUE,
	    ERR_MISSING_ARGS,
	    ERR_STREAM_DESTROYED,
	    ERR_STREAM_PREMATURE_CLOSE
	  },
	  AbortError
	} = requireErrors();
	const { validateFunction, validateAbortSignal } = requireValidators();
	const {
	  isIterable,
	  isReadable,
	  isReadableNodeStream,
	  isNodeStream,
	  isTransformStream,
	  isWebStream,
	  isReadableStream,
	  isReadableFinished
	} = requireUtils$1();
	const AbortController = globalThis.AbortController || requireBrowser$1().AbortController;
	let PassThrough;
	let Readable;
	let addAbortListener;
	function destroyer(stream, reading, writing) {
	  let finished = false;
	  stream.on('close', () => {
	    finished = true;
	  });
	  const cleanup = eos(
	    stream,
	    {
	      readable: reading,
	      writable: writing
	    },
	    (err) => {
	      finished = !err;
	    }
	  );
	  return {
	    destroy: (err) => {
	      if (finished) return
	      finished = true;
	      destroyImpl.destroyer(stream, err || new ERR_STREAM_DESTROYED('pipe'));
	    },
	    cleanup
	  }
	}
	function popCallback(streams) {
	  // Streams should never be an empty array. It should always contain at least
	  // a single stream. Therefore optimize for the average case instead of
	  // checking for length === 0 as well.
	  validateFunction(streams[streams.length - 1], 'streams[stream.length - 1]');
	  return streams.pop()
	}
	function makeAsyncIterable(val) {
	  if (isIterable(val)) {
	    return val
	  } else if (isReadableNodeStream(val)) {
	    // Legacy streams are not Iterable.
	    return fromReadable(val)
	  }
	  throw new ERR_INVALID_ARG_TYPE('val', ['Readable', 'Iterable', 'AsyncIterable'], val)
	}
	async function* fromReadable(val) {
	  if (!Readable) {
	    Readable = requireReadable();
	  }
	  yield* Readable.prototype[SymbolAsyncIterator].call(val);
	}
	async function pumpToNode(iterable, writable, finish, { end }) {
	  let error;
	  let onresolve = null;
	  const resume = (err) => {
	    if (err) {
	      error = err;
	    }
	    if (onresolve) {
	      const callback = onresolve;
	      onresolve = null;
	      callback();
	    }
	  };
	  const wait = () =>
	    new Promise((resolve, reject) => {
	      if (error) {
	        reject(error);
	      } else {
	        onresolve = () => {
	          if (error) {
	            reject(error);
	          } else {
	            resolve();
	          }
	        };
	      }
	    });
	  writable.on('drain', resume);
	  const cleanup = eos(
	    writable,
	    {
	      readable: false
	    },
	    resume
	  );
	  try {
	    if (writable.writableNeedDrain) {
	      await wait();
	    }
	    for await (const chunk of iterable) {
	      if (!writable.write(chunk)) {
	        await wait();
	      }
	    }
	    if (end) {
	      writable.end();
	      await wait();
	    }
	    finish();
	  } catch (err) {
	    finish(error !== err ? aggregateTwoErrors(error, err) : err);
	  } finally {
	    cleanup();
	    writable.off('drain', resume);
	  }
	}
	async function pumpToWeb(readable, writable, finish, { end }) {
	  if (isTransformStream(writable)) {
	    writable = writable.writable;
	  }
	  // https://streams.spec.whatwg.org/#example-manual-write-with-backpressure
	  const writer = writable.getWriter();
	  try {
	    for await (const chunk of readable) {
	      await writer.ready;
	      writer.write(chunk).catch(() => {});
	    }
	    await writer.ready;
	    if (end) {
	      await writer.close();
	    }
	    finish();
	  } catch (err) {
	    try {
	      await writer.abort(err);
	      finish(err);
	    } catch (err) {
	      finish(err);
	    }
	  }
	}
	function pipeline(...streams) {
	  return pipelineImpl(streams, once(popCallback(streams)))
	}
	function pipelineImpl(streams, callback, opts) {
	  if (streams.length === 1 && ArrayIsArray(streams[0])) {
	    streams = streams[0];
	  }
	  if (streams.length < 2) {
	    throw new ERR_MISSING_ARGS('streams')
	  }
	  const ac = new AbortController();
	  const signal = ac.signal;
	  const outerSignal = opts === null || opts === undefined ? undefined : opts.signal;

	  // Need to cleanup event listeners if last stream is readable
	  // https://github.com/nodejs/node/issues/35452
	  const lastStreamCleanup = [];
	  validateAbortSignal(outerSignal, 'options.signal');
	  function abort() {
	    finishImpl(new AbortError());
	  }
	  addAbortListener = addAbortListener || requireUtil$2().addAbortListener;
	  let disposable;
	  if (outerSignal) {
	    disposable = addAbortListener(outerSignal, abort);
	  }
	  let error;
	  let value;
	  const destroys = [];
	  let finishCount = 0;
	  function finish(err) {
	    finishImpl(err, --finishCount === 0);
	  }
	  function finishImpl(err, final) {
	    var _disposable;
	    if (err && (!error || error.code === 'ERR_STREAM_PREMATURE_CLOSE')) {
	      error = err;
	    }
	    if (!error && !final) {
	      return
	    }
	    while (destroys.length) {
	      destroys.shift()(error);
	    }
(_disposable = disposable) === null || _disposable === undefined ? undefined : _disposable[SymbolDispose]();
	    ac.abort();
	    if (final) {
	      if (!error) {
	        lastStreamCleanup.forEach((fn) => fn());
	      }
	      process.nextTick(callback, error, value);
	    }
	  }
	  let ret;
	  for (let i = 0; i < streams.length; i++) {
	    const stream = streams[i];
	    const reading = i < streams.length - 1;
	    const writing = i > 0;
	    const end = reading || (opts === null || opts === undefined ? undefined : opts.end) !== false;
	    const isLastStream = i === streams.length - 1;
	    if (isNodeStream(stream)) {
	      if (end) {
	        const { destroy, cleanup } = destroyer(stream, reading, writing);
	        destroys.push(destroy);
	        if (isReadable(stream) && isLastStream) {
	          lastStreamCleanup.push(cleanup);
	        }
	      }

	      // Catch stream errors that occur after pipe/pump has completed.
	      function onError(err) {
	        if (err && err.name !== 'AbortError' && err.code !== 'ERR_STREAM_PREMATURE_CLOSE') {
	          finish(err);
	        }
	      }
	      stream.on('error', onError);
	      if (isReadable(stream) && isLastStream) {
	        lastStreamCleanup.push(() => {
	          stream.removeListener('error', onError);
	        });
	      }
	    }
	    if (i === 0) {
	      if (typeof stream === 'function') {
	        ret = stream({
	          signal
	        });
	        if (!isIterable(ret)) {
	          throw new ERR_INVALID_RETURN_VALUE('Iterable, AsyncIterable or Stream', 'source', ret)
	        }
	      } else if (isIterable(stream) || isReadableNodeStream(stream) || isTransformStream(stream)) {
	        ret = stream;
	      } else {
	        ret = Duplex.from(stream);
	      }
	    } else if (typeof stream === 'function') {
	      if (isTransformStream(ret)) {
	        var _ret;
	        ret = makeAsyncIterable((_ret = ret) === null || _ret === undefined ? undefined : _ret.readable);
	      } else {
	        ret = makeAsyncIterable(ret);
	      }
	      ret = stream(ret, {
	        signal
	      });
	      if (reading) {
	        if (!isIterable(ret, true)) {
	          throw new ERR_INVALID_RETURN_VALUE('AsyncIterable', `transform[${i - 1}]`, ret)
	        }
	      } else {
	        var _ret2;
	        if (!PassThrough) {
	          PassThrough = requirePassthrough();
	        }

	        // If the last argument to pipeline is not a stream
	        // we must create a proxy stream so that pipeline(...)
	        // always returns a stream which can be further
	        // composed through `.pipe(stream)`.

	        const pt = new PassThrough({
	          objectMode: true
	        });

	        // Handle Promises/A+ spec, `then` could be a getter that throws on
	        // second use.
	        const then = (_ret2 = ret) === null || _ret2 === undefined ? undefined : _ret2.then;
	        if (typeof then === 'function') {
	          finishCount++;
	          then.call(
	            ret,
	            (val) => {
	              value = val;
	              if (val != null) {
	                pt.write(val);
	              }
	              if (end) {
	                pt.end();
	              }
	              process.nextTick(finish);
	            },
	            (err) => {
	              pt.destroy(err);
	              process.nextTick(finish, err);
	            }
	          );
	        } else if (isIterable(ret, true)) {
	          finishCount++;
	          pumpToNode(ret, pt, finish, {
	            end
	          });
	        } else if (isReadableStream(ret) || isTransformStream(ret)) {
	          const toRead = ret.readable || ret;
	          finishCount++;
	          pumpToNode(toRead, pt, finish, {
	            end
	          });
	        } else {
	          throw new ERR_INVALID_RETURN_VALUE('AsyncIterable or Promise', 'destination', ret)
	        }
	        ret = pt;
	        const { destroy, cleanup } = destroyer(ret, false, true);
	        destroys.push(destroy);
	        if (isLastStream) {
	          lastStreamCleanup.push(cleanup);
	        }
	      }
	    } else if (isNodeStream(stream)) {
	      if (isReadableNodeStream(ret)) {
	        finishCount += 2;
	        const cleanup = pipe(ret, stream, finish, {
	          end
	        });
	        if (isReadable(stream) && isLastStream) {
	          lastStreamCleanup.push(cleanup);
	        }
	      } else if (isTransformStream(ret) || isReadableStream(ret)) {
	        const toRead = ret.readable || ret;
	        finishCount++;
	        pumpToNode(toRead, stream, finish, {
	          end
	        });
	      } else if (isIterable(ret)) {
	        finishCount++;
	        pumpToNode(ret, stream, finish, {
	          end
	        });
	      } else {
	        throw new ERR_INVALID_ARG_TYPE(
	          'val',
	          ['Readable', 'Iterable', 'AsyncIterable', 'ReadableStream', 'TransformStream'],
	          ret
	        )
	      }
	      ret = stream;
	    } else if (isWebStream(stream)) {
	      if (isReadableNodeStream(ret)) {
	        finishCount++;
	        pumpToWeb(makeAsyncIterable(ret), stream, finish, {
	          end
	        });
	      } else if (isReadableStream(ret) || isIterable(ret)) {
	        finishCount++;
	        pumpToWeb(ret, stream, finish, {
	          end
	        });
	      } else if (isTransformStream(ret)) {
	        finishCount++;
	        pumpToWeb(ret.readable, stream, finish, {
	          end
	        });
	      } else {
	        throw new ERR_INVALID_ARG_TYPE(
	          'val',
	          ['Readable', 'Iterable', 'AsyncIterable', 'ReadableStream', 'TransformStream'],
	          ret
	        )
	      }
	      ret = stream;
	    } else {
	      ret = Duplex.from(stream);
	    }
	  }
	  if (
	    (signal !== null && signal !== undefined && signal.aborted) ||
	    (outerSignal !== null && outerSignal !== undefined && outerSignal.aborted)
	  ) {
	    process.nextTick(abort);
	  }
	  return ret
	}
	function pipe(src, dst, finish, { end }) {
	  let ended = false;
	  dst.on('close', () => {
	    if (!ended) {
	      // Finish if the destination closes before the source has completed.
	      finish(new ERR_STREAM_PREMATURE_CLOSE());
	    }
	  });
	  src.pipe(dst, {
	    end: false
	  }); // If end is true we already will have a listener to end dst.

	  if (end) {
	    // Compat. Before node v10.12.0 stdio used to throw an error so
	    // pipe() did/does not end() stdio destinations.
	    // Now they allow it but "secretly" don't close the underlying fd.

	    function endFn() {
	      ended = true;
	      dst.end();
	    }
	    if (isReadableFinished(src)) {
	      // End the destination if the source has already ended.
	      process.nextTick(endFn);
	    } else {
	      src.once('end', endFn);
	    }
	  } else {
	    finish();
	  }
	  eos(
	    src,
	    {
	      readable: true,
	      writable: false
	    },
	    (err) => {
	      const rState = src._readableState;
	      if (
	        err &&
	        err.code === 'ERR_STREAM_PREMATURE_CLOSE' &&
	        rState &&
	        rState.ended &&
	        !rState.errored &&
	        !rState.errorEmitted
	      ) {
	        // Some readable streams will emit 'close' before 'end'. However, since
	        // this is on the readable side 'end' should still be emitted if the
	        // stream has been ended and no error emitted. This should be allowed in
	        // favor of backwards compatibility. Since the stream is piped to a
	        // destination this should not result in any observable difference.
	        // We don't need to check if this is a writable premature close since
	        // eos will only fail with premature close on the reading side for
	        // duplex streams.
	        src.once('end', finish).once('error', finish);
	      } else {
	        finish(err);
	      }
	    }
	  );
	  return eos(
	    dst,
	    {
	      readable: false,
	      writable: true
	    },
	    finish
	  )
	}
	pipeline_1 = {
	  pipelineImpl,
	  pipeline
	};
	return pipeline_1;
}

var compose;
var hasRequiredCompose;

function requireCompose () {
	if (hasRequiredCompose) return compose;
	hasRequiredCompose = 1;

	const { pipeline } = requirePipeline();
	const Duplex = requireDuplex();
	const { destroyer } = requireDestroy();
	const {
	  isNodeStream,
	  isReadable,
	  isWritable,
	  isWebStream,
	  isTransformStream,
	  isWritableStream,
	  isReadableStream
	} = requireUtils$1();
	const {
	  AbortError,
	  codes: { ERR_INVALID_ARG_VALUE, ERR_MISSING_ARGS }
	} = requireErrors();
	const eos = requireEndOfStream();
	compose = function compose(...streams) {
	  if (streams.length === 0) {
	    throw new ERR_MISSING_ARGS('streams')
	  }
	  if (streams.length === 1) {
	    return Duplex.from(streams[0])
	  }
	  const orgStreams = [...streams];
	  if (typeof streams[0] === 'function') {
	    streams[0] = Duplex.from(streams[0]);
	  }
	  if (typeof streams[streams.length - 1] === 'function') {
	    const idx = streams.length - 1;
	    streams[idx] = Duplex.from(streams[idx]);
	  }
	  for (let n = 0; n < streams.length; ++n) {
	    if (!isNodeStream(streams[n]) && !isWebStream(streams[n])) {
	      // TODO(ronag): Add checks for non streams.
	      continue
	    }
	    if (
	      n < streams.length - 1 &&
	      !(isReadable(streams[n]) || isReadableStream(streams[n]) || isTransformStream(streams[n]))
	    ) {
	      throw new ERR_INVALID_ARG_VALUE(`streams[${n}]`, orgStreams[n], 'must be readable')
	    }
	    if (n > 0 && !(isWritable(streams[n]) || isWritableStream(streams[n]) || isTransformStream(streams[n]))) {
	      throw new ERR_INVALID_ARG_VALUE(`streams[${n}]`, orgStreams[n], 'must be writable')
	    }
	  }
	  let ondrain;
	  let onfinish;
	  let onreadable;
	  let onclose;
	  let d;
	  function onfinished(err) {
	    const cb = onclose;
	    onclose = null;
	    if (cb) {
	      cb(err);
	    } else if (err) {
	      d.destroy(err);
	    } else if (!readable && !writable) {
	      d.destroy();
	    }
	  }
	  const head = streams[0];
	  const tail = pipeline(streams, onfinished);
	  const writable = !!(isWritable(head) || isWritableStream(head) || isTransformStream(head));
	  const readable = !!(isReadable(tail) || isReadableStream(tail) || isTransformStream(tail));

	  // TODO(ronag): Avoid double buffering.
	  // Implement Writable/Readable/Duplex traits.
	  // See, https://github.com/nodejs/node/pull/33515.
	  d = new Duplex({
	    // TODO (ronag): highWaterMark?
	    writableObjectMode: !!(head !== null && head !== undefined && head.writableObjectMode),
	    readableObjectMode: !!(tail !== null && tail !== undefined && tail.readableObjectMode),
	    writable,
	    readable
	  });
	  if (writable) {
	    if (isNodeStream(head)) {
	      d._write = function (chunk, encoding, callback) {
	        if (head.write(chunk, encoding)) {
	          callback();
	        } else {
	          ondrain = callback;
	        }
	      };
	      d._final = function (callback) {
	        head.end();
	        onfinish = callback;
	      };
	      head.on('drain', function () {
	        if (ondrain) {
	          const cb = ondrain;
	          ondrain = null;
	          cb();
	        }
	      });
	    } else if (isWebStream(head)) {
	      const writable = isTransformStream(head) ? head.writable : head;
	      const writer = writable.getWriter();
	      d._write = async function (chunk, encoding, callback) {
	        try {
	          await writer.ready;
	          writer.write(chunk).catch(() => {});
	          callback();
	        } catch (err) {
	          callback(err);
	        }
	      };
	      d._final = async function (callback) {
	        try {
	          await writer.ready;
	          writer.close().catch(() => {});
	          onfinish = callback;
	        } catch (err) {
	          callback(err);
	        }
	      };
	    }
	    const toRead = isTransformStream(tail) ? tail.readable : tail;
	    eos(toRead, () => {
	      if (onfinish) {
	        const cb = onfinish;
	        onfinish = null;
	        cb();
	      }
	    });
	  }
	  if (readable) {
	    if (isNodeStream(tail)) {
	      tail.on('readable', function () {
	        if (onreadable) {
	          const cb = onreadable;
	          onreadable = null;
	          cb();
	        }
	      });
	      tail.on('end', function () {
	        d.push(null);
	      });
	      d._read = function () {
	        while (true) {
	          const buf = tail.read();
	          if (buf === null) {
	            onreadable = d._read;
	            return
	          }
	          if (!d.push(buf)) {
	            return
	          }
	        }
	      };
	    } else if (isWebStream(tail)) {
	      const readable = isTransformStream(tail) ? tail.readable : tail;
	      const reader = readable.getReader();
	      d._read = async function () {
	        while (true) {
	          try {
	            const { value, done } = await reader.read();
	            if (!d.push(value)) {
	              return
	            }
	            if (done) {
	              d.push(null);
	              return
	            }
	          } catch {
	            return
	          }
	        }
	      };
	    }
	  }
	  d._destroy = function (err, callback) {
	    if (!err && onclose !== null) {
	      err = new AbortError();
	    }
	    onreadable = null;
	    ondrain = null;
	    onfinish = null;
	    if (onclose === null) {
	      callback(err);
	    } else {
	      onclose = callback;
	      if (isNodeStream(tail)) {
	        destroyer(tail, err);
	      }
	    }
	  };
	  return d
	};
	return compose;
}

var hasRequiredOperators;

function requireOperators () {
	if (hasRequiredOperators) return operators;
	hasRequiredOperators = 1;

	const AbortController = globalThis.AbortController || requireBrowser$1().AbortController;
	const {
	  codes: { ERR_INVALID_ARG_VALUE, ERR_INVALID_ARG_TYPE, ERR_MISSING_ARGS, ERR_OUT_OF_RANGE },
	  AbortError
	} = requireErrors();
	const { validateAbortSignal, validateInteger, validateObject } = requireValidators();
	const kWeakHandler = requirePrimordials().Symbol('kWeak');
	const kResistStopPropagation = requirePrimordials().Symbol('kResistStopPropagation');
	const { finished } = requireEndOfStream();
	const staticCompose = requireCompose();
	const { addAbortSignalNoValidate } = requireAddAbortSignal();
	const { isWritable, isNodeStream } = requireUtils$1();
	const { deprecate } = requireUtil$2();
	const {
	  ArrayPrototypePush,
	  Boolean,
	  MathFloor,
	  Number,
	  NumberIsNaN,
	  Promise,
	  PromiseReject,
	  PromiseResolve,
	  PromisePrototypeThen,
	  Symbol
	} = requirePrimordials();
	const kEmpty = Symbol('kEmpty');
	const kEof = Symbol('kEof');
	function compose(stream, options) {
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  if (isNodeStream(stream) && !isWritable(stream)) {
	    throw new ERR_INVALID_ARG_VALUE('stream', stream, 'must be writable')
	  }
	  const composedStream = staticCompose(this, stream);
	  if (options !== null && options !== undefined && options.signal) {
	    // Not validating as we already validated before
	    addAbortSignalNoValidate(options.signal, composedStream);
	  }
	  return composedStream
	}
	function map(fn, options) {
	  if (typeof fn !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE('fn', ['Function', 'AsyncFunction'], fn)
	  }
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  let concurrency = 1;
	  if ((options === null || options === undefined ? undefined : options.concurrency) != null) {
	    concurrency = MathFloor(options.concurrency);
	  }
	  let highWaterMark = concurrency - 1;
	  if ((options === null || options === undefined ? undefined : options.highWaterMark) != null) {
	    highWaterMark = MathFloor(options.highWaterMark);
	  }
	  validateInteger(concurrency, 'options.concurrency', 1);
	  validateInteger(highWaterMark, 'options.highWaterMark', 0);
	  highWaterMark += concurrency;
	  return async function* map() {
	    const signal = requireUtil$2().AbortSignalAny(
	      [options === null || options === undefined ? undefined : options.signal].filter(Boolean)
	    );
	    const stream = this;
	    const queue = [];
	    const signalOpt = {
	      signal
	    };
	    let next;
	    let resume;
	    let done = false;
	    let cnt = 0;
	    function onCatch() {
	      done = true;
	      afterItemProcessed();
	    }
	    function afterItemProcessed() {
	      cnt -= 1;
	      maybeResume();
	    }
	    function maybeResume() {
	      if (resume && !done && cnt < concurrency && queue.length < highWaterMark) {
	        resume();
	        resume = null;
	      }
	    }
	    async function pump() {
	      try {
	        for await (let val of stream) {
	          if (done) {
	            return
	          }
	          if (signal.aborted) {
	            throw new AbortError()
	          }
	          try {
	            val = fn(val, signalOpt);
	            if (val === kEmpty) {
	              continue
	            }
	            val = PromiseResolve(val);
	          } catch (err) {
	            val = PromiseReject(err);
	          }
	          cnt += 1;
	          PromisePrototypeThen(val, afterItemProcessed, onCatch);
	          queue.push(val);
	          if (next) {
	            next();
	            next = null;
	          }
	          if (!done && (queue.length >= highWaterMark || cnt >= concurrency)) {
	            await new Promise((resolve) => {
	              resume = resolve;
	            });
	          }
	        }
	        queue.push(kEof);
	      } catch (err) {
	        const val = PromiseReject(err);
	        PromisePrototypeThen(val, afterItemProcessed, onCatch);
	        queue.push(val);
	      } finally {
	        done = true;
	        if (next) {
	          next();
	          next = null;
	        }
	      }
	    }
	    pump();
	    try {
	      while (true) {
	        while (queue.length > 0) {
	          const val = await queue[0];
	          if (val === kEof) {
	            return
	          }
	          if (signal.aborted) {
	            throw new AbortError()
	          }
	          if (val !== kEmpty) {
	            yield val;
	          }
	          queue.shift();
	          maybeResume();
	        }
	        await new Promise((resolve) => {
	          next = resolve;
	        });
	      }
	    } finally {
	      done = true;
	      if (resume) {
	        resume();
	        resume = null;
	      }
	    }
	  }.call(this)
	}
	function asIndexedPairs(options = undefined) {
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  return async function* asIndexedPairs() {
	    let index = 0;
	    for await (const val of this) {
	      var _options$signal;
	      if (
	        options !== null &&
	        options !== undefined &&
	        (_options$signal = options.signal) !== null &&
	        _options$signal !== undefined &&
	        _options$signal.aborted
	      ) {
	        throw new AbortError({
	          cause: options.signal.reason
	        })
	      }
	      yield [index++, val];
	    }
	  }.call(this)
	}
	async function some(fn, options = undefined) {
	  for await (const unused of filter.call(this, fn, options)) {
	    return true
	  }
	  return false
	}
	async function every(fn, options = undefined) {
	  if (typeof fn !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE('fn', ['Function', 'AsyncFunction'], fn)
	  }
	  // https://en.wikipedia.org/wiki/De_Morgan%27s_laws
	  return !(await some.call(
	    this,
	    async (...args) => {
	      return !(await fn(...args))
	    },
	    options
	  ))
	}
	async function find(fn, options) {
	  for await (const result of filter.call(this, fn, options)) {
	    return result
	  }
	  return undefined
	}
	async function forEach(fn, options) {
	  if (typeof fn !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE('fn', ['Function', 'AsyncFunction'], fn)
	  }
	  async function forEachFn(value, options) {
	    await fn(value, options);
	    return kEmpty
	  }
	  // eslint-disable-next-line no-unused-vars
	  for await (const unused of map.call(this, forEachFn, options));
	}
	function filter(fn, options) {
	  if (typeof fn !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE('fn', ['Function', 'AsyncFunction'], fn)
	  }
	  async function filterFn(value, options) {
	    if (await fn(value, options)) {
	      return value
	    }
	    return kEmpty
	  }
	  return map.call(this, filterFn, options)
	}

	// Specific to provide better error to reduce since the argument is only
	// missing if the stream has no items in it - but the code is still appropriate
	class ReduceAwareErrMissingArgs extends ERR_MISSING_ARGS {
	  constructor() {
	    super('reduce');
	    this.message = 'Reduce of an empty stream requires an initial value';
	  }
	}
	async function reduce(reducer, initialValue, options) {
	  var _options$signal2;
	  if (typeof reducer !== 'function') {
	    throw new ERR_INVALID_ARG_TYPE('reducer', ['Function', 'AsyncFunction'], reducer)
	  }
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  let hasInitialValue = arguments.length > 1;
	  if (
	    options !== null &&
	    options !== undefined &&
	    (_options$signal2 = options.signal) !== null &&
	    _options$signal2 !== undefined &&
	    _options$signal2.aborted
	  ) {
	    const err = new AbortError(undefined, {
	      cause: options.signal.reason
	    });
	    this.once('error', () => {}); // The error is already propagated
	    await finished(this.destroy(err));
	    throw err
	  }
	  const ac = new AbortController();
	  const signal = ac.signal;
	  if (options !== null && options !== undefined && options.signal) {
	    const opts = {
	      once: true,
	      [kWeakHandler]: this,
	      [kResistStopPropagation]: true
	    };
	    options.signal.addEventListener('abort', () => ac.abort(), opts);
	  }
	  let gotAnyItemFromStream = false;
	  try {
	    for await (const value of this) {
	      var _options$signal3;
	      gotAnyItemFromStream = true;
	      if (
	        options !== null &&
	        options !== undefined &&
	        (_options$signal3 = options.signal) !== null &&
	        _options$signal3 !== undefined &&
	        _options$signal3.aborted
	      ) {
	        throw new AbortError()
	      }
	      if (!hasInitialValue) {
	        initialValue = value;
	        hasInitialValue = true;
	      } else {
	        initialValue = await reducer(initialValue, value, {
	          signal
	        });
	      }
	    }
	    if (!gotAnyItemFromStream && !hasInitialValue) {
	      throw new ReduceAwareErrMissingArgs()
	    }
	  } finally {
	    ac.abort();
	  }
	  return initialValue
	}
	async function toArray(options) {
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  const result = [];
	  for await (const val of this) {
	    var _options$signal4;
	    if (
	      options !== null &&
	      options !== undefined &&
	      (_options$signal4 = options.signal) !== null &&
	      _options$signal4 !== undefined &&
	      _options$signal4.aborted
	    ) {
	      throw new AbortError(undefined, {
	        cause: options.signal.reason
	      })
	    }
	    ArrayPrototypePush(result, val);
	  }
	  return result
	}
	function flatMap(fn, options) {
	  const values = map.call(this, fn, options);
	  return async function* flatMap() {
	    for await (const val of values) {
	      yield* val;
	    }
	  }.call(this)
	}
	function toIntegerOrInfinity(number) {
	  // We coerce here to align with the spec
	  // https://github.com/tc39/proposal-iterator-helpers/issues/169
	  number = Number(number);
	  if (NumberIsNaN(number)) {
	    return 0
	  }
	  if (number < 0) {
	    throw new ERR_OUT_OF_RANGE('number', '>= 0', number)
	  }
	  return number
	}
	function drop(number, options = undefined) {
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  number = toIntegerOrInfinity(number);
	  return async function* drop() {
	    var _options$signal5;
	    if (
	      options !== null &&
	      options !== undefined &&
	      (_options$signal5 = options.signal) !== null &&
	      _options$signal5 !== undefined &&
	      _options$signal5.aborted
	    ) {
	      throw new AbortError()
	    }
	    for await (const val of this) {
	      var _options$signal6;
	      if (
	        options !== null &&
	        options !== undefined &&
	        (_options$signal6 = options.signal) !== null &&
	        _options$signal6 !== undefined &&
	        _options$signal6.aborted
	      ) {
	        throw new AbortError()
	      }
	      if (number-- <= 0) {
	        yield val;
	      }
	    }
	  }.call(this)
	}
	function take(number, options = undefined) {
	  if (options != null) {
	    validateObject(options, 'options');
	  }
	  if ((options === null || options === undefined ? undefined : options.signal) != null) {
	    validateAbortSignal(options.signal, 'options.signal');
	  }
	  number = toIntegerOrInfinity(number);
	  return async function* take() {
	    var _options$signal7;
	    if (
	      options !== null &&
	      options !== undefined &&
	      (_options$signal7 = options.signal) !== null &&
	      _options$signal7 !== undefined &&
	      _options$signal7.aborted
	    ) {
	      throw new AbortError()
	    }
	    for await (const val of this) {
	      var _options$signal8;
	      if (
	        options !== null &&
	        options !== undefined &&
	        (_options$signal8 = options.signal) !== null &&
	        _options$signal8 !== undefined &&
	        _options$signal8.aborted
	      ) {
	        throw new AbortError()
	      }
	      if (number-- > 0) {
	        yield val;
	      }

	      // Don't get another item from iterator in case we reached the end
	      if (number <= 0) {
	        return
	      }
	    }
	  }.call(this)
	}
	operators.streamReturningOperators = {
	  asIndexedPairs: deprecate(asIndexedPairs, 'readable.asIndexedPairs will be removed in a future version.'),
	  drop,
	  filter,
	  flatMap,
	  map,
	  take,
	  compose
	};
	operators.promiseReturningOperators = {
	  every,
	  forEach,
	  reduce,
	  toArray,
	  some,
	  find
	};
	return operators;
}

var promises;
var hasRequiredPromises;

function requirePromises () {
	if (hasRequiredPromises) return promises;
	hasRequiredPromises = 1;

	const { ArrayPrototypePop, Promise } = requirePrimordials();
	const { isIterable, isNodeStream, isWebStream } = requireUtils$1();
	const { pipelineImpl: pl } = requirePipeline();
	const { finished } = requireEndOfStream();
	requireStream();
	function pipeline(...streams) {
	  return new Promise((resolve, reject) => {
	    let signal;
	    let end;
	    const lastArg = streams[streams.length - 1];
	    if (
	      lastArg &&
	      typeof lastArg === 'object' &&
	      !isNodeStream(lastArg) &&
	      !isIterable(lastArg) &&
	      !isWebStream(lastArg)
	    ) {
	      const options = ArrayPrototypePop(streams);
	      signal = options.signal;
	      end = options.end;
	    }
	    pl(
	      streams,
	      (err, value) => {
	        if (err) {
	          reject(err);
	        } else {
	          resolve(value);
	        }
	      },
	      {
	        signal,
	        end
	      }
	    );
	  })
	}
	promises = {
	  finished,
	  pipeline
	};
	return promises;
}

var hasRequiredStream;

function requireStream () {
	if (hasRequiredStream) return stream.exports;
	hasRequiredStream = 1;

	/* replacement start */

	const { Buffer } = require$$0$2;

	/* replacement end */

	const { ObjectDefineProperty, ObjectKeys, ReflectApply } = requirePrimordials();
	const {
	  promisify: { custom: customPromisify }
	} = requireUtil$2();
	const { streamReturningOperators, promiseReturningOperators } = requireOperators();
	const {
	  codes: { ERR_ILLEGAL_CONSTRUCTOR }
	} = requireErrors();
	const compose = requireCompose();
	const { setDefaultHighWaterMark, getDefaultHighWaterMark } = requireState();
	const { pipeline } = requirePipeline();
	const { destroyer } = requireDestroy();
	const eos = requireEndOfStream();
	const promises = requirePromises();
	const utils = requireUtils$1();
	const Stream = (stream.exports = requireLegacy().Stream);
	Stream.isDestroyed = utils.isDestroyed;
	Stream.isDisturbed = utils.isDisturbed;
	Stream.isErrored = utils.isErrored;
	Stream.isReadable = utils.isReadable;
	Stream.isWritable = utils.isWritable;
	Stream.Readable = requireReadable();
	for (const key of ObjectKeys(streamReturningOperators)) {
	  const op = streamReturningOperators[key];
	  function fn(...args) {
	    if (new.target) {
	      throw ERR_ILLEGAL_CONSTRUCTOR()
	    }
	    return Stream.Readable.from(ReflectApply(op, this, args))
	  }
	  ObjectDefineProperty(fn, 'name', {
	    __proto__: null,
	    value: op.name
	  });
	  ObjectDefineProperty(fn, 'length', {
	    __proto__: null,
	    value: op.length
	  });
	  ObjectDefineProperty(Stream.Readable.prototype, key, {
	    __proto__: null,
	    value: fn,
	    enumerable: false,
	    configurable: true,
	    writable: true
	  });
	}
	for (const key of ObjectKeys(promiseReturningOperators)) {
	  const op = promiseReturningOperators[key];
	  function fn(...args) {
	    if (new.target) {
	      throw ERR_ILLEGAL_CONSTRUCTOR()
	    }
	    return ReflectApply(op, this, args)
	  }
	  ObjectDefineProperty(fn, 'name', {
	    __proto__: null,
	    value: op.name
	  });
	  ObjectDefineProperty(fn, 'length', {
	    __proto__: null,
	    value: op.length
	  });
	  ObjectDefineProperty(Stream.Readable.prototype, key, {
	    __proto__: null,
	    value: fn,
	    enumerable: false,
	    configurable: true,
	    writable: true
	  });
	}
	Stream.Writable = requireWritable();
	Stream.Duplex = requireDuplex();
	Stream.Transform = requireTransform();
	Stream.PassThrough = requirePassthrough();
	Stream.pipeline = pipeline;
	const { addAbortSignal } = requireAddAbortSignal();
	Stream.addAbortSignal = addAbortSignal;
	Stream.finished = eos;
	Stream.destroy = destroyer;
	Stream.compose = compose;
	Stream.setDefaultHighWaterMark = setDefaultHighWaterMark;
	Stream.getDefaultHighWaterMark = getDefaultHighWaterMark;
	ObjectDefineProperty(Stream, 'promises', {
	  __proto__: null,
	  configurable: true,
	  enumerable: true,
	  get() {
	    return promises
	  }
	});
	ObjectDefineProperty(pipeline, customPromisify, {
	  __proto__: null,
	  enumerable: true,
	  get() {
	    return promises.pipeline
	  }
	});
	ObjectDefineProperty(eos, customPromisify, {
	  __proto__: null,
	  enumerable: true,
	  get() {
	    return promises.finished
	  }
	});

	// Backwards-compat with node 0.4.x
	Stream.Stream = Stream;
	Stream._isUint8Array = function isUint8Array(value) {
	  return value instanceof Uint8Array
	};
	Stream._uint8ArrayToBuffer = function _uint8ArrayToBuffer(chunk) {
	  return Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength)
	};
	return stream.exports;
}

var hasRequiredBrowser;

function requireBrowser () {
	if (hasRequiredBrowser) return browser$1.exports;
	hasRequiredBrowser = 1;
	(function (module) {

		const CustomStream = requireStream();
		const promises = requirePromises();
		const originalDestroy = CustomStream.Readable.destroy;
		module.exports = CustomStream.Readable;

		// Explicit export naming is needed for ESM
		module.exports._uint8ArrayToBuffer = CustomStream._uint8ArrayToBuffer;
		module.exports._isUint8Array = CustomStream._isUint8Array;
		module.exports.isDisturbed = CustomStream.isDisturbed;
		module.exports.isErrored = CustomStream.isErrored;
		module.exports.isReadable = CustomStream.isReadable;
		module.exports.Readable = CustomStream.Readable;
		module.exports.Writable = CustomStream.Writable;
		module.exports.Duplex = CustomStream.Duplex;
		module.exports.Transform = CustomStream.Transform;
		module.exports.PassThrough = CustomStream.PassThrough;
		module.exports.addAbortSignal = CustomStream.addAbortSignal;
		module.exports.finished = CustomStream.finished;
		module.exports.destroy = CustomStream.destroy;
		module.exports.destroy = originalDestroy;
		module.exports.pipeline = CustomStream.pipeline;
		module.exports.compose = CustomStream.compose;
		Object.defineProperty(CustomStream, 'promises', {
		  configurable: true,
		  enumerable: true,
		  get() {
		    return promises
		  }
		});
		module.exports.Stream = CustomStream.Stream;

		// Allow default importing
		module.exports.default = module.exports; 
	} (browser$1));
	return browser$1.exports;
}

var FileHandle = {};

var util$1 = {};

var constants = {};

var hasRequiredConstants;

function requireConstants () {
	if (hasRequiredConstants) return constants;
	hasRequiredConstants = 1;
	Object.defineProperty(constants, "__esModule", { value: true });
	constants.FLAGS = constants.ERRSTR = void 0;
	const constants_1 = requireConstants$2();
	constants.ERRSTR = {
	    PATH_STR: 'path must be a string, Buffer, or Uint8Array',
	    // FD:             'file descriptor must be a unsigned 32-bit integer',
	    FD: 'fd must be a file descriptor',
	    MODE_INT: 'mode must be an int',
	    CB: 'callback must be a function',
	    UID: 'uid must be an unsigned int',
	    GID: 'gid must be an unsigned int',
	    LEN: 'len must be an integer',
	    ATIME: 'atime must be an integer',
	    MTIME: 'mtime must be an integer',
	    PREFIX: 'filename prefix is required',
	    BUFFER: 'buffer must be an instance of Buffer or StaticBuffer',
	    OFFSET: 'offset must be an integer',
	    LENGTH: 'length must be an integer',
	    POSITION: 'position must be an integer',
	};
	const { O_RDONLY, O_WRONLY, O_RDWR, O_CREAT, O_EXCL, O_TRUNC, O_APPEND, O_SYNC } = constants_1.constants;
	// List of file `flags` as defined by Node.
	var FLAGS;
	(function (FLAGS) {
	    // Open file for reading. An exception occurs if the file does not exist.
	    FLAGS[FLAGS["r"] = O_RDONLY] = "r";
	    // Open file for reading and writing. An exception occurs if the file does not exist.
	    FLAGS[FLAGS["r+"] = O_RDWR] = "r+";
	    // Open file for reading in synchronous mode. Instructs the operating system to bypass the local file system cache.
	    FLAGS[FLAGS["rs"] = O_RDONLY | O_SYNC] = "rs";
	    FLAGS[FLAGS["sr"] = FLAGS.rs] = "sr";
	    // Open file for reading and writing, telling the OS to open it synchronously. See notes for 'rs' about using this with caution.
	    FLAGS[FLAGS["rs+"] = O_RDWR | O_SYNC] = "rs+";
	    FLAGS[FLAGS["sr+"] = FLAGS['rs+']] = "sr+";
	    // Open file for writing. The file is created (if it does not exist) or truncated (if it exists).
	    FLAGS[FLAGS["w"] = O_WRONLY | O_CREAT | O_TRUNC] = "w";
	    // Like 'w' but fails if path exists.
	    FLAGS[FLAGS["wx"] = O_WRONLY | O_CREAT | O_TRUNC | O_EXCL] = "wx";
	    FLAGS[FLAGS["xw"] = FLAGS.wx] = "xw";
	    // Open file for reading and writing. The file is created (if it does not exist) or truncated (if it exists).
	    FLAGS[FLAGS["w+"] = O_RDWR | O_CREAT | O_TRUNC] = "w+";
	    // Like 'w+' but fails if path exists.
	    FLAGS[FLAGS["wx+"] = O_RDWR | O_CREAT | O_TRUNC | O_EXCL] = "wx+";
	    FLAGS[FLAGS["xw+"] = FLAGS['wx+']] = "xw+";
	    // Open file for appending. The file is created if it does not exist.
	    FLAGS[FLAGS["a"] = O_WRONLY | O_APPEND | O_CREAT] = "a";
	    // Like 'a' but fails if path exists.
	    FLAGS[FLAGS["ax"] = O_WRONLY | O_APPEND | O_CREAT | O_EXCL] = "ax";
	    FLAGS[FLAGS["xa"] = FLAGS.ax] = "xa";
	    // Open file for reading and appending. The file is created if it does not exist.
	    FLAGS[FLAGS["a+"] = O_RDWR | O_APPEND | O_CREAT] = "a+";
	    // Like 'a+' but fails if path exists.
	    FLAGS[FLAGS["ax+"] = O_RDWR | O_APPEND | O_CREAT | O_EXCL] = "ax+";
	    FLAGS[FLAGS["xa+"] = FLAGS['ax+']] = "xa+";
	})(FLAGS || (constants.FLAGS = FLAGS = {}));
	
	return constants;
}

var url = {};

var punycode$1 = {exports: {}};

/*! https://mths.be/punycode v1.4.1 by @mathias */
var punycode = punycode$1.exports;

var hasRequiredPunycode;

function requirePunycode () {
	if (hasRequiredPunycode) return punycode$1.exports;
	hasRequiredPunycode = 1;
	(function (module, exports) {
(function(root) {

			/** Detect free variables */
			var freeExports = exports &&
				!exports.nodeType && exports;
			var freeModule = module &&
				!module.nodeType && module;
			var freeGlobal = typeof commonjsGlobal$1 == 'object' && commonjsGlobal$1;
			if (
				freeGlobal.undefined === freeGlobal ||
				freeGlobal.window === freeGlobal ||
				freeGlobal.self === freeGlobal
			) {
				root = freeGlobal;
			}

			/**
			 * The `punycode` object.
			 * @name punycode
			 * @type Object
			 */
			var punycode,

			/** Highest positive signed 32-bit float value */
			maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1

			/** Bootstring parameters */
			base = 36,
			tMin = 1,
			tMax = 26,
			skew = 38,
			damp = 700,
			initialBias = 72,
			initialN = 128, // 0x80
			delimiter = '-', // '\x2D'

			/** Regular expressions */
			regexPunycode = /^xn--/,
			regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
			regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators

			/** Error messages */
			errors = {
				'overflow': 'Overflow: input needs wider integers to process',
				'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
				'invalid-input': 'Invalid input'
			},

			/** Convenience shortcuts */
			baseMinusTMin = base - tMin,
			floor = Math.floor,
			stringFromCharCode = String.fromCharCode,

			/** Temporary variable */
			key;

			/*--------------------------------------------------------------------------*/

			/**
			 * A generic error utility function.
			 * @private
			 * @param {String} type The error type.
			 * @returns {Error} Throws a `RangeError` with the applicable error message.
			 */
			function error(type) {
				throw new RangeError(errors[type]);
			}

			/**
			 * A generic `Array#map` utility function.
			 * @private
			 * @param {Array} array The array to iterate over.
			 * @param {Function} callback The function that gets called for every array
			 * item.
			 * @returns {Array} A new array of values returned by the callback function.
			 */
			function map(array, fn) {
				var length = array.length;
				var result = [];
				while (length--) {
					result[length] = fn(array[length]);
				}
				return result;
			}

			/**
			 * A simple `Array#map`-like wrapper to work with domain name strings or email
			 * addresses.
			 * @private
			 * @param {String} domain The domain name or email address.
			 * @param {Function} callback The function that gets called for every
			 * character.
			 * @returns {Array} A new string of characters returned by the callback
			 * function.
			 */
			function mapDomain(string, fn) {
				var parts = string.split('@');
				var result = '';
				if (parts.length > 1) {
					// In email addresses, only the domain name should be punycoded. Leave
					// the local part (i.e. everything up to `@`) intact.
					result = parts[0] + '@';
					string = parts[1];
				}
				// Avoid `split(regex)` for IE8 compatibility. See #17.
				string = string.replace(regexSeparators, '\x2E');
				var labels = string.split('.');
				var encoded = map(labels, fn).join('.');
				return result + encoded;
			}

			/**
			 * Creates an array containing the numeric code points of each Unicode
			 * character in the string. While JavaScript uses UCS-2 internally,
			 * this function will convert a pair of surrogate halves (each of which
			 * UCS-2 exposes as separate characters) into a single code point,
			 * matching UTF-16.
			 * @see `punycode.ucs2.encode`
			 * @see <https://mathiasbynens.be/notes/javascript-encoding>
			 * @memberOf punycode.ucs2
			 * @name decode
			 * @param {String} string The Unicode input string (UCS-2).
			 * @returns {Array} The new array of code points.
			 */
			function ucs2decode(string) {
				var output = [],
				    counter = 0,
				    length = string.length,
				    value,
				    extra;
				while (counter < length) {
					value = string.charCodeAt(counter++);
					if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
						// high surrogate, and there is a next character
						extra = string.charCodeAt(counter++);
						if ((extra & 0xFC00) == 0xDC00) { // low surrogate
							output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
						} else {
							// unmatched surrogate; only append this code unit, in case the next
							// code unit is the high surrogate of a surrogate pair
							output.push(value);
							counter--;
						}
					} else {
						output.push(value);
					}
				}
				return output;
			}

			/**
			 * Creates a string based on an array of numeric code points.
			 * @see `punycode.ucs2.decode`
			 * @memberOf punycode.ucs2
			 * @name encode
			 * @param {Array} codePoints The array of numeric code points.
			 * @returns {String} The new Unicode string (UCS-2).
			 */
			function ucs2encode(array) {
				return map(array, function(value) {
					var output = '';
					if (value > 0xFFFF) {
						value -= 0x10000;
						output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
						value = 0xDC00 | value & 0x3FF;
					}
					output += stringFromCharCode(value);
					return output;
				}).join('');
			}

			/**
			 * Converts a basic code point into a digit/integer.
			 * @see `digitToBasic()`
			 * @private
			 * @param {Number} codePoint The basic numeric code point value.
			 * @returns {Number} The numeric value of a basic code point (for use in
			 * representing integers) in the range `0` to `base - 1`, or `base` if
			 * the code point does not represent a value.
			 */
			function basicToDigit(codePoint) {
				if (codePoint - 48 < 10) {
					return codePoint - 22;
				}
				if (codePoint - 65 < 26) {
					return codePoint - 65;
				}
				if (codePoint - 97 < 26) {
					return codePoint - 97;
				}
				return base;
			}

			/**
			 * Converts a digit/integer into a basic code point.
			 * @see `basicToDigit()`
			 * @private
			 * @param {Number} digit The numeric value of a basic code point.
			 * @returns {Number} The basic code point whose value (when used for
			 * representing integers) is `digit`, which needs to be in the range
			 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
			 * used; else, the lowercase form is used. The behavior is undefined
			 * if `flag` is non-zero and `digit` has no uppercase form.
			 */
			function digitToBasic(digit, flag) {
				//  0..25 map to ASCII a..z or A..Z
				// 26..35 map to ASCII 0..9
				return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
			}

			/**
			 * Bias adaptation function as per section 3.4 of RFC 3492.
			 * https://tools.ietf.org/html/rfc3492#section-3.4
			 * @private
			 */
			function adapt(delta, numPoints, firstTime) {
				var k = 0;
				delta = firstTime ? floor(delta / damp) : delta >> 1;
				delta += floor(delta / numPoints);
				for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
					delta = floor(delta / baseMinusTMin);
				}
				return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
			}

			/**
			 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
			 * symbols.
			 * @memberOf punycode
			 * @param {String} input The Punycode string of ASCII-only symbols.
			 * @returns {String} The resulting string of Unicode symbols.
			 */
			function decode(input) {
				// Don't use UCS-2
				var output = [],
				    inputLength = input.length,
				    out,
				    i = 0,
				    n = initialN,
				    bias = initialBias,
				    basic,
				    j,
				    index,
				    oldi,
				    w,
				    k,
				    digit,
				    t,
				    /** Cached calculation results */
				    baseMinusT;

				// Handle the basic code points: let `basic` be the number of input code
				// points before the last delimiter, or `0` if there is none, then copy
				// the first basic code points to the output.

				basic = input.lastIndexOf(delimiter);
				if (basic < 0) {
					basic = 0;
				}

				for (j = 0; j < basic; ++j) {
					// if it's not a basic code point
					if (input.charCodeAt(j) >= 0x80) {
						error('not-basic');
					}
					output.push(input.charCodeAt(j));
				}

				// Main decoding loop: start just after the last delimiter if any basic code
				// points were copied; start at the beginning otherwise.

				for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

					// `index` is the index of the next character to be consumed.
					// Decode a generalized variable-length integer into `delta`,
					// which gets added to `i`. The overflow checking is easier
					// if we increase `i` as we go, then subtract off its starting
					// value at the end to obtain `delta`.
					for (oldi = i, w = 1, k = base; /* no condition */; k += base) {

						if (index >= inputLength) {
							error('invalid-input');
						}

						digit = basicToDigit(input.charCodeAt(index++));

						if (digit >= base || digit > floor((maxInt - i) / w)) {
							error('overflow');
						}

						i += digit * w;
						t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

						if (digit < t) {
							break;
						}

						baseMinusT = base - t;
						if (w > floor(maxInt / baseMinusT)) {
							error('overflow');
						}

						w *= baseMinusT;

					}

					out = output.length + 1;
					bias = adapt(i - oldi, out, oldi == 0);

					// `i` was supposed to wrap around from `out` to `0`,
					// incrementing `n` each time, so we'll fix that now:
					if (floor(i / out) > maxInt - n) {
						error('overflow');
					}

					n += floor(i / out);
					i %= out;

					// Insert `n` at position `i` of the output
					output.splice(i++, 0, n);

				}

				return ucs2encode(output);
			}

			/**
			 * Converts a string of Unicode symbols (e.g. a domain name label) to a
			 * Punycode string of ASCII-only symbols.
			 * @memberOf punycode
			 * @param {String} input The string of Unicode symbols.
			 * @returns {String} The resulting Punycode string of ASCII-only symbols.
			 */
			function encode(input) {
				var n,
				    delta,
				    handledCPCount,
				    basicLength,
				    bias,
				    j,
				    m,
				    q,
				    k,
				    t,
				    currentValue,
				    output = [],
				    /** `inputLength` will hold the number of code points in `input`. */
				    inputLength,
				    /** Cached calculation results */
				    handledCPCountPlusOne,
				    baseMinusT,
				    qMinusT;

				// Convert the input in UCS-2 to Unicode
				input = ucs2decode(input);

				// Cache the length
				inputLength = input.length;

				// Initialize the state
				n = initialN;
				delta = 0;
				bias = initialBias;

				// Handle the basic code points
				for (j = 0; j < inputLength; ++j) {
					currentValue = input[j];
					if (currentValue < 0x80) {
						output.push(stringFromCharCode(currentValue));
					}
				}

				handledCPCount = basicLength = output.length;

				// `handledCPCount` is the number of code points that have been handled;
				// `basicLength` is the number of basic code points.

				// Finish the basic string - if it is not empty - with a delimiter
				if (basicLength) {
					output.push(delimiter);
				}

				// Main encoding loop:
				while (handledCPCount < inputLength) {

					// All non-basic code points < n have been handled already. Find the next
					// larger one:
					for (m = maxInt, j = 0; j < inputLength; ++j) {
						currentValue = input[j];
						if (currentValue >= n && currentValue < m) {
							m = currentValue;
						}
					}

					// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
					// but guard against overflow
					handledCPCountPlusOne = handledCPCount + 1;
					if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
						error('overflow');
					}

					delta += (m - n) * handledCPCountPlusOne;
					n = m;

					for (j = 0; j < inputLength; ++j) {
						currentValue = input[j];

						if (currentValue < n && ++delta > maxInt) {
							error('overflow');
						}

						if (currentValue == n) {
							// Represent delta as a generalized variable-length integer
							for (q = delta, k = base; /* no condition */; k += base) {
								t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
								if (q < t) {
									break;
								}
								qMinusT = q - t;
								baseMinusT = base - t;
								output.push(
									stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
								);
								q = floor(qMinusT / baseMinusT);
							}

							output.push(stringFromCharCode(digitToBasic(q, 0)));
							bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
							delta = 0;
							++handledCPCount;
						}
					}

					++delta;
					++n;

				}
				return output.join('');
			}

			/**
			 * Converts a Punycode string representing a domain name or an email address
			 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
			 * it doesn't matter if you call it on a string that has already been
			 * converted to Unicode.
			 * @memberOf punycode
			 * @param {String} input The Punycoded domain name or email address to
			 * convert to Unicode.
			 * @returns {String} The Unicode representation of the given Punycode
			 * string.
			 */
			function toUnicode(input) {
				return mapDomain(input, function(string) {
					return regexPunycode.test(string)
						? decode(string.slice(4).toLowerCase())
						: string;
				});
			}

			/**
			 * Converts a Unicode string representing a domain name or an email address to
			 * Punycode. Only the non-ASCII parts of the domain name will be converted,
			 * i.e. it doesn't matter if you call it with a domain that's already in
			 * ASCII.
			 * @memberOf punycode
			 * @param {String} input The domain name or email address to convert, as a
			 * Unicode string.
			 * @returns {String} The Punycode representation of the given domain name or
			 * email address.
			 */
			function toASCII(input) {
				return mapDomain(input, function(string) {
					return regexNonASCII.test(string)
						? 'xn--' + encode(string)
						: string;
				});
			}

			/*--------------------------------------------------------------------------*/

			/** Define the public API */
			punycode = {
				/**
				 * A string representing the current Punycode.js version number.
				 * @memberOf punycode
				 * @type String
				 */
				'version': '1.4.1',
				/**
				 * An object of methods to convert from JavaScript's internal character
				 * representation (UCS-2) to Unicode code points, and back.
				 * @see <https://mathiasbynens.be/notes/javascript-encoding>
				 * @memberOf punycode
				 * @type Object
				 */
				'ucs2': {
					'decode': ucs2decode,
					'encode': ucs2encode
				},
				'decode': decode,
				'encode': encode,
				'toASCII': toASCII,
				'toUnicode': toUnicode
			};

			/** Expose `punycode` */
			// Some AMD build optimizers, like r.js, check for specific condition patterns
			// like the following:
			if (freeExports && freeModule) {
				if (module.exports == freeExports) {
					// in Node.js, io.js, or RingoJS v0.8.0+
					freeModule.exports = punycode;
				} else {
					// in Narwhal or RingoJS v0.7.0-
					for (key in punycode) {
						punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
					}
				}
			} else {
				// in Rhino or a web browser
				root.punycode = punycode;
			}

		}(punycode)); 
	} (punycode$1, punycode$1.exports));
	return punycode$1.exports;
}

var type;
var hasRequiredType;

function requireType () {
	if (hasRequiredType) return type;
	hasRequiredType = 1;

	/** @type {import('./type')} */
	type = TypeError;
	return type;
}

var _nodeResolve_empty = {};

var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	default: _nodeResolve_empty
});

var require$$0$1 = /*@__PURE__*/getAugmentedNamespace(_nodeResolve_empty$1);

var objectInspect;
var hasRequiredObjectInspect;

function requireObjectInspect () {
	if (hasRequiredObjectInspect) return objectInspect;
	hasRequiredObjectInspect = 1;
	var hasMap = typeof Map === 'function' && Map.prototype;
	var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, 'size') : null;
	var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === 'function' ? mapSizeDescriptor.get : null;
	var mapForEach = hasMap && Map.prototype.forEach;
	var hasSet = typeof Set === 'function' && Set.prototype;
	var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, 'size') : null;
	var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === 'function' ? setSizeDescriptor.get : null;
	var setForEach = hasSet && Set.prototype.forEach;
	var hasWeakMap = typeof WeakMap === 'function' && WeakMap.prototype;
	var weakMapHas = hasWeakMap ? WeakMap.prototype.has : null;
	var hasWeakSet = typeof WeakSet === 'function' && WeakSet.prototype;
	var weakSetHas = hasWeakSet ? WeakSet.prototype.has : null;
	var hasWeakRef = typeof WeakRef === 'function' && WeakRef.prototype;
	var weakRefDeref = hasWeakRef ? WeakRef.prototype.deref : null;
	var booleanValueOf = Boolean.prototype.valueOf;
	var objectToString = Object.prototype.toString;
	var functionToString = Function.prototype.toString;
	var $match = String.prototype.match;
	var $slice = String.prototype.slice;
	var $replace = String.prototype.replace;
	var $toUpperCase = String.prototype.toUpperCase;
	var $toLowerCase = String.prototype.toLowerCase;
	var $test = RegExp.prototype.test;
	var $concat = Array.prototype.concat;
	var $join = Array.prototype.join;
	var $arrSlice = Array.prototype.slice;
	var $floor = Math.floor;
	var bigIntValueOf = typeof BigInt === 'function' ? BigInt.prototype.valueOf : null;
	var gOPS = Object.getOwnPropertySymbols;
	var symToString = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol.prototype.toString : null;
	var hasShammedSymbols = typeof Symbol === 'function' && typeof Symbol.iterator === 'object';
	// ie, `has-tostringtag/shams
	var toStringTag = typeof Symbol === 'function' && Symbol.toStringTag && (typeof Symbol.toStringTag === hasShammedSymbols ? 'object' : 'symbol')
	    ? Symbol.toStringTag
	    : null;
	var isEnumerable = Object.prototype.propertyIsEnumerable;

	var gPO = (typeof Reflect === 'function' ? Reflect.getPrototypeOf : Object.getPrototypeOf) || (
	    [].__proto__ === Array.prototype // eslint-disable-line no-proto
	        ? function (O) {
	            return O.__proto__; // eslint-disable-line no-proto
	        }
	        : null
	);

	function addNumericSeparator(num, str) {
	    if (
	        num === Infinity
	        || num === -Infinity
	        || num !== num
	        || (num && num > -1e3 && num < 1000)
	        || $test.call(/e/, str)
	    ) {
	        return str;
	    }
	    var sepRegex = /[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;
	    if (typeof num === 'number') {
	        var int = num < 0 ? -$floor(-num) : $floor(num); // trunc(num)
	        if (int !== num) {
	            var intStr = String(int);
	            var dec = $slice.call(str, intStr.length + 1);
	            return $replace.call(intStr, sepRegex, '$&_') + '.' + $replace.call($replace.call(dec, /([0-9]{3})/g, '$&_'), /_$/, '');
	        }
	    }
	    return $replace.call(str, sepRegex, '$&_');
	}

	var utilInspect = require$$0$1;
	var inspectCustom = utilInspect.custom;
	var inspectSymbol = isSymbol(inspectCustom) ? inspectCustom : null;

	var quotes = {
	    __proto__: null,
	    'double': '"',
	    single: "'"
	};
	var quoteREs = {
	    __proto__: null,
	    'double': /(["\\])/g,
	    single: /(['\\])/g
	};

	objectInspect = function inspect_(obj, options, depth, seen) {
	    var opts = options || {};

	    if (has(opts, 'quoteStyle') && !has(quotes, opts.quoteStyle)) {
	        throw new TypeError('option "quoteStyle" must be "single" or "double"');
	    }
	    if (
	        has(opts, 'maxStringLength') && (typeof opts.maxStringLength === 'number'
	            ? opts.maxStringLength < 0 && opts.maxStringLength !== Infinity
	            : opts.maxStringLength !== null
	        )
	    ) {
	        throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');
	    }
	    var customInspect = has(opts, 'customInspect') ? opts.customInspect : true;
	    if (typeof customInspect !== 'boolean' && customInspect !== 'symbol') {
	        throw new TypeError('option "customInspect", if provided, must be `true`, `false`, or `\'symbol\'`');
	    }

	    if (
	        has(opts, 'indent')
	        && opts.indent !== null
	        && opts.indent !== '\t'
	        && !(parseInt(opts.indent, 10) === opts.indent && opts.indent > 0)
	    ) {
	        throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');
	    }
	    if (has(opts, 'numericSeparator') && typeof opts.numericSeparator !== 'boolean') {
	        throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');
	    }
	    var numericSeparator = opts.numericSeparator;

	    if (typeof obj === 'undefined') {
	        return 'undefined';
	    }
	    if (obj === null) {
	        return 'null';
	    }
	    if (typeof obj === 'boolean') {
	        return obj ? 'true' : 'false';
	    }

	    if (typeof obj === 'string') {
	        return inspectString(obj, opts);
	    }
	    if (typeof obj === 'number') {
	        if (obj === 0) {
	            return Infinity / obj > 0 ? '0' : '-0';
	        }
	        var str = String(obj);
	        return numericSeparator ? addNumericSeparator(obj, str) : str;
	    }
	    if (typeof obj === 'bigint') {
	        var bigIntStr = String(obj) + 'n';
	        return numericSeparator ? addNumericSeparator(obj, bigIntStr) : bigIntStr;
	    }

	    var maxDepth = typeof opts.depth === 'undefined' ? 5 : opts.depth;
	    if (typeof depth === 'undefined') { depth = 0; }
	    if (depth >= maxDepth && maxDepth > 0 && typeof obj === 'object') {
	        return isArray(obj) ? '[Array]' : '[Object]';
	    }

	    var indent = getIndent(opts, depth);

	    if (typeof seen === 'undefined') {
	        seen = [];
	    } else if (indexOf(seen, obj) >= 0) {
	        return '[Circular]';
	    }

	    function inspect(value, from, noIndent) {
	        if (from) {
	            seen = $arrSlice.call(seen);
	            seen.push(from);
	        }
	        if (noIndent) {
	            var newOpts = {
	                depth: opts.depth
	            };
	            if (has(opts, 'quoteStyle')) {
	                newOpts.quoteStyle = opts.quoteStyle;
	            }
	            return inspect_(value, newOpts, depth + 1, seen);
	        }
	        return inspect_(value, opts, depth + 1, seen);
	    }

	    if (typeof obj === 'function' && !isRegExp(obj)) { // in older engines, regexes are callable
	        var name = nameOf(obj);
	        var keys = arrObjKeys(obj, inspect);
	        return '[Function' + (name ? ': ' + name : ' (anonymous)') + ']' + (keys.length > 0 ? ' { ' + $join.call(keys, ', ') + ' }' : '');
	    }
	    if (isSymbol(obj)) {
	        var symString = hasShammedSymbols ? $replace.call(String(obj), /^(Symbol\(.*\))_[^)]*$/, '$1') : symToString.call(obj);
	        return typeof obj === 'object' && !hasShammedSymbols ? markBoxed(symString) : symString;
	    }
	    if (isElement(obj)) {
	        var s = '<' + $toLowerCase.call(String(obj.nodeName));
	        var attrs = obj.attributes || [];
	        for (var i = 0; i < attrs.length; i++) {
	            s += ' ' + attrs[i].name + '=' + wrapQuotes(quote(attrs[i].value), 'double', opts);
	        }
	        s += '>';
	        if (obj.childNodes && obj.childNodes.length) { s += '...'; }
	        s += '</' + $toLowerCase.call(String(obj.nodeName)) + '>';
	        return s;
	    }
	    if (isArray(obj)) {
	        if (obj.length === 0) { return '[]'; }
	        var xs = arrObjKeys(obj, inspect);
	        if (indent && !singleLineValues(xs)) {
	            return '[' + indentedJoin(xs, indent) + ']';
	        }
	        return '[ ' + $join.call(xs, ', ') + ' ]';
	    }
	    if (isError(obj)) {
	        var parts = arrObjKeys(obj, inspect);
	        if (!('cause' in Error.prototype) && 'cause' in obj && !isEnumerable.call(obj, 'cause')) {
	            return '{ [' + String(obj) + '] ' + $join.call($concat.call('[cause]: ' + inspect(obj.cause), parts), ', ') + ' }';
	        }
	        if (parts.length === 0) { return '[' + String(obj) + ']'; }
	        return '{ [' + String(obj) + '] ' + $join.call(parts, ', ') + ' }';
	    }
	    if (typeof obj === 'object' && customInspect) {
	        if (inspectSymbol && typeof obj[inspectSymbol] === 'function' && utilInspect) {
	            return utilInspect(obj, { depth: maxDepth - depth });
	        } else if (customInspect !== 'symbol' && typeof obj.inspect === 'function') {
	            return obj.inspect();
	        }
	    }
	    if (isMap(obj)) {
	        var mapParts = [];
	        if (mapForEach) {
	            mapForEach.call(obj, function (value, key) {
	                mapParts.push(inspect(key, obj, true) + ' => ' + inspect(value, obj));
	            });
	        }
	        return collectionOf('Map', mapSize.call(obj), mapParts, indent);
	    }
	    if (isSet(obj)) {
	        var setParts = [];
	        if (setForEach) {
	            setForEach.call(obj, function (value) {
	                setParts.push(inspect(value, obj));
	            });
	        }
	        return collectionOf('Set', setSize.call(obj), setParts, indent);
	    }
	    if (isWeakMap(obj)) {
	        return weakCollectionOf('WeakMap');
	    }
	    if (isWeakSet(obj)) {
	        return weakCollectionOf('WeakSet');
	    }
	    if (isWeakRef(obj)) {
	        return weakCollectionOf('WeakRef');
	    }
	    if (isNumber(obj)) {
	        return markBoxed(inspect(Number(obj)));
	    }
	    if (isBigInt(obj)) {
	        return markBoxed(inspect(bigIntValueOf.call(obj)));
	    }
	    if (isBoolean(obj)) {
	        return markBoxed(booleanValueOf.call(obj));
	    }
	    if (isString(obj)) {
	        return markBoxed(inspect(String(obj)));
	    }
	    // note: in IE 8, sometimes `undefined !== window` but both are the prototypes of each other
	    /* eslint-env browser */
	    if (typeof window !== 'undefined' && obj === window) {
	        return '{ [object Window] }';
	    }
	    if (
	        (typeof globalThis !== 'undefined' && obj === globalThis)
	        || (typeof commonjsGlobal$1 !== 'undefined' && obj === commonjsGlobal$1)
	    ) {
	        return '{ [object globalThis] }';
	    }
	    if (!isDate(obj) && !isRegExp(obj)) {
	        var ys = arrObjKeys(obj, inspect);
	        var isPlainObject = gPO ? gPO(obj) === Object.prototype : obj instanceof Object || obj.constructor === Object;
	        var protoTag = obj instanceof Object ? '' : 'null prototype';
	        var stringTag = !isPlainObject && toStringTag && Object(obj) === obj && toStringTag in obj ? $slice.call(toStr(obj), 8, -1) : protoTag ? 'Object' : '';
	        var constructorTag = isPlainObject || typeof obj.constructor !== 'function' ? '' : obj.constructor.name ? obj.constructor.name + ' ' : '';
	        var tag = constructorTag + (stringTag || protoTag ? '[' + $join.call($concat.call([], stringTag || [], protoTag || []), ': ') + '] ' : '');
	        if (ys.length === 0) { return tag + '{}'; }
	        if (indent) {
	            return tag + '{' + indentedJoin(ys, indent) + '}';
	        }
	        return tag + '{ ' + $join.call(ys, ', ') + ' }';
	    }
	    return String(obj);
	};

	function wrapQuotes(s, defaultStyle, opts) {
	    var style = opts.quoteStyle || defaultStyle;
	    var quoteChar = quotes[style];
	    return quoteChar + s + quoteChar;
	}

	function quote(s) {
	    return $replace.call(String(s), /"/g, '&quot;');
	}

	function canTrustToString(obj) {
	    return !toStringTag || !(typeof obj === 'object' && (toStringTag in obj || typeof obj[toStringTag] !== 'undefined'));
	}
	function isArray(obj) { return toStr(obj) === '[object Array]' && canTrustToString(obj); }
	function isDate(obj) { return toStr(obj) === '[object Date]' && canTrustToString(obj); }
	function isRegExp(obj) { return toStr(obj) === '[object RegExp]' && canTrustToString(obj); }
	function isError(obj) { return toStr(obj) === '[object Error]' && canTrustToString(obj); }
	function isString(obj) { return toStr(obj) === '[object String]' && canTrustToString(obj); }
	function isNumber(obj) { return toStr(obj) === '[object Number]' && canTrustToString(obj); }
	function isBoolean(obj) { return toStr(obj) === '[object Boolean]' && canTrustToString(obj); }

	// Symbol and BigInt do have Symbol.toStringTag by spec, so that can't be used to eliminate false positives
	function isSymbol(obj) {
	    if (hasShammedSymbols) {
	        return obj && typeof obj === 'object' && obj instanceof Symbol;
	    }
	    if (typeof obj === 'symbol') {
	        return true;
	    }
	    if (!obj || typeof obj !== 'object' || !symToString) {
	        return false;
	    }
	    try {
	        symToString.call(obj);
	        return true;
	    } catch (e) {}
	    return false;
	}

	function isBigInt(obj) {
	    if (!obj || typeof obj !== 'object' || !bigIntValueOf) {
	        return false;
	    }
	    try {
	        bigIntValueOf.call(obj);
	        return true;
	    } catch (e) {}
	    return false;
	}

	var hasOwn = Object.prototype.hasOwnProperty || function (key) { return key in this; };
	function has(obj, key) {
	    return hasOwn.call(obj, key);
	}

	function toStr(obj) {
	    return objectToString.call(obj);
	}

	function nameOf(f) {
	    if (f.name) { return f.name; }
	    var m = $match.call(functionToString.call(f), /^function\s*([\w$]+)/);
	    if (m) { return m[1]; }
	    return null;
	}

	function indexOf(xs, x) {
	    if (xs.indexOf) { return xs.indexOf(x); }
	    for (var i = 0, l = xs.length; i < l; i++) {
	        if (xs[i] === x) { return i; }
	    }
	    return -1;
	}

	function isMap(x) {
	    if (!mapSize || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        mapSize.call(x);
	        try {
	            setSize.call(x);
	        } catch (s) {
	            return true;
	        }
	        return x instanceof Map; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isWeakMap(x) {
	    if (!weakMapHas || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        weakMapHas.call(x, weakMapHas);
	        try {
	            weakSetHas.call(x, weakSetHas);
	        } catch (s) {
	            return true;
	        }
	        return x instanceof WeakMap; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isWeakRef(x) {
	    if (!weakRefDeref || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        weakRefDeref.call(x);
	        return true;
	    } catch (e) {}
	    return false;
	}

	function isSet(x) {
	    if (!setSize || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        setSize.call(x);
	        try {
	            mapSize.call(x);
	        } catch (m) {
	            return true;
	        }
	        return x instanceof Set; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isWeakSet(x) {
	    if (!weakSetHas || !x || typeof x !== 'object') {
	        return false;
	    }
	    try {
	        weakSetHas.call(x, weakSetHas);
	        try {
	            weakMapHas.call(x, weakMapHas);
	        } catch (s) {
	            return true;
	        }
	        return x instanceof WeakSet; // core-js workaround, pre-v2.5.0
	    } catch (e) {}
	    return false;
	}

	function isElement(x) {
	    if (!x || typeof x !== 'object') { return false; }
	    if (typeof HTMLElement !== 'undefined' && x instanceof HTMLElement) {
	        return true;
	    }
	    return typeof x.nodeName === 'string' && typeof x.getAttribute === 'function';
	}

	function inspectString(str, opts) {
	    if (str.length > opts.maxStringLength) {
	        var remaining = str.length - opts.maxStringLength;
	        var trailer = '... ' + remaining + ' more character' + (remaining > 1 ? 's' : '');
	        return inspectString($slice.call(str, 0, opts.maxStringLength), opts) + trailer;
	    }
	    var quoteRE = quoteREs[opts.quoteStyle || 'single'];
	    quoteRE.lastIndex = 0;
	    // eslint-disable-next-line no-control-regex
	    var s = $replace.call($replace.call(str, quoteRE, '\\$1'), /[\x00-\x1f]/g, lowbyte);
	    return wrapQuotes(s, 'single', opts);
	}

	function lowbyte(c) {
	    var n = c.charCodeAt(0);
	    var x = {
	        8: 'b',
	        9: 't',
	        10: 'n',
	        12: 'f',
	        13: 'r'
	    }[n];
	    if (x) { return '\\' + x; }
	    return '\\x' + (n < 0x10 ? '0' : '') + $toUpperCase.call(n.toString(16));
	}

	function markBoxed(str) {
	    return 'Object(' + str + ')';
	}

	function weakCollectionOf(type) {
	    return type + ' { ? }';
	}

	function collectionOf(type, size, entries, indent) {
	    var joinedEntries = indent ? indentedJoin(entries, indent) : $join.call(entries, ', ');
	    return type + ' (' + size + ') {' + joinedEntries + '}';
	}

	function singleLineValues(xs) {
	    for (var i = 0; i < xs.length; i++) {
	        if (indexOf(xs[i], '\n') >= 0) {
	            return false;
	        }
	    }
	    return true;
	}

	function getIndent(opts, depth) {
	    var baseIndent;
	    if (opts.indent === '\t') {
	        baseIndent = '\t';
	    } else if (typeof opts.indent === 'number' && opts.indent > 0) {
	        baseIndent = $join.call(Array(opts.indent + 1), ' ');
	    } else {
	        return null;
	    }
	    return {
	        base: baseIndent,
	        prev: $join.call(Array(depth + 1), baseIndent)
	    };
	}

	function indentedJoin(xs, indent) {
	    if (xs.length === 0) { return ''; }
	    var lineJoiner = '\n' + indent.prev + indent.base;
	    return lineJoiner + $join.call(xs, ',' + lineJoiner) + '\n' + indent.prev;
	}

	function arrObjKeys(obj, inspect) {
	    var isArr = isArray(obj);
	    var xs = [];
	    if (isArr) {
	        xs.length = obj.length;
	        for (var i = 0; i < obj.length; i++) {
	            xs[i] = has(obj, i) ? inspect(obj[i], obj) : '';
	        }
	    }
	    var syms = typeof gOPS === 'function' ? gOPS(obj) : [];
	    var symMap;
	    if (hasShammedSymbols) {
	        symMap = {};
	        for (var k = 0; k < syms.length; k++) {
	            symMap['$' + syms[k]] = syms[k];
	        }
	    }

	    for (var key in obj) { // eslint-disable-line no-restricted-syntax
	        if (!has(obj, key)) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
	        if (isArr && String(Number(key)) === key && key < obj.length) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
	        if (hasShammedSymbols && symMap['$' + key] instanceof Symbol) {
	            // this is to prevent shammed Symbols, which are stored as strings, from being included in the string key section
	            continue; // eslint-disable-line no-restricted-syntax, no-continue
	        } else if ($test.call(/[^\w$]/, key)) {
	            xs.push(inspect(key, obj) + ': ' + inspect(obj[key], obj));
	        } else {
	            xs.push(key + ': ' + inspect(obj[key], obj));
	        }
	    }
	    if (typeof gOPS === 'function') {
	        for (var j = 0; j < syms.length; j++) {
	            if (isEnumerable.call(obj, syms[j])) {
	                xs.push('[' + inspect(syms[j]) + ']: ' + inspect(obj[syms[j]], obj));
	            }
	        }
	    }
	    return xs;
	}
	return objectInspect;
}

var sideChannelList;
var hasRequiredSideChannelList;

function requireSideChannelList () {
	if (hasRequiredSideChannelList) return sideChannelList;
	hasRequiredSideChannelList = 1;

	var inspect = /*@__PURE__*/ requireObjectInspect();

	var $TypeError = /*@__PURE__*/ requireType();

	/*
	* This function traverses the list returning the node corresponding to the given key.
	*
	* That node is also moved to the head of the list, so that if it's accessed again we don't need to traverse the whole list.
	* By doing so, all the recently used nodes can be accessed relatively quickly.
	*/
	/** @type {import('./list.d.ts').listGetNode} */
	// eslint-disable-next-line consistent-return
	var listGetNode = function (list, key, isDelete) {
		/** @type {typeof list | NonNullable<(typeof list)['next']>} */
		var prev = list;
		/** @type {(typeof list)['next']} */
		var curr;
		// eslint-disable-next-line eqeqeq
		for (; (curr = prev.next) != null; prev = curr) {
			if (curr.key === key) {
				prev.next = curr.next;
				if (!isDelete) {
					// eslint-disable-next-line no-extra-parens
					curr.next = /** @type {NonNullable<typeof list.next>} */ (list.next);
					list.next = curr; // eslint-disable-line no-param-reassign
				}
				return curr;
			}
		}
	};

	/** @type {import('./list.d.ts').listGet} */
	var listGet = function (objects, key) {
		if (!objects) {
			return void undefined;
		}
		var node = listGetNode(objects, key);
		return node && node.value;
	};
	/** @type {import('./list.d.ts').listSet} */
	var listSet = function (objects, key, value) {
		var node = listGetNode(objects, key);
		if (node) {
			node.value = value;
		} else {
			// Prepend the new node to the beginning of the list
			objects.next = /** @type {import('./list.d.ts').ListNode<typeof value, typeof key>} */ ({ // eslint-disable-line no-param-reassign, no-extra-parens
				key: key,
				next: objects.next,
				value: value
			});
		}
	};
	/** @type {import('./list.d.ts').listHas} */
	var listHas = function (objects, key) {
		if (!objects) {
			return false;
		}
		return !!listGetNode(objects, key);
	};
	/** @type {import('./list.d.ts').listDelete} */
	// eslint-disable-next-line consistent-return
	var listDelete = function (objects, key) {
		if (objects) {
			return listGetNode(objects, key, true);
		}
	};

	/** @type {import('.')} */
	sideChannelList = function getSideChannelList() {
		/** @typedef {ReturnType<typeof getSideChannelList>} Channel */
		/** @typedef {Parameters<Channel['get']>[0]} K */
		/** @typedef {Parameters<Channel['set']>[1]} V */

		/** @type {import('./list.d.ts').RootNode<V, K> | undefined} */ var $o;

		/** @type {Channel} */
		var channel = {
			assert: function (key) {
				if (!channel.has(key)) {
					throw new $TypeError('Side channel does not contain ' + inspect(key));
				}
			},
			'delete': function (key) {
				var root = $o && $o.next;
				var deletedNode = listDelete($o, key);
				if (deletedNode && root && root === deletedNode) {
					$o = void undefined;
				}
				return !!deletedNode;
			},
			get: function (key) {
				return listGet($o, key);
			},
			has: function (key) {
				return listHas($o, key);
			},
			set: function (key, value) {
				if (!$o) {
					// Initialize the linked list as an empty node, so that we don't have to special-case handling of the first node: we can always refer to it as (previous node).next, instead of something like (list).head
					$o = {
						next: void undefined
					};
				}
				// eslint-disable-next-line no-extra-parens
				listSet(/** @type {NonNullable<typeof $o>} */ ($o), key, value);
			}
		};
		// @ts-expect-error TODO: figure out why this is erroring
		return channel;
	};
	return sideChannelList;
}

var esObjectAtoms;
var hasRequiredEsObjectAtoms;

function requireEsObjectAtoms () {
	if (hasRequiredEsObjectAtoms) return esObjectAtoms;
	hasRequiredEsObjectAtoms = 1;

	/** @type {import('.')} */
	esObjectAtoms = Object;
	return esObjectAtoms;
}

var esErrors;
var hasRequiredEsErrors;

function requireEsErrors () {
	if (hasRequiredEsErrors) return esErrors;
	hasRequiredEsErrors = 1;

	/** @type {import('.')} */
	esErrors = Error;
	return esErrors;
}

var _eval;
var hasRequired_eval;

function require_eval () {
	if (hasRequired_eval) return _eval;
	hasRequired_eval = 1;

	/** @type {import('./eval')} */
	_eval = EvalError;
	return _eval;
}

var range;
var hasRequiredRange;

function requireRange () {
	if (hasRequiredRange) return range;
	hasRequiredRange = 1;

	/** @type {import('./range')} */
	range = RangeError;
	return range;
}

var ref;
var hasRequiredRef;

function requireRef () {
	if (hasRequiredRef) return ref;
	hasRequiredRef = 1;

	/** @type {import('./ref')} */
	ref = ReferenceError;
	return ref;
}

var syntax;
var hasRequiredSyntax;

function requireSyntax () {
	if (hasRequiredSyntax) return syntax;
	hasRequiredSyntax = 1;

	/** @type {import('./syntax')} */
	syntax = SyntaxError;
	return syntax;
}

var uri;
var hasRequiredUri;

function requireUri () {
	if (hasRequiredUri) return uri;
	hasRequiredUri = 1;

	/** @type {import('./uri')} */
	uri = URIError;
	return uri;
}

var abs;
var hasRequiredAbs;

function requireAbs () {
	if (hasRequiredAbs) return abs;
	hasRequiredAbs = 1;

	/** @type {import('./abs')} */
	abs = Math.abs;
	return abs;
}

var floor;
var hasRequiredFloor;

function requireFloor () {
	if (hasRequiredFloor) return floor;
	hasRequiredFloor = 1;

	/** @type {import('./floor')} */
	floor = Math.floor;
	return floor;
}

var max;
var hasRequiredMax;

function requireMax () {
	if (hasRequiredMax) return max;
	hasRequiredMax = 1;

	/** @type {import('./max')} */
	max = Math.max;
	return max;
}

var min;
var hasRequiredMin;

function requireMin () {
	if (hasRequiredMin) return min;
	hasRequiredMin = 1;

	/** @type {import('./min')} */
	min = Math.min;
	return min;
}

var pow;
var hasRequiredPow;

function requirePow () {
	if (hasRequiredPow) return pow;
	hasRequiredPow = 1;

	/** @type {import('./pow')} */
	pow = Math.pow;
	return pow;
}

var round;
var hasRequiredRound;

function requireRound () {
	if (hasRequiredRound) return round;
	hasRequiredRound = 1;

	/** @type {import('./round')} */
	round = Math.round;
	return round;
}

var _isNaN;
var hasRequired_isNaN;

function require_isNaN () {
	if (hasRequired_isNaN) return _isNaN;
	hasRequired_isNaN = 1;

	/** @type {import('./isNaN')} */
	_isNaN = Number.isNaN || function isNaN(a) {
		return a !== a;
	};
	return _isNaN;
}

var sign;
var hasRequiredSign;

function requireSign () {
	if (hasRequiredSign) return sign;
	hasRequiredSign = 1;

	var $isNaN = /*@__PURE__*/ require_isNaN();

	/** @type {import('./sign')} */
	sign = function sign(number) {
		if ($isNaN(number) || number === 0) {
			return number;
		}
		return number < 0 ? -1 : 1;
	};
	return sign;
}

var gOPD;
var hasRequiredGOPD;

function requireGOPD () {
	if (hasRequiredGOPD) return gOPD;
	hasRequiredGOPD = 1;

	/** @type {import('./gOPD')} */
	gOPD = Object.getOwnPropertyDescriptor;
	return gOPD;
}

var gopd;
var hasRequiredGopd;

function requireGopd () {
	if (hasRequiredGopd) return gopd;
	hasRequiredGopd = 1;

	/** @type {import('.')} */
	var $gOPD = /*@__PURE__*/ requireGOPD();

	if ($gOPD) {
		try {
			$gOPD([], 'length');
		} catch (e) {
			// IE 8 has a broken gOPD
			$gOPD = null;
		}
	}

	gopd = $gOPD;
	return gopd;
}

var esDefineProperty;
var hasRequiredEsDefineProperty;

function requireEsDefineProperty () {
	if (hasRequiredEsDefineProperty) return esDefineProperty;
	hasRequiredEsDefineProperty = 1;

	/** @type {import('.')} */
	var $defineProperty = Object.defineProperty || false;
	if ($defineProperty) {
		try {
			$defineProperty({}, 'a', { value: 1 });
		} catch (e) {
			// IE 8 has a broken defineProperty
			$defineProperty = false;
		}
	}

	esDefineProperty = $defineProperty;
	return esDefineProperty;
}

var shams;
var hasRequiredShams;

function requireShams () {
	if (hasRequiredShams) return shams;
	hasRequiredShams = 1;

	/** @type {import('./shams')} */
	/* eslint complexity: [2, 18], max-statements: [2, 33] */
	shams = function hasSymbols() {
		if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
		if (typeof Symbol.iterator === 'symbol') { return true; }

		/** @type {{ [k in symbol]?: unknown }} */
		var obj = {};
		var sym = Symbol('test');
		var symObj = Object(sym);
		if (typeof sym === 'string') { return false; }

		if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
		if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

		// temp disabled per https://github.com/ljharb/object.assign/issues/17
		// if (sym instanceof Symbol) { return false; }
		// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
		// if (!(symObj instanceof Symbol)) { return false; }

		// if (typeof Symbol.prototype.toString !== 'function') { return false; }
		// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

		var symVal = 42;
		obj[sym] = symVal;
		for (var _ in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
		if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

		if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

		var syms = Object.getOwnPropertySymbols(obj);
		if (syms.length !== 1 || syms[0] !== sym) { return false; }

		if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

		if (typeof Object.getOwnPropertyDescriptor === 'function') {
			// eslint-disable-next-line no-extra-parens
			var descriptor = /** @type {PropertyDescriptor} */ (Object.getOwnPropertyDescriptor(obj, sym));
			if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
		}

		return true;
	};
	return shams;
}

var hasSymbols;
var hasRequiredHasSymbols;

function requireHasSymbols () {
	if (hasRequiredHasSymbols) return hasSymbols;
	hasRequiredHasSymbols = 1;

	var origSymbol = typeof Symbol !== 'undefined' && Symbol;
	var hasSymbolSham = requireShams();

	/** @type {import('.')} */
	hasSymbols = function hasNativeSymbols() {
		if (typeof origSymbol !== 'function') { return false; }
		if (typeof Symbol !== 'function') { return false; }
		if (typeof origSymbol('foo') !== 'symbol') { return false; }
		if (typeof Symbol('bar') !== 'symbol') { return false; }

		return hasSymbolSham();
	};
	return hasSymbols;
}

var Reflect_getPrototypeOf;
var hasRequiredReflect_getPrototypeOf;

function requireReflect_getPrototypeOf () {
	if (hasRequiredReflect_getPrototypeOf) return Reflect_getPrototypeOf;
	hasRequiredReflect_getPrototypeOf = 1;

	/** @type {import('./Reflect.getPrototypeOf')} */
	Reflect_getPrototypeOf = (typeof Reflect !== 'undefined' && Reflect.getPrototypeOf) || null;
	return Reflect_getPrototypeOf;
}

var Object_getPrototypeOf;
var hasRequiredObject_getPrototypeOf;

function requireObject_getPrototypeOf () {
	if (hasRequiredObject_getPrototypeOf) return Object_getPrototypeOf;
	hasRequiredObject_getPrototypeOf = 1;

	var $Object = /*@__PURE__*/ requireEsObjectAtoms();

	/** @type {import('./Object.getPrototypeOf')} */
	Object_getPrototypeOf = $Object.getPrototypeOf || null;
	return Object_getPrototypeOf;
}

var implementation;
var hasRequiredImplementation;

function requireImplementation () {
	if (hasRequiredImplementation) return implementation;
	hasRequiredImplementation = 1;

	/* eslint no-invalid-this: 1 */

	var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
	var toStr = Object.prototype.toString;
	var max = Math.max;
	var funcType = '[object Function]';

	var concatty = function concatty(a, b) {
	    var arr = [];

	    for (var i = 0; i < a.length; i += 1) {
	        arr[i] = a[i];
	    }
	    for (var j = 0; j < b.length; j += 1) {
	        arr[j + a.length] = b[j];
	    }

	    return arr;
	};

	var slicy = function slicy(arrLike, offset) {
	    var arr = [];
	    for (var i = offset, j = 0; i < arrLike.length; i += 1, j += 1) {
	        arr[j] = arrLike[i];
	    }
	    return arr;
	};

	var joiny = function (arr, joiner) {
	    var str = '';
	    for (var i = 0; i < arr.length; i += 1) {
	        str += arr[i];
	        if (i + 1 < arr.length) {
	            str += joiner;
	        }
	    }
	    return str;
	};

	implementation = function bind(that) {
	    var target = this;
	    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
	        throw new TypeError(ERROR_MESSAGE + target);
	    }
	    var args = slicy(arguments, 1);

	    var bound;
	    var binder = function () {
	        if (this instanceof bound) {
	            var result = target.apply(
	                this,
	                concatty(args, arguments)
	            );
	            if (Object(result) === result) {
	                return result;
	            }
	            return this;
	        }
	        return target.apply(
	            that,
	            concatty(args, arguments)
	        );

	    };

	    var boundLength = max(0, target.length - args.length);
	    var boundArgs = [];
	    for (var i = 0; i < boundLength; i++) {
	        boundArgs[i] = '$' + i;
	    }

	    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

	    if (target.prototype) {
	        var Empty = function Empty() {};
	        Empty.prototype = target.prototype;
	        bound.prototype = new Empty();
	        Empty.prototype = null;
	    }

	    return bound;
	};
	return implementation;
}

var functionBind;
var hasRequiredFunctionBind;

function requireFunctionBind () {
	if (hasRequiredFunctionBind) return functionBind;
	hasRequiredFunctionBind = 1;

	var implementation = requireImplementation();

	functionBind = Function.prototype.bind || implementation;
	return functionBind;
}

var functionCall;
var hasRequiredFunctionCall;

function requireFunctionCall () {
	if (hasRequiredFunctionCall) return functionCall;
	hasRequiredFunctionCall = 1;

	/** @type {import('./functionCall')} */
	functionCall = Function.prototype.call;
	return functionCall;
}

var functionApply;
var hasRequiredFunctionApply;

function requireFunctionApply () {
	if (hasRequiredFunctionApply) return functionApply;
	hasRequiredFunctionApply = 1;

	/** @type {import('./functionApply')} */
	functionApply = Function.prototype.apply;
	return functionApply;
}

var reflectApply;
var hasRequiredReflectApply;

function requireReflectApply () {
	if (hasRequiredReflectApply) return reflectApply;
	hasRequiredReflectApply = 1;

	/** @type {import('./reflectApply')} */
	reflectApply = typeof Reflect !== 'undefined' && Reflect && Reflect.apply;
	return reflectApply;
}

var actualApply;
var hasRequiredActualApply;

function requireActualApply () {
	if (hasRequiredActualApply) return actualApply;
	hasRequiredActualApply = 1;

	var bind = requireFunctionBind();

	var $apply = requireFunctionApply();
	var $call = requireFunctionCall();
	var $reflectApply = requireReflectApply();

	/** @type {import('./actualApply')} */
	actualApply = $reflectApply || bind.call($call, $apply);
	return actualApply;
}

var callBindApplyHelpers;
var hasRequiredCallBindApplyHelpers;

function requireCallBindApplyHelpers () {
	if (hasRequiredCallBindApplyHelpers) return callBindApplyHelpers;
	hasRequiredCallBindApplyHelpers = 1;

	var bind = requireFunctionBind();
	var $TypeError = /*@__PURE__*/ requireType();

	var $call = requireFunctionCall();
	var $actualApply = requireActualApply();

	/** @type {(args: [Function, thisArg?: unknown, ...args: unknown[]]) => Function} TODO FIXME, find a way to use import('.') */
	callBindApplyHelpers = function callBindBasic(args) {
		if (args.length < 1 || typeof args[0] !== 'function') {
			throw new $TypeError('a function is required');
		}
		return $actualApply(bind, $call, args);
	};
	return callBindApplyHelpers;
}

var get;
var hasRequiredGet;

function requireGet () {
	if (hasRequiredGet) return get;
	hasRequiredGet = 1;

	var callBind = requireCallBindApplyHelpers();
	var gOPD = /*@__PURE__*/ requireGopd();

	var hasProtoAccessor;
	try {
		// eslint-disable-next-line no-extra-parens, no-proto
		hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */ ([]).__proto__ === Array.prototype;
	} catch (e) {
		if (!e || typeof e !== 'object' || !('code' in e) || e.code !== 'ERR_PROTO_ACCESS') {
			throw e;
		}
	}

	// eslint-disable-next-line no-extra-parens
	var desc = !!hasProtoAccessor && gOPD && gOPD(Object.prototype, /** @type {keyof typeof Object.prototype} */ ('__proto__'));

	var $Object = Object;
	var $getPrototypeOf = $Object.getPrototypeOf;

	/** @type {import('./get')} */
	get = desc && typeof desc.get === 'function'
		? callBind([desc.get])
		: typeof $getPrototypeOf === 'function'
			? /** @type {import('./get')} */ function getDunder(value) {
				// eslint-disable-next-line eqeqeq
				return $getPrototypeOf(value == null ? value : $Object(value));
			}
			: false;
	return get;
}

var getProto;
var hasRequiredGetProto;

function requireGetProto () {
	if (hasRequiredGetProto) return getProto;
	hasRequiredGetProto = 1;

	var reflectGetProto = requireReflect_getPrototypeOf();
	var originalGetProto = requireObject_getPrototypeOf();

	var getDunderProto = /*@__PURE__*/ requireGet();

	/** @type {import('.')} */
	getProto = reflectGetProto
		? function getProto(O) {
			// @ts-expect-error TS can't narrow inside a closure, for some reason
			return reflectGetProto(O);
		}
		: originalGetProto
			? function getProto(O) {
				if (!O || (typeof O !== 'object' && typeof O !== 'function')) {
					throw new TypeError('getProto: not an object');
				}
				// @ts-expect-error TS can't narrow inside a closure, for some reason
				return originalGetProto(O);
			}
			: getDunderProto
				? function getProto(O) {
					// @ts-expect-error TS can't narrow inside a closure, for some reason
					return getDunderProto(O);
				}
				: null;
	return getProto;
}

var hasown;
var hasRequiredHasown;

function requireHasown () {
	if (hasRequiredHasown) return hasown;
	hasRequiredHasown = 1;

	var call = Function.prototype.call;
	var $hasOwn = Object.prototype.hasOwnProperty;
	var bind = requireFunctionBind();

	/** @type {import('.')} */
	hasown = bind.call(call, $hasOwn);
	return hasown;
}

var getIntrinsic;
var hasRequiredGetIntrinsic;

function requireGetIntrinsic () {
	if (hasRequiredGetIntrinsic) return getIntrinsic;
	hasRequiredGetIntrinsic = 1;

	var undefined$1;

	var $Object = /*@__PURE__*/ requireEsObjectAtoms();

	var $Error = /*@__PURE__*/ requireEsErrors();
	var $EvalError = /*@__PURE__*/ require_eval();
	var $RangeError = /*@__PURE__*/ requireRange();
	var $ReferenceError = /*@__PURE__*/ requireRef();
	var $SyntaxError = /*@__PURE__*/ requireSyntax();
	var $TypeError = /*@__PURE__*/ requireType();
	var $URIError = /*@__PURE__*/ requireUri();

	var abs = /*@__PURE__*/ requireAbs();
	var floor = /*@__PURE__*/ requireFloor();
	var max = /*@__PURE__*/ requireMax();
	var min = /*@__PURE__*/ requireMin();
	var pow = /*@__PURE__*/ requirePow();
	var round = /*@__PURE__*/ requireRound();
	var sign = /*@__PURE__*/ requireSign();

	var $Function = Function;

	// eslint-disable-next-line consistent-return
	var getEvalledConstructor = function (expressionSyntax) {
		try {
			return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
		} catch (e) {}
	};

	var $gOPD = /*@__PURE__*/ requireGopd();
	var $defineProperty = /*@__PURE__*/ requireEsDefineProperty();

	var throwTypeError = function () {
		throw new $TypeError();
	};
	var ThrowTypeError = $gOPD
		? (function () {
			try {
				// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
				arguments.callee; // IE 8 does not throw here
				return throwTypeError;
			} catch (calleeThrows) {
				try {
					// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
					return $gOPD(arguments, 'callee').get;
				} catch (gOPDthrows) {
					return throwTypeError;
				}
			}
		}())
		: throwTypeError;

	var hasSymbols = requireHasSymbols()();

	var getProto = requireGetProto();
	var $ObjectGPO = requireObject_getPrototypeOf();
	var $ReflectGPO = requireReflect_getPrototypeOf();

	var $apply = requireFunctionApply();
	var $call = requireFunctionCall();

	var needsEval = {};

	var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined$1 : getProto(Uint8Array);

	var INTRINSICS = {
		__proto__: null,
		'%AggregateError%': typeof AggregateError === 'undefined' ? undefined$1 : AggregateError,
		'%Array%': Array,
		'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined$1 : ArrayBuffer,
		'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined$1,
		'%AsyncFromSyncIteratorPrototype%': undefined$1,
		'%AsyncFunction%': needsEval,
		'%AsyncGenerator%': needsEval,
		'%AsyncGeneratorFunction%': needsEval,
		'%AsyncIteratorPrototype%': needsEval,
		'%Atomics%': typeof Atomics === 'undefined' ? undefined$1 : Atomics,
		'%BigInt%': typeof BigInt === 'undefined' ? undefined$1 : BigInt,
		'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined$1 : BigInt64Array,
		'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined$1 : BigUint64Array,
		'%Boolean%': Boolean,
		'%DataView%': typeof DataView === 'undefined' ? undefined$1 : DataView,
		'%Date%': Date,
		'%decodeURI%': decodeURI,
		'%decodeURIComponent%': decodeURIComponent,
		'%encodeURI%': encodeURI,
		'%encodeURIComponent%': encodeURIComponent,
		'%Error%': $Error,
		'%eval%': eval, // eslint-disable-line no-eval
		'%EvalError%': $EvalError,
		'%Float16Array%': typeof Float16Array === 'undefined' ? undefined$1 : Float16Array,
		'%Float32Array%': typeof Float32Array === 'undefined' ? undefined$1 : Float32Array,
		'%Float64Array%': typeof Float64Array === 'undefined' ? undefined$1 : Float64Array,
		'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined$1 : FinalizationRegistry,
		'%Function%': $Function,
		'%GeneratorFunction%': needsEval,
		'%Int8Array%': typeof Int8Array === 'undefined' ? undefined$1 : Int8Array,
		'%Int16Array%': typeof Int16Array === 'undefined' ? undefined$1 : Int16Array,
		'%Int32Array%': typeof Int32Array === 'undefined' ? undefined$1 : Int32Array,
		'%isFinite%': isFinite,
		'%isNaN%': isNaN,
		'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined$1,
		'%JSON%': typeof JSON === 'object' ? JSON : undefined$1,
		'%Map%': typeof Map === 'undefined' ? undefined$1 : Map,
		'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined$1 : getProto(new Map()[Symbol.iterator]()),
		'%Math%': Math,
		'%Number%': Number,
		'%Object%': $Object,
		'%Object.getOwnPropertyDescriptor%': $gOPD,
		'%parseFloat%': parseFloat,
		'%parseInt%': parseInt,
		'%Promise%': typeof Promise === 'undefined' ? undefined$1 : Promise,
		'%Proxy%': typeof Proxy === 'undefined' ? undefined$1 : Proxy,
		'%RangeError%': $RangeError,
		'%ReferenceError%': $ReferenceError,
		'%Reflect%': typeof Reflect === 'undefined' ? undefined$1 : Reflect,
		'%RegExp%': RegExp,
		'%Set%': typeof Set === 'undefined' ? undefined$1 : Set,
		'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined$1 : getProto(new Set()[Symbol.iterator]()),
		'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined$1 : SharedArrayBuffer,
		'%String%': String,
		'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined$1,
		'%Symbol%': hasSymbols ? Symbol : undefined$1,
		'%SyntaxError%': $SyntaxError,
		'%ThrowTypeError%': ThrowTypeError,
		'%TypedArray%': TypedArray,
		'%TypeError%': $TypeError,
		'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined$1 : Uint8Array,
		'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined$1 : Uint8ClampedArray,
		'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined$1 : Uint16Array,
		'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined$1 : Uint32Array,
		'%URIError%': $URIError,
		'%WeakMap%': typeof WeakMap === 'undefined' ? undefined$1 : WeakMap,
		'%WeakRef%': typeof WeakRef === 'undefined' ? undefined$1 : WeakRef,
		'%WeakSet%': typeof WeakSet === 'undefined' ? undefined$1 : WeakSet,

		'%Function.prototype.call%': $call,
		'%Function.prototype.apply%': $apply,
		'%Object.defineProperty%': $defineProperty,
		'%Object.getPrototypeOf%': $ObjectGPO,
		'%Math.abs%': abs,
		'%Math.floor%': floor,
		'%Math.max%': max,
		'%Math.min%': min,
		'%Math.pow%': pow,
		'%Math.round%': round,
		'%Math.sign%': sign,
		'%Reflect.getPrototypeOf%': $ReflectGPO
	};

	if (getProto) {
		try {
			null.error; // eslint-disable-line no-unused-expressions
		} catch (e) {
			// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
			var errorProto = getProto(getProto(e));
			INTRINSICS['%Error.prototype%'] = errorProto;
		}
	}

	var doEval = function doEval(name) {
		var value;
		if (name === '%AsyncFunction%') {
			value = getEvalledConstructor('async function () {}');
		} else if (name === '%GeneratorFunction%') {
			value = getEvalledConstructor('function* () {}');
		} else if (name === '%AsyncGeneratorFunction%') {
			value = getEvalledConstructor('async function* () {}');
		} else if (name === '%AsyncGenerator%') {
			var fn = doEval('%AsyncGeneratorFunction%');
			if (fn) {
				value = fn.prototype;
			}
		} else if (name === '%AsyncIteratorPrototype%') {
			var gen = doEval('%AsyncGenerator%');
			if (gen && getProto) {
				value = getProto(gen.prototype);
			}
		}

		INTRINSICS[name] = value;

		return value;
	};

	var LEGACY_ALIASES = {
		__proto__: null,
		'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
		'%ArrayPrototype%': ['Array', 'prototype'],
		'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
		'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
		'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
		'%ArrayProto_values%': ['Array', 'prototype', 'values'],
		'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
		'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
		'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
		'%BooleanPrototype%': ['Boolean', 'prototype'],
		'%DataViewPrototype%': ['DataView', 'prototype'],
		'%DatePrototype%': ['Date', 'prototype'],
		'%ErrorPrototype%': ['Error', 'prototype'],
		'%EvalErrorPrototype%': ['EvalError', 'prototype'],
		'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
		'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
		'%FunctionPrototype%': ['Function', 'prototype'],
		'%Generator%': ['GeneratorFunction', 'prototype'],
		'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
		'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
		'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
		'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
		'%JSONParse%': ['JSON', 'parse'],
		'%JSONStringify%': ['JSON', 'stringify'],
		'%MapPrototype%': ['Map', 'prototype'],
		'%NumberPrototype%': ['Number', 'prototype'],
		'%ObjectPrototype%': ['Object', 'prototype'],
		'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
		'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
		'%PromisePrototype%': ['Promise', 'prototype'],
		'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
		'%Promise_all%': ['Promise', 'all'],
		'%Promise_reject%': ['Promise', 'reject'],
		'%Promise_resolve%': ['Promise', 'resolve'],
		'%RangeErrorPrototype%': ['RangeError', 'prototype'],
		'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
		'%RegExpPrototype%': ['RegExp', 'prototype'],
		'%SetPrototype%': ['Set', 'prototype'],
		'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
		'%StringPrototype%': ['String', 'prototype'],
		'%SymbolPrototype%': ['Symbol', 'prototype'],
		'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
		'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
		'%TypeErrorPrototype%': ['TypeError', 'prototype'],
		'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
		'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
		'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
		'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
		'%URIErrorPrototype%': ['URIError', 'prototype'],
		'%WeakMapPrototype%': ['WeakMap', 'prototype'],
		'%WeakSetPrototype%': ['WeakSet', 'prototype']
	};

	var bind = requireFunctionBind();
	var hasOwn = /*@__PURE__*/ requireHasown();
	var $concat = bind.call($call, Array.prototype.concat);
	var $spliceApply = bind.call($apply, Array.prototype.splice);
	var $replace = bind.call($call, String.prototype.replace);
	var $strSlice = bind.call($call, String.prototype.slice);
	var $exec = bind.call($call, RegExp.prototype.exec);

	/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
	var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
	var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
	var stringToPath = function stringToPath(string) {
		var first = $strSlice(string, 0, 1);
		var last = $strSlice(string, -1);
		if (first === '%' && last !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
		} else if (last === '%' && first !== '%') {
			throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
		}
		var result = [];
		$replace(string, rePropName, function (match, number, quote, subString) {
			result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
		});
		return result;
	};
	/* end adaptation */

	var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
		var intrinsicName = name;
		var alias;
		if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
			alias = LEGACY_ALIASES[intrinsicName];
			intrinsicName = '%' + alias[0] + '%';
		}

		if (hasOwn(INTRINSICS, intrinsicName)) {
			var value = INTRINSICS[intrinsicName];
			if (value === needsEval) {
				value = doEval(intrinsicName);
			}
			if (typeof value === 'undefined' && !allowMissing) {
				throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
			}

			return {
				alias: alias,
				name: intrinsicName,
				value: value
			};
		}

		throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
	};

	getIntrinsic = function GetIntrinsic(name, allowMissing) {
		if (typeof name !== 'string' || name.length === 0) {
			throw new $TypeError('intrinsic name must be a non-empty string');
		}
		if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
			throw new $TypeError('"allowMissing" argument must be a boolean');
		}

		if ($exec(/^%?[^%]*%?$/, name) === null) {
			throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
		}
		var parts = stringToPath(name);
		var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

		var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
		var intrinsicRealName = intrinsic.name;
		var value = intrinsic.value;
		var skipFurtherCaching = false;

		var alias = intrinsic.alias;
		if (alias) {
			intrinsicBaseName = alias[0];
			$spliceApply(parts, $concat([0, 1], alias));
		}

		for (var i = 1, isOwn = true; i < parts.length; i += 1) {
			var part = parts[i];
			var first = $strSlice(part, 0, 1);
			var last = $strSlice(part, -1);
			if (
				(
					(first === '"' || first === "'" || first === '`')
					|| (last === '"' || last === "'" || last === '`')
				)
				&& first !== last
			) {
				throw new $SyntaxError('property names with quotes must have matching quotes');
			}
			if (part === 'constructor' || !isOwn) {
				skipFurtherCaching = true;
			}

			intrinsicBaseName += '.' + part;
			intrinsicRealName = '%' + intrinsicBaseName + '%';

			if (hasOwn(INTRINSICS, intrinsicRealName)) {
				value = INTRINSICS[intrinsicRealName];
			} else if (value != null) {
				if (!(part in value)) {
					if (!allowMissing) {
						throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
					}
					return void undefined$1;
				}
				if ($gOPD && (i + 1) >= parts.length) {
					var desc = $gOPD(value, part);
					isOwn = !!desc;

					// By convention, when a data property is converted to an accessor
					// property to emulate a data property that does not suffer from
					// the override mistake, that accessor's getter is marked with
					// an `originalValue` property. Here, when we detect this, we
					// uphold the illusion by pretending to see that original data
					// property, i.e., returning the value rather than the getter
					// itself.
					if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
						value = desc.get;
					} else {
						value = value[part];
					}
				} else {
					isOwn = hasOwn(value, part);
					value = value[part];
				}

				if (isOwn && !skipFurtherCaching) {
					INTRINSICS[intrinsicRealName] = value;
				}
			}
		}
		return value;
	};
	return getIntrinsic;
}

var callBound;
var hasRequiredCallBound;

function requireCallBound () {
	if (hasRequiredCallBound) return callBound;
	hasRequiredCallBound = 1;

	var GetIntrinsic = /*@__PURE__*/ requireGetIntrinsic();

	var callBindBasic = requireCallBindApplyHelpers();

	/** @type {(thisArg: string, searchString: string, position?: number) => number} */
	var $indexOf = callBindBasic([GetIntrinsic('%String.prototype.indexOf%')]);

	/** @type {import('.')} */
	callBound = function callBoundIntrinsic(name, allowMissing) {
		/* eslint no-extra-parens: 0 */

		var intrinsic = /** @type {(this: unknown, ...args: unknown[]) => unknown} */ (GetIntrinsic(name, !!allowMissing));
		if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
			return callBindBasic(/** @type {const} */ ([intrinsic]));
		}
		return intrinsic;
	};
	return callBound;
}

var sideChannelMap;
var hasRequiredSideChannelMap;

function requireSideChannelMap () {
	if (hasRequiredSideChannelMap) return sideChannelMap;
	hasRequiredSideChannelMap = 1;

	var GetIntrinsic = /*@__PURE__*/ requireGetIntrinsic();
	var callBound = /*@__PURE__*/ requireCallBound();
	var inspect = /*@__PURE__*/ requireObjectInspect();

	var $TypeError = /*@__PURE__*/ requireType();
	var $Map = GetIntrinsic('%Map%', true);

	/** @type {<K, V>(thisArg: Map<K, V>, key: K) => V} */
	var $mapGet = callBound('Map.prototype.get', true);
	/** @type {<K, V>(thisArg: Map<K, V>, key: K, value: V) => void} */
	var $mapSet = callBound('Map.prototype.set', true);
	/** @type {<K, V>(thisArg: Map<K, V>, key: K) => boolean} */
	var $mapHas = callBound('Map.prototype.has', true);
	/** @type {<K, V>(thisArg: Map<K, V>, key: K) => boolean} */
	var $mapDelete = callBound('Map.prototype.delete', true);
	/** @type {<K, V>(thisArg: Map<K, V>) => number} */
	var $mapSize = callBound('Map.prototype.size', true);

	/** @type {import('.')} */
	sideChannelMap = !!$Map && /** @type {Exclude<import('.'), false>} */ function getSideChannelMap() {
		/** @typedef {ReturnType<typeof getSideChannelMap>} Channel */
		/** @typedef {Parameters<Channel['get']>[0]} K */
		/** @typedef {Parameters<Channel['set']>[1]} V */

		/** @type {Map<K, V> | undefined} */ var $m;

		/** @type {Channel} */
		var channel = {
			assert: function (key) {
				if (!channel.has(key)) {
					throw new $TypeError('Side channel does not contain ' + inspect(key));
				}
			},
			'delete': function (key) {
				if ($m) {
					var result = $mapDelete($m, key);
					if ($mapSize($m) === 0) {
						$m = void undefined;
					}
					return result;
				}
				return false;
			},
			get: function (key) { // eslint-disable-line consistent-return
				if ($m) {
					return $mapGet($m, key);
				}
			},
			has: function (key) {
				if ($m) {
					return $mapHas($m, key);
				}
				return false;
			},
			set: function (key, value) {
				if (!$m) {
					// @ts-expect-error TS can't handle narrowing a variable inside a closure
					$m = new $Map();
				}
				$mapSet($m, key, value);
			}
		};

		// @ts-expect-error TODO: figure out why TS is erroring here
		return channel;
	};
	return sideChannelMap;
}

var sideChannelWeakmap;
var hasRequiredSideChannelWeakmap;

function requireSideChannelWeakmap () {
	if (hasRequiredSideChannelWeakmap) return sideChannelWeakmap;
	hasRequiredSideChannelWeakmap = 1;

	var GetIntrinsic = /*@__PURE__*/ requireGetIntrinsic();
	var callBound = /*@__PURE__*/ requireCallBound();
	var inspect = /*@__PURE__*/ requireObjectInspect();
	var getSideChannelMap = requireSideChannelMap();

	var $TypeError = /*@__PURE__*/ requireType();
	var $WeakMap = GetIntrinsic('%WeakMap%', true);

	/** @type {<K extends object, V>(thisArg: WeakMap<K, V>, key: K) => V} */
	var $weakMapGet = callBound('WeakMap.prototype.get', true);
	/** @type {<K extends object, V>(thisArg: WeakMap<K, V>, key: K, value: V) => void} */
	var $weakMapSet = callBound('WeakMap.prototype.set', true);
	/** @type {<K extends object, V>(thisArg: WeakMap<K, V>, key: K) => boolean} */
	var $weakMapHas = callBound('WeakMap.prototype.has', true);
	/** @type {<K extends object, V>(thisArg: WeakMap<K, V>, key: K) => boolean} */
	var $weakMapDelete = callBound('WeakMap.prototype.delete', true);

	/** @type {import('.')} */
	sideChannelWeakmap = $WeakMap
		? /** @type {Exclude<import('.'), false>} */ function getSideChannelWeakMap() {
			/** @typedef {ReturnType<typeof getSideChannelWeakMap>} Channel */
			/** @typedef {Parameters<Channel['get']>[0]} K */
			/** @typedef {Parameters<Channel['set']>[1]} V */

			/** @type {WeakMap<K & object, V> | undefined} */ var $wm;
			/** @type {Channel | undefined} */ var $m;

			/** @type {Channel} */
			var channel = {
				assert: function (key) {
					if (!channel.has(key)) {
						throw new $TypeError('Side channel does not contain ' + inspect(key));
					}
				},
				'delete': function (key) {
					if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
						if ($wm) {
							return $weakMapDelete($wm, key);
						}
					} else if (getSideChannelMap) {
						if ($m) {
							return $m['delete'](key);
						}
					}
					return false;
				},
				get: function (key) {
					if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
						if ($wm) {
							return $weakMapGet($wm, key);
						}
					}
					return $m && $m.get(key);
				},
				has: function (key) {
					if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
						if ($wm) {
							return $weakMapHas($wm, key);
						}
					}
					return !!$m && $m.has(key);
				},
				set: function (key, value) {
					if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
						if (!$wm) {
							$wm = new $WeakMap();
						}
						$weakMapSet($wm, key, value);
					} else if (getSideChannelMap) {
						if (!$m) {
							$m = getSideChannelMap();
						}
						// eslint-disable-next-line no-extra-parens
						/** @type {NonNullable<typeof $m>} */ ($m).set(key, value);
					}
				}
			};

			// @ts-expect-error TODO: figure out why this is erroring
			return channel;
		}
		: getSideChannelMap;
	return sideChannelWeakmap;
}

var sideChannel;
var hasRequiredSideChannel;

function requireSideChannel () {
	if (hasRequiredSideChannel) return sideChannel;
	hasRequiredSideChannel = 1;

	var $TypeError = /*@__PURE__*/ requireType();
	var inspect = /*@__PURE__*/ requireObjectInspect();
	var getSideChannelList = requireSideChannelList();
	var getSideChannelMap = requireSideChannelMap();
	var getSideChannelWeakMap = requireSideChannelWeakmap();

	var makeChannel = getSideChannelWeakMap || getSideChannelMap || getSideChannelList;

	/** @type {import('.')} */
	sideChannel = function getSideChannel() {
		/** @typedef {ReturnType<typeof getSideChannel>} Channel */

		/** @type {Channel | undefined} */ var $channelData;

		/** @type {Channel} */
		var channel = {
			assert: function (key) {
				if (!channel.has(key)) {
					throw new $TypeError('Side channel does not contain ' + inspect(key));
				}
			},
			'delete': function (key) {
				return !!$channelData && $channelData['delete'](key);
			},
			get: function (key) {
				return $channelData && $channelData.get(key);
			},
			has: function (key) {
				return !!$channelData && $channelData.has(key);
			},
			set: function (key, value) {
				if (!$channelData) {
					$channelData = makeChannel();
				}

				$channelData.set(key, value);
			}
		};
		// @ts-expect-error TODO: figure out why this is erroring
		return channel;
	};
	return sideChannel;
}

var formats;
var hasRequiredFormats;

function requireFormats () {
	if (hasRequiredFormats) return formats;
	hasRequiredFormats = 1;

	var replace = String.prototype.replace;
	var percentTwenties = /%20/g;

	var Format = {
	    RFC1738: 'RFC1738',
	    RFC3986: 'RFC3986'
	};

	formats = {
	    'default': Format.RFC3986,
	    formatters: {
	        RFC1738: function (value) {
	            return replace.call(value, percentTwenties, '+');
	        },
	        RFC3986: function (value) {
	            return String(value);
	        }
	    },
	    RFC1738: Format.RFC1738,
	    RFC3986: Format.RFC3986
	};
	return formats;
}

var utils;
var hasRequiredUtils;

function requireUtils () {
	if (hasRequiredUtils) return utils;
	hasRequiredUtils = 1;

	var formats = /*@__PURE__*/ requireFormats();

	var has = Object.prototype.hasOwnProperty;
	var isArray = Array.isArray;

	var hexTable = (function () {
	    var array = [];
	    for (var i = 0; i < 256; ++i) {
	        array.push('%' + ((i < 16 ? '0' : '') + i.toString(16)).toUpperCase());
	    }

	    return array;
	}());

	var compactQueue = function compactQueue(queue) {
	    while (queue.length > 1) {
	        var item = queue.pop();
	        var obj = item.obj[item.prop];

	        if (isArray(obj)) {
	            var compacted = [];

	            for (var j = 0; j < obj.length; ++j) {
	                if (typeof obj[j] !== 'undefined') {
	                    compacted.push(obj[j]);
	                }
	            }

	            item.obj[item.prop] = compacted;
	        }
	    }
	};

	var arrayToObject = function arrayToObject(source, options) {
	    var obj = options && options.plainObjects ? { __proto__: null } : {};
	    for (var i = 0; i < source.length; ++i) {
	        if (typeof source[i] !== 'undefined') {
	            obj[i] = source[i];
	        }
	    }

	    return obj;
	};

	var merge = function merge(target, source, options) {
	    /* eslint no-param-reassign: 0 */
	    if (!source) {
	        return target;
	    }

	    if (typeof source !== 'object' && typeof source !== 'function') {
	        if (isArray(target)) {
	            target.push(source);
	        } else if (target && typeof target === 'object') {
	            if (
	                (options && (options.plainObjects || options.allowPrototypes))
	                || !has.call(Object.prototype, source)
	            ) {
	                target[source] = true;
	            }
	        } else {
	            return [target, source];
	        }

	        return target;
	    }

	    if (!target || typeof target !== 'object') {
	        return [target].concat(source);
	    }

	    var mergeTarget = target;
	    if (isArray(target) && !isArray(source)) {
	        mergeTarget = arrayToObject(target, options);
	    }

	    if (isArray(target) && isArray(source)) {
	        source.forEach(function (item, i) {
	            if (has.call(target, i)) {
	                var targetItem = target[i];
	                if (targetItem && typeof targetItem === 'object' && item && typeof item === 'object') {
	                    target[i] = merge(targetItem, item, options);
	                } else {
	                    target.push(item);
	                }
	            } else {
	                target[i] = item;
	            }
	        });
	        return target;
	    }

	    return Object.keys(source).reduce(function (acc, key) {
	        var value = source[key];

	        if (has.call(acc, key)) {
	            acc[key] = merge(acc[key], value, options);
	        } else {
	            acc[key] = value;
	        }
	        return acc;
	    }, mergeTarget);
	};

	var assign = function assignSingleSource(target, source) {
	    return Object.keys(source).reduce(function (acc, key) {
	        acc[key] = source[key];
	        return acc;
	    }, target);
	};

	var decode = function (str, defaultDecoder, charset) {
	    var strWithoutPlus = str.replace(/\+/g, ' ');
	    if (charset === 'iso-8859-1') {
	        // unescape never throws, no try...catch needed:
	        return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
	    }
	    // utf-8
	    try {
	        return decodeURIComponent(strWithoutPlus);
	    } catch (e) {
	        return strWithoutPlus;
	    }
	};

	var limit = 1024;

	/* eslint operator-linebreak: [2, "before"] */

	var encode = function encode(str, defaultEncoder, charset, kind, format) {
	    // This code was originally written by Brian White (mscdex) for the io.js core querystring library.
	    // It has been adapted here for stricter adherence to RFC 3986
	    if (str.length === 0) {
	        return str;
	    }

	    var string = str;
	    if (typeof str === 'symbol') {
	        string = Symbol.prototype.toString.call(str);
	    } else if (typeof str !== 'string') {
	        string = String(str);
	    }

	    if (charset === 'iso-8859-1') {
	        return escape(string).replace(/%u[0-9a-f]{4}/gi, function ($0) {
	            return '%26%23' + parseInt($0.slice(2), 16) + '%3B';
	        });
	    }

	    var out = '';
	    for (var j = 0; j < string.length; j += limit) {
	        var segment = string.length >= limit ? string.slice(j, j + limit) : string;
	        var arr = [];

	        for (var i = 0; i < segment.length; ++i) {
	            var c = segment.charCodeAt(i);
	            if (
	                c === 0x2D // -
	                || c === 0x2E // .
	                || c === 0x5F // _
	                || c === 0x7E // ~
	                || (c >= 0x30 && c <= 0x39) // 0-9
	                || (c >= 0x41 && c <= 0x5A) // a-z
	                || (c >= 0x61 && c <= 0x7A) // A-Z
	                || (format === formats.RFC1738 && (c === 0x28 || c === 0x29)) // ( )
	            ) {
	                arr[arr.length] = segment.charAt(i);
	                continue;
	            }

	            if (c < 0x80) {
	                arr[arr.length] = hexTable[c];
	                continue;
	            }

	            if (c < 0x800) {
	                arr[arr.length] = hexTable[0xC0 | (c >> 6)]
	                    + hexTable[0x80 | (c & 0x3F)];
	                continue;
	            }

	            if (c < 0xD800 || c >= 0xE000) {
	                arr[arr.length] = hexTable[0xE0 | (c >> 12)]
	                    + hexTable[0x80 | ((c >> 6) & 0x3F)]
	                    + hexTable[0x80 | (c & 0x3F)];
	                continue;
	            }

	            i += 1;
	            c = 0x10000 + (((c & 0x3FF) << 10) | (segment.charCodeAt(i) & 0x3FF));

	            arr[arr.length] = hexTable[0xF0 | (c >> 18)]
	                + hexTable[0x80 | ((c >> 12) & 0x3F)]
	                + hexTable[0x80 | ((c >> 6) & 0x3F)]
	                + hexTable[0x80 | (c & 0x3F)];
	        }

	        out += arr.join('');
	    }

	    return out;
	};

	var compact = function compact(value) {
	    var queue = [{ obj: { o: value }, prop: 'o' }];
	    var refs = [];

	    for (var i = 0; i < queue.length; ++i) {
	        var item = queue[i];
	        var obj = item.obj[item.prop];

	        var keys = Object.keys(obj);
	        for (var j = 0; j < keys.length; ++j) {
	            var key = keys[j];
	            var val = obj[key];
	            if (typeof val === 'object' && val !== null && refs.indexOf(val) === -1) {
	                queue.push({ obj: obj, prop: key });
	                refs.push(val);
	            }
	        }
	    }

	    compactQueue(queue);

	    return value;
	};

	var isRegExp = function isRegExp(obj) {
	    return Object.prototype.toString.call(obj) === '[object RegExp]';
	};

	var isBuffer = function isBuffer(obj) {
	    if (!obj || typeof obj !== 'object') {
	        return false;
	    }

	    return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
	};

	var combine = function combine(a, b) {
	    return [].concat(a, b);
	};

	var maybeMap = function maybeMap(val, fn) {
	    if (isArray(val)) {
	        var mapped = [];
	        for (var i = 0; i < val.length; i += 1) {
	            mapped.push(fn(val[i]));
	        }
	        return mapped;
	    }
	    return fn(val);
	};

	utils = {
	    arrayToObject: arrayToObject,
	    assign: assign,
	    combine: combine,
	    compact: compact,
	    decode: decode,
	    encode: encode,
	    isBuffer: isBuffer,
	    isRegExp: isRegExp,
	    maybeMap: maybeMap,
	    merge: merge
	};
	return utils;
}

var stringify_1;
var hasRequiredStringify;

function requireStringify () {
	if (hasRequiredStringify) return stringify_1;
	hasRequiredStringify = 1;

	var getSideChannel = requireSideChannel();
	var utils = /*@__PURE__*/ requireUtils();
	var formats = /*@__PURE__*/ requireFormats();
	var has = Object.prototype.hasOwnProperty;

	var arrayPrefixGenerators = {
	    brackets: function brackets(prefix) {
	        return prefix + '[]';
	    },
	    comma: 'comma',
	    indices: function indices(prefix, key) {
	        return prefix + '[' + key + ']';
	    },
	    repeat: function repeat(prefix) {
	        return prefix;
	    }
	};

	var isArray = Array.isArray;
	var push = Array.prototype.push;
	var pushToArray = function (arr, valueOrArray) {
	    push.apply(arr, isArray(valueOrArray) ? valueOrArray : [valueOrArray]);
	};

	var toISO = Date.prototype.toISOString;

	var defaultFormat = formats['default'];
	var defaults = {
	    addQueryPrefix: false,
	    allowDots: false,
	    allowEmptyArrays: false,
	    arrayFormat: 'indices',
	    charset: 'utf-8',
	    charsetSentinel: false,
	    commaRoundTrip: false,
	    delimiter: '&',
	    encode: true,
	    encodeDotInKeys: false,
	    encoder: utils.encode,
	    encodeValuesOnly: false,
	    filter: void undefined,
	    format: defaultFormat,
	    formatter: formats.formatters[defaultFormat],
	    // deprecated
	    indices: false,
	    serializeDate: function serializeDate(date) {
	        return toISO.call(date);
	    },
	    skipNulls: false,
	    strictNullHandling: false
	};

	var isNonNullishPrimitive = function isNonNullishPrimitive(v) {
	    return typeof v === 'string'
	        || typeof v === 'number'
	        || typeof v === 'boolean'
	        || typeof v === 'symbol'
	        || typeof v === 'bigint';
	};

	var sentinel = {};

	var stringify = function stringify(
	    object,
	    prefix,
	    generateArrayPrefix,
	    commaRoundTrip,
	    allowEmptyArrays,
	    strictNullHandling,
	    skipNulls,
	    encodeDotInKeys,
	    encoder,
	    filter,
	    sort,
	    allowDots,
	    serializeDate,
	    format,
	    formatter,
	    encodeValuesOnly,
	    charset,
	    sideChannel
	) {
	    var obj = object;

	    var tmpSc = sideChannel;
	    var step = 0;
	    var findFlag = false;
	    while ((tmpSc = tmpSc.get(sentinel)) !== void undefined && !findFlag) {
	        // Where object last appeared in the ref tree
	        var pos = tmpSc.get(object);
	        step += 1;
	        if (typeof pos !== 'undefined') {
	            if (pos === step) {
	                throw new RangeError('Cyclic object value');
	            } else {
	                findFlag = true; // Break while
	            }
	        }
	        if (typeof tmpSc.get(sentinel) === 'undefined') {
	            step = 0;
	        }
	    }

	    if (typeof filter === 'function') {
	        obj = filter(prefix, obj);
	    } else if (obj instanceof Date) {
	        obj = serializeDate(obj);
	    } else if (generateArrayPrefix === 'comma' && isArray(obj)) {
	        obj = utils.maybeMap(obj, function (value) {
	            if (value instanceof Date) {
	                return serializeDate(value);
	            }
	            return value;
	        });
	    }

	    if (obj === null) {
	        if (strictNullHandling) {
	            return encoder && !encodeValuesOnly ? encoder(prefix, defaults.encoder, charset, 'key', format) : prefix;
	        }

	        obj = '';
	    }

	    if (isNonNullishPrimitive(obj) || utils.isBuffer(obj)) {
	        if (encoder) {
	            var keyValue = encodeValuesOnly ? prefix : encoder(prefix, defaults.encoder, charset, 'key', format);
	            return [formatter(keyValue) + '=' + formatter(encoder(obj, defaults.encoder, charset, 'value', format))];
	        }
	        return [formatter(prefix) + '=' + formatter(String(obj))];
	    }

	    var values = [];

	    if (typeof obj === 'undefined') {
	        return values;
	    }

	    var objKeys;
	    if (generateArrayPrefix === 'comma' && isArray(obj)) {
	        // we need to join elements in
	        if (encodeValuesOnly && encoder) {
	            obj = utils.maybeMap(obj, encoder);
	        }
	        objKeys = [{ value: obj.length > 0 ? obj.join(',') || null : void undefined }];
	    } else if (isArray(filter)) {
	        objKeys = filter;
	    } else {
	        var keys = Object.keys(obj);
	        objKeys = sort ? keys.sort(sort) : keys;
	    }

	    var encodedPrefix = encodeDotInKeys ? String(prefix).replace(/\./g, '%2E') : String(prefix);

	    var adjustedPrefix = commaRoundTrip && isArray(obj) && obj.length === 1 ? encodedPrefix + '[]' : encodedPrefix;

	    if (allowEmptyArrays && isArray(obj) && obj.length === 0) {
	        return adjustedPrefix + '[]';
	    }

	    for (var j = 0; j < objKeys.length; ++j) {
	        var key = objKeys[j];
	        var value = typeof key === 'object' && key && typeof key.value !== 'undefined'
	            ? key.value
	            : obj[key];

	        if (skipNulls && value === null) {
	            continue;
	        }

	        var encodedKey = allowDots && encodeDotInKeys ? String(key).replace(/\./g, '%2E') : String(key);
	        var keyPrefix = isArray(obj)
	            ? typeof generateArrayPrefix === 'function' ? generateArrayPrefix(adjustedPrefix, encodedKey) : adjustedPrefix
	            : adjustedPrefix + (allowDots ? '.' + encodedKey : '[' + encodedKey + ']');

	        sideChannel.set(object, step);
	        var valueSideChannel = getSideChannel();
	        valueSideChannel.set(sentinel, sideChannel);
	        pushToArray(values, stringify(
	            value,
	            keyPrefix,
	            generateArrayPrefix,
	            commaRoundTrip,
	            allowEmptyArrays,
	            strictNullHandling,
	            skipNulls,
	            encodeDotInKeys,
	            generateArrayPrefix === 'comma' && encodeValuesOnly && isArray(obj) ? null : encoder,
	            filter,
	            sort,
	            allowDots,
	            serializeDate,
	            format,
	            formatter,
	            encodeValuesOnly,
	            charset,
	            valueSideChannel
	        ));
	    }

	    return values;
	};

	var normalizeStringifyOptions = function normalizeStringifyOptions(opts) {
	    if (!opts) {
	        return defaults;
	    }

	    if (typeof opts.allowEmptyArrays !== 'undefined' && typeof opts.allowEmptyArrays !== 'boolean') {
	        throw new TypeError('`allowEmptyArrays` option can only be `true` or `false`, when provided');
	    }

	    if (typeof opts.encodeDotInKeys !== 'undefined' && typeof opts.encodeDotInKeys !== 'boolean') {
	        throw new TypeError('`encodeDotInKeys` option can only be `true` or `false`, when provided');
	    }

	    if (opts.encoder !== null && typeof opts.encoder !== 'undefined' && typeof opts.encoder !== 'function') {
	        throw new TypeError('Encoder has to be a function.');
	    }

	    var charset = opts.charset || defaults.charset;
	    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
	        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
	    }

	    var format = formats['default'];
	    if (typeof opts.format !== 'undefined') {
	        if (!has.call(formats.formatters, opts.format)) {
	            throw new TypeError('Unknown format option provided.');
	        }
	        format = opts.format;
	    }
	    var formatter = formats.formatters[format];

	    var filter = defaults.filter;
	    if (typeof opts.filter === 'function' || isArray(opts.filter)) {
	        filter = opts.filter;
	    }

	    var arrayFormat;
	    if (opts.arrayFormat in arrayPrefixGenerators) {
	        arrayFormat = opts.arrayFormat;
	    } else if ('indices' in opts) {
	        arrayFormat = opts.indices ? 'indices' : 'repeat';
	    } else {
	        arrayFormat = defaults.arrayFormat;
	    }

	    if ('commaRoundTrip' in opts && typeof opts.commaRoundTrip !== 'boolean') {
	        throw new TypeError('`commaRoundTrip` must be a boolean, or absent');
	    }

	    var allowDots = typeof opts.allowDots === 'undefined' ? opts.encodeDotInKeys === true ? true : defaults.allowDots : !!opts.allowDots;

	    return {
	        addQueryPrefix: typeof opts.addQueryPrefix === 'boolean' ? opts.addQueryPrefix : defaults.addQueryPrefix,
	        allowDots: allowDots,
	        allowEmptyArrays: typeof opts.allowEmptyArrays === 'boolean' ? !!opts.allowEmptyArrays : defaults.allowEmptyArrays,
	        arrayFormat: arrayFormat,
	        charset: charset,
	        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults.charsetSentinel,
	        commaRoundTrip: !!opts.commaRoundTrip,
	        delimiter: typeof opts.delimiter === 'undefined' ? defaults.delimiter : opts.delimiter,
	        encode: typeof opts.encode === 'boolean' ? opts.encode : defaults.encode,
	        encodeDotInKeys: typeof opts.encodeDotInKeys === 'boolean' ? opts.encodeDotInKeys : defaults.encodeDotInKeys,
	        encoder: typeof opts.encoder === 'function' ? opts.encoder : defaults.encoder,
	        encodeValuesOnly: typeof opts.encodeValuesOnly === 'boolean' ? opts.encodeValuesOnly : defaults.encodeValuesOnly,
	        filter: filter,
	        format: format,
	        formatter: formatter,
	        serializeDate: typeof opts.serializeDate === 'function' ? opts.serializeDate : defaults.serializeDate,
	        skipNulls: typeof opts.skipNulls === 'boolean' ? opts.skipNulls : defaults.skipNulls,
	        sort: typeof opts.sort === 'function' ? opts.sort : null,
	        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults.strictNullHandling
	    };
	};

	stringify_1 = function (object, opts) {
	    var obj = object;
	    var options = normalizeStringifyOptions(opts);

	    var objKeys;
	    var filter;

	    if (typeof options.filter === 'function') {
	        filter = options.filter;
	        obj = filter('', obj);
	    } else if (isArray(options.filter)) {
	        filter = options.filter;
	        objKeys = filter;
	    }

	    var keys = [];

	    if (typeof obj !== 'object' || obj === null) {
	        return '';
	    }

	    var generateArrayPrefix = arrayPrefixGenerators[options.arrayFormat];
	    var commaRoundTrip = generateArrayPrefix === 'comma' && options.commaRoundTrip;

	    if (!objKeys) {
	        objKeys = Object.keys(obj);
	    }

	    if (options.sort) {
	        objKeys.sort(options.sort);
	    }

	    var sideChannel = getSideChannel();
	    for (var i = 0; i < objKeys.length; ++i) {
	        var key = objKeys[i];
	        var value = obj[key];

	        if (options.skipNulls && value === null) {
	            continue;
	        }
	        pushToArray(keys, stringify(
	            value,
	            key,
	            generateArrayPrefix,
	            commaRoundTrip,
	            options.allowEmptyArrays,
	            options.strictNullHandling,
	            options.skipNulls,
	            options.encodeDotInKeys,
	            options.encode ? options.encoder : null,
	            options.filter,
	            options.sort,
	            options.allowDots,
	            options.serializeDate,
	            options.format,
	            options.formatter,
	            options.encodeValuesOnly,
	            options.charset,
	            sideChannel
	        ));
	    }

	    var joined = keys.join(options.delimiter);
	    var prefix = options.addQueryPrefix === true ? '?' : '';

	    if (options.charsetSentinel) {
	        if (options.charset === 'iso-8859-1') {
	            // encodeURIComponent('&#10003;'), the "numeric entity" representation of a checkmark
	            prefix += 'utf8=%26%2310003%3B&';
	        } else {
	            // encodeURIComponent('✓')
	            prefix += 'utf8=%E2%9C%93&';
	        }
	    }

	    return joined.length > 0 ? prefix + joined : '';
	};
	return stringify_1;
}

var parse;
var hasRequiredParse;

function requireParse () {
	if (hasRequiredParse) return parse;
	hasRequiredParse = 1;

	var utils = /*@__PURE__*/ requireUtils();

	var has = Object.prototype.hasOwnProperty;
	var isArray = Array.isArray;

	var defaults = {
	    allowDots: false,
	    allowEmptyArrays: false,
	    allowPrototypes: false,
	    allowSparse: false,
	    arrayLimit: 20,
	    charset: 'utf-8',
	    charsetSentinel: false,
	    comma: false,
	    decodeDotInKeys: false,
	    decoder: utils.decode,
	    delimiter: '&',
	    depth: 5,
	    duplicates: 'combine',
	    ignoreQueryPrefix: false,
	    interpretNumericEntities: false,
	    parameterLimit: 1000,
	    parseArrays: true,
	    plainObjects: false,
	    strictDepth: false,
	    strictNullHandling: false,
	    throwOnLimitExceeded: false
	};

	var interpretNumericEntities = function (str) {
	    return str.replace(/&#(\d+);/g, function ($0, numberStr) {
	        return String.fromCharCode(parseInt(numberStr, 10));
	    });
	};

	var parseArrayValue = function (val, options, currentArrayLength) {
	    if (val && typeof val === 'string' && options.comma && val.indexOf(',') > -1) {
	        return val.split(',');
	    }

	    if (options.throwOnLimitExceeded && currentArrayLength >= options.arrayLimit) {
	        throw new RangeError('Array limit exceeded. Only ' + options.arrayLimit + ' element' + (options.arrayLimit === 1 ? '' : 's') + ' allowed in an array.');
	    }

	    return val;
	};

	// This is what browsers will submit when the ✓ character occurs in an
	// application/x-www-form-urlencoded body and the encoding of the page containing
	// the form is iso-8859-1, or when the submitted form has an accept-charset
	// attribute of iso-8859-1. Presumably also with other charsets that do not contain
	// the ✓ character, such as us-ascii.
	var isoSentinel = 'utf8=%26%2310003%3B'; // encodeURIComponent('&#10003;')

	// These are the percent-encoded utf-8 octets representing a checkmark, indicating that the request actually is utf-8 encoded.
	var charsetSentinel = 'utf8=%E2%9C%93'; // encodeURIComponent('✓')

	var parseValues = function parseQueryStringValues(str, options) {
	    var obj = { __proto__: null };

	    var cleanStr = options.ignoreQueryPrefix ? str.replace(/^\?/, '') : str;
	    cleanStr = cleanStr.replace(/%5B/gi, '[').replace(/%5D/gi, ']');

	    var limit = options.parameterLimit === Infinity ? undefined : options.parameterLimit;
	    var parts = cleanStr.split(
	        options.delimiter,
	        options.throwOnLimitExceeded ? limit + 1 : limit
	    );

	    if (options.throwOnLimitExceeded && parts.length > limit) {
	        throw new RangeError('Parameter limit exceeded. Only ' + limit + ' parameter' + (limit === 1 ? '' : 's') + ' allowed.');
	    }

	    var skipIndex = -1; // Keep track of where the utf8 sentinel was found
	    var i;

	    var charset = options.charset;
	    if (options.charsetSentinel) {
	        for (i = 0; i < parts.length; ++i) {
	            if (parts[i].indexOf('utf8=') === 0) {
	                if (parts[i] === charsetSentinel) {
	                    charset = 'utf-8';
	                } else if (parts[i] === isoSentinel) {
	                    charset = 'iso-8859-1';
	                }
	                skipIndex = i;
	                i = parts.length; // The eslint settings do not allow break;
	            }
	        }
	    }

	    for (i = 0; i < parts.length; ++i) {
	        if (i === skipIndex) {
	            continue;
	        }
	        var part = parts[i];

	        var bracketEqualsPos = part.indexOf(']=');
	        var pos = bracketEqualsPos === -1 ? part.indexOf('=') : bracketEqualsPos + 1;

	        var key;
	        var val;
	        if (pos === -1) {
	            key = options.decoder(part, defaults.decoder, charset, 'key');
	            val = options.strictNullHandling ? null : '';
	        } else {
	            key = options.decoder(part.slice(0, pos), defaults.decoder, charset, 'key');

	            val = utils.maybeMap(
	                parseArrayValue(
	                    part.slice(pos + 1),
	                    options,
	                    isArray(obj[key]) ? obj[key].length : 0
	                ),
	                function (encodedVal) {
	                    return options.decoder(encodedVal, defaults.decoder, charset, 'value');
	                }
	            );
	        }

	        if (val && options.interpretNumericEntities && charset === 'iso-8859-1') {
	            val = interpretNumericEntities(String(val));
	        }

	        if (part.indexOf('[]=') > -1) {
	            val = isArray(val) ? [val] : val;
	        }

	        var existing = has.call(obj, key);
	        if (existing && options.duplicates === 'combine') {
	            obj[key] = utils.combine(obj[key], val);
	        } else if (!existing || options.duplicates === 'last') {
	            obj[key] = val;
	        }
	    }

	    return obj;
	};

	var parseObject = function (chain, val, options, valuesParsed) {
	    var currentArrayLength = 0;
	    if (chain.length > 0 && chain[chain.length - 1] === '[]') {
	        var parentKey = chain.slice(0, -1).join('');
	        currentArrayLength = Array.isArray(val) && val[parentKey] ? val[parentKey].length : 0;
	    }

	    var leaf = valuesParsed ? val : parseArrayValue(val, options, currentArrayLength);

	    for (var i = chain.length - 1; i >= 0; --i) {
	        var obj;
	        var root = chain[i];

	        if (root === '[]' && options.parseArrays) {
	            obj = options.allowEmptyArrays && (leaf === '' || (options.strictNullHandling && leaf === null))
	                ? []
	                : utils.combine([], leaf);
	        } else {
	            obj = options.plainObjects ? { __proto__: null } : {};
	            var cleanRoot = root.charAt(0) === '[' && root.charAt(root.length - 1) === ']' ? root.slice(1, -1) : root;
	            var decodedRoot = options.decodeDotInKeys ? cleanRoot.replace(/%2E/g, '.') : cleanRoot;
	            var index = parseInt(decodedRoot, 10);
	            if (!options.parseArrays && decodedRoot === '') {
	                obj = { 0: leaf };
	            } else if (
	                !isNaN(index)
	                && root !== decodedRoot
	                && String(index) === decodedRoot
	                && index >= 0
	                && (options.parseArrays && index <= options.arrayLimit)
	            ) {
	                obj = [];
	                obj[index] = leaf;
	            } else if (decodedRoot !== '__proto__') {
	                obj[decodedRoot] = leaf;
	            }
	        }

	        leaf = obj;
	    }

	    return leaf;
	};

	var parseKeys = function parseQueryStringKeys(givenKey, val, options, valuesParsed) {
	    if (!givenKey) {
	        return;
	    }

	    // Transform dot notation to bracket notation
	    var key = options.allowDots ? givenKey.replace(/\.([^.[]+)/g, '[$1]') : givenKey;

	    // The regex chunks

	    var brackets = /(\[[^[\]]*])/;
	    var child = /(\[[^[\]]*])/g;

	    // Get the parent

	    var segment = options.depth > 0 && brackets.exec(key);
	    var parent = segment ? key.slice(0, segment.index) : key;

	    // Stash the parent if it exists

	    var keys = [];
	    if (parent) {
	        // If we aren't using plain objects, optionally prefix keys that would overwrite object prototype properties
	        if (!options.plainObjects && has.call(Object.prototype, parent)) {
	            if (!options.allowPrototypes) {
	                return;
	            }
	        }

	        keys.push(parent);
	    }

	    // Loop through children appending to the array until we hit depth

	    var i = 0;
	    while (options.depth > 0 && (segment = child.exec(key)) !== null && i < options.depth) {
	        i += 1;
	        if (!options.plainObjects && has.call(Object.prototype, segment[1].slice(1, -1))) {
	            if (!options.allowPrototypes) {
	                return;
	            }
	        }
	        keys.push(segment[1]);
	    }

	    // If there's a remainder, check strictDepth option for throw, else just add whatever is left

	    if (segment) {
	        if (options.strictDepth === true) {
	            throw new RangeError('Input depth exceeded depth option of ' + options.depth + ' and strictDepth is true');
	        }
	        keys.push('[' + key.slice(segment.index) + ']');
	    }

	    return parseObject(keys, val, options, valuesParsed);
	};

	var normalizeParseOptions = function normalizeParseOptions(opts) {
	    if (!opts) {
	        return defaults;
	    }

	    if (typeof opts.allowEmptyArrays !== 'undefined' && typeof opts.allowEmptyArrays !== 'boolean') {
	        throw new TypeError('`allowEmptyArrays` option can only be `true` or `false`, when provided');
	    }

	    if (typeof opts.decodeDotInKeys !== 'undefined' && typeof opts.decodeDotInKeys !== 'boolean') {
	        throw new TypeError('`decodeDotInKeys` option can only be `true` or `false`, when provided');
	    }

	    if (opts.decoder !== null && typeof opts.decoder !== 'undefined' && typeof opts.decoder !== 'function') {
	        throw new TypeError('Decoder has to be a function.');
	    }

	    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
	        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
	    }

	    if (typeof opts.throwOnLimitExceeded !== 'undefined' && typeof opts.throwOnLimitExceeded !== 'boolean') {
	        throw new TypeError('`throwOnLimitExceeded` option must be a boolean');
	    }

	    var charset = typeof opts.charset === 'undefined' ? defaults.charset : opts.charset;

	    var duplicates = typeof opts.duplicates === 'undefined' ? defaults.duplicates : opts.duplicates;

	    if (duplicates !== 'combine' && duplicates !== 'first' && duplicates !== 'last') {
	        throw new TypeError('The duplicates option must be either combine, first, or last');
	    }

	    var allowDots = typeof opts.allowDots === 'undefined' ? opts.decodeDotInKeys === true ? true : defaults.allowDots : !!opts.allowDots;

	    return {
	        allowDots: allowDots,
	        allowEmptyArrays: typeof opts.allowEmptyArrays === 'boolean' ? !!opts.allowEmptyArrays : defaults.allowEmptyArrays,
	        allowPrototypes: typeof opts.allowPrototypes === 'boolean' ? opts.allowPrototypes : defaults.allowPrototypes,
	        allowSparse: typeof opts.allowSparse === 'boolean' ? opts.allowSparse : defaults.allowSparse,
	        arrayLimit: typeof opts.arrayLimit === 'number' ? opts.arrayLimit : defaults.arrayLimit,
	        charset: charset,
	        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults.charsetSentinel,
	        comma: typeof opts.comma === 'boolean' ? opts.comma : defaults.comma,
	        decodeDotInKeys: typeof opts.decodeDotInKeys === 'boolean' ? opts.decodeDotInKeys : defaults.decodeDotInKeys,
	        decoder: typeof opts.decoder === 'function' ? opts.decoder : defaults.decoder,
	        delimiter: typeof opts.delimiter === 'string' || utils.isRegExp(opts.delimiter) ? opts.delimiter : defaults.delimiter,
	        // eslint-disable-next-line no-implicit-coercion, no-extra-parens
	        depth: (typeof opts.depth === 'number' || opts.depth === false) ? +opts.depth : defaults.depth,
	        duplicates: duplicates,
	        ignoreQueryPrefix: opts.ignoreQueryPrefix === true,
	        interpretNumericEntities: typeof opts.interpretNumericEntities === 'boolean' ? opts.interpretNumericEntities : defaults.interpretNumericEntities,
	        parameterLimit: typeof opts.parameterLimit === 'number' ? opts.parameterLimit : defaults.parameterLimit,
	        parseArrays: opts.parseArrays !== false,
	        plainObjects: typeof opts.plainObjects === 'boolean' ? opts.plainObjects : defaults.plainObjects,
	        strictDepth: typeof opts.strictDepth === 'boolean' ? !!opts.strictDepth : defaults.strictDepth,
	        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults.strictNullHandling,
	        throwOnLimitExceeded: typeof opts.throwOnLimitExceeded === 'boolean' ? opts.throwOnLimitExceeded : false
	    };
	};

	parse = function (str, opts) {
	    var options = normalizeParseOptions(opts);

	    if (str === '' || str === null || typeof str === 'undefined') {
	        return options.plainObjects ? { __proto__: null } : {};
	    }

	    var tempObj = typeof str === 'string' ? parseValues(str, options) : str;
	    var obj = options.plainObjects ? { __proto__: null } : {};

	    // Iterate over the keys and setup the new object

	    var keys = Object.keys(tempObj);
	    for (var i = 0; i < keys.length; ++i) {
	        var key = keys[i];
	        var newObj = parseKeys(key, tempObj[key], options, typeof str === 'string');
	        obj = utils.merge(obj, newObj, options);
	    }

	    if (options.allowSparse === true) {
	        return obj;
	    }

	    return utils.compact(obj);
	};
	return parse;
}

var lib$1;
var hasRequiredLib$2;

function requireLib$2 () {
	if (hasRequiredLib$2) return lib$1;
	hasRequiredLib$2 = 1;

	var stringify = /*@__PURE__*/ requireStringify();
	var parse = /*@__PURE__*/ requireParse();
	var formats = /*@__PURE__*/ requireFormats();

	lib$1 = {
	    formats: formats,
	    parse: parse,
	    stringify: stringify
	};
	return lib$1;
}

/*
 * Copyright Joyent, Inc. and other Node contributors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the
 * following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
 * NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

var hasRequiredUrl;

function requireUrl () {
	if (hasRequiredUrl) return url;
	hasRequiredUrl = 1;

	var punycode = requirePunycode();

	function Url() {
	  this.protocol = null;
	  this.slashes = null;
	  this.auth = null;
	  this.host = null;
	  this.port = null;
	  this.hostname = null;
	  this.hash = null;
	  this.search = null;
	  this.query = null;
	  this.pathname = null;
	  this.path = null;
	  this.href = null;
	}

	// Reference: RFC 3986, RFC 1808, RFC 2396

	/*
	 * define these here so at least they only have to be
	 * compiled once on the first module load.
	 */
	var protocolPattern = /^([a-z0-9.+-]+:)/i,
	  portPattern = /:[0-9]*$/,

	  // Special case for a simple path URL
	  simplePathPattern = /^(\/\/?(?!\/)[^?\s]*)(\?[^\s]*)?$/,

	  /*
	   * RFC 2396: characters reserved for delimiting URLs.
	   * We actually just auto-escape these.
	   */
	  delims = [
	    '<', '>', '"', '`', ' ', '\r', '\n', '\t'
	  ],

	  // RFC 2396: characters not allowed for various reasons.
	  unwise = [
	    '{', '}', '|', '\\', '^', '`'
	  ].concat(delims),

	  // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
	  autoEscape = ['\''].concat(unwise),
	  /*
	   * Characters that are never ever allowed in a hostname.
	   * Note that any invalid chars are also handled, but these
	   * are the ones that are *expected* to be seen, so we fast-path
	   * them.
	   */
	  nonHostChars = [
	    '%', '/', '?', ';', '#'
	  ].concat(autoEscape),
	  hostEndingChars = [
	    '/', '?', '#'
	  ],
	  hostnameMaxLen = 255,
	  hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
	  hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
	  // protocols that can allow "unsafe" and "unwise" chars.
	  unsafeProtocol = {
	    javascript: true,
	    'javascript:': true
	  },
	  // protocols that never have a hostname.
	  hostlessProtocol = {
	    javascript: true,
	    'javascript:': true
	  },
	  // protocols that always contain a // bit.
	  slashedProtocol = {
	    http: true,
	    https: true,
	    ftp: true,
	    gopher: true,
	    file: true,
	    'http:': true,
	    'https:': true,
	    'ftp:': true,
	    'gopher:': true,
	    'file:': true
	  },
	  querystring = /*@__PURE__*/ requireLib$2();

	function urlParse(url, parseQueryString, slashesDenoteHost) {
	  if (url && typeof url === 'object' && url instanceof Url) { return url; }

	  var u = new Url();
	  u.parse(url, parseQueryString, slashesDenoteHost);
	  return u;
	}

	Url.prototype.parse = function (url, parseQueryString, slashesDenoteHost) {
	  if (typeof url !== 'string') {
	    throw new TypeError("Parameter 'url' must be a string, not " + typeof url);
	  }

	  /*
	   * Copy chrome, IE, opera backslash-handling behavior.
	   * Back slashes before the query string get converted to forward slashes
	   * See: https://code.google.com/p/chromium/issues/detail?id=25916
	   */
	  var queryIndex = url.indexOf('?'),
	    splitter = queryIndex !== -1 && queryIndex < url.indexOf('#') ? '?' : '#',
	    uSplit = url.split(splitter),
	    slashRegex = /\\/g;
	  uSplit[0] = uSplit[0].replace(slashRegex, '/');
	  url = uSplit.join(splitter);

	  var rest = url;

	  /*
	   * trim before proceeding.
	   * This is to support parse stuff like "  http://foo.com  \n"
	   */
	  rest = rest.trim();

	  if (!slashesDenoteHost && url.split('#').length === 1) {
	    // Try fast path regexp
	    var simplePath = simplePathPattern.exec(rest);
	    if (simplePath) {
	      this.path = rest;
	      this.href = rest;
	      this.pathname = simplePath[1];
	      if (simplePath[2]) {
	        this.search = simplePath[2];
	        if (parseQueryString) {
	          this.query = querystring.parse(this.search.substr(1));
	        } else {
	          this.query = this.search.substr(1);
	        }
	      } else if (parseQueryString) {
	        this.search = '';
	        this.query = {};
	      }
	      return this;
	    }
	  }

	  var proto = protocolPattern.exec(rest);
	  if (proto) {
	    proto = proto[0];
	    var lowerProto = proto.toLowerCase();
	    this.protocol = lowerProto;
	    rest = rest.substr(proto.length);
	  }

	  /*
	   * figure out if it's got a host
	   * user@server is *always* interpreted as a hostname, and url
	   * resolution will treat //foo/bar as host=foo,path=bar because that's
	   * how the browser resolves relative URLs.
	   */
	  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@/]+@[^@/]+/)) {
	    var slashes = rest.substr(0, 2) === '//';
	    if (slashes && !(proto && hostlessProtocol[proto])) {
	      rest = rest.substr(2);
	      this.slashes = true;
	    }
	  }

	  if (!hostlessProtocol[proto] && (slashes || (proto && !slashedProtocol[proto]))) {

	    /*
	     * there's a hostname.
	     * the first instance of /, ?, ;, or # ends the host.
	     *
	     * If there is an @ in the hostname, then non-host chars *are* allowed
	     * to the left of the last @ sign, unless some host-ending character
	     * comes *before* the @-sign.
	     * URLs are obnoxious.
	     *
	     * ex:
	     * http://a@b@c/ => user:a@b host:c
	     * http://a@b?@c => user:a host:c path:/?@c
	     */

	    /*
	     * v0.12 TODO(isaacs): This is not quite how Chrome does things.
	     * Review our test case against browsers more comprehensively.
	     */

	    // find the first instance of any hostEndingChars
	    var hostEnd = -1;
	    for (var i = 0; i < hostEndingChars.length; i++) {
	      var hec = rest.indexOf(hostEndingChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) { hostEnd = hec; }
	    }

	    /*
	     * at this point, either we have an explicit point where the
	     * auth portion cannot go past, or the last @ char is the decider.
	     */
	    var auth, atSign;
	    if (hostEnd === -1) {
	      // atSign can be anywhere.
	      atSign = rest.lastIndexOf('@');
	    } else {
	      /*
	       * atSign must be in auth portion.
	       * http://a@b/c@d => host:b auth:a path:/c@d
	       */
	      atSign = rest.lastIndexOf('@', hostEnd);
	    }

	    /*
	     * Now we have a portion which is definitely the auth.
	     * Pull that off.
	     */
	    if (atSign !== -1) {
	      auth = rest.slice(0, atSign);
	      rest = rest.slice(atSign + 1);
	      this.auth = decodeURIComponent(auth);
	    }

	    // the host is the remaining to the left of the first non-host char
	    hostEnd = -1;
	    for (var i = 0; i < nonHostChars.length; i++) {
	      var hec = rest.indexOf(nonHostChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) { hostEnd = hec; }
	    }
	    // if we still have not hit it, then the entire thing is a host.
	    if (hostEnd === -1) { hostEnd = rest.length; }

	    this.host = rest.slice(0, hostEnd);
	    rest = rest.slice(hostEnd);

	    // pull out port.
	    this.parseHost();

	    /*
	     * we've indicated that there is a hostname,
	     * so even if it's empty, it has to be present.
	     */
	    this.hostname = this.hostname || '';

	    /*
	     * if hostname begins with [ and ends with ]
	     * assume that it's an IPv6 address.
	     */
	    var ipv6Hostname = this.hostname[0] === '[' && this.hostname[this.hostname.length - 1] === ']';

	    // validate a little.
	    if (!ipv6Hostname) {
	      var hostparts = this.hostname.split(/\./);
	      for (var i = 0, l = hostparts.length; i < l; i++) {
	        var part = hostparts[i];
	        if (!part) { continue; }
	        if (!part.match(hostnamePartPattern)) {
	          var newpart = '';
	          for (var j = 0, k = part.length; j < k; j++) {
	            if (part.charCodeAt(j) > 127) {
	              /*
	               * we replace non-ASCII char with a temporary placeholder
	               * we need this to make sure size of hostname is not
	               * broken by replacing non-ASCII by nothing
	               */
	              newpart += 'x';
	            } else {
	              newpart += part[j];
	            }
	          }
	          // we test again with ASCII char only
	          if (!newpart.match(hostnamePartPattern)) {
	            var validParts = hostparts.slice(0, i);
	            var notHost = hostparts.slice(i + 1);
	            var bit = part.match(hostnamePartStart);
	            if (bit) {
	              validParts.push(bit[1]);
	              notHost.unshift(bit[2]);
	            }
	            if (notHost.length) {
	              rest = '/' + notHost.join('.') + rest;
	            }
	            this.hostname = validParts.join('.');
	            break;
	          }
	        }
	      }
	    }

	    if (this.hostname.length > hostnameMaxLen) {
	      this.hostname = '';
	    } else {
	      // hostnames are always lower case.
	      this.hostname = this.hostname.toLowerCase();
	    }

	    if (!ipv6Hostname) {
	      /*
	       * IDNA Support: Returns a punycoded representation of "domain".
	       * It only converts parts of the domain name that
	       * have non-ASCII characters, i.e. it doesn't matter if
	       * you call it with a domain that already is ASCII-only.
	       */
	      this.hostname = punycode.toASCII(this.hostname);
	    }

	    var p = this.port ? ':' + this.port : '';
	    var h = this.hostname || '';
	    this.host = h + p;
	    this.href += this.host;

	    /*
	     * strip [ and ] from the hostname
	     * the host field still retains them, though
	     */
	    if (ipv6Hostname) {
	      this.hostname = this.hostname.substr(1, this.hostname.length - 2);
	      if (rest[0] !== '/') {
	        rest = '/' + rest;
	      }
	    }
	  }

	  /*
	   * now rest is set to the post-host stuff.
	   * chop off any delim chars.
	   */
	  if (!unsafeProtocol[lowerProto]) {

	    /*
	     * First, make 100% sure that any "autoEscape" chars get
	     * escaped, even if encodeURIComponent doesn't think they
	     * need to be.
	     */
	    for (var i = 0, l = autoEscape.length; i < l; i++) {
	      var ae = autoEscape[i];
	      if (rest.indexOf(ae) === -1) { continue; }
	      var esc = encodeURIComponent(ae);
	      if (esc === ae) {
	        esc = escape(ae);
	      }
	      rest = rest.split(ae).join(esc);
	    }
	  }

	  // chop off from the tail first.
	  var hash = rest.indexOf('#');
	  if (hash !== -1) {
	    // got a fragment string.
	    this.hash = rest.substr(hash);
	    rest = rest.slice(0, hash);
	  }
	  var qm = rest.indexOf('?');
	  if (qm !== -1) {
	    this.search = rest.substr(qm);
	    this.query = rest.substr(qm + 1);
	    if (parseQueryString) {
	      this.query = querystring.parse(this.query);
	    }
	    rest = rest.slice(0, qm);
	  } else if (parseQueryString) {
	    // no query string, but parseQueryString still requested
	    this.search = '';
	    this.query = {};
	  }
	  if (rest) { this.pathname = rest; }
	  if (slashedProtocol[lowerProto] && this.hostname && !this.pathname) {
	    this.pathname = '/';
	  }

	  // to support http.request
	  if (this.pathname || this.search) {
	    var p = this.pathname || '';
	    var s = this.search || '';
	    this.path = p + s;
	  }

	  // finally, reconstruct the href based on what has been validated.
	  this.href = this.format();
	  return this;
	};

	// format a parsed object into a url string
	function urlFormat(obj) {
	  /*
	   * ensure it's an object, and not a string url.
	   * If it's an obj, this is a no-op.
	   * this way, you can call url_format() on strings
	   * to clean up potentially wonky urls.
	   */
	  if (typeof obj === 'string') { obj = urlParse(obj); }
	  if (!(obj instanceof Url)) { return Url.prototype.format.call(obj); }
	  return obj.format();
	}

	Url.prototype.format = function () {
	  var auth = this.auth || '';
	  if (auth) {
	    auth = encodeURIComponent(auth);
	    auth = auth.replace(/%3A/i, ':');
	    auth += '@';
	  }

	  var protocol = this.protocol || '',
	    pathname = this.pathname || '',
	    hash = this.hash || '',
	    host = false,
	    query = '';

	  if (this.host) {
	    host = auth + this.host;
	  } else if (this.hostname) {
	    host = auth + (this.hostname.indexOf(':') === -1 ? this.hostname : '[' + this.hostname + ']');
	    if (this.port) {
	      host += ':' + this.port;
	    }
	  }

	  if (this.query && typeof this.query === 'object' && Object.keys(this.query).length) {
	    query = querystring.stringify(this.query, {
	      arrayFormat: 'repeat',
	      addQueryPrefix: false
	    });
	  }

	  var search = this.search || (query && ('?' + query)) || '';

	  if (protocol && protocol.substr(-1) !== ':') { protocol += ':'; }

	  /*
	   * only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
	   * unless they had them to begin with.
	   */
	  if (this.slashes || (!protocol || slashedProtocol[protocol]) && host !== false) {
	    host = '//' + (host || '');
	    if (pathname && pathname.charAt(0) !== '/') { pathname = '/' + pathname; }
	  } else if (!host) {
	    host = '';
	  }

	  if (hash && hash.charAt(0) !== '#') { hash = '#' + hash; }
	  if (search && search.charAt(0) !== '?') { search = '?' + search; }

	  pathname = pathname.replace(/[?#]/g, function (match) {
	    return encodeURIComponent(match);
	  });
	  search = search.replace('#', '%23');

	  return protocol + host + pathname + search + hash;
	};

	function urlResolve(source, relative) {
	  return urlParse(source, false, true).resolve(relative);
	}

	Url.prototype.resolve = function (relative) {
	  return this.resolveObject(urlParse(relative, false, true)).format();
	};

	function urlResolveObject(source, relative) {
	  if (!source) { return relative; }
	  return urlParse(source, false, true).resolveObject(relative);
	}

	Url.prototype.resolveObject = function (relative) {
	  if (typeof relative === 'string') {
	    var rel = new Url();
	    rel.parse(relative, false, true);
	    relative = rel;
	  }

	  var result = new Url();
	  var tkeys = Object.keys(this);
	  for (var tk = 0; tk < tkeys.length; tk++) {
	    var tkey = tkeys[tk];
	    result[tkey] = this[tkey];
	  }

	  /*
	   * hash is always overridden, no matter what.
	   * even href="" will remove it.
	   */
	  result.hash = relative.hash;

	  // if the relative url is empty, then there's nothing left to do here.
	  if (relative.href === '') {
	    result.href = result.format();
	    return result;
	  }

	  // hrefs like //foo/bar always cut to the protocol.
	  if (relative.slashes && !relative.protocol) {
	    // take everything except the protocol from relative
	    var rkeys = Object.keys(relative);
	    for (var rk = 0; rk < rkeys.length; rk++) {
	      var rkey = rkeys[rk];
	      if (rkey !== 'protocol') { result[rkey] = relative[rkey]; }
	    }

	    // urlParse appends trailing / to urls like http://www.example.com
	    if (slashedProtocol[result.protocol] && result.hostname && !result.pathname) {
	      result.pathname = '/';
	      result.path = result.pathname;
	    }

	    result.href = result.format();
	    return result;
	  }

	  if (relative.protocol && relative.protocol !== result.protocol) {
	    /*
	     * if it's a known url protocol, then changing
	     * the protocol does weird things
	     * first, if it's not file:, then we MUST have a host,
	     * and if there was a path
	     * to begin with, then we MUST have a path.
	     * if it is file:, then the host is dropped,
	     * because that's known to be hostless.
	     * anything else is assumed to be absolute.
	     */
	    if (!slashedProtocol[relative.protocol]) {
	      var keys = Object.keys(relative);
	      for (var v = 0; v < keys.length; v++) {
	        var k = keys[v];
	        result[k] = relative[k];
	      }
	      result.href = result.format();
	      return result;
	    }

	    result.protocol = relative.protocol;
	    if (!relative.host && !hostlessProtocol[relative.protocol]) {
	      var relPath = (relative.pathname || '').split('/');
	      while (relPath.length && !(relative.host = relPath.shift())) { }
	      if (!relative.host) { relative.host = ''; }
	      if (!relative.hostname) { relative.hostname = ''; }
	      if (relPath[0] !== '') { relPath.unshift(''); }
	      if (relPath.length < 2) { relPath.unshift(''); }
	      result.pathname = relPath.join('/');
	    } else {
	      result.pathname = relative.pathname;
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    result.host = relative.host || '';
	    result.auth = relative.auth;
	    result.hostname = relative.hostname || relative.host;
	    result.port = relative.port;
	    // to support http.request
	    if (result.pathname || result.search) {
	      var p = result.pathname || '';
	      var s = result.search || '';
	      result.path = p + s;
	    }
	    result.slashes = result.slashes || relative.slashes;
	    result.href = result.format();
	    return result;
	  }

	  var isSourceAbs = result.pathname && result.pathname.charAt(0) === '/',
	    isRelAbs = relative.host || relative.pathname && relative.pathname.charAt(0) === '/',
	    mustEndAbs = isRelAbs || isSourceAbs || (result.host && relative.pathname),
	    removeAllDots = mustEndAbs,
	    srcPath = result.pathname && result.pathname.split('/') || [],
	    relPath = relative.pathname && relative.pathname.split('/') || [],
	    psychotic = result.protocol && !slashedProtocol[result.protocol];

	  /*
	   * if the url is a non-slashed url, then relative
	   * links like ../.. should be able
	   * to crawl up to the hostname, as well.  This is strange.
	   * result.protocol has already been set by now.
	   * Later on, put the first path part into the host field.
	   */
	  if (psychotic) {
	    result.hostname = '';
	    result.port = null;
	    if (result.host) {
	      if (srcPath[0] === '') { srcPath[0] = result.host; } else { srcPath.unshift(result.host); }
	    }
	    result.host = '';
	    if (relative.protocol) {
	      relative.hostname = null;
	      relative.port = null;
	      if (relative.host) {
	        if (relPath[0] === '') { relPath[0] = relative.host; } else { relPath.unshift(relative.host); }
	      }
	      relative.host = null;
	    }
	    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
	  }

	  if (isRelAbs) {
	    // it's absolute.
	    result.host = relative.host || relative.host === '' ? relative.host : result.host;
	    result.hostname = relative.hostname || relative.hostname === '' ? relative.hostname : result.hostname;
	    result.search = relative.search;
	    result.query = relative.query;
	    srcPath = relPath;
	    // fall through to the dot-handling below.
	  } else if (relPath.length) {
	    /*
	     * it's relative
	     * throw away the existing file, and take the new path instead.
	     */
	    if (!srcPath) { srcPath = []; }
	    srcPath.pop();
	    srcPath = srcPath.concat(relPath);
	    result.search = relative.search;
	    result.query = relative.query;
	  } else if (relative.search != null) {
	    /*
	     * just pull out the search.
	     * like href='?foo'.
	     * Put this after the other two cases because it simplifies the booleans
	     */
	    if (psychotic) {
	      result.host = srcPath.shift();
	      result.hostname = result.host;
	      /*
	       * occationaly the auth can get stuck only in host
	       * this especially happens in cases like
	       * url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	       */
	      var authInHost = result.host && result.host.indexOf('@') > 0 ? result.host.split('@') : false;
	      if (authInHost) {
	        result.auth = authInHost.shift();
	        result.hostname = authInHost.shift();
	        result.host = result.hostname;
	      }
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    // to support http.request
	    if (result.pathname !== null || result.search !== null) {
	      result.path = (result.pathname ? result.pathname : '') + (result.search ? result.search : '');
	    }
	    result.href = result.format();
	    return result;
	  }

	  if (!srcPath.length) {
	    /*
	     * no path at all.  easy.
	     * we've already handled the other stuff above.
	     */
	    result.pathname = null;
	    // to support http.request
	    if (result.search) {
	      result.path = '/' + result.search;
	    } else {
	      result.path = null;
	    }
	    result.href = result.format();
	    return result;
	  }

	  /*
	   * if a url ENDs in . or .., then it must get a trailing slash.
	   * however, if it ends in anything else non-slashy,
	   * then it must NOT get a trailing slash.
	   */
	  var last = srcPath.slice(-1)[0];
	  var hasTrailingSlash = (result.host || relative.host || srcPath.length > 1) && (last === '.' || last === '..') || last === '';

	  /*
	   * strip single dots, resolve double dots to parent dir
	   * if the path tries to go above the root, `up` ends up > 0
	   */
	  var up = 0;
	  for (var i = srcPath.length; i >= 0; i--) {
	    last = srcPath[i];
	    if (last === '.') {
	      srcPath.splice(i, 1);
	    } else if (last === '..') {
	      srcPath.splice(i, 1);
	      up++;
	    } else if (up) {
	      srcPath.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (!mustEndAbs && !removeAllDots) {
	    for (; up--; up) {
	      srcPath.unshift('..');
	    }
	  }

	  if (mustEndAbs && srcPath[0] !== '' && (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
	    srcPath.unshift('');
	  }

	  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
	    srcPath.push('');
	  }

	  var isAbsolute = srcPath[0] === '' || (srcPath[0] && srcPath[0].charAt(0) === '/');

	  // put the host back
	  if (psychotic) {
	    result.hostname = isAbsolute ? '' : srcPath.length ? srcPath.shift() : '';
	    result.host = result.hostname;
	    /*
	     * occationaly the auth can get stuck only in host
	     * this especially happens in cases like
	     * url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	     */
	    var authInHost = result.host && result.host.indexOf('@') > 0 ? result.host.split('@') : false;
	    if (authInHost) {
	      result.auth = authInHost.shift();
	      result.hostname = authInHost.shift();
	      result.host = result.hostname;
	    }
	  }

	  mustEndAbs = mustEndAbs || (result.host && srcPath.length);

	  if (mustEndAbs && !isAbsolute) {
	    srcPath.unshift('');
	  }

	  if (srcPath.length > 0) {
	    result.pathname = srcPath.join('/');
	  } else {
	    result.pathname = null;
	    result.path = null;
	  }

	  // to support request.http
	  if (result.pathname !== null || result.search !== null) {
	    result.path = (result.pathname ? result.pathname : '') + (result.search ? result.search : '');
	  }
	  result.auth = relative.auth || result.auth;
	  result.slashes = result.slashes || relative.slashes;
	  result.href = result.format();
	  return result;
	};

	Url.prototype.parseHost = function () {
	  var host = this.host;
	  var port = portPattern.exec(host);
	  if (port) {
	    port = port[0];
	    if (port !== ':') {
	      this.port = port.substr(1);
	    }
	    host = host.substr(0, host.length - port.length);
	  }
	  if (host) { this.hostname = host; }
	};

	url.parse = urlParse;
	url.resolve = urlResolve;
	url.resolveObject = urlResolveObject;
	url.format = urlFormat;

	url.Url = Url;
	return url;
}

var hasRequiredUtil$1;

function requireUtil$1 () {
	if (hasRequiredUtil$1) return util$1;
	hasRequiredUtil$1 = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.unixify = exports.getWriteSyncArgs = exports.getWriteArgs = exports.bufToUint8 = exports.isWin = void 0;
		exports.promisify = promisify;
		exports.validateCallback = validateCallback;
		exports.modeToNumber = modeToNumber;
		exports.nullCheck = nullCheck;
		exports.pathToFilename = pathToFilename;
		exports.createError = createError;
		exports.genRndStr6 = genRndStr6;
		exports.flagsToNumber = flagsToNumber;
		exports.isFd = isFd;
		exports.validateFd = validateFd;
		exports.streamToBuffer = streamToBuffer;
		exports.dataToBuffer = dataToBuffer;
		exports.bufferToEncoding = bufferToEncoding;
		exports.isReadableStream = isReadableStream;
		const constants_1 = requireConstants();
		const errors = requireErrors$1();
		const buffer_1 = requireBuffer$1();
		const encoding_1 = requireEncoding();
		const buffer_2 = requireBuffer$1();
		const queueMicrotask_1 = requireQueueMicrotask();
		exports.isWin = process$1.platform === 'win32';
		function promisify(fs, fn, getResult = input => input) {
		    return (...args) => new Promise((resolve, reject) => {
		        fs[fn].bind(fs)(...args, (error, result) => {
		            if (error)
		                return reject(error);
		            return resolve(getResult(result));
		        });
		    });
		}
		function validateCallback(callback) {
		    if (typeof callback !== 'function')
		        throw TypeError(constants_1.ERRSTR.CB);
		    return callback;
		}
		function _modeToNumber(mode, def) {
		    if (typeof mode === 'number')
		        return mode;
		    if (typeof mode === 'string')
		        return parseInt(mode, 8);
		    if (def)
		        return modeToNumber(def);
		    return undefined;
		}
		function modeToNumber(mode, def) {
		    const result = _modeToNumber(mode, def);
		    if (typeof result !== 'number' || isNaN(result))
		        throw new TypeError(constants_1.ERRSTR.MODE_INT);
		    return result;
		}
		function nullCheck(path, callback) {
		    if (('' + path).indexOf('\u0000') !== -1) {
		        const er = new Error('Path must be a string without null bytes');
		        er.code = 'ENOENT';
		        if (typeof callback !== 'function')
		            throw er;
		        (0, queueMicrotask_1.default)(() => {
		            callback(er);
		        });
		        return false;
		    }
		    return true;
		}
		function getPathFromURLPosix(url) {
		    if (url.hostname !== '') {
		        throw new errors.TypeError('ERR_INVALID_FILE_URL_HOST', process$1.platform);
		    }
		    const pathname = url.pathname;
		    for (let n = 0; n < pathname.length; n++) {
		        if (pathname[n] === '%') {
		            const third = pathname.codePointAt(n + 2) | 0x20;
		            if (pathname[n + 1] === '2' && third === 102) {
		                throw new errors.TypeError('ERR_INVALID_FILE_URL_PATH', 'must not include encoded / characters');
		            }
		        }
		    }
		    return decodeURIComponent(pathname);
		}
		function pathToFilename(path) {
		    if (path instanceof Uint8Array) {
		        path = (0, buffer_2.bufferFrom)(path);
		    }
		    if (typeof path !== 'string' && !buffer_1.Buffer.isBuffer(path)) {
		        try {
		            if (!(path instanceof requireUrl().URL))
		                throw new TypeError(constants_1.ERRSTR.PATH_STR);
		        }
		        catch (err) {
		            throw new TypeError(constants_1.ERRSTR.PATH_STR);
		        }
		        path = getPathFromURLPosix(path);
		    }
		    const pathString = String(path);
		    nullCheck(pathString);
		    // return slash(pathString);
		    return pathString;
		}
		const ENOENT = 'ENOENT';
		const EBADF = 'EBADF';
		const EINVAL = 'EINVAL';
		const EPERM = 'EPERM';
		const EPROTO = 'EPROTO';
		const EEXIST = 'EEXIST';
		const ENOTDIR = 'ENOTDIR';
		const EMFILE = 'EMFILE';
		const EACCES = 'EACCES';
		const EISDIR = 'EISDIR';
		const ENOTEMPTY = 'ENOTEMPTY';
		const ENOSYS = 'ENOSYS';
		const ERR_FS_EISDIR = 'ERR_FS_EISDIR';
		const ERR_OUT_OF_RANGE = 'ERR_OUT_OF_RANGE';
		function formatError(errorCode, func = '', path = '', path2 = '') {
		    let pathFormatted = '';
		    if (path)
		        pathFormatted = ` '${path}'`;
		    if (path2)
		        pathFormatted += ` -> '${path2}'`;
		    switch (errorCode) {
		        case ENOENT:
		            return `ENOENT: no such file or directory, ${func}${pathFormatted}`;
		        case EBADF:
		            return `EBADF: bad file descriptor, ${func}${pathFormatted}`;
		        case EINVAL:
		            return `EINVAL: invalid argument, ${func}${pathFormatted}`;
		        case EPERM:
		            return `EPERM: operation not permitted, ${func}${pathFormatted}`;
		        case EPROTO:
		            return `EPROTO: protocol error, ${func}${pathFormatted}`;
		        case EEXIST:
		            return `EEXIST: file already exists, ${func}${pathFormatted}`;
		        case ENOTDIR:
		            return `ENOTDIR: not a directory, ${func}${pathFormatted}`;
		        case EISDIR:
		            return `EISDIR: illegal operation on a directory, ${func}${pathFormatted}`;
		        case EACCES:
		            return `EACCES: permission denied, ${func}${pathFormatted}`;
		        case ENOTEMPTY:
		            return `ENOTEMPTY: directory not empty, ${func}${pathFormatted}`;
		        case EMFILE:
		            return `EMFILE: too many open files, ${func}${pathFormatted}`;
		        case ENOSYS:
		            return `ENOSYS: function not implemented, ${func}${pathFormatted}`;
		        case ERR_FS_EISDIR:
		            return `[ERR_FS_EISDIR]: Path is a directory: ${func} returned EISDIR (is a directory) ${path}`;
		        case ERR_OUT_OF_RANGE:
		            return `[ERR_OUT_OF_RANGE]: value out of range, ${func}${pathFormatted}`;
		        default:
		            return `${errorCode}: error occurred, ${func}${pathFormatted}`;
		    }
		}
		function createError(errorCode, func = '', path = '', path2 = '', Constructor = Error) {
		    const error = new Constructor(formatError(errorCode, func, path, path2));
		    error.code = errorCode;
		    if (path) {
		        error.path = path;
		    }
		    return error;
		}
		function genRndStr6() {
		    const str = (Math.random() + 1).toString(36).substring(2, 8);
		    if (str.length === 6)
		        return str;
		    else
		        return genRndStr6();
		}
		function flagsToNumber(flags) {
		    if (typeof flags === 'number')
		        return flags;
		    if (typeof flags === 'string') {
		        const flagsNum = constants_1.FLAGS[flags];
		        if (typeof flagsNum !== 'undefined')
		            return flagsNum;
		    }
		    // throw new TypeError(formatError(ERRSTR_FLAG(flags)));
		    throw new errors.TypeError('ERR_INVALID_OPT_VALUE', 'flags', flags);
		}
		function isFd(path) {
		    return path >>> 0 === path;
		}
		function validateFd(fd) {
		    if (!isFd(fd))
		        throw TypeError(constants_1.ERRSTR.FD);
		}
		function streamToBuffer(stream) {
		    const chunks = [];
		    return new Promise((resolve, reject) => {
		        stream.on('data', chunk => chunks.push(chunk));
		        stream.on('end', () => resolve(buffer_1.Buffer.concat(chunks)));
		        stream.on('error', reject);
		    });
		}
		function dataToBuffer(data, encoding = encoding_1.ENCODING_UTF8) {
		    if (buffer_1.Buffer.isBuffer(data))
		        return data;
		    else if (data instanceof Uint8Array)
		        return (0, buffer_2.bufferFrom)(data);
		    else
		        return (0, buffer_2.bufferFrom)(String(data), encoding);
		}
		const bufToUint8 = (buf) => new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength);
		exports.bufToUint8 = bufToUint8;
		const getWriteArgs = (fd, a, b, c, d, e) => {
		    validateFd(fd);
		    let offset = 0;
		    let length;
		    let position = null;
		    let encoding;
		    let callback;
		    const tipa = typeof a;
		    const tipb = typeof b;
		    const tipc = typeof c;
		    const tipd = typeof d;
		    if (tipa !== 'string') {
		        if (tipb === 'function') {
		            callback = b;
		        }
		        else if (tipc === 'function') {
		            offset = b | 0;
		            callback = c;
		        }
		        else if (tipd === 'function') {
		            offset = b | 0;
		            length = c;
		            callback = d;
		        }
		        else {
		            offset = b | 0;
		            length = c;
		            position = d;
		            callback = e;
		        }
		    }
		    else {
		        if (tipb === 'function') {
		            callback = b;
		        }
		        else if (tipc === 'function') {
		            position = b;
		            callback = c;
		        }
		        else if (tipd === 'function') {
		            position = b;
		            encoding = c;
		            callback = d;
		        }
		    }
		    const buf = dataToBuffer(a, encoding);
		    if (tipa !== 'string') {
		        if (typeof length === 'undefined')
		            length = buf.length;
		    }
		    else {
		        offset = 0;
		        length = buf.length;
		    }
		    const cb = validateCallback(callback);
		    return [fd, tipa === 'string', buf, offset, length, position, cb];
		};
		exports.getWriteArgs = getWriteArgs;
		const getWriteSyncArgs = (fd, a, b, c, d) => {
		    validateFd(fd);
		    let encoding;
		    let offset;
		    let length;
		    let position;
		    const isBuffer = typeof a !== 'string';
		    if (isBuffer) {
		        offset = (b || 0) | 0;
		        length = c;
		        position = d;
		    }
		    else {
		        position = b;
		        encoding = c;
		    }
		    const buf = dataToBuffer(a, encoding);
		    if (isBuffer) {
		        if (typeof length === 'undefined') {
		            length = buf.length;
		        }
		    }
		    else {
		        offset = 0;
		        length = buf.length;
		    }
		    return [fd, buf, offset || 0, length, position];
		};
		exports.getWriteSyncArgs = getWriteSyncArgs;
		function bufferToEncoding(buffer, encoding) {
		    if (!encoding || encoding === 'buffer')
		        return buffer;
		    else
		        return buffer.toString(encoding);
		}
		function isReadableStream(stream) {
		    return (stream !== null &&
		        typeof stream === 'object' &&
		        typeof stream.pipe === 'function' &&
		        typeof stream.on === 'function' &&
		        stream.readable === true);
		}
		const isSeparator = (str, i) => {
		    let char = str[i];
		    return i > 0 && (char === '/' || (exports.isWin && char === '\\'));
		};
		const removeTrailingSeparator = (str) => {
		    let i = str.length - 1;
		    if (i < 2)
		        return str;
		    while (isSeparator(str, i))
		        i--;
		    return str.substr(0, i + 1);
		};
		const normalizePath = (str, stripTrailing) => {
		    if (typeof str !== 'string')
		        throw new TypeError('expected a string');
		    str = str.replace(/[\\\/]+/g, '/');
		    if (stripTrailing !== false)
		        str = removeTrailingSeparator(str);
		    return str;
		};
		const unixify = (filepath, stripTrailing = true) => {
		    if (exports.isWin) {
		        filepath = normalizePath(filepath, stripTrailing);
		        return filepath.replace(/^([a-zA-Z]+:|\.\/)/, '');
		    }
		    return filepath;
		};
		exports.unixify = unixify;
		
	} (util$1));
	return util$1;
}

var hasRequiredFileHandle;

function requireFileHandle () {
	if (hasRequiredFileHandle) return FileHandle;
	hasRequiredFileHandle = 1;
	Object.defineProperty(FileHandle, "__esModule", { value: true });
	FileHandle.FileHandle = void 0;
	const util_1 = requireUtil$1();
	let FileHandle$1 = class FileHandle {
	    constructor(fs, fd) {
	        this.fs = fs;
	        this.fd = fd;
	    }
	    appendFile(data, options) {
	        return (0, util_1.promisify)(this.fs, 'appendFile')(this.fd, data, options);
	    }
	    chmod(mode) {
	        return (0, util_1.promisify)(this.fs, 'fchmod')(this.fd, mode);
	    }
	    chown(uid, gid) {
	        return (0, util_1.promisify)(this.fs, 'fchown')(this.fd, uid, gid);
	    }
	    close() {
	        return (0, util_1.promisify)(this.fs, 'close')(this.fd);
	    }
	    datasync() {
	        return (0, util_1.promisify)(this.fs, 'fdatasync')(this.fd);
	    }
	    createReadStream(options) {
	        return this.fs.createReadStream('', Object.assign(Object.assign({}, options), { fd: this }));
	    }
	    createWriteStream(options) {
	        return this.fs.createWriteStream('', Object.assign(Object.assign({}, options), { fd: this }));
	    }
	    readableWebStream(options) {
	        return new ReadableStream({
	            pull: async (controller) => {
	                const data = await this.readFile();
	                controller.enqueue(data);
	                controller.close();
	            },
	        });
	    }
	    read(buffer, offset, length, position) {
	        return (0, util_1.promisify)(this.fs, 'read', bytesRead => ({ bytesRead, buffer }))(this.fd, buffer, offset, length, position);
	    }
	    readv(buffers, position) {
	        return (0, util_1.promisify)(this.fs, 'readv', bytesRead => ({ bytesRead, buffers }))(this.fd, buffers, position);
	    }
	    readFile(options) {
	        return (0, util_1.promisify)(this.fs, 'readFile')(this.fd, options);
	    }
	    stat(options) {
	        return (0, util_1.promisify)(this.fs, 'fstat')(this.fd, options);
	    }
	    sync() {
	        return (0, util_1.promisify)(this.fs, 'fsync')(this.fd);
	    }
	    truncate(len) {
	        return (0, util_1.promisify)(this.fs, 'ftruncate')(this.fd, len);
	    }
	    utimes(atime, mtime) {
	        return (0, util_1.promisify)(this.fs, 'futimes')(this.fd, atime, mtime);
	    }
	    write(buffer, offset, length, position) {
	        return (0, util_1.promisify)(this.fs, 'write', bytesWritten => ({ bytesWritten, buffer }))(this.fd, buffer, offset, length, position);
	    }
	    writev(buffers, position) {
	        return (0, util_1.promisify)(this.fs, 'writev', bytesWritten => ({ bytesWritten, buffers }))(this.fd, buffers, position);
	    }
	    writeFile(data, options) {
	        return (0, util_1.promisify)(this.fs, 'writeFile')(this.fd, data, options);
	    }
	};
	FileHandle.FileHandle = FileHandle$1;
	
	return FileHandle;
}

var FsPromises = {};

var hasRequiredFsPromises;

function requireFsPromises () {
	if (hasRequiredFsPromises) return FsPromises;
	hasRequiredFsPromises = 1;
	Object.defineProperty(FsPromises, "__esModule", { value: true });
	FsPromises.FsPromises = void 0;
	const util_1 = requireUtil$1();
	const constants_1 = requireConstants$2();
	let FsPromises$1 = class FsPromises {
	    constructor(fs, FileHandle) {
	        this.fs = fs;
	        this.FileHandle = FileHandle;
	        this.constants = constants_1.constants;
	        this.cp = (0, util_1.promisify)(this.fs, 'cp');
	        this.opendir = (0, util_1.promisify)(this.fs, 'opendir');
	        this.statfs = (0, util_1.promisify)(this.fs, 'statfs');
	        this.lutimes = (0, util_1.promisify)(this.fs, 'lutimes');
	        this.access = (0, util_1.promisify)(this.fs, 'access');
	        this.chmod = (0, util_1.promisify)(this.fs, 'chmod');
	        this.chown = (0, util_1.promisify)(this.fs, 'chown');
	        this.copyFile = (0, util_1.promisify)(this.fs, 'copyFile');
	        this.lchmod = (0, util_1.promisify)(this.fs, 'lchmod');
	        this.lchown = (0, util_1.promisify)(this.fs, 'lchown');
	        this.link = (0, util_1.promisify)(this.fs, 'link');
	        this.lstat = (0, util_1.promisify)(this.fs, 'lstat');
	        this.mkdir = (0, util_1.promisify)(this.fs, 'mkdir');
	        this.mkdtemp = (0, util_1.promisify)(this.fs, 'mkdtemp');
	        this.readdir = (0, util_1.promisify)(this.fs, 'readdir');
	        this.readlink = (0, util_1.promisify)(this.fs, 'readlink');
	        this.realpath = (0, util_1.promisify)(this.fs, 'realpath');
	        this.rename = (0, util_1.promisify)(this.fs, 'rename');
	        this.rmdir = (0, util_1.promisify)(this.fs, 'rmdir');
	        this.rm = (0, util_1.promisify)(this.fs, 'rm');
	        this.stat = (0, util_1.promisify)(this.fs, 'stat');
	        this.symlink = (0, util_1.promisify)(this.fs, 'symlink');
	        this.truncate = (0, util_1.promisify)(this.fs, 'truncate');
	        this.unlink = (0, util_1.promisify)(this.fs, 'unlink');
	        this.utimes = (0, util_1.promisify)(this.fs, 'utimes');
	        this.readFile = (id, options) => {
	            return (0, util_1.promisify)(this.fs, 'readFile')(id instanceof this.FileHandle ? id.fd : id, options);
	        };
	        this.appendFile = (path, data, options) => {
	            return (0, util_1.promisify)(this.fs, 'appendFile')(path instanceof this.FileHandle ? path.fd : path, data, options);
	        };
	        this.open = (path, flags = 'r', mode) => {
	            return (0, util_1.promisify)(this.fs, 'open', fd => new this.FileHandle(this.fs, fd))(path, flags, mode);
	        };
	        this.writeFile = (id, data, options) => {
	            const dataPromise = (0, util_1.isReadableStream)(data) ? (0, util_1.streamToBuffer)(data) : Promise.resolve(data);
	            return dataPromise.then(data => (0, util_1.promisify)(this.fs, 'writeFile')(id instanceof this.FileHandle ? id.fd : id, data, options));
	        };
	        this.watch = () => {
	            throw new Error('Not implemented');
	        };
	    }
	};
	FsPromises.FsPromises = FsPromises$1;
	
	return FsPromises;
}

var print = {};

var lib = {};

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* undefined Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  };
  return __assign.apply(this, arguments);
};

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
}
function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
}
function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
}
function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
}
function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
}
var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

var tslib_es6 = {
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
};

var tslib_es6$1 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	__addDisposableResource: __addDisposableResource,
	get __assign () { return __assign; },
	__asyncDelegator: __asyncDelegator,
	__asyncGenerator: __asyncGenerator,
	__asyncValues: __asyncValues,
	__await: __await,
	__awaiter: __awaiter,
	__classPrivateFieldGet: __classPrivateFieldGet,
	__classPrivateFieldIn: __classPrivateFieldIn,
	__classPrivateFieldSet: __classPrivateFieldSet,
	__createBinding: __createBinding,
	__decorate: __decorate,
	__disposeResources: __disposeResources,
	__esDecorate: __esDecorate,
	__exportStar: __exportStar,
	__extends: __extends,
	__generator: __generator,
	__importDefault: __importDefault,
	__importStar: __importStar,
	__makeTemplateObject: __makeTemplateObject,
	__metadata: __metadata,
	__param: __param,
	__propKey: __propKey,
	__read: __read,
	__rest: __rest,
	__rewriteRelativeImportExtension: __rewriteRelativeImportExtension,
	__runInitializers: __runInitializers,
	__setFunctionName: __setFunctionName,
	__spread: __spread,
	__spreadArray: __spreadArray,
	__spreadArrays: __spreadArrays,
	__values: __values,
	default: tslib_es6
});

var require$$0 = /*@__PURE__*/getAugmentedNamespace(tslib_es6$1);

var printTree = {};

var hasRequiredPrintTree;

function requirePrintTree () {
	if (hasRequiredPrintTree) return printTree;
	hasRequiredPrintTree = 1;
	Object.defineProperty(printTree, "__esModule", { value: true });
	printTree.printTree = void 0;
	const printTree$1 = (tab = '', children) => {
	    let str = '';
	    let last = children.length - 1;
	    for (; last >= 0; last--)
	        if (children[last])
	            break;
	    for (let i = 0; i <= last; i++) {
	        const fn = children[i];
	        if (!fn)
	            continue;
	        const isLast = i === last;
	        const child = fn(tab + (isLast ? ' ' : '│') + '  ');
	        const branch = child ? (isLast ? '└─' : '├─') : '│';
	        str += '\n' + tab + branch + (child ? ' ' + child : '');
	    }
	    return str;
	};
	printTree.printTree = printTree$1;
	return printTree;
}

var printBinary = {};

var hasRequiredPrintBinary;

function requirePrintBinary () {
	if (hasRequiredPrintBinary) return printBinary;
	hasRequiredPrintBinary = 1;
	Object.defineProperty(printBinary, "__esModule", { value: true });
	printBinary.printBinary = void 0;
	const printBinary$1 = (tab = '', children) => {
	    const left = children[0], right = children[1];
	    let str = '';
	    if (left)
	        str += '\n' + tab + '← ' + left(tab + '  ');
	    if (right)
	        str += '\n' + tab + '→ ' + right(tab + '  ');
	    return str;
	};
	printBinary.printBinary = printBinary$1;
	return printBinary;
}

var hasRequiredLib$1;

function requireLib$1 () {
	if (hasRequiredLib$1) return lib;
	hasRequiredLib$1 = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		const tslib_1 = require$$0;
		tslib_1.__exportStar(requirePrintTree(), exports);
		tslib_1.__exportStar(requirePrintBinary(), exports); 
	} (lib));
	return lib;
}

var util = {};

var hasRequiredUtil;

function requireUtil () {
	if (hasRequiredUtil) return util;
	hasRequiredUtil = 1;
	Object.defineProperty(util, "__esModule", { value: true });
	util.newNotAllowedError = util.newTypeMismatchError = util.newNotFoundError = util.assertCanWrite = util.assertName = util.basename = util.ctx = void 0;
	/**
	 * Creates a new {@link NodeFsaContext}.
	 */
	const ctx = (partial = {}) => {
	    return Object.assign({ separator: '/', syncHandleAllowed: false, mode: 'read' }, partial);
	};
	util.ctx = ctx;
	const basename = (path, separator) => {
	    if (path[path.length - 1] === separator)
	        path = path.slice(0, -1);
	    const lastSlashIndex = path.lastIndexOf(separator);
	    return lastSlashIndex === -1 ? path : path.slice(lastSlashIndex + 1);
	};
	util.basename = basename;
	const nameRegex = /^(\.{1,2})$|^(.*([\/\\]).*)$/;
	const assertName = (name, method, klass) => {
	    const isInvalid = !name || nameRegex.test(name);
	    if (isInvalid)
	        throw new TypeError(`Failed to execute '${method}' on '${klass}': Name is not allowed.`);
	};
	util.assertName = assertName;
	const assertCanWrite = (mode) => {
	    if (mode !== 'readwrite')
	        throw new DOMException('The request is not allowed by the user agent or the platform in the current context.', 'NotAllowedError');
	};
	util.assertCanWrite = assertCanWrite;
	const newNotFoundError = () => new DOMException('A requested file or directory could not be found at the time an operation was processed.', 'NotFoundError');
	util.newNotFoundError = newNotFoundError;
	const newTypeMismatchError = () => new DOMException('The path supplied exists, but was not an entry of requested type.', 'TypeMismatchError');
	util.newTypeMismatchError = newTypeMismatchError;
	const newNotAllowedError = () => new DOMException('Permission not granted.', 'NotAllowedError');
	util.newNotAllowedError = newNotAllowedError;
	
	return util;
}

var hasRequiredPrint;

function requirePrint () {
	if (hasRequiredPrint) return print;
	hasRequiredPrint = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.toTreeSync = void 0;
		const tree_dump_1 = requireLib$1();
		const util_1 = requireUtil();
		const toTreeSync = (fs, opts = {}) => {
		    var _a;
		    const separator = opts.separator || '/';
		    let dir = opts.dir || separator;
		    if (dir[dir.length - 1] !== separator)
		        dir += separator;
		    const tab = opts.tab || '';
		    const depth = (_a = opts.depth) !== null && _a !== void 0 ? _a : 10;
		    let subtree = ' (...)';
		    if (depth > 0) {
		        const list = fs.readdirSync(dir, { withFileTypes: true });
		        subtree = (0, tree_dump_1.printTree)(tab, list.map(entry => tab => {
		            if (entry.isDirectory()) {
		                return (0, exports.toTreeSync)(fs, { dir: dir + entry.name, depth: depth - 1, tab });
		            }
		            else if (entry.isSymbolicLink()) {
		                return '' + entry.name + ' → ' + fs.readlinkSync(dir + entry.name);
		            }
		            else {
		                return '' + entry.name;
		            }
		        }));
		    }
		    const base = (0, util_1.basename)(dir, separator) + separator;
		    return base + subtree;
		};
		exports.toTreeSync = toTreeSync;
		
	} (print));
	return print;
}

var options = {};

var hasRequiredOptions;

function requireOptions () {
	if (hasRequiredOptions) return options;
	hasRequiredOptions = 1;
	(function (exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.getWriteFileOptions = exports.writeFileDefaults = exports.getRealpathOptsAndCb = exports.getRealpathOptions = exports.getStatOptsAndCb = exports.getStatOptions = exports.getAppendFileOptsAndCb = exports.getAppendFileOpts = exports.getOpendirOptsAndCb = exports.getOpendirOptions = exports.getReaddirOptsAndCb = exports.getReaddirOptions = exports.getReadFileOptions = exports.getRmOptsAndCb = exports.getRmdirOptions = exports.getDefaultOptsAndCb = exports.getDefaultOpts = exports.optsDefaults = exports.getMkdirOptions = void 0;
		exports.getOptions = getOptions;
		exports.optsGenerator = optsGenerator;
		exports.optsAndCbGenerator = optsAndCbGenerator;
		const constants_1 = requireConstants();
		const encoding_1 = requireEncoding();
		const util_1 = requireUtil$1();
		const mkdirDefaults = {
		    mode: 511 /* MODE.DIR */,
		    recursive: false,
		};
		const getMkdirOptions = (options) => {
		    if (typeof options === 'number')
		        return Object.assign({}, mkdirDefaults, { mode: options });
		    return Object.assign({}, mkdirDefaults, options);
		};
		exports.getMkdirOptions = getMkdirOptions;
		const ERRSTR_OPTS = tipeof => `Expected options to be either an object or a string, but got ${tipeof} instead`;
		function getOptions(defaults, options) {
		    let opts;
		    if (!options)
		        return defaults;
		    else {
		        const tipeof = typeof options;
		        switch (tipeof) {
		            case 'string':
		                opts = Object.assign({}, defaults, { encoding: options });
		                break;
		            case 'object':
		                opts = Object.assign({}, defaults, options);
		                break;
		            default:
		                throw TypeError(ERRSTR_OPTS(tipeof));
		        }
		    }
		    if (opts.encoding !== 'buffer')
		        (0, encoding_1.assertEncoding)(opts.encoding);
		    return opts;
		}
		function optsGenerator(defaults) {
		    return options => getOptions(defaults, options);
		}
		function optsAndCbGenerator(getOpts) {
		    return (options, callback) => typeof options === 'function' ? [getOpts(), options] : [getOpts(options), (0, util_1.validateCallback)(callback)];
		}
		exports.optsDefaults = {
		    encoding: 'utf8',
		};
		exports.getDefaultOpts = optsGenerator(exports.optsDefaults);
		exports.getDefaultOptsAndCb = optsAndCbGenerator(exports.getDefaultOpts);
		const rmdirDefaults = {
		    recursive: false,
		};
		const getRmdirOptions = (options) => {
		    return Object.assign({}, rmdirDefaults, options);
		};
		exports.getRmdirOptions = getRmdirOptions;
		const getRmOpts = optsGenerator(exports.optsDefaults);
		exports.getRmOptsAndCb = optsAndCbGenerator(getRmOpts);
		const readFileOptsDefaults = {
		    flag: 'r',
		};
		exports.getReadFileOptions = optsGenerator(readFileOptsDefaults);
		const readdirDefaults = {
		    encoding: 'utf8',
		    recursive: false,
		    withFileTypes: false,
		};
		exports.getReaddirOptions = optsGenerator(readdirDefaults);
		exports.getReaddirOptsAndCb = optsAndCbGenerator(exports.getReaddirOptions);
		const opendirDefaults = {
		    encoding: 'utf8',
		    bufferSize: 32,
		    recursive: false,
		};
		exports.getOpendirOptions = optsGenerator(opendirDefaults);
		exports.getOpendirOptsAndCb = optsAndCbGenerator(exports.getOpendirOptions);
		const appendFileDefaults = {
		    encoding: 'utf8',
		    mode: 438 /* MODE.DEFAULT */,
		    flag: constants_1.FLAGS[constants_1.FLAGS.a],
		};
		exports.getAppendFileOpts = optsGenerator(appendFileDefaults);
		exports.getAppendFileOptsAndCb = optsAndCbGenerator(exports.getAppendFileOpts);
		const statDefaults = {
		    bigint: false,
		};
		const getStatOptions = (options = {}) => Object.assign({}, statDefaults, options);
		exports.getStatOptions = getStatOptions;
		const getStatOptsAndCb = (options, callback) => typeof options === 'function' ? [(0, exports.getStatOptions)(), options] : [(0, exports.getStatOptions)(options), (0, util_1.validateCallback)(callback)];
		exports.getStatOptsAndCb = getStatOptsAndCb;
		const realpathDefaults = exports.optsDefaults;
		exports.getRealpathOptions = optsGenerator(realpathDefaults);
		exports.getRealpathOptsAndCb = optsAndCbGenerator(exports.getRealpathOptions);
		exports.writeFileDefaults = {
		    encoding: 'utf8',
		    mode: 438 /* MODE.DEFAULT */,
		    flag: constants_1.FLAGS[constants_1.FLAGS.w],
		};
		exports.getWriteFileOptions = optsGenerator(exports.writeFileDefaults);
		
	} (options));
	return options;
}

var Dir = {};

var hasRequiredDir;

function requireDir () {
	if (hasRequiredDir) return Dir;
	hasRequiredDir = 1;
	Object.defineProperty(Dir, "__esModule", { value: true });
	Dir.Dir = void 0;
	const util_1 = requireUtil$1();
	const Dirent_1 = requireDirent();
	/**
	 * A directory stream, like `fs.Dir`.
	 */
	let Dir$1 = class Dir {
	    constructor(link, options) {
	        this.link = link;
	        this.options = options;
	        this.iteratorInfo = [];
	        this.path = link.getParentPath();
	        this.iteratorInfo.push(link.children[Symbol.iterator]());
	    }
	    wrapAsync(method, args, callback) {
	        (0, util_1.validateCallback)(callback);
	        Promise.resolve().then(() => {
	            let result;
	            try {
	                result = method.apply(this, args);
	            }
	            catch (err) {
	                callback(err);
	                return;
	            }
	            callback(null, result);
	        });
	    }
	    isFunction(x) {
	        return typeof x === 'function';
	    }
	    promisify(obj, fn) {
	        return (...args) => new Promise((resolve, reject) => {
	            if (this.isFunction(obj[fn])) {
	                obj[fn].bind(obj)(...args, (error, result) => {
	                    if (error)
	                        reject(error);
	                    resolve(result);
	                });
	            }
	            else {
	                reject('Not a function');
	            }
	        });
	    }
	    closeBase() { }
	    readBase(iteratorInfo) {
	        let done;
	        let value;
	        let name;
	        let link;
	        do {
	            do {
	                ({ done, value } = iteratorInfo[iteratorInfo.length - 1].next());
	                if (!done) {
	                    [name, link] = value;
	                }
	                else {
	                    break;
	                }
	            } while (name === '.' || name === '..');
	            if (done) {
	                iteratorInfo.pop();
	                if (iteratorInfo.length === 0) {
	                    break;
	                }
	                else {
	                    done = false;
	                }
	            }
	            else {
	                if (this.options.recursive && link.children.size) {
	                    iteratorInfo.push(link.children[Symbol.iterator]());
	                }
	                return Dirent_1.default.build(link, this.options.encoding);
	            }
	        } while (!done);
	        return null;
	    }
	    closeBaseAsync(callback) {
	        this.wrapAsync(this.closeBase, [], callback);
	    }
	    close(callback) {
	        if (typeof callback === 'function') {
	            this.closeBaseAsync(callback);
	        }
	        else {
	            return this.promisify(this, 'closeBaseAsync')();
	        }
	    }
	    closeSync() {
	        this.closeBase();
	    }
	    readBaseAsync(callback) {
	        this.wrapAsync(this.readBase, [this.iteratorInfo], callback);
	    }
	    read(callback) {
	        if (typeof callback === 'function') {
	            this.readBaseAsync(callback);
	        }
	        else {
	            return this.promisify(this, 'readBaseAsync')();
	        }
	    }
	    readSync() {
	        return this.readBase(this.iteratorInfo);
	    }
	    [Symbol.asyncIterator]() {
	        const iteratorInfo = [];
	        const _this = this;
	        iteratorInfo.push(_this.link.children[Symbol.iterator]());
	        // auxiliary object so promisify() can be used
	        const o = {
	            readBaseAsync(callback) {
	                _this.wrapAsync(_this.readBase, [iteratorInfo], callback);
	            },
	        };
	        return {
	            async next() {
	                const dirEnt = await _this.promisify(o, 'readBaseAsync')();
	                if (dirEnt !== null) {
	                    return { done: false, value: dirEnt };
	                }
	                else {
	                    return { done: true, value: undefined };
	                }
	            },
	            [Symbol.asyncIterator]() {
	                throw new Error('Not implemented');
	            },
	        };
	    }
	};
	Dir.Dir = Dir$1;
	
	return Dir;
}

var hasRequiredVolume;

function requireVolume () {
	if (hasRequiredVolume) return volume;
	hasRequiredVolume = 1;
	Object.defineProperty(volume, "__esModule", { value: true });
	volume.FSWatcher = volume.StatWatcher = volume.Volume = void 0;
	volume.filenameToSteps = filenameToSteps;
	volume.pathToSteps = pathToSteps;
	volume.dataToStr = dataToStr;
	volume.toUnixTimestamp = toUnixTimestamp;
	const pathModule = requirePathBrowserify();
	const node_1 = requireNode();
	const Stats_1 = requireStats();
	const Dirent_1 = requireDirent();
	const buffer_1 = requireBuffer$1();
	const queueMicrotask_1 = requireQueueMicrotask();
	const process_1 = requireProcess();
	const setTimeoutUnref_1 = requireSetTimeoutUnref();
	const stream_1 = requireBrowser();
	const constants_1 = requireConstants$2();
	const events_1 = requireEvents();
	const encoding_1 = requireEncoding();
	const FileHandle_1 = requireFileHandle();
	const util = require$$13;
	const FsPromises_1 = requireFsPromises();
	const print_1 = requirePrint();
	const constants_2 = requireConstants();
	const options_1 = requireOptions();
	const util_1 = requireUtil$1();
	const Dir_1 = requireDir();
	const resolveCrossPlatform = pathModule.resolve;
	const { O_RDONLY, O_WRONLY, O_RDWR, O_CREAT, O_EXCL, O_TRUNC, O_APPEND, O_DIRECTORY, O_SYMLINK, F_OK, COPYFILE_EXCL, COPYFILE_FICLONE_FORCE, } = constants_1.constants;
	const { sep, relative, join, dirname } = pathModule.posix ? pathModule.posix : pathModule;
	// ---------------------------------------- Constants
	const kMinPoolSpace = 128;
	// ---------------------------------------- Error messages
	const EPERM = 'EPERM';
	const ENOENT = 'ENOENT';
	const EBADF = 'EBADF';
	const EINVAL = 'EINVAL';
	const EEXIST = 'EEXIST';
	const ENOTDIR = 'ENOTDIR';
	const EMFILE = 'EMFILE';
	const EACCES = 'EACCES';
	const EISDIR = 'EISDIR';
	const ENOTEMPTY = 'ENOTEMPTY';
	const ENOSYS = 'ENOSYS';
	const ERR_FS_EISDIR = 'ERR_FS_EISDIR';
	const ERR_OUT_OF_RANGE = 'ERR_OUT_OF_RANGE';
	let resolve = (filename, base = process_1.default.cwd()) => resolveCrossPlatform(base, filename);
	if (util_1.isWin) {
	    const _resolve = resolve;
	    resolve = (filename, base) => (0, util_1.unixify)(_resolve(filename, base));
	}
	function filenameToSteps(filename, base) {
	    const fullPath = resolve(filename, base);
	    const fullPathSansSlash = fullPath.substring(1);
	    if (!fullPathSansSlash)
	        return [];
	    return fullPathSansSlash.split(sep);
	}
	function pathToSteps(path) {
	    return filenameToSteps((0, util_1.pathToFilename)(path));
	}
	function dataToStr(data, encoding = encoding_1.ENCODING_UTF8) {
	    if (buffer_1.Buffer.isBuffer(data))
	        return data.toString(encoding);
	    else if (data instanceof Uint8Array)
	        return (0, buffer_1.bufferFrom)(data).toString(encoding);
	    else
	        return String(data);
	}
	// converts Date or number to a fractional UNIX timestamp
	function toUnixTimestamp(time) {
	    // tslint:disable-next-line triple-equals
	    if (typeof time === 'string' && +time == time) {
	        return +time;
	    }
	    if (time instanceof Date) {
	        return time.getTime() / 1000;
	    }
	    if (isFinite(time)) {
	        if (time < 0) {
	            return Date.now() / 1000;
	        }
	        return time;
	    }
	    throw new Error('Cannot parse time: ' + time);
	}
	function validateUid(uid) {
	    if (typeof uid !== 'number')
	        throw TypeError(constants_2.ERRSTR.UID);
	}
	function validateGid(gid) {
	    if (typeof gid !== 'number')
	        throw TypeError(constants_2.ERRSTR.GID);
	}
	function flattenJSON(nestedJSON) {
	    const flatJSON = {};
	    function flatten(pathPrefix, node) {
	        for (const path in node) {
	            const contentOrNode = node[path];
	            const joinedPath = join(pathPrefix, path);
	            if (typeof contentOrNode === 'string' || contentOrNode instanceof buffer_1.Buffer) {
	                flatJSON[joinedPath] = contentOrNode;
	            }
	            else if (typeof contentOrNode === 'object' && contentOrNode !== null && Object.keys(contentOrNode).length > 0) {
	                // empty directories need an explicit entry and therefore get handled in `else`, non-empty ones are implicitly considered
	                flatten(joinedPath, contentOrNode);
	            }
	            else {
	                // without this branch null, empty-object or non-object entries would not be handled in the same way
	                // by both fromJSON() and fromNestedJSON()
	                flatJSON[joinedPath] = null;
	            }
	        }
	    }
	    flatten('', nestedJSON);
	    return flatJSON;
	}
	const notImplemented = () => {
	    throw new Error('Not implemented');
	};
	/**
	 * `Volume` represents a file system.
	 */
	class Volume {
	    static fromJSON(json, cwd) {
	        const vol = new Volume();
	        vol.fromJSON(json, cwd);
	        return vol;
	    }
	    static fromNestedJSON(json, cwd) {
	        const vol = new Volume();
	        vol.fromNestedJSON(json, cwd);
	        return vol;
	    }
	    get promises() {
	        if (this.promisesApi === null)
	            throw new Error('Promise is not supported in this environment.');
	        return this.promisesApi;
	    }
	    constructor(props = {}) {
	        // I-node number counter.
	        this.ino = 0;
	        // A mapping for i-node numbers to i-nodes (`Node`);
	        this.inodes = {};
	        // List of released i-node numbers, for reuse.
	        this.releasedInos = [];
	        // A mapping for file descriptors to `File`s.
	        this.fds = {};
	        // A list of reusable (opened and closed) file descriptors, that should be
	        // used first before creating a new file descriptor.
	        this.releasedFds = [];
	        // Max number of open files.
	        this.maxFiles = 10000;
	        // Current number of open files.
	        this.openFiles = 0;
	        this.promisesApi = new FsPromises_1.FsPromises(this, FileHandle_1.FileHandle);
	        this.statWatchers = {};
	        this.cpSync = notImplemented;
	        this.statfsSync = notImplemented;
	        this.cp = notImplemented;
	        this.statfs = notImplemented;
	        this.openAsBlob = notImplemented;
	        this.props = Object.assign({ Node: node_1.Node, Link: node_1.Link, File: node_1.File }, props);
	        const root = this.createLink();
	        root.setNode(this.createNode(constants_1.constants.S_IFDIR | 0o777));
	        const self = this; // tslint:disable-line no-this-assignment
	        this.StatWatcher = class extends StatWatcher {
	            constructor() {
	                super(self);
	            }
	        };
	        const _ReadStream = FsReadStream;
	        this.ReadStream = class extends _ReadStream {
	            constructor(...args) {
	                super(self, ...args);
	            }
	        };
	        const _WriteStream = FsWriteStream;
	        this.WriteStream = class extends _WriteStream {
	            constructor(...args) {
	                super(self, ...args);
	            }
	        };
	        this.FSWatcher = class extends FSWatcher {
	            constructor() {
	                super(self);
	            }
	        };
	        root.setChild('.', root);
	        root.getNode().nlink++;
	        root.setChild('..', root);
	        root.getNode().nlink++;
	        this.root = root;
	    }
	    createLink(parent, name, isDirectory = false, mode) {
	        if (!parent) {
	            return new this.props.Link(this, null, '');
	        }
	        if (!name) {
	            throw new Error('createLink: name cannot be empty');
	        }
	        // If no explicit permission is provided, use defaults based on type
	        const finalPerm = mode !== null && mode !== void 0 ? mode : (isDirectory ? 0o777 : 0o666);
	        // To prevent making a breaking change, `mode` can also just be a permission number
	        // and the file type is set based on `isDirectory`
	        const hasFileType = mode && mode & constants_1.constants.S_IFMT;
	        const modeType = hasFileType ? mode & constants_1.constants.S_IFMT : isDirectory ? constants_1.constants.S_IFDIR : constants_1.constants.S_IFREG;
	        const finalMode = (finalPerm & ~constants_1.constants.S_IFMT) | modeType;
	        return parent.createChild(name, this.createNode(finalMode));
	    }
	    deleteLink(link) {
	        const parent = link.parent;
	        if (parent) {
	            parent.deleteChild(link);
	            return true;
	        }
	        return false;
	    }
	    newInoNumber() {
	        const releasedFd = this.releasedInos.pop();
	        if (releasedFd)
	            return releasedFd;
	        else {
	            this.ino = (this.ino + 1) % 0xffffffff;
	            return this.ino;
	        }
	    }
	    newFdNumber() {
	        const releasedFd = this.releasedFds.pop();
	        return typeof releasedFd === 'number' ? releasedFd : Volume.fd--;
	    }
	    createNode(mode) {
	        const node = new this.props.Node(this.newInoNumber(), mode);
	        this.inodes[node.ino] = node;
	        return node;
	    }
	    deleteNode(node) {
	        node.del();
	        delete this.inodes[node.ino];
	        this.releasedInos.push(node.ino);
	    }
	    walk(stepsOrFilenameOrLink, resolveSymlinks = false, checkExistence = false, checkAccess = false, funcName) {
	        var _a;
	        let steps;
	        let filename;
	        if (stepsOrFilenameOrLink instanceof node_1.Link) {
	            steps = stepsOrFilenameOrLink.steps;
	            filename = sep + steps.join(sep);
	        }
	        else if (typeof stepsOrFilenameOrLink === 'string') {
	            steps = filenameToSteps(stepsOrFilenameOrLink);
	            filename = stepsOrFilenameOrLink;
	        }
	        else {
	            steps = stepsOrFilenameOrLink;
	            filename = sep + steps.join(sep);
	        }
	        let curr = this.root;
	        let i = 0;
	        while (i < steps.length) {
	            let node = curr.getNode();
	            // Check access permissions if current link is a directory
	            if (node.isDirectory()) {
	                if (checkAccess && !node.canExecute()) {
	                    throw (0, util_1.createError)(EACCES, funcName, filename);
	                }
	            }
	            else {
	                if (i < steps.length - 1)
	                    throw (0, util_1.createError)(ENOTDIR, funcName, filename);
	            }
	            curr = (_a = curr.getChild(steps[i])) !== null && _a !== void 0 ? _a : null;
	            // Check existence of current link
	            if (!curr)
	                if (checkExistence)
	                    throw (0, util_1.createError)(ENOENT, funcName, filename);
	                else
	                    return null;
	            node = curr === null || curr === void 0 ? void 0 : curr.getNode();
	            // Resolve symlink
	            if (resolveSymlinks && node.isSymlink()) {
	                const resolvedPath = pathModule.isAbsolute(node.symlink)
	                    ? node.symlink
	                    : join(pathModule.dirname(curr.getPath()), node.symlink); // Relative to symlink's parent
	                steps = filenameToSteps(resolvedPath).concat(steps.slice(i + 1));
	                curr = this.root;
	                i = 0;
	                continue;
	            }
	            i++;
	        }
	        return curr;
	    }
	    // Returns a `Link` (hard link) referenced by path "split" into steps.
	    getLink(steps) {
	        return this.walk(steps, false, false, false);
	    }
	    // Just link `getLink`, but throws a correct user error, if link to found.
	    getLinkOrThrow(filename, funcName) {
	        return this.walk(filename, false, true, true, funcName);
	    }
	    // Just like `getLink`, but also dereference/resolves symbolic links.
	    getResolvedLink(filenameOrSteps) {
	        return this.walk(filenameOrSteps, true, false, false);
	    }
	    // Just like `getLinkOrThrow`, but also dereference/resolves symbolic links.
	    getResolvedLinkOrThrow(filename, funcName) {
	        return this.walk(filename, true, true, true, funcName);
	    }
	    resolveSymlinks(link) {
	        return this.getResolvedLink(link.steps.slice(1));
	    }
	    // Just like `getLinkOrThrow`, but also verifies that the link is a directory.
	    getLinkAsDirOrThrow(filename, funcName) {
	        const link = this.getLinkOrThrow(filename, funcName);
	        if (!link.getNode().isDirectory())
	            throw (0, util_1.createError)(ENOTDIR, funcName, filename);
	        return link;
	    }
	    // Get the immediate parent directory of the link.
	    getLinkParent(steps) {
	        return this.getLink(steps.slice(0, -1));
	    }
	    getLinkParentAsDirOrThrow(filenameOrSteps, funcName) {
	        const steps = (filenameOrSteps instanceof Array ? filenameOrSteps : filenameToSteps(filenameOrSteps)).slice(0, -1);
	        const filename = sep + steps.join(sep);
	        const link = this.getLinkOrThrow(filename, funcName);
	        if (!link.getNode().isDirectory())
	            throw (0, util_1.createError)(ENOTDIR, funcName, filename);
	        return link;
	    }
	    getFileByFd(fd) {
	        return this.fds[String(fd)];
	    }
	    getFileByFdOrThrow(fd, funcName) {
	        if (!(0, util_1.isFd)(fd))
	            throw TypeError(constants_2.ERRSTR.FD);
	        const file = this.getFileByFd(fd);
	        if (!file)
	            throw (0, util_1.createError)(EBADF, funcName);
	        return file;
	    }
	    /**
	     * @todo This is not used anymore. Remove.
	     */
	    /*
	    private getNodeByIdOrCreate(id: TFileId, flags: number, perm: number): Node {
	      if (typeof id === 'number') {
	        const file = this.getFileByFd(id);
	        if (!file) throw Error('File nto found');
	        return file.node;
	      } else {
	        const steps = pathToSteps(id as PathLike);
	        let link = this.getLink(steps);
	        if (link) return link.getNode();
	  
	        // Try creating a node if not found.
	        if (flags & O_CREAT) {
	          const dirLink = this.getLinkParent(steps);
	          if (dirLink) {
	            const name = steps[steps.length - 1];
	            link = this.createLink(dirLink, name, false, perm);
	            return link.getNode();
	          }
	        }
	  
	        throw createError(ENOENT, 'getNodeByIdOrCreate', pathToFilename(id));
	      }
	    }
	    */
	    wrapAsync(method, args, callback) {
	        (0, util_1.validateCallback)(callback);
	        Promise.resolve().then(() => {
	            let result;
	            try {
	                result = method.apply(this, args);
	            }
	            catch (err) {
	                callback(err);
	                return;
	            }
	            callback(null, result);
	        });
	    }
	    _toJSON(link = this.root, json = {}, path, asBuffer) {
	        let isEmpty = true;
	        let children = link.children;
	        if (link.getNode().isFile()) {
	            children = new Map([[link.getName(), link.parent.getChild(link.getName())]]);
	            link = link.parent;
	        }
	        for (const name of children.keys()) {
	            if (name === '.' || name === '..') {
	                continue;
	            }
	            isEmpty = false;
	            const child = link.getChild(name);
	            if (!child) {
	                throw new Error('_toJSON: unexpected undefined');
	            }
	            const node = child.getNode();
	            if (node.isFile()) {
	                let filename = child.getPath();
	                if (path)
	                    filename = relative(path, filename);
	                json[filename] = asBuffer ? node.getBuffer() : node.getString();
	            }
	            else if (node.isDirectory()) {
	                this._toJSON(child, json, path, asBuffer);
	            }
	        }
	        let dirPath = link.getPath();
	        if (path)
	            dirPath = relative(path, dirPath);
	        if (dirPath && isEmpty) {
	            json[dirPath] = null;
	        }
	        return json;
	    }
	    toJSON(paths, json = {}, isRelative = false, asBuffer = false) {
	        const links = [];
	        if (paths) {
	            if (!Array.isArray(paths))
	                paths = [paths];
	            for (const path of paths) {
	                const filename = (0, util_1.pathToFilename)(path);
	                const link = this.getResolvedLink(filename);
	                if (!link)
	                    continue;
	                links.push(link);
	            }
	        }
	        else {
	            links.push(this.root);
	        }
	        if (!links.length)
	            return json;
	        for (const link of links)
	            this._toJSON(link, json, isRelative ? link.getPath() : '', asBuffer);
	        return json;
	    }
	    // TODO: `cwd` should probably not invoke `process.cwd()`.
	    fromJSON(json, cwd = process_1.default.cwd()) {
	        for (let filename in json) {
	            const data = json[filename];
	            filename = resolve(filename, cwd);
	            if (typeof data === 'string' || data instanceof buffer_1.Buffer) {
	                const dir = dirname(filename);
	                this.mkdirpBase(dir, 511 /* MODE.DIR */);
	                this.writeFileSync(filename, data);
	            }
	            else {
	                this.mkdirpBase(filename, 511 /* MODE.DIR */);
	            }
	        }
	    }
	    fromNestedJSON(json, cwd) {
	        this.fromJSON(flattenJSON(json), cwd);
	    }
	    toTree(opts = { separator: sep }) {
	        return (0, print_1.toTreeSync)(this, opts);
	    }
	    reset() {
	        this.ino = 0;
	        this.inodes = {};
	        this.releasedInos = [];
	        this.fds = {};
	        this.releasedFds = [];
	        this.openFiles = 0;
	        this.root = this.createLink();
	        this.root.setNode(this.createNode(constants_1.constants.S_IFDIR | 0o777));
	    }
	    // Legacy interface
	    mountSync(mountpoint, json) {
	        this.fromJSON(json, mountpoint);
	    }
	    openLink(link, flagsNum, resolveSymlinks = true) {
	        if (this.openFiles >= this.maxFiles) {
	            // Too many open files.
	            throw (0, util_1.createError)(EMFILE, 'open', link.getPath());
	        }
	        // Resolve symlinks.
	        //
	        // @TODO: This should be superfluous. This method is only ever called by openFile(), which does its own symlink resolution
	        // prior to calling.
	        let realLink = link;
	        if (resolveSymlinks)
	            realLink = this.getResolvedLinkOrThrow(link.getPath(), 'open');
	        const node = realLink.getNode();
	        // Check whether node is a directory
	        if (node.isDirectory()) {
	            if ((flagsNum & (O_RDONLY | O_RDWR | O_WRONLY)) !== O_RDONLY)
	                throw (0, util_1.createError)(EISDIR, 'open', link.getPath());
	        }
	        else {
	            if (flagsNum & O_DIRECTORY)
	                throw (0, util_1.createError)(ENOTDIR, 'open', link.getPath());
	        }
	        // Check node permissions
	        if (!(flagsNum & O_WRONLY)) {
	            if (!node.canRead()) {
	                throw (0, util_1.createError)(EACCES, 'open', link.getPath());
	            }
	        }
	        if (!(flagsNum & O_RDONLY)) {
	            if (!node.canWrite()) {
	                throw (0, util_1.createError)(EACCES, 'open', link.getPath());
	            }
	        }
	        const file = new this.props.File(link, node, flagsNum, this.newFdNumber());
	        this.fds[file.fd] = file;
	        this.openFiles++;
	        if (flagsNum & O_TRUNC)
	            file.truncate();
	        return file;
	    }
	    openFile(filename, flagsNum, modeNum, resolveSymlinks = true) {
	        const steps = filenameToSteps(filename);
	        let link;
	        try {
	            link = resolveSymlinks ? this.getResolvedLinkOrThrow(filename, 'open') : this.getLinkOrThrow(filename, 'open');
	            // Check if file already existed when trying to create it exclusively (O_CREAT and O_EXCL flags are set).
	            // This is an error, see https://pubs.opengroup.org/onlinepubs/009695399/functions/open.html:
	            // "If O_CREAT and O_EXCL are set, open() shall fail if the file exists."
	            if (link && flagsNum & O_CREAT && flagsNum & O_EXCL)
	                throw (0, util_1.createError)(EEXIST, 'open', filename);
	        }
	        catch (err) {
	            // Try creating a new file, if it does not exist and O_CREAT flag is set.
	            // Note that this will still throw if the ENOENT came from one of the
	            // intermediate directories instead of the file itself.
	            if (err.code === ENOENT && flagsNum & O_CREAT) {
	                const dirname = pathModule.dirname(filename);
	                const dirLink = this.getResolvedLinkOrThrow(dirname);
	                const dirNode = dirLink.getNode();
	                // Check that the place we create the new file is actually a directory and that we are allowed to do so:
	                if (!dirNode.isDirectory())
	                    throw (0, util_1.createError)(ENOTDIR, 'open', filename);
	                if (!dirNode.canExecute() || !dirNode.canWrite())
	                    throw (0, util_1.createError)(EACCES, 'open', filename);
	                // This is a difference to the original implementation, which would simply not create a file unless modeNum was specified.
	                // However, current Node versions will default to 0o666.
	                modeNum !== null && modeNum !== void 0 ? modeNum : (modeNum = 0o666);
	                link = this.createLink(dirLink, steps[steps.length - 1], false, modeNum);
	            }
	            else
	                throw err;
	        }
	        if (link)
	            return this.openLink(link, flagsNum, resolveSymlinks);
	        throw (0, util_1.createError)(ENOENT, 'open', filename);
	    }
	    openBase(filename, flagsNum, modeNum, resolveSymlinks = true) {
	        const file = this.openFile(filename, flagsNum, modeNum, resolveSymlinks);
	        if (!file)
	            throw (0, util_1.createError)(ENOENT, 'open', filename);
	        return file.fd;
	    }
	    openSync(path, flags, mode = 438 /* MODE.DEFAULT */) {
	        // Validate (1) mode; (2) path; (3) flags - in that order.
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const fileName = (0, util_1.pathToFilename)(path);
	        const flagsNum = (0, util_1.flagsToNumber)(flags);
	        return this.openBase(fileName, flagsNum, modeNum, !(flagsNum & O_SYMLINK));
	    }
	    open(path, flags, a, b) {
	        let mode = a;
	        let callback = b;
	        if (typeof a === 'function') {
	            mode = 438 /* MODE.DEFAULT */;
	            callback = a;
	        }
	        mode = mode || 438 /* MODE.DEFAULT */;
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const fileName = (0, util_1.pathToFilename)(path);
	        const flagsNum = (0, util_1.flagsToNumber)(flags);
	        this.wrapAsync(this.openBase, [fileName, flagsNum, modeNum, !(flagsNum & O_SYMLINK)], callback);
	    }
	    closeFile(file) {
	        if (!this.fds[file.fd])
	            return;
	        this.openFiles--;
	        delete this.fds[file.fd];
	        this.releasedFds.push(file.fd);
	    }
	    closeSync(fd) {
	        (0, util_1.validateFd)(fd);
	        const file = this.getFileByFdOrThrow(fd, 'close');
	        this.closeFile(file);
	    }
	    close(fd, callback) {
	        (0, util_1.validateFd)(fd);
	        const file = this.getFileByFdOrThrow(fd, 'close');
	        // NOTE: not calling closeSync because we can reset in between close and closeSync
	        this.wrapAsync(this.closeFile, [file], callback);
	    }
	    openFileOrGetById(id, flagsNum, modeNum) {
	        if (typeof id === 'number') {
	            const file = this.fds[id];
	            if (!file)
	                throw (0, util_1.createError)(ENOENT);
	            return file;
	        }
	        else {
	            return this.openFile((0, util_1.pathToFilename)(id), flagsNum, modeNum);
	        }
	    }
	    readBase(fd, buffer, offset, length, position) {
	        if (buffer.byteLength < length) {
	            throw (0, util_1.createError)(ERR_OUT_OF_RANGE, 'read', undefined, undefined, RangeError);
	        }
	        const file = this.getFileByFdOrThrow(fd);
	        if (file.node.isSymlink()) {
	            throw (0, util_1.createError)(EPERM, 'read', file.link.getPath());
	        }
	        return file.read(buffer, Number(offset), Number(length), position === -1 || typeof position !== 'number' ? undefined : position);
	    }
	    readSync(fd, buffer, offset, length, position) {
	        (0, util_1.validateFd)(fd);
	        return this.readBase(fd, buffer, offset, length, position);
	    }
	    read(fd, buffer, offset, length, position, callback) {
	        (0, util_1.validateCallback)(callback);
	        // This `if` branch is from Node.js
	        if (length === 0) {
	            return (0, queueMicrotask_1.default)(() => {
	                if (callback)
	                    callback(null, 0, buffer);
	            });
	        }
	        Promise.resolve().then(() => {
	            try {
	                const bytes = this.readBase(fd, buffer, offset, length, position);
	                callback(null, bytes, buffer);
	            }
	            catch (err) {
	                callback(err);
	            }
	        });
	    }
	    readvBase(fd, buffers, position) {
	        const file = this.getFileByFdOrThrow(fd);
	        let p = position !== null && position !== void 0 ? position : undefined;
	        if (p === -1) {
	            p = undefined;
	        }
	        let bytesRead = 0;
	        for (const buffer of buffers) {
	            const bytes = file.read(buffer, 0, buffer.byteLength, p);
	            p = undefined;
	            bytesRead += bytes;
	            if (bytes < buffer.byteLength)
	                break;
	        }
	        return bytesRead;
	    }
	    readv(fd, buffers, a, b) {
	        let position = a;
	        let callback = b;
	        if (typeof a === 'function') {
	            position = null;
	            callback = a;
	        }
	        (0, util_1.validateCallback)(callback);
	        Promise.resolve().then(() => {
	            try {
	                const bytes = this.readvBase(fd, buffers, position);
	                callback(null, bytes, buffers);
	            }
	            catch (err) {
	                callback(err);
	            }
	        });
	    }
	    readvSync(fd, buffers, position) {
	        (0, util_1.validateFd)(fd);
	        return this.readvBase(fd, buffers, position);
	    }
	    readFileBase(id, flagsNum, encoding) {
	        let result;
	        const isUserFd = typeof id === 'number';
	        const userOwnsFd = isUserFd && (0, util_1.isFd)(id);
	        let fd;
	        if (userOwnsFd)
	            fd = id;
	        else {
	            const filename = (0, util_1.pathToFilename)(id);
	            const link = this.getResolvedLinkOrThrow(filename, 'open');
	            const node = link.getNode();
	            if (node.isDirectory())
	                throw (0, util_1.createError)(EISDIR, 'open', link.getPath());
	            fd = this.openSync(id, flagsNum);
	        }
	        try {
	            result = (0, util_1.bufferToEncoding)(this.getFileByFdOrThrow(fd).getBuffer(), encoding);
	        }
	        finally {
	            if (!userOwnsFd) {
	                this.closeSync(fd);
	            }
	        }
	        return result;
	    }
	    readFileSync(file, options) {
	        const opts = (0, options_1.getReadFileOptions)(options);
	        const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
	        return this.readFileBase(file, flagsNum, opts.encoding);
	    }
	    readFile(id, a, b) {
	        const [opts, callback] = (0, options_1.optsAndCbGenerator)(options_1.getReadFileOptions)(a, b);
	        const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
	        this.wrapAsync(this.readFileBase, [id, flagsNum, opts.encoding], callback);
	    }
	    writeBase(fd, buf, offset, length, position) {
	        const file = this.getFileByFdOrThrow(fd, 'write');
	        if (file.node.isSymlink()) {
	            throw (0, util_1.createError)(EBADF, 'write', file.link.getPath());
	        }
	        return file.write(buf, offset, length, position === -1 || typeof position !== 'number' ? undefined : position);
	    }
	    writeSync(fd, a, b, c, d) {
	        const [, buf, offset, length, position] = (0, util_1.getWriteSyncArgs)(fd, a, b, c, d);
	        return this.writeBase(fd, buf, offset, length, position);
	    }
	    write(fd, a, b, c, d, e) {
	        const [, asStr, buf, offset, length, position, cb] = (0, util_1.getWriteArgs)(fd, a, b, c, d, e);
	        Promise.resolve().then(() => {
	            try {
	                const bytes = this.writeBase(fd, buf, offset, length, position);
	                if (!asStr) {
	                    cb(null, bytes, buf);
	                }
	                else {
	                    cb(null, bytes, a);
	                }
	            }
	            catch (err) {
	                cb(err);
	            }
	        });
	    }
	    writevBase(fd, buffers, position) {
	        const file = this.getFileByFdOrThrow(fd);
	        let p = position !== null && position !== void 0 ? position : undefined;
	        if (p === -1) {
	            p = undefined;
	        }
	        let bytesWritten = 0;
	        for (const buffer of buffers) {
	            const nodeBuf = buffer_1.Buffer.from(buffer.buffer, buffer.byteOffset, buffer.byteLength);
	            const bytes = file.write(nodeBuf, 0, nodeBuf.byteLength, p);
	            p = undefined;
	            bytesWritten += bytes;
	            if (bytes < nodeBuf.byteLength)
	                break;
	        }
	        return bytesWritten;
	    }
	    writev(fd, buffers, a, b) {
	        let position = a;
	        let callback = b;
	        if (typeof a === 'function') {
	            position = null;
	            callback = a;
	        }
	        (0, util_1.validateCallback)(callback);
	        Promise.resolve().then(() => {
	            try {
	                const bytes = this.writevBase(fd, buffers, position);
	                callback(null, bytes, buffers);
	            }
	            catch (err) {
	                callback(err);
	            }
	        });
	    }
	    writevSync(fd, buffers, position) {
	        (0, util_1.validateFd)(fd);
	        return this.writevBase(fd, buffers, position);
	    }
	    writeFileBase(id, buf, flagsNum, modeNum) {
	        // console.log('writeFileBase', id, buf, flagsNum, modeNum);
	        // const node = this.getNodeByIdOrCreate(id, flagsNum, modeNum);
	        // node.setBuffer(buf);
	        const isUserFd = typeof id === 'number';
	        let fd;
	        if (isUserFd)
	            fd = id;
	        else {
	            fd = this.openBase((0, util_1.pathToFilename)(id), flagsNum, modeNum);
	            // fd = this.openSync(id as PathLike, flagsNum, modeNum);
	        }
	        let offset = 0;
	        let length = buf.length;
	        let position = flagsNum & O_APPEND ? undefined : 0;
	        try {
	            while (length > 0) {
	                const written = this.writeSync(fd, buf, offset, length, position);
	                offset += written;
	                length -= written;
	                if (position !== undefined)
	                    position += written;
	            }
	        }
	        finally {
	            if (!isUserFd)
	                this.closeSync(fd);
	        }
	    }
	    writeFileSync(id, data, options) {
	        const opts = (0, options_1.getWriteFileOptions)(options);
	        const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
	        const modeNum = (0, util_1.modeToNumber)(opts.mode);
	        const buf = (0, util_1.dataToBuffer)(data, opts.encoding);
	        this.writeFileBase(id, buf, flagsNum, modeNum);
	    }
	    writeFile(id, data, a, b) {
	        let options = a;
	        let callback = b;
	        if (typeof a === 'function') {
	            options = options_1.writeFileDefaults;
	            callback = a;
	        }
	        const cb = (0, util_1.validateCallback)(callback);
	        const opts = (0, options_1.getWriteFileOptions)(options);
	        const flagsNum = (0, util_1.flagsToNumber)(opts.flag);
	        const modeNum = (0, util_1.modeToNumber)(opts.mode);
	        const buf = (0, util_1.dataToBuffer)(data, opts.encoding);
	        this.wrapAsync(this.writeFileBase, [id, buf, flagsNum, modeNum], cb);
	    }
	    linkBase(filename1, filename2) {
	        let link1;
	        try {
	            link1 = this.getLinkOrThrow(filename1, 'link');
	        }
	        catch (err) {
	            // Augment error with filename2
	            if (err.code)
	                err = (0, util_1.createError)(err.code, 'link', filename1, filename2);
	            throw err;
	        }
	        const dirname2 = pathModule.dirname(filename2);
	        let dir2;
	        try {
	            dir2 = this.getLinkOrThrow(dirname2, 'link');
	        }
	        catch (err) {
	            // Augment error with filename1
	            if (err.code)
	                err = (0, util_1.createError)(err.code, 'link', filename1, filename2);
	            throw err;
	        }
	        const name = pathModule.basename(filename2);
	        // Check if new file already exists.
	        if (dir2.getChild(name))
	            throw (0, util_1.createError)(EEXIST, 'link', filename1, filename2);
	        const node = link1.getNode();
	        node.nlink++;
	        dir2.createChild(name, node);
	    }
	    copyFileBase(src, dest, flags) {
	        const buf = this.readFileSync(src);
	        if (flags & COPYFILE_EXCL) {
	            if (this.existsSync(dest)) {
	                throw (0, util_1.createError)(EEXIST, 'copyFile', src, dest);
	            }
	        }
	        if (flags & COPYFILE_FICLONE_FORCE) {
	            throw (0, util_1.createError)(ENOSYS, 'copyFile', src, dest);
	        }
	        this.writeFileBase(dest, buf, constants_2.FLAGS.w, 438 /* MODE.DEFAULT */);
	    }
	    copyFileSync(src, dest, flags) {
	        const srcFilename = (0, util_1.pathToFilename)(src);
	        const destFilename = (0, util_1.pathToFilename)(dest);
	        return this.copyFileBase(srcFilename, destFilename, (flags || 0) | 0);
	    }
	    copyFile(src, dest, a, b) {
	        const srcFilename = (0, util_1.pathToFilename)(src);
	        const destFilename = (0, util_1.pathToFilename)(dest);
	        let flags;
	        let callback;
	        if (typeof a === 'function') {
	            flags = 0;
	            callback = a;
	        }
	        else {
	            flags = a;
	            callback = b;
	        }
	        (0, util_1.validateCallback)(callback);
	        this.wrapAsync(this.copyFileBase, [srcFilename, destFilename, flags], callback);
	    }
	    linkSync(existingPath, newPath) {
	        const existingPathFilename = (0, util_1.pathToFilename)(existingPath);
	        const newPathFilename = (0, util_1.pathToFilename)(newPath);
	        this.linkBase(existingPathFilename, newPathFilename);
	    }
	    link(existingPath, newPath, callback) {
	        const existingPathFilename = (0, util_1.pathToFilename)(existingPath);
	        const newPathFilename = (0, util_1.pathToFilename)(newPath);
	        this.wrapAsync(this.linkBase, [existingPathFilename, newPathFilename], callback);
	    }
	    unlinkBase(filename) {
	        const link = this.getLinkOrThrow(filename, 'unlink');
	        // TODO: Check if it is file, dir, other...
	        if (link.length)
	            throw Error('Dir not empty...');
	        this.deleteLink(link);
	        const node = link.getNode();
	        node.nlink--;
	        // When all hard links to i-node are deleted, remove the i-node, too.
	        if (node.nlink <= 0) {
	            this.deleteNode(node);
	        }
	    }
	    unlinkSync(path) {
	        const filename = (0, util_1.pathToFilename)(path);
	        this.unlinkBase(filename);
	    }
	    unlink(path, callback) {
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.unlinkBase, [filename], callback);
	    }
	    symlinkBase(targetFilename, pathFilename) {
	        const pathSteps = filenameToSteps(pathFilename);
	        // Check if directory exists, where we about to create a symlink.
	        let dirLink;
	        try {
	            dirLink = this.getLinkParentAsDirOrThrow(pathSteps);
	        }
	        catch (err) {
	            // Catch error to populate with the correct fields - getLinkParentAsDirOrThrow won't be aware of the second path
	            if (err.code)
	                err = (0, util_1.createError)(err.code, 'symlink', targetFilename, pathFilename);
	            throw err;
	        }
	        const name = pathSteps[pathSteps.length - 1];
	        // Check if new file already exists.
	        if (dirLink.getChild(name))
	            throw (0, util_1.createError)(EEXIST, 'symlink', targetFilename, pathFilename);
	        // Check permissions on the path where we are creating the symlink.
	        // Note we're not checking permissions on the target path: It is not an error to create a symlink to a
	        // non-existent or inaccessible target
	        const node = dirLink.getNode();
	        if (!node.canExecute() || !node.canWrite())
	            throw (0, util_1.createError)(EACCES, 'symlink', targetFilename, pathFilename);
	        // Create symlink.
	        const symlink = dirLink.createChild(name);
	        symlink.getNode().makeSymlink(targetFilename);
	        return symlink;
	    }
	    // `type` argument works only on Windows.
	    symlinkSync(target, path, type) {
	        const targetFilename = (0, util_1.pathToFilename)(target);
	        const pathFilename = (0, util_1.pathToFilename)(path);
	        this.symlinkBase(targetFilename, pathFilename);
	    }
	    symlink(target, path, a, b) {
	        const callback = (0, util_1.validateCallback)(typeof a === 'function' ? a : b);
	        const targetFilename = (0, util_1.pathToFilename)(target);
	        const pathFilename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.symlinkBase, [targetFilename, pathFilename], callback);
	    }
	    realpathBase(filename, encoding) {
	        const realLink = this.getResolvedLinkOrThrow(filename, 'realpath');
	        return (0, encoding_1.strToEncoding)(realLink.getPath() || '/', encoding);
	    }
	    realpathSync(path, options) {
	        return this.realpathBase((0, util_1.pathToFilename)(path), (0, options_1.getRealpathOptions)(options).encoding);
	    }
	    realpath(path, a, b) {
	        const [opts, callback] = (0, options_1.getRealpathOptsAndCb)(a, b);
	        const pathFilename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.realpathBase, [pathFilename, opts.encoding], callback);
	    }
	    lstatBase(filename, bigint = false, throwIfNoEntry = false) {
	        let link;
	        try {
	            link = this.getLinkOrThrow(filename, 'lstat');
	        }
	        catch (err) {
	            if (err.code === ENOENT && !throwIfNoEntry)
	                return undefined;
	            else
	                throw err;
	        }
	        return Stats_1.default.build(link.getNode(), bigint);
	    }
	    lstatSync(path, options) {
	        const { throwIfNoEntry = true, bigint = false } = (0, options_1.getStatOptions)(options);
	        return this.lstatBase((0, util_1.pathToFilename)(path), bigint, throwIfNoEntry);
	    }
	    lstat(path, a, b) {
	        const [{ throwIfNoEntry = true, bigint = false }, callback] = (0, options_1.getStatOptsAndCb)(a, b);
	        this.wrapAsync(this.lstatBase, [(0, util_1.pathToFilename)(path), bigint, throwIfNoEntry], callback);
	    }
	    statBase(filename, bigint = false, throwIfNoEntry = true) {
	        let link;
	        try {
	            link = this.getResolvedLinkOrThrow(filename, 'stat');
	        }
	        catch (err) {
	            if (err.code === ENOENT && !throwIfNoEntry)
	                return undefined;
	            else
	                throw err;
	        }
	        return Stats_1.default.build(link.getNode(), bigint);
	    }
	    statSync(path, options) {
	        const { bigint = true, throwIfNoEntry = true } = (0, options_1.getStatOptions)(options);
	        return this.statBase((0, util_1.pathToFilename)(path), bigint, throwIfNoEntry);
	    }
	    stat(path, a, b) {
	        const [{ bigint = false, throwIfNoEntry = true }, callback] = (0, options_1.getStatOptsAndCb)(a, b);
	        this.wrapAsync(this.statBase, [(0, util_1.pathToFilename)(path), bigint, throwIfNoEntry], callback);
	    }
	    fstatBase(fd, bigint = false) {
	        const file = this.getFileByFd(fd);
	        if (!file)
	            throw (0, util_1.createError)(EBADF, 'fstat');
	        return Stats_1.default.build(file.node, bigint);
	    }
	    fstatSync(fd, options) {
	        return this.fstatBase(fd, (0, options_1.getStatOptions)(options).bigint);
	    }
	    fstat(fd, a, b) {
	        const [opts, callback] = (0, options_1.getStatOptsAndCb)(a, b);
	        this.wrapAsync(this.fstatBase, [fd, opts.bigint], callback);
	    }
	    renameBase(oldPathFilename, newPathFilename) {
	        let link;
	        try {
	            link = this.getResolvedLinkOrThrow(oldPathFilename);
	        }
	        catch (err) {
	            // Augment err with newPathFilename
	            if (err.code)
	                err = (0, util_1.createError)(err.code, 'rename', oldPathFilename, newPathFilename);
	            throw err;
	        }
	        // TODO: Check if it is directory, if non-empty, we cannot move it, right?
	        // Check directory exists for the new location.
	        let newPathDirLink;
	        try {
	            newPathDirLink = this.getLinkParentAsDirOrThrow(newPathFilename);
	        }
	        catch (err) {
	            // Augment error with oldPathFilename
	            if (err.code)
	                err = (0, util_1.createError)(err.code, 'rename', oldPathFilename, newPathFilename);
	            throw err;
	        }
	        // TODO: Also treat cases with directories and symbolic links.
	        // TODO: See: http://man7.org/linux/man-pages/man2/rename.2.html
	        // Remove hard link from old folder.
	        const oldLinkParent = link.parent;
	        // Check we have access and write permissions in both places
	        const oldParentNode = oldLinkParent.getNode();
	        const newPathDirNode = newPathDirLink.getNode();
	        if (!oldParentNode.canExecute() ||
	            !oldParentNode.canWrite() ||
	            !newPathDirNode.canExecute() ||
	            !newPathDirNode.canWrite()) {
	            throw (0, util_1.createError)(EACCES, 'rename', oldPathFilename, newPathFilename);
	        }
	        oldLinkParent.deleteChild(link);
	        // Rename should overwrite the new path, if that exists.
	        const name = pathModule.basename(newPathFilename);
	        link.name = name;
	        link.steps = [...newPathDirLink.steps, name];
	        newPathDirLink.setChild(link.getName(), link);
	    }
	    renameSync(oldPath, newPath) {
	        const oldPathFilename = (0, util_1.pathToFilename)(oldPath);
	        const newPathFilename = (0, util_1.pathToFilename)(newPath);
	        this.renameBase(oldPathFilename, newPathFilename);
	    }
	    rename(oldPath, newPath, callback) {
	        const oldPathFilename = (0, util_1.pathToFilename)(oldPath);
	        const newPathFilename = (0, util_1.pathToFilename)(newPath);
	        this.wrapAsync(this.renameBase, [oldPathFilename, newPathFilename], callback);
	    }
	    existsBase(filename) {
	        return !!this.statBase(filename);
	    }
	    existsSync(path) {
	        try {
	            return this.existsBase((0, util_1.pathToFilename)(path));
	        }
	        catch (err) {
	            return false;
	        }
	    }
	    exists(path, callback) {
	        const filename = (0, util_1.pathToFilename)(path);
	        if (typeof callback !== 'function')
	            throw Error(constants_2.ERRSTR.CB);
	        Promise.resolve().then(() => {
	            try {
	                callback(this.existsBase(filename));
	            }
	            catch (err) {
	                callback(false);
	            }
	        });
	    }
	    accessBase(filename, mode) {
	        this.getLinkOrThrow(filename, 'access');
	    }
	    accessSync(path, mode = F_OK) {
	        const filename = (0, util_1.pathToFilename)(path);
	        mode = mode | 0;
	        this.accessBase(filename, mode);
	    }
	    access(path, a, b) {
	        let mode = F_OK;
	        let callback;
	        if (typeof a !== 'function') {
	            mode = a | 0; // cast to number
	            callback = (0, util_1.validateCallback)(b);
	        }
	        else {
	            callback = a;
	        }
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.accessBase, [filename, mode], callback);
	    }
	    appendFileSync(id, data, options) {
	        const opts = (0, options_1.getAppendFileOpts)(options);
	        // force append behavior when using a supplied file descriptor
	        if (!opts.flag || (0, util_1.isFd)(id))
	            opts.flag = 'a';
	        this.writeFileSync(id, data, opts);
	    }
	    appendFile(id, data, a, b) {
	        const [opts, callback] = (0, options_1.getAppendFileOptsAndCb)(a, b);
	        // force append behavior when using a supplied file descriptor
	        if (!opts.flag || (0, util_1.isFd)(id))
	            opts.flag = 'a';
	        this.writeFile(id, data, opts, callback);
	    }
	    readdirBase(filename, options) {
	        filenameToSteps(filename);
	        const link = this.getResolvedLinkOrThrow(filename, 'scandir');
	        const node = link.getNode();
	        if (!node.isDirectory())
	            throw (0, util_1.createError)(ENOTDIR, 'scandir', filename);
	        // Check we have permissions
	        if (!node.canRead())
	            throw (0, util_1.createError)(EACCES, 'scandir', filename);
	        const list = []; // output list
	        for (const name of link.children.keys()) {
	            const child = link.getChild(name);
	            if (!child || name === '.' || name === '..')
	                continue;
	            list.push(Dirent_1.default.build(child, options.encoding));
	            // recursion
	            if (options.recursive && child.children.size) {
	                const recurseOptions = Object.assign(Object.assign({}, options), { recursive: true, withFileTypes: true });
	                const childList = this.readdirBase(child.getPath(), recurseOptions);
	                list.push(...childList);
	            }
	        }
	        if (!util_1.isWin && options.encoding !== 'buffer')
	            list.sort((a, b) => {
	                if (a.name < b.name)
	                    return -1;
	                if (a.name > b.name)
	                    return 1;
	                return 0;
	            });
	        if (options.withFileTypes)
	            return list;
	        let filename2 = filename;
	        if (util_1.isWin) {
	            filename2 = filename2.replace(/\\/g, '/');
	        }
	        return list.map(dirent => {
	            if (options.recursive) {
	                let fullPath = pathModule.join(dirent.parentPath, dirent.name.toString());
	                if (util_1.isWin) {
	                    fullPath = fullPath.replace(/\\/g, '/');
	                }
	                return fullPath.replace(filename2 + pathModule.posix.sep, '');
	            }
	            return dirent.name;
	        });
	    }
	    readdirSync(path, options) {
	        const opts = (0, options_1.getReaddirOptions)(options);
	        const filename = (0, util_1.pathToFilename)(path);
	        return this.readdirBase(filename, opts);
	    }
	    readdir(path, a, b) {
	        const [options, callback] = (0, options_1.getReaddirOptsAndCb)(a, b);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.readdirBase, [filename, options], callback);
	    }
	    readlinkBase(filename, encoding) {
	        const link = this.getLinkOrThrow(filename, 'readlink');
	        const node = link.getNode();
	        if (!node.isSymlink())
	            throw (0, util_1.createError)(EINVAL, 'readlink', filename);
	        return (0, encoding_1.strToEncoding)(node.symlink, encoding);
	    }
	    readlinkSync(path, options) {
	        const opts = (0, options_1.getDefaultOpts)(options);
	        const filename = (0, util_1.pathToFilename)(path);
	        return this.readlinkBase(filename, opts.encoding);
	    }
	    readlink(path, a, b) {
	        const [opts, callback] = (0, options_1.getDefaultOptsAndCb)(a, b);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.readlinkBase, [filename, opts.encoding], callback);
	    }
	    fsyncBase(fd) {
	        this.getFileByFdOrThrow(fd, 'fsync');
	    }
	    fsyncSync(fd) {
	        this.fsyncBase(fd);
	    }
	    fsync(fd, callback) {
	        this.wrapAsync(this.fsyncBase, [fd], callback);
	    }
	    fdatasyncBase(fd) {
	        this.getFileByFdOrThrow(fd, 'fdatasync');
	    }
	    fdatasyncSync(fd) {
	        this.fdatasyncBase(fd);
	    }
	    fdatasync(fd, callback) {
	        this.wrapAsync(this.fdatasyncBase, [fd], callback);
	    }
	    ftruncateBase(fd, len) {
	        const file = this.getFileByFdOrThrow(fd, 'ftruncate');
	        file.truncate(len);
	    }
	    ftruncateSync(fd, len) {
	        this.ftruncateBase(fd, len);
	    }
	    ftruncate(fd, a, b) {
	        const len = typeof a === 'number' ? a : 0;
	        const callback = (0, util_1.validateCallback)(typeof a === 'number' ? b : a);
	        this.wrapAsync(this.ftruncateBase, [fd, len], callback);
	    }
	    truncateBase(path, len) {
	        const fd = this.openSync(path, 'r+');
	        try {
	            this.ftruncateSync(fd, len);
	        }
	        finally {
	            this.closeSync(fd);
	        }
	    }
	    /**
	     * `id` should be a file descriptor or a path. `id` as file descriptor will
	     * not be supported soon.
	     */
	    truncateSync(id, len) {
	        if ((0, util_1.isFd)(id))
	            return this.ftruncateSync(id, len);
	        this.truncateBase(id, len);
	    }
	    truncate(id, a, b) {
	        const len = typeof a === 'number' ? a : 0;
	        const callback = (0, util_1.validateCallback)(typeof a === 'number' ? b : a);
	        if ((0, util_1.isFd)(id))
	            return this.ftruncate(id, len, callback);
	        this.wrapAsync(this.truncateBase, [id, len], callback);
	    }
	    futimesBase(fd, atime, mtime) {
	        const file = this.getFileByFdOrThrow(fd, 'futimes');
	        const node = file.node;
	        node.atime = new Date(atime * 1000);
	        node.mtime = new Date(mtime * 1000);
	    }
	    futimesSync(fd, atime, mtime) {
	        this.futimesBase(fd, toUnixTimestamp(atime), toUnixTimestamp(mtime));
	    }
	    futimes(fd, atime, mtime, callback) {
	        this.wrapAsync(this.futimesBase, [fd, toUnixTimestamp(atime), toUnixTimestamp(mtime)], callback);
	    }
	    utimesBase(filename, atime, mtime, followSymlinks = true) {
	        const link = followSymlinks
	            ? this.getResolvedLinkOrThrow(filename, 'utimes')
	            : this.getLinkOrThrow(filename, 'lutimes');
	        const node = link.getNode();
	        node.atime = new Date(atime * 1000);
	        node.mtime = new Date(mtime * 1000);
	    }
	    utimesSync(path, atime, mtime) {
	        this.utimesBase((0, util_1.pathToFilename)(path), toUnixTimestamp(atime), toUnixTimestamp(mtime), true);
	    }
	    utimes(path, atime, mtime, callback) {
	        this.wrapAsync(this.utimesBase, [(0, util_1.pathToFilename)(path), toUnixTimestamp(atime), toUnixTimestamp(mtime), true], callback);
	    }
	    lutimesSync(path, atime, mtime) {
	        this.utimesBase((0, util_1.pathToFilename)(path), toUnixTimestamp(atime), toUnixTimestamp(mtime), false);
	    }
	    lutimes(path, atime, mtime, callback) {
	        this.wrapAsync(this.utimesBase, [(0, util_1.pathToFilename)(path), toUnixTimestamp(atime), toUnixTimestamp(mtime), false], callback);
	    }
	    mkdirBase(filename, modeNum) {
	        const steps = filenameToSteps(filename);
	        // This will throw if user tries to create root dir `fs.mkdirSync('/')`.
	        if (!steps.length) {
	            throw (0, util_1.createError)(EEXIST, 'mkdir', filename);
	        }
	        const dir = this.getLinkParentAsDirOrThrow(filename, 'mkdir');
	        // Check path already exists.
	        const name = steps[steps.length - 1];
	        if (dir.getChild(name))
	            throw (0, util_1.createError)(EEXIST, 'mkdir', filename);
	        const node = dir.getNode();
	        if (!node.canWrite() || !node.canExecute())
	            throw (0, util_1.createError)(EACCES, 'mkdir', filename);
	        dir.createChild(name, this.createNode(constants_1.constants.S_IFDIR | modeNum));
	    }
	    /**
	     * Creates directory tree recursively.
	     */
	    mkdirpBase(filename, modeNum) {
	        let created = false;
	        const steps = filenameToSteps(filename);
	        let curr = null;
	        let i = steps.length;
	        // Find the longest subpath of filename that still exists:
	        for (i = steps.length; i >= 0; i--) {
	            curr = this.getResolvedLink(steps.slice(0, i));
	            if (curr)
	                break;
	        }
	        if (!curr) {
	            curr = this.root;
	            i = 0;
	        }
	        // curr is now the last directory that still exists.
	        // (If none of them existed, curr is the root.)
	        // Check access the lazy way:
	        curr = this.getResolvedLinkOrThrow(sep + steps.slice(0, i).join(sep), 'mkdir');
	        // Start creating directories:
	        for (i; i < steps.length; i++) {
	            const node = curr.getNode();
	            if (node.isDirectory()) {
	                // Check we have permissions
	                if (!node.canExecute() || !node.canWrite())
	                    throw (0, util_1.createError)(EACCES, 'mkdir', filename);
	            }
	            else {
	                throw (0, util_1.createError)(ENOTDIR, 'mkdir', filename);
	            }
	            created = true;
	            curr = curr.createChild(steps[i], this.createNode(constants_1.constants.S_IFDIR | modeNum));
	        }
	        return created ? filename : undefined;
	    }
	    mkdirSync(path, options) {
	        const opts = (0, options_1.getMkdirOptions)(options);
	        const modeNum = (0, util_1.modeToNumber)(opts.mode, 0o777);
	        const filename = (0, util_1.pathToFilename)(path);
	        if (opts.recursive)
	            return this.mkdirpBase(filename, modeNum);
	        this.mkdirBase(filename, modeNum);
	    }
	    mkdir(path, a, b) {
	        const opts = (0, options_1.getMkdirOptions)(a);
	        const callback = (0, util_1.validateCallback)(typeof a === 'function' ? a : b);
	        const modeNum = (0, util_1.modeToNumber)(opts.mode, 0o777);
	        const filename = (0, util_1.pathToFilename)(path);
	        if (opts.recursive)
	            this.wrapAsync(this.mkdirpBase, [filename, modeNum], callback);
	        else
	            this.wrapAsync(this.mkdirBase, [filename, modeNum], callback);
	    }
	    mkdtempBase(prefix, encoding, retry = 5) {
	        const filename = prefix + (0, util_1.genRndStr6)();
	        try {
	            this.mkdirBase(filename, 511 /* MODE.DIR */);
	            return (0, encoding_1.strToEncoding)(filename, encoding);
	        }
	        catch (err) {
	            if (err.code === EEXIST) {
	                if (retry > 1)
	                    return this.mkdtempBase(prefix, encoding, retry - 1);
	                else
	                    throw Error('Could not create temp dir.');
	            }
	            else
	                throw err;
	        }
	    }
	    mkdtempSync(prefix, options) {
	        const { encoding } = (0, options_1.getDefaultOpts)(options);
	        if (!prefix || typeof prefix !== 'string')
	            throw new TypeError('filename prefix is required');
	        (0, util_1.nullCheck)(prefix);
	        return this.mkdtempBase(prefix, encoding);
	    }
	    mkdtemp(prefix, a, b) {
	        const [{ encoding }, callback] = (0, options_1.getDefaultOptsAndCb)(a, b);
	        if (!prefix || typeof prefix !== 'string')
	            throw new TypeError('filename prefix is required');
	        if (!(0, util_1.nullCheck)(prefix))
	            return;
	        this.wrapAsync(this.mkdtempBase, [prefix, encoding], callback);
	    }
	    rmdirBase(filename, options) {
	        const opts = (0, options_1.getRmdirOptions)(options);
	        const link = this.getLinkAsDirOrThrow(filename, 'rmdir');
	        // Check directory is empty.
	        if (link.length && !opts.recursive)
	            throw (0, util_1.createError)(ENOTEMPTY, 'rmdir', filename);
	        this.deleteLink(link);
	    }
	    rmdirSync(path, options) {
	        this.rmdirBase((0, util_1.pathToFilename)(path), options);
	    }
	    rmdir(path, a, b) {
	        const opts = (0, options_1.getRmdirOptions)(a);
	        const callback = (0, util_1.validateCallback)(typeof a === 'function' ? a : b);
	        this.wrapAsync(this.rmdirBase, [(0, util_1.pathToFilename)(path), opts], callback);
	    }
	    rmBase(filename, options = {}) {
	        // "stat" is used to match Node's native error message.
	        let link;
	        try {
	            link = this.getResolvedLinkOrThrow(filename, 'stat');
	        }
	        catch (err) {
	            // Silently ignore missing paths if force option is true
	            if (err.code === ENOENT && options.force)
	                return;
	            else
	                throw err;
	        }
	        if (link.getNode().isDirectory() && !options.recursive)
	            throw (0, util_1.createError)(ERR_FS_EISDIR, 'rm', filename);
	        // Check permissions
	        if (!link.parent.getNode().canWrite())
	            throw (0, util_1.createError)(EACCES, 'rm', filename);
	        this.deleteLink(link);
	    }
	    rmSync(path, options) {
	        this.rmBase((0, util_1.pathToFilename)(path), options);
	    }
	    rm(path, a, b) {
	        const [opts, callback] = (0, options_1.getRmOptsAndCb)(a, b);
	        this.wrapAsync(this.rmBase, [(0, util_1.pathToFilename)(path), opts], callback);
	    }
	    fchmodBase(fd, modeNum) {
	        const file = this.getFileByFdOrThrow(fd, 'fchmod');
	        file.chmod(modeNum);
	    }
	    fchmodSync(fd, mode) {
	        this.fchmodBase(fd, (0, util_1.modeToNumber)(mode));
	    }
	    fchmod(fd, mode, callback) {
	        this.wrapAsync(this.fchmodBase, [fd, (0, util_1.modeToNumber)(mode)], callback);
	    }
	    chmodBase(filename, modeNum, followSymlinks = true) {
	        const link = followSymlinks
	            ? this.getResolvedLinkOrThrow(filename, 'chmod')
	            : this.getLinkOrThrow(filename, 'chmod');
	        const node = link.getNode();
	        node.chmod(modeNum);
	    }
	    chmodSync(path, mode) {
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.chmodBase(filename, modeNum, true);
	    }
	    chmod(path, mode, callback) {
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.chmodBase, [filename, modeNum], callback);
	    }
	    lchmodBase(filename, modeNum) {
	        this.chmodBase(filename, modeNum, false);
	    }
	    lchmodSync(path, mode) {
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.lchmodBase(filename, modeNum);
	    }
	    lchmod(path, mode, callback) {
	        const modeNum = (0, util_1.modeToNumber)(mode);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.lchmodBase, [filename, modeNum], callback);
	    }
	    fchownBase(fd, uid, gid) {
	        this.getFileByFdOrThrow(fd, 'fchown').chown(uid, gid);
	    }
	    fchownSync(fd, uid, gid) {
	        validateUid(uid);
	        validateGid(gid);
	        this.fchownBase(fd, uid, gid);
	    }
	    fchown(fd, uid, gid, callback) {
	        validateUid(uid);
	        validateGid(gid);
	        this.wrapAsync(this.fchownBase, [fd, uid, gid], callback);
	    }
	    chownBase(filename, uid, gid) {
	        const link = this.getResolvedLinkOrThrow(filename, 'chown');
	        const node = link.getNode();
	        node.chown(uid, gid);
	        // if(node.isFile() || node.isSymlink()) {
	        //
	        // } else if(node.isDirectory()) {
	        //
	        // } else {
	        // TODO: What do we do here?
	        // }
	    }
	    chownSync(path, uid, gid) {
	        validateUid(uid);
	        validateGid(gid);
	        this.chownBase((0, util_1.pathToFilename)(path), uid, gid);
	    }
	    chown(path, uid, gid, callback) {
	        validateUid(uid);
	        validateGid(gid);
	        this.wrapAsync(this.chownBase, [(0, util_1.pathToFilename)(path), uid, gid], callback);
	    }
	    lchownBase(filename, uid, gid) {
	        this.getLinkOrThrow(filename, 'lchown').getNode().chown(uid, gid);
	    }
	    lchownSync(path, uid, gid) {
	        validateUid(uid);
	        validateGid(gid);
	        this.lchownBase((0, util_1.pathToFilename)(path), uid, gid);
	    }
	    lchown(path, uid, gid, callback) {
	        validateUid(uid);
	        validateGid(gid);
	        this.wrapAsync(this.lchownBase, [(0, util_1.pathToFilename)(path), uid, gid], callback);
	    }
	    watchFile(path, a, b) {
	        const filename = (0, util_1.pathToFilename)(path);
	        let options = a;
	        let listener = b;
	        if (typeof options === 'function') {
	            listener = a;
	            options = null;
	        }
	        if (typeof listener !== 'function') {
	            throw Error('"watchFile()" requires a listener function');
	        }
	        let interval = 5007;
	        let persistent = true;
	        if (options && typeof options === 'object') {
	            if (typeof options.interval === 'number')
	                interval = options.interval;
	            if (typeof options.persistent === 'boolean')
	                persistent = options.persistent;
	        }
	        let watcher = this.statWatchers[filename];
	        if (!watcher) {
	            watcher = new this.StatWatcher();
	            watcher.start(filename, persistent, interval);
	            this.statWatchers[filename] = watcher;
	        }
	        watcher.addListener('change', listener);
	        return watcher;
	    }
	    unwatchFile(path, listener) {
	        const filename = (0, util_1.pathToFilename)(path);
	        const watcher = this.statWatchers[filename];
	        if (!watcher)
	            return;
	        if (typeof listener === 'function') {
	            watcher.removeListener('change', listener);
	        }
	        else {
	            watcher.removeAllListeners('change');
	        }
	        if (watcher.listenerCount('change') === 0) {
	            watcher.stop();
	            delete this.statWatchers[filename];
	        }
	    }
	    createReadStream(path, options) {
	        return new this.ReadStream(path, options);
	    }
	    createWriteStream(path, options) {
	        return new this.WriteStream(path, options);
	    }
	    // watch(path: PathLike): FSWatcher;
	    // watch(path: PathLike, options?: IWatchOptions | string): FSWatcher;
	    watch(path, options, listener) {
	        const filename = (0, util_1.pathToFilename)(path);
	        let givenOptions = options;
	        if (typeof options === 'function') {
	            listener = options;
	            givenOptions = null;
	        }
	        // tslint:disable-next-line prefer-const
	        let { persistent, recursive, encoding } = (0, options_1.getDefaultOpts)(givenOptions);
	        if (persistent === undefined)
	            persistent = true;
	        if (recursive === undefined)
	            recursive = false;
	        const watcher = new this.FSWatcher();
	        watcher.start(filename, persistent, recursive, encoding);
	        if (listener) {
	            watcher.addListener('change', listener);
	        }
	        return watcher;
	    }
	    opendirBase(filename, options) {
	        const link = this.getResolvedLinkOrThrow(filename, 'scandir');
	        const node = link.getNode();
	        if (!node.isDirectory())
	            throw (0, util_1.createError)(ENOTDIR, 'scandir', filename);
	        return new Dir_1.Dir(link, options);
	    }
	    opendirSync(path, options) {
	        const opts = (0, options_1.getOpendirOptions)(options);
	        const filename = (0, util_1.pathToFilename)(path);
	        return this.opendirBase(filename, opts);
	    }
	    opendir(path, a, b) {
	        const [options, callback] = (0, options_1.getOpendirOptsAndCb)(a, b);
	        const filename = (0, util_1.pathToFilename)(path);
	        this.wrapAsync(this.opendirBase, [filename, options], callback);
	    }
	}
	volume.Volume = Volume;
	/**
	 * Global file descriptor counter. UNIX file descriptors start from 0 and go sequentially
	 * up, so here, in order not to conflict with them, we choose some big number and descrease
	 * the file descriptor of every new opened file.
	 * @type {number}
	 * @todo This should not be static, right?
	 */
	Volume.fd = 0x7fffffff;
	function emitStop(self) {
	    self.emit('stop');
	}
	class StatWatcher extends events_1.EventEmitter {
	    constructor(vol) {
	        super();
	        this.onInterval = () => {
	            try {
	                const stats = this.vol.statSync(this.filename);
	                if (this.hasChanged(stats)) {
	                    this.emit('change', stats, this.prev);
	                    this.prev = stats;
	                }
	            }
	            finally {
	                this.loop();
	            }
	        };
	        this.vol = vol;
	    }
	    loop() {
	        this.timeoutRef = this.setTimeout(this.onInterval, this.interval);
	    }
	    hasChanged(stats) {
	        // if(!this.prev) return false;
	        if (stats.mtimeMs > this.prev.mtimeMs)
	            return true;
	        if (stats.nlink !== this.prev.nlink)
	            return true;
	        return false;
	    }
	    start(path, persistent = true, interval = 5007) {
	        this.filename = (0, util_1.pathToFilename)(path);
	        this.setTimeout = persistent
	            ? setTimeout.bind(typeof globalThis !== 'undefined' ? globalThis : commonjsGlobal$1)
	            : setTimeoutUnref_1.default;
	        this.interval = interval;
	        this.prev = this.vol.statSync(this.filename);
	        this.loop();
	    }
	    stop() {
	        clearTimeout(this.timeoutRef);
	        (0, queueMicrotask_1.default)(() => {
	            emitStop.call(this, this);
	        });
	    }
	}
	volume.StatWatcher = StatWatcher;
	/* tslint:disable no-var-keyword prefer-const */
	// ---------------------------------------- ReadStream
	var pool;
	function allocNewPool(poolSize) {
	    pool = (0, buffer_1.bufferAllocUnsafe)(poolSize);
	    pool.used = 0;
	}
	util.inherits(FsReadStream, stream_1.Readable);
	volume.ReadStream = FsReadStream;
	function FsReadStream(vol, path, options) {
	    if (!(this instanceof FsReadStream))
	        return new FsReadStream(vol, path, options);
	    this._vol = vol;
	    // a little bit bigger buffer and water marks by default
	    options = Object.assign({}, (0, options_1.getOptions)(options, {}));
	    if (options.highWaterMark === undefined)
	        options.highWaterMark = 64 * 1024;
	    stream_1.Readable.call(this, options);
	    this.path = (0, util_1.pathToFilename)(path);
	    this.fd = options.fd === undefined ? null : typeof options.fd !== 'number' ? options.fd.fd : options.fd;
	    this.flags = options.flags === undefined ? 'r' : options.flags;
	    this.mode = options.mode === undefined ? 0o666 : options.mode;
	    this.start = options.start;
	    this.end = options.end;
	    this.autoClose = options.autoClose === undefined ? true : options.autoClose;
	    this.pos = undefined;
	    this.bytesRead = 0;
	    if (this.start !== undefined) {
	        if (typeof this.start !== 'number') {
	            throw new TypeError('"start" option must be a Number');
	        }
	        if (this.end === undefined) {
	            this.end = Infinity;
	        }
	        else if (typeof this.end !== 'number') {
	            throw new TypeError('"end" option must be a Number');
	        }
	        if (this.start > this.end) {
	            throw new Error('"start" option must be <= "end" option');
	        }
	        this.pos = this.start;
	    }
	    if (typeof this.fd !== 'number')
	        this.open();
	    this.on('end', function () {
	        if (this.autoClose) {
	            if (this.destroy)
	                this.destroy();
	        }
	    });
	}
	FsReadStream.prototype.open = function () {
	    var self = this; // tslint:disable-line no-this-assignment
	    this._vol.open(this.path, this.flags, this.mode, (er, fd) => {
	        if (er) {
	            if (self.autoClose) {
	                if (self.destroy)
	                    self.destroy();
	            }
	            self.emit('error', er);
	            return;
	        }
	        self.fd = fd;
	        self.emit('open', fd);
	        // start the flow of data.
	        self.read();
	    });
	};
	FsReadStream.prototype._read = function (n) {
	    if (typeof this.fd !== 'number') {
	        return this.once('open', function () {
	            this._read(n);
	        });
	    }
	    if (this.destroyed)
	        return;
	    if (!pool || pool.length - pool.used < kMinPoolSpace) {
	        // discard the old pool.
	        allocNewPool(this._readableState.highWaterMark);
	    }
	    // Grab another reference to the pool in the case that while we're
	    // in the thread pool another read() finishes up the pool, and
	    // allocates a new one.
	    var thisPool = pool;
	    var toRead = Math.min(pool.length - pool.used, n);
	    var start = pool.used;
	    if (this.pos !== undefined)
	        toRead = Math.min(this.end - this.pos + 1, toRead);
	    // already read everything we were supposed to read!
	    // treat as EOF.
	    if (toRead <= 0)
	        return this.push(null);
	    // the actual read.
	    var self = this; // tslint:disable-line no-this-assignment
	    this._vol.read(this.fd, pool, pool.used, toRead, this.pos, onread);
	    // move the pool positions, and internal position for reading.
	    if (this.pos !== undefined)
	        this.pos += toRead;
	    pool.used += toRead;
	    function onread(er, bytesRead) {
	        if (er) {
	            if (self.autoClose && self.destroy) {
	                self.destroy();
	            }
	            self.emit('error', er);
	        }
	        else {
	            var b = null;
	            if (bytesRead > 0) {
	                self.bytesRead += bytesRead;
	                b = thisPool.slice(start, start + bytesRead);
	            }
	            self.push(b);
	        }
	    }
	};
	FsReadStream.prototype._destroy = function (err, cb) {
	    this.close(err2 => {
	        cb(err || err2);
	    });
	};
	FsReadStream.prototype.close = function (cb) {
	    var _a;
	    if (cb)
	        this.once('close', cb);
	    if (this.closed || typeof this.fd !== 'number') {
	        if (typeof this.fd !== 'number') {
	            this.once('open', closeOnOpen);
	            return;
	        }
	        return (0, queueMicrotask_1.default)(() => this.emit('close'));
	    }
	    // Since Node 18, there is only a getter for '.closed'.
	    // The first branch mimics other setters from Readable.
	    // See https://github.com/nodejs/node/blob/v18.0.0/lib/internal/streams/readable.js#L1243
	    if (typeof ((_a = this._readableState) === null || _a === void 0 ? void 0 : _a.closed) === 'boolean') {
	        this._readableState.closed = true;
	    }
	    else {
	        this.closed = true;
	    }
	    this._vol.close(this.fd, er => {
	        if (er)
	            this.emit('error', er);
	        else
	            this.emit('close');
	    });
	    this.fd = null;
	};
	// needed because as it will be called with arguments
	// that does not match this.close() signature
	function closeOnOpen(fd) {
	    this.close();
	}
	util.inherits(FsWriteStream, stream_1.Writable);
	volume.WriteStream = FsWriteStream;
	function FsWriteStream(vol, path, options) {
	    if (!(this instanceof FsWriteStream))
	        return new FsWriteStream(vol, path, options);
	    this._vol = vol;
	    options = Object.assign({}, (0, options_1.getOptions)(options, {}));
	    stream_1.Writable.call(this, options);
	    this.path = (0, util_1.pathToFilename)(path);
	    this.fd = options.fd === undefined ? null : typeof options.fd !== 'number' ? options.fd.fd : options.fd;
	    this.flags = options.flags === undefined ? 'w' : options.flags;
	    this.mode = options.mode === undefined ? 0o666 : options.mode;
	    this.start = options.start;
	    this.autoClose = options.autoClose === undefined ? true : !!options.autoClose;
	    this.pos = undefined;
	    this.bytesWritten = 0;
	    this.pending = true;
	    if (this.start !== undefined) {
	        if (typeof this.start !== 'number') {
	            throw new TypeError('"start" option must be a Number');
	        }
	        if (this.start < 0) {
	            throw new Error('"start" must be >= zero');
	        }
	        this.pos = this.start;
	    }
	    if (options.encoding)
	        this.setDefaultEncoding(options.encoding);
	    if (typeof this.fd !== 'number')
	        this.open();
	    // dispose on finish.
	    this.once('finish', function () {
	        if (this.autoClose) {
	            this.close();
	        }
	    });
	}
	FsWriteStream.prototype.open = function () {
	    this._vol.open(this.path, this.flags, this.mode, function (er, fd) {
	        if (er) {
	            if (this.autoClose && this.destroy) {
	                this.destroy();
	            }
	            this.emit('error', er);
	            return;
	        }
	        this.fd = fd;
	        this.pending = false;
	        this.emit('open', fd);
	    }.bind(this));
	};
	FsWriteStream.prototype._write = function (data, encoding, cb) {
	    if (!(data instanceof buffer_1.Buffer || data instanceof Uint8Array))
	        return this.emit('error', new Error('Invalid data'));
	    if (typeof this.fd !== 'number') {
	        return this.once('open', function () {
	            this._write(data, encoding, cb);
	        });
	    }
	    var self = this; // tslint:disable-line no-this-assignment
	    this._vol.write(this.fd, data, 0, data.length, this.pos, (er, bytes) => {
	        if (er) {
	            if (self.autoClose && self.destroy) {
	                self.destroy();
	            }
	            return cb(er);
	        }
	        self.bytesWritten += bytes;
	        cb();
	    });
	    if (this.pos !== undefined)
	        this.pos += data.length;
	};
	FsWriteStream.prototype._writev = function (data, cb) {
	    if (typeof this.fd !== 'number') {
	        return this.once('open', function () {
	            this._writev(data, cb);
	        });
	    }
	    const self = this; // tslint:disable-line no-this-assignment
	    const len = data.length;
	    const chunks = new Array(len);
	    var size = 0;
	    for (var i = 0; i < len; i++) {
	        var chunk = data[i].chunk;
	        chunks[i] = chunk;
	        size += chunk.length;
	    }
	    const buf = buffer_1.Buffer.concat(chunks);
	    this._vol.write(this.fd, buf, 0, buf.length, this.pos, (er, bytes) => {
	        if (er) {
	            if (self.destroy)
	                self.destroy();
	            return cb(er);
	        }
	        self.bytesWritten += bytes;
	        cb();
	    });
	    if (this.pos !== undefined)
	        this.pos += size;
	};
	FsWriteStream.prototype.close = function (cb) {
	    var _a;
	    if (cb)
	        this.once('close', cb);
	    if (this.closed || typeof this.fd !== 'number') {
	        if (typeof this.fd !== 'number') {
	            this.once('open', closeOnOpen);
	            return;
	        }
	        return (0, queueMicrotask_1.default)(() => this.emit('close'));
	    }
	    // Since Node 18, there is only a getter for '.closed'.
	    // The first branch mimics other setters from Writable.
	    // See https://github.com/nodejs/node/blob/v18.0.0/lib/internal/streams/writable.js#L766
	    if (typeof ((_a = this._writableState) === null || _a === void 0 ? void 0 : _a.closed) === 'boolean') {
	        this._writableState.closed = true;
	    }
	    else {
	        this.closed = true;
	    }
	    this._vol.close(this.fd, er => {
	        if (er)
	            this.emit('error', er);
	        else
	            this.emit('close');
	    });
	    this.fd = null;
	};
	FsWriteStream.prototype._destroy = FsReadStream.prototype._destroy;
	// There is no shutdown() for files.
	FsWriteStream.prototype.destroySoon = FsWriteStream.prototype.end;
	// ---------------------------------------- FSWatcher
	class FSWatcher extends events_1.EventEmitter {
	    constructor(vol) {
	        super();
	        this._filename = '';
	        this._filenameEncoded = '';
	        // _persistent: boolean = true;
	        this._recursive = false;
	        this._encoding = encoding_1.ENCODING_UTF8;
	        // inode -> removers
	        this._listenerRemovers = new Map();
	        this._onParentChild = (link) => {
	            if (link.getName() === this._getName()) {
	                this._emit('rename');
	            }
	        };
	        this._emit = (type) => {
	            this.emit('change', type, this._filenameEncoded);
	        };
	        this._persist = () => {
	            this._timer = setTimeout(this._persist, 1e6);
	        };
	        this._vol = vol;
	        // TODO: Emit "error" messages when watching.
	        // this._handle.onchange = function(status, eventType, filename) {
	        //     if (status < 0) {
	        //         self._handle.close();
	        //         const error = !filename ?
	        //             errnoException(status, 'Error watching file for changes:') :
	        //             errnoException(status, `Error watching file ${filename} for changes:`);
	        //         error.filename = filename;
	        //         self.emit('error', error);
	        //     } else {
	        //         self.emit('change', eventType, filename);
	        //     }
	        // };
	    }
	    _getName() {
	        return this._steps[this._steps.length - 1];
	    }
	    start(path, persistent = true, recursive = false, encoding = encoding_1.ENCODING_UTF8) {
	        this._filename = (0, util_1.pathToFilename)(path);
	        this._steps = filenameToSteps(this._filename);
	        this._filenameEncoded = (0, encoding_1.strToEncoding)(this._filename);
	        // this._persistent = persistent;
	        this._recursive = recursive;
	        this._encoding = encoding;
	        try {
	            this._link = this._vol.getLinkOrThrow(this._filename, 'FSWatcher');
	        }
	        catch (err) {
	            const error = new Error(`watch ${this._filename} ${err.code}`);
	            error.code = err.code;
	            error.errno = err.code;
	            throw error;
	        }
	        const watchLinkNodeChanged = (link) => {
	            var _a;
	            const filepath = link.getPath();
	            const node = link.getNode();
	            const onNodeChange = () => {
	                let filename = relative(this._filename, filepath);
	                if (!filename) {
	                    filename = this._getName();
	                }
	                return this.emit('change', 'change', filename);
	            };
	            node.on('change', onNodeChange);
	            const removers = (_a = this._listenerRemovers.get(node.ino)) !== null && _a !== void 0 ? _a : [];
	            removers.push(() => node.removeListener('change', onNodeChange));
	            this._listenerRemovers.set(node.ino, removers);
	        };
	        const watchLinkChildrenChanged = (link) => {
	            var _a;
	            const node = link.getNode();
	            // when a new link added
	            const onLinkChildAdd = (l) => {
	                this.emit('change', 'rename', relative(this._filename, l.getPath()));
	                setTimeout(() => {
	                    // 1. watch changes of the new link-node
	                    watchLinkNodeChanged(l);
	                    // 2. watch changes of the new link-node's children
	                    watchLinkChildrenChanged(l);
	                });
	            };
	            // when a new link deleted
	            const onLinkChildDelete = (l) => {
	                // remove the listeners of the children nodes
	                const removeLinkNodeListeners = (curLink) => {
	                    const ino = curLink.getNode().ino;
	                    const removers = this._listenerRemovers.get(ino);
	                    if (removers) {
	                        removers.forEach(r => r());
	                        this._listenerRemovers.delete(ino);
	                    }
	                    for (const [name, childLink] of curLink.children.entries()) {
	                        if (childLink && name !== '.' && name !== '..') {
	                            removeLinkNodeListeners(childLink);
	                        }
	                    }
	                };
	                removeLinkNodeListeners(l);
	                this.emit('change', 'rename', relative(this._filename, l.getPath()));
	            };
	            // children nodes changed
	            for (const [name, childLink] of link.children.entries()) {
	                if (childLink && name !== '.' && name !== '..') {
	                    watchLinkNodeChanged(childLink);
	                }
	            }
	            // link children add/remove
	            link.on('child:add', onLinkChildAdd);
	            link.on('child:delete', onLinkChildDelete);
	            const removers = (_a = this._listenerRemovers.get(node.ino)) !== null && _a !== void 0 ? _a : [];
	            removers.push(() => {
	                link.removeListener('child:add', onLinkChildAdd);
	                link.removeListener('child:delete', onLinkChildDelete);
	            });
	            if (recursive) {
	                for (const [name, childLink] of link.children.entries()) {
	                    if (childLink && name !== '.' && name !== '..') {
	                        watchLinkChildrenChanged(childLink);
	                    }
	                }
	            }
	        };
	        watchLinkNodeChanged(this._link);
	        watchLinkChildrenChanged(this._link);
	        const parent = this._link.parent;
	        if (parent) {
	            // parent.on('child:add', this._onParentChild);
	            parent.setMaxListeners(parent.getMaxListeners() + 1);
	            parent.on('child:delete', this._onParentChild);
	        }
	        if (persistent)
	            this._persist();
	    }
	    close() {
	        clearTimeout(this._timer);
	        this._listenerRemovers.forEach(removers => {
	            removers.forEach(r => r());
	        });
	        this._listenerRemovers.clear();
	        const parent = this._link.parent;
	        if (parent) {
	            // parent.removeListener('child:add', this._onParentChild);
	            parent.removeListener('child:delete', this._onParentChild);
	        }
	    }
	}
	volume.FSWatcher = FSWatcher;
	
	return volume;
}

var fsSynchronousApiList = {};

var hasRequiredFsSynchronousApiList;

function requireFsSynchronousApiList () {
	if (hasRequiredFsSynchronousApiList) return fsSynchronousApiList;
	hasRequiredFsSynchronousApiList = 1;
	Object.defineProperty(fsSynchronousApiList, "__esModule", { value: true });
	fsSynchronousApiList.fsSynchronousApiList = void 0;
	fsSynchronousApiList.fsSynchronousApiList = [
	    'accessSync',
	    'appendFileSync',
	    'chmodSync',
	    'chownSync',
	    'closeSync',
	    'copyFileSync',
	    'existsSync',
	    'fchmodSync',
	    'fchownSync',
	    'fdatasyncSync',
	    'fstatSync',
	    'fsyncSync',
	    'ftruncateSync',
	    'futimesSync',
	    'lchmodSync',
	    'lchownSync',
	    'linkSync',
	    'lstatSync',
	    'mkdirSync',
	    'mkdtempSync',
	    'openSync',
	    'readdirSync',
	    'readFileSync',
	    'readlinkSync',
	    'readSync',
	    'readvSync',
	    'realpathSync',
	    'renameSync',
	    'rmdirSync',
	    'rmSync',
	    'statSync',
	    'symlinkSync',
	    'truncateSync',
	    'unlinkSync',
	    'utimesSync',
	    'lutimesSync',
	    'writeFileSync',
	    'writeSync',
	    'writevSync',
	    // 'cpSync',
	    // 'statfsSync',
	];
	
	return fsSynchronousApiList;
}

var fsCallbackApiList = {};

var hasRequiredFsCallbackApiList;

function requireFsCallbackApiList () {
	if (hasRequiredFsCallbackApiList) return fsCallbackApiList;
	hasRequiredFsCallbackApiList = 1;
	Object.defineProperty(fsCallbackApiList, "__esModule", { value: true });
	fsCallbackApiList.fsCallbackApiList = void 0;
	fsCallbackApiList.fsCallbackApiList = [
	    'access',
	    'appendFile',
	    'chmod',
	    'chown',
	    'close',
	    'copyFile',
	    'createReadStream',
	    'createWriteStream',
	    'exists',
	    'fchmod',
	    'fchown',
	    'fdatasync',
	    'fstat',
	    'fsync',
	    'ftruncate',
	    'futimes',
	    'lchmod',
	    'lchown',
	    'link',
	    'lstat',
	    'mkdir',
	    'mkdtemp',
	    'open',
	    'read',
	    'readv',
	    'readdir',
	    'readFile',
	    'readlink',
	    'realpath',
	    'rename',
	    'rm',
	    'rmdir',
	    'stat',
	    'symlink',
	    'truncate',
	    'unlink',
	    'unwatchFile',
	    'utimes',
	    'lutimes',
	    'watch',
	    'watchFile',
	    'write',
	    'writev',
	    'writeFile',
	];
	
	return fsCallbackApiList;
}

var hasRequiredLib;

function requireLib () {
	if (hasRequiredLib) return lib$2.exports;
	hasRequiredLib = 1;
	(function (module, exports) {
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.memfs = exports.fs = exports.vol = exports.Volume = void 0;
		exports.createFsFromVolume = createFsFromVolume;
		const Stats_1 = requireStats();
		const Dirent_1 = requireDirent();
		const volume_1 = requireVolume();
		Object.defineProperty(exports, "Volume", { enumerable: true, get: function () { return volume_1.Volume; } });
		const constants_1 = requireConstants$2();
		const fsSynchronousApiList_1 = requireFsSynchronousApiList();
		const fsCallbackApiList_1 = requireFsCallbackApiList();
		const { F_OK, R_OK, W_OK, X_OK } = constants_1.constants;
		// Default volume.
		exports.vol = new volume_1.Volume();
		function createFsFromVolume(vol) {
		    const fs = { F_OK, R_OK, W_OK, X_OK, constants: constants_1.constants, Stats: Stats_1.default, Dirent: Dirent_1.default };
		    // Bind FS methods.
		    for (const method of fsSynchronousApiList_1.fsSynchronousApiList)
		        if (typeof vol[method] === 'function')
		            fs[method] = vol[method].bind(vol);
		    for (const method of fsCallbackApiList_1.fsCallbackApiList)
		        if (typeof vol[method] === 'function')
		            fs[method] = vol[method].bind(vol);
		    fs.StatWatcher = vol.StatWatcher;
		    fs.FSWatcher = vol.FSWatcher;
		    fs.WriteStream = vol.WriteStream;
		    fs.ReadStream = vol.ReadStream;
		    fs.promises = vol.promises;
		    fs._toUnixTimestamp = volume_1.toUnixTimestamp;
		    fs.__vol = vol;
		    return fs;
		}
		exports.fs = createFsFromVolume(exports.vol);
		/**
		 * Creates a new file system instance.
		 *
		 * @param json File system structure expressed as a JSON object.
		 *        Use `null` for empty directories and empty string for empty files.
		 * @param cwd Current working directory. The JSON structure will be created
		 *        relative to this path.
		 * @returns A `memfs` file system instance, which is a drop-in replacement for
		 *          the `fs` module.
		 */
		const memfs = (json = {}, cwd = '/') => {
		    const vol = volume_1.Volume.fromNestedJSON(json, cwd);
		    const fs = createFsFromVolume(vol);
		    return { fs, vol };
		};
		exports.memfs = memfs;
		module.exports = Object.assign(Object.assign({}, module.exports), exports.fs);
		module.exports.semantic = true;
		
	} (lib$2, lib$2.exports));
	return lib$2.exports;
}

var libExports = requireLib();
var index = /*@__PURE__*/getDefaultExportFromCjs$1(libExports);

var memfsExported = /*#__PURE__*/_mergeNamespaces({
	__proto__: null,
	default: index
}, [libExports]);

const { createFsFromVolume, Volume, fs, memfs } = memfsExported;

export { Volume, createFsFromVolume, fs, memfs, memfsExported };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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