import type { Params } from '../../../server/request/params';
import type { AppPageRouteModule } from '../../../server/route-modules/app-page/module.compiled';
import type { AppRouteRouteModule } from '../../../server/route-modules/app-route/module.compiled';
import { type AppSegmentConfig } from './app-segment-config';
import type { DynamicParamTypes } from '../../../shared/lib/app-router-types';
type GenerateStaticParams = (options: {
    params?: Params;
}) => Promise<Params[]>;
export type AppSegment = {
    name: string;
    paramName: string | undefined;
    paramType: DynamicParamTypes | undefined;
    filePath: string | undefined;
    config: AppSegmentConfig | undefined;
    generateStaticParams: GenerateStaticParams | undefined;
};
/**
 * Collects the segments for a given route module.
 *
 * @param components the loaded components
 * @returns the segments for the route module
 */
export declare function collectSegments(routeModule: AppRouteRouteModule | AppPageRouteModule): Promise<AppSegment[]> | AppSegment[];
export {};
