@extends('layouts.app')

@section('title', 'Nuevo Candidato')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nuevo Candidato</h1>

        <form action="{{ route('admin.candidatos.store') }}" method="POST" enctype="multipart/form-data"
            class="card space-y-6">
            @csrf

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" class="form-input" required>
                    <option value="">Seleccionar sede</option>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ old('sede_id') == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
                @error('sede_id') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="nombre" value="{{ old('nombre') }}" class="form-input" required>
                @error('nombre') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Tipo de Candidato *</label>
                <select name="tipo" class="form-input" required>
                    <option value="">Seleccionar tipo</option>
                    <option value="personero" {{ old('tipo') === 'personero' ? 'selected' : '' }}>Personero</option>
                    <option value="contralor" {{ old('tipo') === 'contralor' ? 'selected' : '' }}>Contralor</option>
                </select>
                @error('tipo') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Foto del Candidato</label>
                <input type="file" name="foto" accept="image/*" class="form-input">
                <p class="text-gray-500 text-sm mt-1">Formatos: JPG, PNG. Máximo 2MB.</p>
                @error('foto') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Propuestas</label>
                <textarea name="propuestas" rows="4" class="form-input">{{ old('propuestas') }}</textarea>
                @error('propuestas') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Candidato</button>
                <a href="{{ route('admin.candidatos.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection