@extends('layouts.app')

@section('title', 'Editar Candidato')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Candidato</h1>

        <form action="{{ route('admin.candidatos.update', $candidato) }}" method="POST" enctype="multipart/form-data"
            class="card space-y-6">
            @csrf
            @method('PUT')

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" class="form-input" required>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ $candidato->sede_id == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="nombre" value="{{ old('nombre', $candidato->nombre) }}" class="form-input"
                    required>
            </div>

            <div>
                <label class="form-label">Tipo de Candidato *</label>
                <select name="tipo" class="form-input" required>
                    <option value="personero" {{ $candidato->tipo === 'personero' ? 'selected' : '' }}>Personero</option>
                    <option value="contralor" {{ $candidato->tipo === 'contralor' ? 'selected' : '' }}>Contralor</option>
                </select>
            </div>

            <div>
                <label class="form-label">Foto del Candidato</label>
                @if($candidato->foto)
                    <div class="mb-4">
                        <img src="{{ asset('storage/' . $candidato->foto) }}" class="w-32 h-32 rounded-xl object-cover">
                    </div>
                @endif
                <input type="file" name="foto" accept="image/*" class="form-input">
                <p class="text-gray-500 text-sm mt-1">Deja vacío para mantener la foto actual.</p>
            </div>

            <div>
                <label class="form-label">Propuestas</label>
                <textarea name="propuestas" rows="4"
                    class="form-input">{{ old('propuestas', $candidato->propuestas) }}</textarea>
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="activo" value="1" {{ $candidato->activo ? 'checked' : '' }}
                        class="w-5 h-5 rounded">
                    <span class="font-medium">Candidato Activo</span>
                </label>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Candidato</button>
                <a href="{{ route('admin.candidatos.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection