@extends('layouts.app')

@section('title', 'Gestión de Candidatos')

@section('content')
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-gray-800">Candidatos</h1>
            <a href="{{ route('admin.candidatos.create') }}" class="btn-primary">+ Nuevo Candidato</a>
        </div>

        <div class="table-container overflow-x-auto">
            <table class="w-full">
                <thead class="table-header">
                    <tr>
                        <th>Foto</th>
                        <th>Nombre</th>
                        <th>Tipo</th>
                        <th>Sede</th>
                        <th>Votos</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($candidatos as $candidato)
                        <tr class="table-row">
                            <td>
                                @if($candidato->foto)
                                    <img src="{{ asset('storage/' . $candidato->foto) }}"
                                        class="w-12 h-12 rounded-full object-cover">
                                @else
                                    <div
                                        class="w-12 h-12 rounded-full bg-gradient-to-br {{ $candidato->tipo === 'personero' ? 'from-green-400 to-green-600' : 'from-yellow-400 to-yellow-600' }} flex items-center justify-center text-white font-bold">
                                        {{ strtoupper(substr($candidato->nombre, 0, 2)) }}
                                    </div>
                                @endif
                            </td>
                            <td class="font-semibold">{{ $candidato->nombre }}</td>
                            <td>
                                <span class="badge {{ $candidato->tipo === 'personero' ? 'badge-green' : 'badge-yellow' }}">
                                    {{ ucfirst($candidato->tipo) }}
                                </span>
                            </td>
                            <td>{{ $candidato->sede->nombre }}</td>
                            <td class="font-bold">{{ $candidato->votos_count }}</td>
                            <td>
                                <span class="badge {{ $candidato->activo ? 'badge-green' : 'badge-red' }}">
                                    {{ $candidato->activo ? 'Activo' : 'Inactivo' }}
                                </span>
                            </td>
                            <td class="flex gap-2">
                                <a href="{{ route('admin.candidatos.edit', $candidato) }}"
                                    class="btn-secondary text-sm px-3 py-1">Editar</a>
                                <form action="{{ route('admin.candidatos.destroy', $candidato) }}" method="POST"
                                    onsubmit="return confirm('¿Eliminar este candidato?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-danger text-sm px-3 py-1">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-8 text-gray-500">No hay candidatos registrados</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
@endsection