@extends('layouts.app')

@section('title', 'Nuevo Estudiante')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nuevo Estudiante</h1>

        <form action="{{ route('admin.estudiantes.store') }}" method="POST" class="card space-y-6">
            @csrf

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="name" value="{{ old('name') }}" class="form-input" required>
                @error('name') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Número de Documento *</label>
                <input type="text" name="documento" value="{{ old('documento') }}" class="form-input" required>
                <p class="text-gray-500 text-sm mt-1">Este será también la contraseña del estudiante.</p>
                @error('documento') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" id="sede_id" class="form-input" required onchange="filtrarGrados()">
                    <option value="">Seleccionar sede</option>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ old('sede_id') == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
                @error('sede_id') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Grado *</label>
                <select name="grado_id" id="grado_id" class="form-input" required>
                    <option value="">Primero selecciona una sede</option>
                    @foreach($grados as $grado)
                        <option value="{{ $grado->id }}" data-sede="{{ $grado->sede_id }}" {{ old('grado_id') == $grado->id ? 'selected' : '' }} style="display: none;">
                            {{ $grado->nombre }}
                        </option>
                    @endforeach
                </select>
                @error('grado_id') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="habilitado" value="1" {{ old('habilitado') ? 'checked' : '' }}
                        class="w-5 h-5 rounded">
                    <span class="font-medium">Habilitar para votar</span>
                </label>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Estudiante</button>
                <a href="{{ route('admin.estudiantes.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>

    <script>
        function filtrarGrados() {
            const sedeId = document.getElementById('sede_id').value;
            const gradoSelect = document.getElementById('grado_id');
            const opciones = gradoSelect.querySelectorAll('option[data-sede]');

            gradoSelect.value = '';

            opciones.forEach(opt => {
                if (opt.dataset.sede === sedeId) {
                    opt.style.display = '';
                } else {
                    opt.style.display = 'none';
                }
            });

            if (sedeId) {
                gradoSelect.querySelector('option:first-child').textContent = 'Seleccionar grado';
            } else {
                gradoSelect.querySelector('option:first-child').textContent = 'Primero selecciona una sede';
            }
        }

        // Ejecutar al cargar si hay valor previo
        if (document.getElementById('sede_id').value) {
            filtrarGrados();
        }
    </script>
@endsection