@extends('layouts.app')

@section('title', 'Editar Estudiante')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Estudiante</h1>

        <form action="{{ route('admin.estudiantes.update', $estudiante) }}" method="POST" class="card space-y-6">
            @csrf
            @method('PUT')

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="name" value="{{ old('name', $estudiante->name) }}" class="form-input" required>
            </div>

            <div>
                <label class="form-label">Número de Documento *</label>
                <input type="text" name="documento" value="{{ old('documento', $estudiante->documento) }}"
                    class="form-input" required>
            </div>

            <div>
                <label class="form-label">Correo Electrónico</label>
                <input type="email" name="email" value="{{ old('email', $estudiante->email) }}" class="form-input">
            </div>

            <div>
                <label class="form-label">Grado *</label>
                <select name="grado_id" class="form-input" required>
                    @foreach($grados as $grado)
                        <option value="{{ $grado->id }}" {{ $estudiante->grado_id == $grado->id ? 'selected' : '' }}>
                            {{ $grado->nombre }} - {{ $grado->sede->nombre }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="habilitado" value="1" {{ $estudiante->habilitado ? 'checked' : '' }}
                        class="w-5 h-5 rounded">
                    <span class="font-medium">Habilitar para votar</span>
                </label>
            </div>

            <!-- Estado de Votación -->
            <div class="p-4 bg-gray-50 rounded-xl">
                <h3 class="font-semibold mb-3">Estado de Votación</h3>
                <div class="space-y-2">
                    <div class="flex items-center justify-between">
                        <span>Voto Personero:</span>
                        @if($estudiante->ha_votado_personero)
                            <span class="badge badge-green">✓ Registrado</span>
                        @else
                            <span class="badge badge-yellow">Pendiente</span>
                        @endif
                    </div>
                    <div class="flex items-center justify-between">
                        <span>Voto Contralor:</span>
                        @if($estudiante->ha_votado_contralor)
                            <span class="badge badge-green">✓ Registrado</span>
                        @else
                            <span class="badge badge-yellow">Pendiente</span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Estudiante</button>
                <a href="{{ route('admin.estudiantes.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection