@extends('layouts.app')

@section('title', 'Gestión de Estudiantes')

@section('content')
    <div class="space-y-6">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <h1 class="text-3xl font-bold text-gray-800">Estudiantes</h1>
            <div class="flex gap-2">
                <a href="{{ route('admin.estudiantes.create') }}" class="btn-primary">+ Nuevo Estudiante</a>
            </div>
        </div>

        <!-- Acciones Masivas -->
        <div class="card">
            <div class="flex flex-wrap gap-4 items-center">
                <form action="{{ route('admin.estudiantes.habilitar-todos') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn-secondary"
                        onclick="return confirm('¿Habilitar todos los estudiantes para votar?')">
                        Habilitar Todos
                    </button>
                </form>
                <form action="{{ route('admin.estudiantes.resetear-votos') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn-danger"
                        onclick="return confirm('¿Resetear los votos de todos los estudiantes? Esta acción no se puede deshacer.')">
                        Resetear Votos
                    </button>
                </form>
            </div>
        </div>

        <!-- Filtros -->
        <form method="GET" class="card">
            <div class="flex flex-wrap gap-4 items-end">
                <div>
                    <label class="form-label">Grado</label>
                    <select name="grado_id" class="form-input w-auto">
                        <option value="">Todos</option>
                        @foreach($grados as $grado)
                            <option value="{{ $grado->id }}" {{ request('grado_id') == $grado->id ? 'selected' : '' }}>
                                {{ $grado->nombre }} - {{ $grado->sede->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="form-label">Estado</label>
                    <select name="habilitado" class="form-input w-auto">
                        <option value="">Todos</option>
                        <option value="1" {{ request('habilitado') === '1' ? 'selected' : '' }}>Habilitados</option>
                        <option value="0" {{ request('habilitado') === '0' ? 'selected' : '' }}>No Habilitados</option>
                    </select>
                </div>
                <button type="submit" class="btn-secondary">Filtrar</button>
            </div>
        </form>

        <!-- Tabla -->
        <div class="table-container overflow-x-auto">
            <table class="w-full">
                <thead class="table-header">
                    <tr>
                        <th>Nombre</th>
                        <th>Documento</th>
                        <th>Grado</th>
                        <th>Sede</th>
                        <th>Estado</th>
                        <th>Personero</th>
                        <th>Contralor</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($estudiantes as $estudiante)
                        <tr class="table-row">
                            <td class="font-semibold">{{ $estudiante->name }}</td>
                            <td>{{ $estudiante->documento }}</td>
                            <td>{{ $estudiante->grado?->nombre ?? '-' }}</td>
                            <td>{{ $estudiante->grado?->sede?->nombre ?? '-' }}</td>
                            <td>
                                <span class="badge {{ $estudiante->habilitado ? 'badge-green' : 'badge-red' }}">
                                    {{ $estudiante->habilitado ? 'Habilitado' : 'No Habilitado' }}
                                </span>
                            </td>
                            <td>
                                @if($estudiante->ha_votado_personero)
                                    <span class="text-green-600">✓</span>
                                @else
                                    <span class="text-gray-300">-</span>
                                @endif
                            </td>
                            <td>
                                @if($estudiante->ha_votado_contralor)
                                    <span class="text-green-600">✓</span>
                                @else
                                    <span class="text-gray-300">-</span>
                                @endif
                            </td>
                            <td class="flex gap-2">
                                <a href="{{ route('admin.estudiantes.edit', $estudiante) }}"
                                    class="btn-secondary text-sm px-3 py-1">Editar</a>
                                <form action="{{ route('admin.estudiantes.destroy', $estudiante) }}" method="POST"
                                    onsubmit="return confirm('¿Eliminar este estudiante?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-danger text-sm px-3 py-1">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-8 text-gray-500">No hay estudiantes registrados</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="text-gray-500 text-sm">
            Total: {{ $estudiantes->count() }} estudiantes
        </div>
    </div>
@endsection