@extends('layouts.app')

@section('title', 'Nuevo Grado')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nuevo Grado</h1>

        <form action="{{ route('admin.grados.store') }}" method="POST" class="card space-y-6">
            @csrf

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" class="form-input" required>
                    <option value="">Seleccionar sede</option>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ old('sede_id') == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
                @error('sede_id') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Nombre del Grado *</label>
                <input type="text" name="nombre" value="{{ old('nombre') }}" class="form-input" placeholder="Ej: 10° A"
                    required>
                @error('nombre') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Nivel (1-12) *</label>
                <input type="number" name="nivel" value="{{ old('nivel') }}" class="form-input" min="1" max="12"
                    placeholder="Ej: 10" required>
                <p class="text-gray-500 text-sm mt-1">Número del grado (primero=1, segundo=2, etc.)</p>
                @error('nivel') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Grado</button>
                <a href="{{ route('admin.grados.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection