@extends('layouts.app')

@section('title', 'Editar Grado')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Grado</h1>

        <form action="{{ route('admin.grados.update', $grado) }}" method="POST" class="card space-y-6">
            @csrf
            @method('PUT')

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" class="form-input" required>
                    <option value="">Seleccionar sede</option>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ old('sede_id', $grado->sede_id) == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
                @error('sede_id') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Nombre del Grado *</label>
                <input type="text" name="nombre" value="{{ old('nombre', $grado->nombre) }}" class="form-input" required>
                @error('nombre') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Nivel (1-12) *</label>
                <input type="number" name="nivel" value="{{ old('nivel', $grado->nivel) }}" class="form-input" min="1"
                    max="12" required>
                @error('nivel') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Grado</button>
                <a href="{{ route('admin.grados.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection