@extends('layouts.app')

@section('title', 'Gestión de Grados')

@section('content')
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-gray-800">Grados</h1>
            <a href="{{ route('admin.grados.create') }}" class="btn-primary">+ Nuevo Grado</a>
        </div>

        @if(session('error'))
            <div class="alert alert-error">{{ session('error') }}</div>
        @endif

        <div class="card overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Grado</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Sede</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Nivel</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Estudiantes</th>
                        <th class="px-4 py-3 text-right text-sm font-semibold text-gray-600">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($grados as $grado)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 font-medium">{{ $grado->nombre }}</td>
                            <td class="px-4 py-3 text-gray-600">{{ $grado->sede->nombre }}</td>
                            <td class="px-4 py-3">
                                <span class="badge badge-blue">{{ $grado->nivel }}°</span>
                            </td>
                            <td class="px-4 py-3">{{ $grado->users_count }}</td>
                            <td class="px-4 py-3 text-right">
                                <div class="flex justify-end gap-2">
                                    <a href="{{ route('admin.grados.edit', $grado) }}" class="btn-secondary text-sm">Editar</a>
                                    <form action="{{ route('admin.grados.destroy', $grado) }}" method="POST"
                                        onsubmit="return confirm('¿Eliminar este grado?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn-danger text-sm">Eliminar</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-4 py-8 text-center text-gray-500">No hay grados registrados</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
@endsection