@extends('layouts.app')

@section('title', 'Resultados')

@section('content')
    <div class="space-y-8">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <h1 class="text-3xl font-bold text-gray-800">Resultados de Votación</h1>

            <!-- Filtro por Sede -->
            <form method="GET" class="flex items-center gap-4">
                <select name="sede_id" class="form-input w-auto" onchange="this.form.submit()">
                    <option value="">Todas las Sedes</option>
                    @foreach($sedes as $sede)
                        <option value="{{ $sede->id }}" {{ $sedeId == $sede->id ? 'selected' : '' }}>
                            {{ $sede->nombre }}
                        </option>
                    @endforeach
                </select>
            </form>
        </div>

        <div class="grid md:grid-cols-2 gap-8">
            <!-- Gráfica Personeros -->
            <div class="chart-container">
                <h2 class="text-xl font-bold mb-6 text-green-700">Resultados Personero</h2>
                <canvas id="chartPersoneros" height="300"></canvas>

                <div class="mt-6 space-y-3">
                    @foreach($personeros as $candidato)
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 rounded-full"
                                    style="background: hsl({{ $loop->index * 60 + 120 }}, 70%, 50%);"></div>
                                <span>{{ $candidato->nombre }}</span>
                            </div>
                            <span class="font-bold">{{ $candidato->votos_count }} votos</span>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Gráfica Contralores -->
            <div class="chart-container">
                <h2 class="text-xl font-bold mb-6 text-yellow-700">Resultados Contralor</h2>
                <canvas id="chartContralores" height="300"></canvas>

                <div class="mt-6 space-y-3">
                    @foreach($contralores as $candidato)
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 rounded-full"
                                    style="background: hsl({{ $loop->index * 60 + 40 }}, 70%, 50%);"></div>
                                <span>{{ $candidato->nombre }}</span>
                            </div>
                            <span class="font-bold">{{ $candidato->votos_count }} votos</span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Ganadores -->
        @if($personeros->count() > 0 || $contralores->count() > 0)
            <div class="grid md:grid-cols-2 gap-8">
                @if($personeros->first())
                    <div class="card text-center py-8 border-4 border-green-500">
                        <div class="text-5xl mb-4">👑</div>
                        <h3 class="text-xl font-bold text-gray-600 mb-2">Ganador Personero</h3>
                        <p class="text-3xl font-bold text-green-600">{{ $personeros->first()->nombre }}</p>
                        <p class="text-gray-500 mt-2">{{ $personeros->first()->votos_count }} votos</p>
                    </div>
                @endif

                @if($contralores->first())
                    <div class="card text-center py-8 border-4 border-yellow-500">
                        <div class="text-5xl mb-4">👑</div>
                        <h3 class="text-xl font-bold text-gray-600 mb-2">Ganador Contralor</h3>
                        <p class="text-3xl font-bold text-yellow-600">{{ $contralores->first()->nombre }}</p>
                        <p class="text-gray-500 mt-2">{{ $contralores->first()->votos_count }} votos</p>
                    </div>
                @endif
            </div>
        @endif
    </div>

    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            // Colores institucionales
            const colorsGreen = ['#2E7D32', '#4CAF50', '#81C784', '#A5D6A7'];
            const colorsYellow = ['#F9A825', '#FBC02D', '#FFEB3B', '#FFF176'];

            // Gráfico Personeros
            new Chart(document.getElementById('chartPersoneros'), {
                type: 'doughnut',
                data: {
                    labels: @json($chartDataPersoneros['labels']),
                    datasets: [{
                        data: @json($chartDataPersoneros['data']),
                        backgroundColor: colorsGreen,
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });

            // Gráfico Contralores
            new Chart(document.getElementById('chartContralores'), {
                type: 'doughnut',
                data: {
                    labels: @json($chartDataContralores['labels']),
                    datasets: [{
                        data: @json($chartDataContralores['data']),
                        backgroundColor: colorsYellow,
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
        </script>
    @endpush
@endsection