@extends('layouts.app')

@section('title', 'Nueva Sede')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nueva Sede</h1>

        <form action="{{ route('admin.sedes.store') }}" method="POST" class="card space-y-6">
            @csrf

            <div>
                <label class="form-label">Nombre de la Sede *</label>
                <input type="text" name="nombre" value="{{ old('nombre') }}" class="form-input" required>
                @error('nombre') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Slug (URL pública) *</label>
                <div class="flex items-center gap-2">
                    <span class="text-gray-500">/sede/</span>
                    <input type="text" name="slug" value="{{ old('slug') }}" class="form-input flex-1"
                        placeholder="ej: sede-principal" required pattern="[a-z0-9\-]+"
                        title="Solo letras minúsculas, números y guiones">
                </div>
                <p class="text-gray-500 text-sm mt-1">Este será el link público para votar. Usa solo letras minúsculas,
                    números y guiones.</p>
                @error('slug') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Dirección</label>
                <input type="text" name="direccion" value="{{ old('direccion') }}" class="form-input">
                @error('direccion') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Sede</button>
                <a href="{{ route('admin.sedes.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection