@extends('layouts.app')

@section('title', 'Editar Sede')

@section('content')
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Sede</h1>

        <form action="{{ route('admin.sedes.update', $sede) }}" method="POST" class="card space-y-6">
            @csrf
            @method('PUT')

            <div>
                <label class="form-label">Nombre de la Sede *</label>
                <input type="text" name="nombre" value="{{ old('nombre', $sede->nombre) }}" class="form-input" required>
            </div>

            <div>
                <label class="form-label">Slug (URL pública) *</label>
                <div class="flex items-center gap-2">
                    <span class="text-gray-500">/sede/</span>
                    <input type="text" name="slug" value="{{ old('slug', $sede->slug) }}" class="form-input flex-1" required
                        pattern="[a-z0-9\-]+" title="Solo letras minúsculas, números y guiones">
                </div>
                @if($sede->slug)
                    <p class="text-green-600 text-sm mt-1">
                        Link público: <a href="{{ route('sede.votar', $sede) }}" target="_blank"
                            class="underline">{{ url('/sede/' . $sede->slug) }}</a>
                    </p>
                @endif
                @error('slug') <p class="text-red-500 text-sm mt-1">{{ $message }}</p> @enderror
            </div>

            <div>
                <label class="form-label">Dirección</label>
                <input type="text" name="direccion" value="{{ old('direccion', $sede->direccion) }}" class="form-input">
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="activa" value="1" {{ $sede->activa ? 'checked' : '' }}
                        class="w-5 h-5 rounded">
                    <span class="font-medium">Sede Activa</span>
                </label>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Sede</button>
                <a href="{{ route('admin.sedes.index') }}" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
@endsection