<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Confirmar Contraseña - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="w-full max-w-md px-6">
        <!-- Logo y Título -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}">
                <img src="{{ asset('logo.jpg') }}" alt="Logo I.E. Las Huacas"
                    class="w-24 h-24 mx-auto rounded-full bg-white p-2 shadow-lg object-contain mb-4">
            </a>
            <h1 class="text-2xl font-bold text-white">Confirmar Contraseña</h1>
            <p class="text-white/70">I.E. Las Huacas</p>
        </div>

        <!-- Formulario -->
        <div class="bg-white rounded-3xl p-8 shadow-2xl">
            <p class="text-gray-600 text-sm mb-6 text-center">
                Esta es un área segura de la aplicación. Por favor confirma tu contraseña antes de continuar.
            </p>

            <form method="POST" action="{{ route('password.confirm') }}" class="space-y-5">
                @csrf

                <!-- Password -->
                <div>
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" id="password" name="password" class="form-input" required
                        autocomplete="current-password">
                    @error('password')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit -->
                <button type="submit" class="btn-primary w-full py-3">
                    Confirmar
                </button>
            </form>
        </div>
    </div>
</body>

</html>