<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Recuperar Contraseña - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="w-full max-w-md px-6">
        <!-- Logo y Título -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}">
                <img src="{{ asset('logo.jpg') }}" alt="Logo I.E. Las Huacas"
                    class="w-24 h-24 mx-auto rounded-full bg-white p-2 shadow-lg object-contain mb-4">
            </a>
            <h1 class="text-2xl font-bold text-white">Recuperar Contraseña</h1>
            <p class="text-white/70">I.E. Las Huacas</p>
        </div>

        <!-- Formulario -->
        <div class="bg-white rounded-3xl p-8 shadow-2xl">
            <p class="text-gray-600 text-sm mb-6 text-center">
                Ingresa tu correo electrónico y te enviaremos un enlace para restablecer tu contraseña.
            </p>

            <!-- Session Status -->
            @if (session('status'))
                <div class="alert alert-success mb-4">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('password.email') }}" class="space-y-5">
                @csrf

                <!-- Email -->
                <div>
                    <label for="email" class="form-label">Correo Electrónico</label>
                    <input type="email" id="email" name="email" value="{{ old('email') }}" class="form-input" required
                        autofocus>
                    @error('email')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit -->
                <button type="submit" class="btn-primary w-full py-3">
                    Enviar Enlace de Recuperación
                </button>
            </form>
        </div>

        <!-- Link de regreso -->
        <div class="text-center mt-6">
            <a href="{{ route('login') }}" class="text-white/80 hover:text-white underline text-sm">
                ← Volver a iniciar sesión
            </a>
        </div>
    </div>
</body>

</html>