<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Registrarse - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="w-full max-w-md px-6 py-8">
        <!-- Logo y Título -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}">
                <img src="{{ asset('logo.jpg') }}" alt="Logo I.E. Las Huacas"
                    class="w-20 h-20 mx-auto rounded-full bg-white p-2 shadow-lg object-contain mb-4">
            </a>
            <h1 class="text-2xl font-bold text-white">Crear Cuenta</h1>
            <p class="text-white/70">I.E. Las Huacas</p>
        </div>

        <!-- Formulario -->
        <div class="bg-white rounded-3xl p-8 shadow-2xl">
            <form method="POST" action="{{ route('register') }}" class="space-y-4">
                @csrf

                <!-- Name -->
                <div>
                    <label for="name" class="form-label">Nombre Completo</label>
                    <input type="text" id="name" name="name" value="{{ old('name') }}" class="form-input" required
                        autofocus autocomplete="name">
                    @error('name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Email -->
                <div>
                    <label for="email" class="form-label">Correo Electrónico</label>
                    <input type="email" id="email" name="email" value="{{ old('email') }}" class="form-input" required
                        autocomplete="username">
                    @error('email')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" id="password" name="password" class="form-input" required
                        autocomplete="new-password">
                    @error('password')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirmation" class="form-label">Confirmar Contraseña</label>
                    <input type="password" id="password_confirmation" name="password_confirmation" class="form-input"
                        required autocomplete="new-password">
                </div>

                <!-- Submit -->
                <button type="submit" class="btn-primary w-full py-3 mt-2">
                    Registrarse
                </button>

                <p class="text-center text-sm text-gray-500 mt-4">
                    ¿Ya tienes cuenta?
                    <a href="{{ route('login') }}" class="text-green-600 hover:text-green-800 underline">Inicia
                        sesión</a>
                </p>
            </form>
        </div>

        <!-- Link de regreso -->
        <div class="text-center mt-6">
            <a href="{{ route('home') }}" class="text-white/80 hover:text-white underline text-sm">
                ← Volver a la página principal
            </a>
        </div>
    </div>
</body>

</html>