<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Verificar Email - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="w-full max-w-md px-6">
        <!-- Logo y Título -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}">
                <img src="{{ asset('logo.jpg') }}" alt="Logo I.E. Las Huacas"
                    class="w-24 h-24 mx-auto rounded-full bg-white p-2 shadow-lg object-contain mb-4">
            </a>
            <h1 class="text-2xl font-bold text-white">Verificar Email</h1>
            <p class="text-white/70">I.E. Las Huacas</p>
        </div>

        <!-- Contenido -->
        <div class="bg-white rounded-3xl p-8 shadow-2xl">
            <div class="text-center mb-6">
                <div class="text-5xl mb-4">📧</div>
                <p class="text-gray-600">
                    Gracias por registrarte. Antes de continuar, verifica tu correo electrónico haciendo clic en el
                    enlace que te enviamos.
                </p>
            </div>

            @if (session('status') == 'verification-link-sent')
                <div class="alert alert-success mb-4">
                    Se ha enviado un nuevo enlace de verificación a tu correo electrónico.
                </div>
            @endif

            <div class="space-y-4">
                <form method="POST" action="{{ route('verification.send') }}">
                    @csrf
                    <button type="submit" class="btn-primary w-full py-3">
                        Reenviar Email de Verificación
                    </button>
                </form>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="btn-secondary w-full py-3">
                        Cerrar Sesión
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>

</html>