@extends('layouts.app')

@section('title', 'Mi Panel')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="card text-center py-12">
            <div class="mb-8">
                <img src="{{ asset('logo.jpg') }}" alt="Logo I.E. Las Huacas"
                    class="w-32 h-32 mx-auto rounded-full bg-white p-2 shadow-lg object-contain">
            </div>

            <h1 class="text-3xl font-bold text-gray-800 mb-2">Bienvenido, {{ auth()->user()->name }}</h1>

            @if(auth()->user()->grado)
                <p class="text-gray-600 mb-8">
                    {{ auth()->user()->grado->nombre }} -
                    {{ auth()->user()->grado->sede->nombre ?? 'Sin sede' }}
                </p>
            @else
                <p class="text-gray-600 mb-8">Administrador del Sistema</p>
            @endif

            @if(auth()->user()->isAdmin())
                <!-- Panel Admin -->
                <div class="grid md:grid-cols-3 gap-6 max-w-3xl mx-auto">
                    <a href="{{ route('admin.dashboard') }}" class="card hover:shadow-xl transition-shadow">
                        <div class="text-4xl mb-3">📊</div>
                        <h3 class="font-bold">Dashboard</h3>
                        <p class="text-gray-500 text-sm">Ver estadísticas</p>
                    </a>
                    <a href="{{ route('admin.candidatos.index') }}" class="card hover:shadow-xl transition-shadow">
                        <div class="text-4xl mb-3">👥</div>
                        <h3 class="font-bold">Candidatos</h3>
                        <p class="text-gray-500 text-sm">Gestionar candidatos</p>
                    </a>
                    <a href="{{ route('admin.estudiantes.index') }}" class="card hover:shadow-xl transition-shadow">
                        <div class="text-4xl mb-3">📋</div>
                        <h3 class="font-bold">Estudiantes</h3>
                        <p class="text-gray-500 text-sm">Gestionar votantes</p>
                    </a>
                </div>
            @else
                <!-- Panel Estudiante -->
                @if(auth()->user()->puedeVotar())
                    @if(!auth()->user()->yaVotoPersonero() || !auth()->user()->yaVotoContralor())
                        <div class="mb-8">
                            <p class="text-lg text-gray-700 mb-4">Tienes votaciones pendientes:</p>
                            <div class="flex justify-center gap-4 flex-wrap">
                                @if(!auth()->user()->yaVotoPersonero())
                                    <span class="badge badge-yellow">Personero: Pendiente</span>
                                @else
                                    <span class="badge badge-green">✓ Personero</span>
                                @endif
                                @if(!auth()->user()->yaVotoContralor())
                                    <span class="badge badge-yellow">Contralor: Pendiente</span>
                                @else
                                    <span class="badge badge-green">✓ Contralor</span>
                                @endif
                            </div>
                        </div>
                        <a href="{{ route('votar.mostrar') }}" class="btn-primary text-xl px-12 py-4">
                            Ir a Votar
                        </a>
                    @else
                        <div class="confirmation-icon mx-auto mb-6" style="width: 100px; height: 100px;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"
                                class="w-12 h-12 text-white">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-green-600 mb-4">¡Has completado tu votación!</h2>
                        <p class="text-gray-600">Gracias por participar en las elecciones estudiantiles.</p>
                    @endif
                @else
                    <div class="p-6 bg-yellow-50 rounded-xl border-2 border-yellow-200 max-w-md mx-auto">
                        <p class="text-yellow-800 font-medium">
                            No estás habilitado para votar. Contacta al administrador si crees que esto es un error.
                        </p>
                    </div>
                @endif
            @endif
        </div>
    </div>
@endsection