@extends('layouts.app')

@section('title', 'Voto Confirmado')

@section('content')
    <div class="confirmation-container">
        <div class="confirmation-icon">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
            </svg>
        </div>

        <h1 class="confirmation-title">¡Voto Registrado!</h1>

        <p class="text-xl text-gray-600 mb-8">
            Tu voto ha sido registrado exitosamente.<br>
            Gracias por participar en las elecciones estudiantiles.
        </p>

        <div class="card max-w-md mx-auto mb-8">
            <h3 class="font-bold text-lg mb-4">Estado de tu votación:</h3>
            <div class="space-y-3">
                <div class="flex items-center justify-between">
                    <span>Voto por Personero:</span>
                    @if($user->yaVotoPersonero())
                        <span class="badge badge-green">✓ Registrado</span>
                    @else
                        <span class="badge badge-yellow">Pendiente</span>
                    @endif
                </div>
                <div class="flex items-center justify-between">
                    <span>Voto por Contralor:</span>
                    @if($user->yaVotoContralor())
                        <span class="badge badge-green">✓ Registrado</span>
                    @else
                        <span class="badge badge-yellow">Pendiente</span>
                    @endif
                </div>
            </div>
        </div>

        @if(!$user->yaVotoPersonero() || !$user->yaVotoContralor())
            <a href="{{ route('votacion.index') }}" class="btn-primary">
                Continuar Votando
            </a>
        @else
            <a href="{{ route('home') }}" class="btn-secondary">
                Volver al Inicio
            </a>
        @endif
    </div>
@endsection