@extends('layouts.app')

@section('title', 'Votación')

@section('content')
    <div class="max-w-6xl mx-auto">
        <!-- Estado del Usuario -->
        <div class="card mb-8">
            <div class="flex items-center justify-between flex-wrap gap-4">
                <div>
                    <h2 class="text-2xl font-bold text-gray-800">Hola, {{ $user->name }}</h2>
                    <p class="text-gray-600">{{ $user->grado?->nombre }} - {{ $sede->nombre }}</p>
                </div>
                <div class="flex gap-4">
                    @if($user->yaVotoPersonero())
                        <span class="badge badge-green">✓ Ya votaste por Personero</span>
                    @endif
                    @if($user->yaVotoContralor())
                        <span class="badge badge-green">✓ Ya votaste por Contralor</span>
                    @endif
                </div>
            </div>
        </div>

        <form action="{{ route('votacion.votar') }}" method="POST" id="votacion-form">
            @csrf

            <!-- Sección Personero -->
            @if(!$user->yaVotoPersonero() && $personeros->count() > 0)
                <div class="voting-section">
                    <h2 class="voting-section-title mb-12">Candidatos a Personero</h2>

                    <div class="grid md:grid-cols-2 gap-8">
                        @foreach($personeros as $personero)
                            <div class="candidate-card" data-type="personero" data-id="{{ $personero->id }}"
                                onclick="selectCandidate(this, 'personero', {{ $personero->id }})">
                                @if($personero->foto)
                                    <img src="{{ asset('storage/' . $personero->foto) }}" alt="{{ $personero->nombre }}"
                                        class="candidate-photo">
                                @else
                                    <div
                                        class="candidate-photo bg-gradient-to-br from-green-400 to-green-600 flex items-center justify-center text-white text-5xl font-bold">
                                        {{ strtoupper(substr($personero->nombre, 0, 2)) }}
                                    </div>
                                @endif

                                <span class="candidate-badge personero">Personero</span>
                                <h3 class="candidate-name">{{ $personero->nombre }}</h3>

                                @if($personero->propuestas)
                                    <p class="text-gray-600 text-sm mt-4 text-left">
                                        <strong>Propuestas:</strong><br>
                                        {{ Str::limit($personero->propuestas, 200) }}
                                    </p>
                                @endif
                            </div>
                        @endforeach
                    </div>
                    <input type="hidden" name="personero_id" id="personero_id" value="">
                </div>
            @elseif($user->yaVotoPersonero())
                <div class="card text-center py-8 mb-8">
                    <div class="text-green-600 text-5xl mb-4">✓</div>
                    <h3 class="text-2xl font-bold text-gray-800">Ya votaste por Personero</h3>
                    <p class="text-gray-600 mt-2">Tu voto ha sido registrado exitosamente.</p>
                </div>
            @endif

            <!-- Sección Contralor -->
            @if(!$user->yaVotoContralor() && $contralores->count() > 0)
                <div class="voting-section mt-12">
                    <h2 class="voting-section-title mb-12">Candidatos a Contralor</h2>

                    <div class="grid md:grid-cols-2 gap-8">
                        @foreach($contralores as $contralor)
                            <div class="candidate-card" data-type="contralor" data-id="{{ $contralor->id }}"
                                onclick="selectCandidate(this, 'contralor', {{ $contralor->id }})">
                                @if($contralor->foto)
                                    <img src="{{ asset('storage/' . $contralor->foto) }}" alt="{{ $contralor->nombre }}"
                                        class="candidate-photo">
                                @else
                                    <div
                                        class="candidate-photo bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center text-white text-5xl font-bold">
                                        {{ strtoupper(substr($contralor->nombre, 0, 2)) }}
                                    </div>
                                @endif

                                <span class="candidate-badge contralor">Contralor</span>
                                <h3 class="candidate-name">{{ $contralor->nombre }}</h3>

                                @if($contralor->propuestas)
                                    <p class="text-gray-600 text-sm mt-4 text-left">
                                        <strong>Propuestas:</strong><br>
                                        {{ Str::limit($contralor->propuestas, 200) }}
                                    </p>
                                @endif
                            </div>
                        @endforeach
                    </div>
                    <input type="hidden" name="contralor_id" id="contralor_id" value="">
                </div>
            @elseif($user->yaVotoContralor())
                <div class="card text-center py-8">
                    <div class="text-green-600 text-5xl mb-4">✓</div>
                    <h3 class="text-2xl font-bold text-gray-800">Ya votaste por Contralor</h3>
                    <p class="text-gray-600 mt-2">Tu voto ha sido registrado exitosamente.</p>
                </div>
            @endif

            <!-- Botón de Votar -->
            @if((!$user->yaVotoPersonero() && $personeros->count() > 0) || (!$user->yaVotoContralor() && $contralores->count() > 0))
                <div class="mt-12 text-center">
                    <button type="submit" class="btn-primary text-xl px-12 py-4" id="btn-votar" disabled>
                        Confirmar Voto
                    </button>
                    <p class="text-gray-500 text-sm mt-4">Selecciona tus candidatos para habilitar el botón de voto</p>
                </div>
            @endif
        </form>
    </div>

    @push('scripts')
        <script>
            function selectCandidate(card, type, id) {
                // Remover selección de otras tarjetas del mismo tipo
                document.querySelectorAll(`.candidate-card[data-type="${type}"]`).forEach(c => {
                    c.classList.remove('selected');
                });

                // Seleccionar esta tarjeta
                card.classList.add('selected');

                // Actualizar el input hidden
                document.getElementById(`${type}_id`).value = id;

                // Verificar si se puede habilitar el botón
                checkVoteButton();
            }

            function checkVoteButton() {
                const personeroId = document.getElementById('personero_id')?.value;
                const contralorId = document.getElementById('contralor_id')?.value;
                const btnVotar = document.getElementById('btn-votar');

                if (btnVotar) {
                    // El botón se habilita si se ha seleccionado al menos un candidato
                    btnVotar.disabled = !(personeroId || contralorId);
                }
            }

            // Confirmación antes de enviar
            document.getElementById('votacion-form')?.addEventListener('submit', function (e) {
                if (!confirm('¿Estás seguro de confirmar tu voto? Esta acción no se puede deshacer.')) {
                    e.preventDefault();
                }
            });
        </script>
    @endpush
@endsection