<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Votar - {{ $sede->nombre }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        .mini-card {
            background: white;
            border-radius: 16px;
            padding: 12px;
            cursor: pointer;
            transition: all 0.2s;
            border: 3px solid transparent;
            text-align: center;
        }
        .mini-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }
        .mini-card.selected {
            border-color: #2E7D32;
            background: linear-gradient(135deg, #E8F5E9, #C8E6C9);
        }
        .mini-card.selected .check-mark {
            display: flex;
        }
        .mini-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            margin: 0 auto 8px;
            border: 3px solid #e5e7eb;
        }
        .mini-card.selected .mini-photo {
            border-color: #2E7D32;
        }
        .check-mark {
            display: none;
            position: absolute;
            top: -8px;
            right: -8px;
            width: 28px;
            height: 28px;
            background: #2E7D32;
            border-radius: 50%;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        .section-title {
            font-size: 1rem;
            font-weight: 700;
            color: #1B5E20;
            margin-bottom: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .compact-header {
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 100%);
            padding: 16px 20px;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
    </style>
</head>
<body class="antialiased min-h-screen bg-gray-100">
    <!-- Header compacto -->
    <div class="compact-header">
        <div class="flex items-center gap-3">
            <img src="{{ asset('logo.jpg') }}" alt="Logo" class="h-10 w-10 rounded-full bg-white p-0.5 object-contain">
            <div>
                <div class="font-bold">{{ $estudiante->name }}</div>
                <div class="text-white/70 text-xs">{{ $estudiante->grado?->nombre }} • {{ $sede->nombre }}</div>
            </div>
        </div>
        <a href="{{ route('sede.votar', $sede) }}" class="text-white/80 hover:text-white text-sm">✕ Salir</a>
    </div>

    @if($estudiante->ha_votado_personero && $estudiante->ha_votado_contralor)
        <!-- Ya votó -->
        <div class="flex items-center justify-center min-h-[80vh]">
            <div class="text-center p-8">
                <div class="w-20 h-20 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-10 h-10 text-white">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-green-600 mb-2">¡Votación Completa!</h1>
                <p class="text-gray-500">Gracias por participar.</p>
            </div>
        </div>
    @else
        <form action="{{ route('sede.votar.registrar', $sede) }}" method="POST" id="votacion-form" class="p-4 max-w-4xl mx-auto">
            @csrf
            
            <div class="grid md:grid-cols-2 gap-6">
                <!-- Personeros -->
                @if(!$estudiante->ha_votado_personero && $personeros->count() > 0)
                <div class="bg-white rounded-2xl p-4 shadow-sm">
                    <div class="section-title flex items-center gap-2">
                        <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                        Personero
                    </div>
                    <div class="grid grid-cols-2 gap-3">
                        @foreach($personeros as $p)
                        <div class="mini-card relative" onclick="selectCandidate(this, 'personero', {{ $p->id }})">
                            <div class="check-mark">✓</div>
                            @if($p->foto)
                                <img src="{{ asset('storage/' . $p->foto) }}" class="mini-photo">
                            @else
                                <div class="mini-photo bg-gradient-to-br from-green-400 to-green-600 flex items-center justify-center text-white text-xl font-bold">
                                    {{ strtoupper(substr($p->nombre, 0, 2)) }}
                                </div>
                            @endif
                            <div class="font-semibold text-gray-800 text-sm">{{ $p->nombre }}</div>
                        </div>
                        @endforeach
                    </div>
                    <input type="hidden" name="personero_id" id="personero_id" value="">
                </div>
                @elseif($estudiante->ha_votado_personero)
                <div class="bg-green-50 rounded-2xl p-4 flex items-center justify-center">
                    <div class="text-center">
                        <span class="text-3xl">✅</span>
                        <p class="text-green-700 font-medium mt-2">Ya votaste por Personero</p>
                    </div>
                </div>
                @endif

                <!-- Contralores -->
                @if(!$estudiante->ha_votado_contralor && $contralores->count() > 0)
                <div class="bg-white rounded-2xl p-4 shadow-sm">
                    <div class="section-title flex items-center gap-2">
                        <span class="w-3 h-3 bg-yellow-500 rounded-full"></span>
                        Contralor
                    </div>
                    <div class="grid grid-cols-2 gap-3">
                        @foreach($contralores as $c)
                        <div class="mini-card relative" onclick="selectCandidate(this, 'contralor', {{ $c->id }})">
                            <div class="check-mark">✓</div>
                            @if($c->foto)
                                <img src="{{ asset('storage/' . $c->foto) }}" class="mini-photo">
                            @else
                                <div class="mini-photo bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center text-white text-xl font-bold">
                                    {{ strtoupper(substr($c->nombre, 0, 2)) }}
                                </div>
                            @endif
                            <div class="font-semibold text-gray-800 text-sm">{{ $c->nombre }}</div>
                        </div>
                        @endforeach
                    </div>
                    <input type="hidden" name="contralor_id" id="contralor_id" value="">
                </div>
                @elseif($estudiante->ha_votado_contralor)
                <div class="bg-green-50 rounded-2xl p-4 flex items-center justify-center">
                    <div class="text-center">
                        <span class="text-3xl">✅</span>
                        <p class="text-green-700 font-medium mt-2">Ya votaste por Contralor</p>
                    </div>
                </div>
                @endif
            </div>

            <!-- Botón Votar -->
            <div class="mt-6 text-center">
                <button type="submit" id="btn-votar" disabled
                    class="bg-green-600 hover:bg-green-700 disabled:bg-gray-300 disabled:cursor-not-allowed text-white font-bold py-3 px-10 rounded-full text-lg transition-all shadow-lg disabled:shadow-none">
                    Confirmar Voto
                </button>
                <p class="text-gray-400 text-xs mt-2">Selecciona al menos un candidato</p>
            </div>
        </form>
    @endif

    <script>
        function selectCandidate(card, type, id) {
            card.parentElement.querySelectorAll('.mini-card').forEach(c => c.classList.remove('selected'));
            card.classList.add('selected');
            document.getElementById(`${type}_id`).value = id;
            checkButton();
        }
        
        function checkButton() {
            const p = document.getElementById('personero_id')?.value;
            const c = document.getElementById('contralor_id')?.value;
            const btn = document.getElementById('btn-votar');
            if (btn) btn.disabled = !(p || c);
        }
        
        document.getElementById('votacion-form')?.addEventListener('submit', function(e) {
            if (!confirm('¿Confirmar tu voto?')) e.preventDefault();
        });
    </script>
</body>
</html>