<?php

use App\Http\Controllers\Api\AdminController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CandidatoApiController;
use App\Http\Controllers\Api\EstudianteApiController;
use App\Http\Controllers\Api\GradoApiController;
use App\Http\Controllers\Api\SedeApiController;
use App\Http\Controllers\Api\VotacionController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// Public Auth Routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);

// Public Voting Routes
Route::get('/sedes', [VotacionController::class, 'sedes']);
Route::get('/sede/{sede:slug}', [VotacionController::class, 'sede']);
Route::post('/sede/{sede:slug}/verificar', [VotacionController::class, 'verificar']);
Route::post('/sede/{sede:slug}/candidatos', [VotacionController::class, 'candidatos']);
Route::post('/sede/{sede:slug}/votar', [VotacionController::class, 'votar']);
Route::get('/resultados-publicos', [VotacionController::class, 'resultadosPublicos']);

// Authenticated Routes
Route::middleware('auth:sanctum')->group(function () {
    // Auth
    Route::get('/user', [AuthController::class, 'user']);
    Route::post('/logout', [AuthController::class, 'logout']);

    // Admin Routes (require admin role)
    Route::middleware('admin')->prefix('admin')->group(function () {
        // Dashboard
        Route::get('/dashboard', [AdminController::class, 'dashboard']);
        Route::post('/toggle-votacion', [AdminController::class, 'toggleVotacion']);
        Route::get('/resultados', [AdminController::class, 'resultados']);

        // CRUD Resources
        Route::apiResource('sedes', SedeApiController::class);
        Route::apiResource('grados', GradoApiController::class);
        Route::get('sedes/{sede}/grados', [GradoApiController::class, 'getBySede']);
        Route::apiResource('candidatos', CandidatoApiController::class);
        Route::apiResource('estudiantes', EstudianteApiController::class);
        Route::post('estudiantes/habilitar-todos', [EstudianteApiController::class, 'habilitarTodos']);
        Route::post('estudiantes/resetear-votos', [EstudianteApiController::class, 'resetearVotos']);
        Route::get('estudiantes-export', [EstudianteApiController::class, 'export']);
        Route::post('estudiantes-import', [EstudianteApiController::class, 'import']);
    });
});
