<?php

use App\Http\Controllers\Admin\CandidatoController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\EstudianteController;
use App\Http\Controllers\Admin\SedeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\VotacionController;
use App\Http\Controllers\VotacionPublicaController;
use Illuminate\Support\Facades\Route;

// Página principal - Selección de sede o resultados
Route::get('/', function () {
    $votacionAbierta = \App\Models\Setting::votacionAbierta();
    $sedes = \App\Models\Sede::where('activa', true)->whereNotNull('slug')->get();
    
    $resultados = [];
    if (!$votacionAbierta) {
        foreach ($sedes as $sede) {
            $personero = \App\Models\Candidato::where('sede_id', $sede->id)
                ->where('tipo', 'personero')
                ->where('activo', true)
                ->withCount('votos')
                ->orderByDesc('votos_count')
                ->first();
            
            $contralor = \App\Models\Candidato::where('sede_id', $sede->id)
                ->where('tipo', 'contralor')
                ->where('activo', true)
                ->withCount('votos')
                ->orderByDesc('votos_count')
                ->first();
            
            $resultados[] = [
                'sede' => $sede,
                'personero' => $personero,
                'contralor' => $contralor,
            ];
        }
    }
    
    return view('welcome', compact('sedes', 'votacionAbierta', 'resultados'));
})->name('home');

// Rutas de votación pública (sin autenticación, por documento)
Route::post('/verificar', [VotacionPublicaController::class, 'verificar'])->name('votar.verificar');
Route::get('/votar', [VotacionPublicaController::class, 'mostrar'])->name('votar.mostrar');
Route::post('/votar', [VotacionPublicaController::class, 'votar'])->name('votar.registrar');
Route::get('/confirmacion', [VotacionPublicaController::class, 'confirmacion'])->name('votar.confirmacion');

// Rutas de votación por sede (URL pública con slug)
use App\Http\Controllers\VotacionSedeController;
Route::get('/sede/{sede}', [VotacionSedeController::class, 'index'])->name('sede.votar');
Route::post('/sede/{sede}/verificar', [VotacionSedeController::class, 'verificar'])->name('sede.votar.verificar');
Route::get('/sede/{sede}/votar', [VotacionSedeController::class, 'mostrar'])->name('sede.votar.mostrar');
Route::post('/sede/{sede}/votar', [VotacionSedeController::class, 'votar'])->name('sede.votar.registrar');
Route::get('/sede/{sede}/confirmacion', [VotacionSedeController::class, 'confirmacion'])->name('sede.votar.confirmacion');

// Dashboard según rol (para admin)
Route::get('/dashboard', function () {
    $user = auth()->user();
    
    if ($user->isAdmin()) {
        return redirect()->route('admin.dashboard');
    }
    
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Rutas de perfil
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Rutas de administración
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');
    Route::get('/resultados', [AdminDashboardController::class, 'resultados'])->name('resultados');
    Route::post('/toggle-votacion', [AdminDashboardController::class, 'toggleVotacion'])->name('toggle-votacion');
    
    // CRUD Sedes
    Route::resource('sedes', SedeController::class);
    
    // CRUD Grados
    Route::resource('grados', \App\Http\Controllers\Admin\GradoController::class);
    
    // CRUD Candidatos
    Route::resource('candidatos', CandidatoController::class);
    
    // CRUD Estudiantes
    Route::resource('estudiantes', EstudianteController::class);
    Route::post('/estudiantes/habilitar-todos', [EstudianteController::class, 'habilitarTodos'])->name('estudiantes.habilitar-todos');
    Route::post('/estudiantes/resetear-votos', [EstudianteController::class, 'resetearVotos'])->name('estudiantes.resetear-votos');
});

require __DIR__.'/auth.php';
