<?php $__env->startSection('title', 'Editar Sede'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Sede</h1>

        <form action="<?php echo e(route('admin.sedes.update', $sede)); ?>" method="POST" class="card space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div>
                <label class="form-label">Nombre de la Sede *</label>
                <input type="text" name="nombre" value="<?php echo e(old('nombre', $sede->nombre)); ?>" class="form-input" required>
            </div>

            <div>
                <label class="form-label">Slug (URL pública) *</label>
                <div class="flex items-center gap-2">
                    <span class="text-gray-500">/sede/</span>
                    <input type="text" name="slug" value="<?php echo e(old('slug', $sede->slug)); ?>" class="form-input flex-1" required
                        pattern="[a-z0-9\-]+" title="Solo letras minúsculas, números y guiones">
                </div>
                <?php if($sede->slug): ?>
                    <p class="text-green-600 text-sm mt-1">
                        Link público: <a href="<?php echo e(route('sede.votar', $sede)); ?>" target="_blank"
                            class="underline"><?php echo e(url('/sede/' . $sede->slug)); ?></a>
                    </p>
                <?php endif; ?>
                <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Dirección</label>
                <input type="text" name="direccion" value="<?php echo e(old('direccion', $sede->direccion)); ?>" class="form-input">
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="activa" value="1" <?php echo e($sede->activa ? 'checked' : ''); ?>

                        class="w-5 h-5 rounded">
                    <span class="font-medium">Sede Activa</span>
                </label>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Sede</button>
                <a href="<?php echo e(route('admin.sedes.index')); ?>" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/sedes/edit.blade.php ENDPATH**/ ?>