<?php $__env->startSection('title', 'Resultados'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-8">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <h1 class="text-3xl font-bold text-gray-800">Resultados de Votación</h1>

            <!-- Filtro por Sede -->
            <form method="GET" class="flex items-center gap-4">
                <select name="sede_id" class="form-input w-auto" onchange="this.form.submit()">
                    <option value="">Todas las Sedes</option>
                    <?php $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sede->id); ?>" <?php echo e($sedeId == $sede->id ? 'selected' : ''); ?>>
                            <?php echo e($sede->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>

        <div class="grid md:grid-cols-2 gap-8">
            <!-- Gráfica Personeros -->
            <div class="chart-container">
                <h2 class="text-xl font-bold mb-6 text-green-700">Resultados Personero</h2>
                <canvas id="chartPersoneros" height="300"></canvas>

                <div class="mt-6 space-y-3">
                    <?php $__currentLoopData = $personeros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 rounded-full"
                                    style="background: hsl(<?php echo e($loop->index * 60 + 120); ?>, 70%, 50%);"></div>
                                <span><?php echo e($candidato->nombre); ?></span>
                            </div>
                            <span class="font-bold"><?php echo e($candidato->votos_count); ?> votos</span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Gráfica Contralores -->
            <div class="chart-container">
                <h2 class="text-xl font-bold mb-6 text-yellow-700">Resultados Contralor</h2>
                <canvas id="chartContralores" height="300"></canvas>

                <div class="mt-6 space-y-3">
                    <?php $__currentLoopData = $contralores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 rounded-full"
                                    style="background: hsl(<?php echo e($loop->index * 60 + 40); ?>, 70%, 50%);"></div>
                                <span><?php echo e($candidato->nombre); ?></span>
                            </div>
                            <span class="font-bold"><?php echo e($candidato->votos_count); ?> votos</span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Ganadores -->
        <?php if($personeros->count() > 0 || $contralores->count() > 0): ?>
            <div class="grid md:grid-cols-2 gap-8">
                <?php if($personeros->first()): ?>
                    <div class="card text-center py-8 border-4 border-green-500">
                        <div class="text-5xl mb-4">👑</div>
                        <h3 class="text-xl font-bold text-gray-600 mb-2">Ganador Personero</h3>
                        <p class="text-3xl font-bold text-green-600"><?php echo e($personeros->first()->nombre); ?></p>
                        <p class="text-gray-500 mt-2"><?php echo e($personeros->first()->votos_count); ?> votos</p>
                    </div>
                <?php endif; ?>

                <?php if($contralores->first()): ?>
                    <div class="card text-center py-8 border-4 border-yellow-500">
                        <div class="text-5xl mb-4">👑</div>
                        <h3 class="text-xl font-bold text-gray-600 mb-2">Ganador Contralor</h3>
                        <p class="text-3xl font-bold text-yellow-600"><?php echo e($contralores->first()->nombre); ?></p>
                        <p class="text-gray-500 mt-2"><?php echo e($contralores->first()->votos_count); ?> votos</p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            // Colores institucionales
            const colorsGreen = ['#2E7D32', '#4CAF50', '#81C784', '#A5D6A7'];
            const colorsYellow = ['#F9A825', '#FBC02D', '#FFEB3B', '#FFF176'];

            // Gráfico Personeros
            new Chart(document.getElementById('chartPersoneros'), {
                type: 'doughnut',
                data: {
                    labels: <?php echo json_encode($chartDataPersoneros['labels'], 15, 512) ?>,
                    datasets: [{
                        data: <?php echo json_encode($chartDataPersoneros['data'], 15, 512) ?>,
                        backgroundColor: colorsGreen,
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });

            // Gráfico Contralores
            new Chart(document.getElementById('chartContralores'), {
                type: 'doughnut',
                data: {
                    labels: <?php echo json_encode($chartDataContralores['labels'], 15, 512) ?>,
                    datasets: [{
                        data: <?php echo json_encode($chartDataContralores['data'], 15, 512) ?>,
                        backgroundColor: colorsYellow,
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/resultados.blade.php ENDPATH**/ ?>