<?php $__env->startSection('title', 'Gestión de Sedes'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-gray-800">Sedes</h1>
            <a href="<?php echo e(route('admin.sedes.create')); ?>" class="btn-primary">+ Nueva Sede</a>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__empty_1 = true; $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card">
                    <div class="flex items-start justify-between mb-4">
                        <div>
                            <h3 class="text-xl font-bold"><?php echo e($sede->nombre); ?></h3>
                            <p class="text-gray-500 text-sm"><?php echo e($sede->direccion ?: 'Sin dirección'); ?></p>
                        </div>
                        <span class="badge <?php echo e($sede->activa ? 'badge-green' : 'badge-red'); ?>">
                            <?php echo e($sede->activa ? 'Activa' : 'Inactiva'); ?>

                        </span>
                    </div>

                    <!-- Link público -->
                    <?php if($sede->slug): ?>
                        <div class="mb-4 p-3 bg-green-50 rounded-xl">
                            <p class="text-xs text-gray-500 mb-1">Link público para votar:</p>
                            <a href="<?php echo e(route('sede.votar', $sede)); ?>" target="_blank"
                                class="text-green-600 font-mono text-sm hover:underline break-all">
                                <?php echo e(url('/sede/' . $sede->slug)); ?>

                            </a>
                        </div>
                    <?php else: ?>
                        <div class="mb-4 p-3 bg-yellow-50 rounded-xl">
                            <p class="text-yellow-700 text-sm">⚠️ Sin slug. Edita para agregar link público.</p>
                        </div>
                    <?php endif; ?>

                    <div class="grid grid-cols-2 gap-4 mb-6">
                        <div class="text-center p-3 bg-gray-50 rounded-xl">
                            <div class="text-2xl font-bold text-green-600"><?php echo e($sede->grados_count); ?></div>
                            <div class="text-xs text-gray-500">Grados</div>
                        </div>
                        <div class="text-center p-3 bg-gray-50 rounded-xl">
                            <div class="text-2xl font-bold text-yellow-600"><?php echo e($sede->candidatos_count); ?></div>
                            <div class="text-xs text-gray-500">Candidatos</div>
                        </div>
                    </div>

                    <div class="flex gap-2">
                        <a href="<?php echo e(route('admin.sedes.edit', $sede->id)); ?>"
                            class="btn-secondary text-sm flex-1 text-center">Editar</a>
                        <form action="<?php echo e(route('admin.sedes.destroy', $sede->id)); ?>" method="POST" class="flex-1"
                            onsubmit="return confirm('¿Eliminar esta sede?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn-danger text-sm w-full">Eliminar</button>
                        </form>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-full text-center py-12 text-gray-500">
                    <p class="text-xl mb-4">No hay sedes registradas</p>
                    <a href="<?php echo e(route('admin.sedes.create')); ?>" class="btn-primary">Crear Primera Sede</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/sedes/index.blade.php ENDPATH**/ ?>