<?php $__env->startSection('title', 'Gestión de Grados'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-gray-800">Grados</h1>
            <a href="<?php echo e(route('admin.grados.create')); ?>" class="btn-primary">+ Nuevo Grado</a>
        </div>

        <?php if(session('error')): ?>
            <div class="alert alert-error"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <div class="card overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Grado</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Sede</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Nivel</th>
                        <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Estudiantes</th>
                        <th class="px-4 py-3 text-right text-sm font-semibold text-gray-600">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $grados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 font-medium"><?php echo e($grado->nombre); ?></td>
                            <td class="px-4 py-3 text-gray-600"><?php echo e($grado->sede->nombre); ?></td>
                            <td class="px-4 py-3">
                                <span class="badge badge-blue"><?php echo e($grado->nivel); ?>°</span>
                            </td>
                            <td class="px-4 py-3"><?php echo e($grado->users_count); ?></td>
                            <td class="px-4 py-3 text-right">
                                <div class="flex justify-end gap-2">
                                    <a href="<?php echo e(route('admin.grados.edit', $grado)); ?>" class="btn-secondary text-sm">Editar</a>
                                    <form action="<?php echo e(route('admin.grados.destroy', $grado)); ?>" method="POST"
                                        onsubmit="return confirm('¿Eliminar este grado?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn-danger text-sm">Eliminar</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-4 py-8 text-center text-gray-500">No hay grados registrados</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/grados/index.blade.php ENDPATH**/ ?>