<?php $__env->startSection('title', 'Nuevo Grado'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nuevo Grado</h1>

        <form action="<?php echo e(route('admin.grados.store')); ?>" method="POST" class="card space-y-6">
            <?php echo csrf_field(); ?>

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" class="form-input" required>
                    <option value="">Seleccionar sede</option>
                    <?php $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sede->id); ?>" <?php echo e(old('sede_id') == $sede->id ? 'selected' : ''); ?>>
                            <?php echo e($sede->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['sede_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Nombre del Grado *</label>
                <input type="text" name="nombre" value="<?php echo e(old('nombre')); ?>" class="form-input" placeholder="Ej: 10° A"
                    required>
                <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Nivel (1-12) *</label>
                <input type="number" name="nivel" value="<?php echo e(old('nivel')); ?>" class="form-input" min="1" max="12"
                    placeholder="Ej: 10" required>
                <p class="text-gray-500 text-sm mt-1">Número del grado (primero=1, segundo=2, etc.)</p>
                <?php $__errorArgs = ['nivel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Grado</button>
                <a href="<?php echo e(route('admin.grados.index')); ?>" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/grados/create.blade.php ENDPATH**/ ?>