<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voto Confirmado - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="max-w-xl mx-auto text-center px-6">
        <div class="bg-white rounded-3xl p-12 shadow-2xl">
            <div class="confirmation-icon mx-auto mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"
                    class="w-16 h-16 text-white">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
            </div>

            <h1 class="text-4xl font-bold text-green-600 mb-4">¡Voto Registrado!</h1>

            <p class="text-xl text-gray-600 mb-8">
                Tu voto ha sido registrado exitosamente.<br>
                <span class="text-gray-500">Gracias por participar en las elecciones estudiantiles.</span>
            </p>

            <img src="<?php echo e(asset('logo.jpg')); ?>" alt="Logo I.E. Las Huacas"
                class="w-24 h-24 mx-auto mb-8 rounded-full bg-white shadow-lg object-contain p-2">

            <a href="<?php echo e(route('home')); ?>" class="btn-primary inline-block">
                Volver al Inicio
            </a>

            <p class="text-gray-400 text-sm mt-8 italic">
                "Armonía - Ciencia - Trabajo"
            </p>
        </div>
    </div>
</body>

</html><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/votacion/confirmacion-publica.blade.php ENDPATH**/ ?>