<?php $__env->startSection('title', 'Gestión de Estudiantes'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <h1 class="text-3xl font-bold text-gray-800">Estudiantes</h1>
            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.estudiantes.create')); ?>" class="btn-primary">+ Nuevo Estudiante</a>
            </div>
        </div>

        <!-- Acciones Masivas -->
        <div class="card">
            <div class="flex flex-wrap gap-4 items-center">
                <form action="<?php echo e(route('admin.estudiantes.habilitar-todos')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-secondary"
                        onclick="return confirm('¿Habilitar todos los estudiantes para votar?')">
                        Habilitar Todos
                    </button>
                </form>
                <form action="<?php echo e(route('admin.estudiantes.resetear-votos')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-danger"
                        onclick="return confirm('¿Resetear los votos de todos los estudiantes? Esta acción no se puede deshacer.')">
                        Resetear Votos
                    </button>
                </form>
            </div>
        </div>

        <!-- Filtros -->
        <form method="GET" class="card">
            <div class="flex flex-wrap gap-4 items-end">
                <div>
                    <label class="form-label">Grado</label>
                    <select name="grado_id" class="form-input w-auto">
                        <option value="">Todos</option>
                        <?php $__currentLoopData = $grados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($grado->id); ?>" <?php echo e(request('grado_id') == $grado->id ? 'selected' : ''); ?>>
                                <?php echo e($grado->nombre); ?> - <?php echo e($grado->sede->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="form-label">Estado</label>
                    <select name="habilitado" class="form-input w-auto">
                        <option value="">Todos</option>
                        <option value="1" <?php echo e(request('habilitado') === '1' ? 'selected' : ''); ?>>Habilitados</option>
                        <option value="0" <?php echo e(request('habilitado') === '0' ? 'selected' : ''); ?>>No Habilitados</option>
                    </select>
                </div>
                <button type="submit" class="btn-secondary">Filtrar</button>
            </div>
        </form>

        <!-- Tabla -->
        <div class="table-container overflow-x-auto">
            <table class="w-full">
                <thead class="table-header">
                    <tr>
                        <th>Nombre</th>
                        <th>Documento</th>
                        <th>Grado</th>
                        <th>Sede</th>
                        <th>Estado</th>
                        <th>Personero</th>
                        <th>Contralor</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estudiante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="table-row">
                            <td class="font-semibold"><?php echo e($estudiante->name); ?></td>
                            <td><?php echo e($estudiante->documento); ?></td>
                            <td><?php echo e($estudiante->grado?->nombre ?? '-'); ?></td>
                            <td><?php echo e($estudiante->grado?->sede?->nombre ?? '-'); ?></td>
                            <td>
                                <span class="badge <?php echo e($estudiante->habilitado ? 'badge-green' : 'badge-red'); ?>">
                                    <?php echo e($estudiante->habilitado ? 'Habilitado' : 'No Habilitado'); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($estudiante->ha_votado_personero): ?>
                                    <span class="text-green-600">✓</span>
                                <?php else: ?>
                                    <span class="text-gray-300">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($estudiante->ha_votado_contralor): ?>
                                    <span class="text-green-600">✓</span>
                                <?php else: ?>
                                    <span class="text-gray-300">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="flex gap-2">
                                <a href="<?php echo e(route('admin.estudiantes.edit', $estudiante)); ?>"
                                    class="btn-secondary text-sm px-3 py-1">Editar</a>
                                <form action="<?php echo e(route('admin.estudiantes.destroy', $estudiante)); ?>" method="POST"
                                    onsubmit="return confirm('¿Eliminar este estudiante?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-danger text-sm px-3 py-1">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-8 text-gray-500">No hay estudiantes registrados</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="text-gray-500 text-sm">
            Total: <?php echo e($estudiantes->count()); ?> estudiantes
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/estudiantes/index.blade.php ENDPATH**/ ?>