<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Votar - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="antialiased min-h-screen">
    <!-- Header simple -->
    <header class="header">
        <div class="max-w-7xl mx-auto flex items-center justify-between">
            <a href="<?php echo e(route('home')); ?>" class="flex items-center gap-4">
                <img src="<?php echo e(asset('logo.jpg')); ?>" alt="Logo"
                    class="h-14 w-14 rounded-full bg-white p-1 object-contain">
                <div class="hidden md:block">
                    <h1 class="text-white font-bold text-xl">I.E. Las Huacas</h1>
                    <p class="text-white/70 text-sm">Elecciones Estudiantiles</p>
                </div>
            </a>

            <a href="<?php echo e(route('home')); ?>" class="nav-link">
                ← Salir
            </a>
        </div>
    </header>

    <main class="py-8 px-4">
        <div class="max-w-6xl mx-auto">
            <!-- Info del estudiante -->
            <div class="card mb-8">
                <div class="flex items-center justify-between flex-wrap gap-4">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-800"><?php echo e($estudiante->name); ?></h2>
                        <p class="text-gray-600"><?php echo e($estudiante->grado?->nombre); ?> - <?php echo e($sede->nombre); ?></p>
                        <p class="text-gray-400 text-sm">Documento: <?php echo e($estudiante->documento); ?></p>
                    </div>
                    <div class="flex gap-4">
                        <?php if($estudiante->ha_votado_personero): ?>
                            <span class="badge badge-green">✓ Ya votaste por Personero</span>
                        <?php endif; ?>
                        <?php if($estudiante->ha_votado_contralor): ?>
                            <span class="badge badge-green">✓ Ya votaste por Contralor</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if($estudiante->ha_votado_personero && $estudiante->ha_votado_contralor): ?>
                <!-- Ya votó por ambos -->
                <div class="confirmation-container">
                    <div class="confirmation-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"
                            class="w-16 h-16 text-white">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                    </div>
                    <h1 class="confirmation-title">¡Ya completaste tu votación!</h1>
                    <p class="text-xl text-gray-600 mb-8">
                        Tu voto ya fue registrado. Gracias por participar.
                    </p>
                    <a href="<?php echo e(route('home')); ?>" class="btn-secondary">Volver al Inicio</a>
                </div>
            <?php else: ?>
                <form action="<?php echo e(route('votar.registrar')); ?>" method="POST" id="votacion-form">
                    <?php echo csrf_field(); ?>

                    <!-- Sección Personero -->
                    <?php if(!$estudiante->ha_votado_personero && $personeros->count() > 0): ?>
                        <div class="voting-section">
                            <h2 class="voting-section-title mb-12">Elige tu Personero</h2>

                            <div class="grid md:grid-cols-2 gap-8">
                                <?php $__currentLoopData = $personeros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $personero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="candidate-card" data-type="personero" data-id="<?php echo e($personero->id); ?>"
                                        onclick="selectCandidate(this, 'personero', <?php echo e($personero->id); ?>)">
                                        <?php if($personero->foto): ?>
                                            <img src="<?php echo e(asset('storage/' . $personero->foto)); ?>" alt="<?php echo e($personero->nombre); ?>"
                                                class="candidate-photo">
                                        <?php else: ?>
                                            <div
                                                class="candidate-photo bg-gradient-to-br from-green-400 to-green-600 flex items-center justify-center text-white text-5xl font-bold">
                                                <?php echo e(strtoupper(substr($personero->nombre, 0, 2))); ?>

                                            </div>
                                        <?php endif; ?>

                                        <span class="candidate-badge personero">Personero</span>
                                        <h3 class="candidate-name"><?php echo e($personero->nombre); ?></h3>

                                        <?php if($personero->propuestas): ?>
                                            <p class="text-gray-600 text-sm mt-4 text-left">
                                                <strong>Propuestas:</strong><br>
                                                <?php echo e(Str::limit($personero->propuestas, 200)); ?>

                                            </p>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <input type="hidden" name="personero_id" id="personero_id" value="">
                        </div>
                    <?php endif; ?>

                    <!-- Sección Contralor -->
                    <?php if(!$estudiante->ha_votado_contralor && $contralores->count() > 0): ?>
                        <div class="voting-section mt-12">
                            <h2 class="voting-section-title mb-12">Elige tu Contralor</h2>

                            <div class="grid md:grid-cols-2 gap-8">
                                <?php $__currentLoopData = $contralores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contralor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="candidate-card" data-type="contralor" data-id="<?php echo e($contralor->id); ?>"
                                        onclick="selectCandidate(this, 'contralor', <?php echo e($contralor->id); ?>)">
                                        <?php if($contralor->foto): ?>
                                            <img src="<?php echo e(asset('storage/' . $contralor->foto)); ?>" alt="<?php echo e($contralor->nombre); ?>"
                                                class="candidate-photo">
                                        <?php else: ?>
                                            <div
                                                class="candidate-photo bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center text-white text-5xl font-bold">
                                                <?php echo e(strtoupper(substr($contralor->nombre, 0, 2))); ?>

                                            </div>
                                        <?php endif; ?>

                                        <span class="candidate-badge contralor">Contralor</span>
                                        <h3 class="candidate-name"><?php echo e($contralor->nombre); ?></h3>

                                        <?php if($contralor->propuestas): ?>
                                            <p class="text-gray-600 text-sm mt-4 text-left">
                                                <strong>Propuestas:</strong><br>
                                                <?php echo e(Str::limit($contralor->propuestas, 200)); ?>

                                            </p>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <input type="hidden" name="contralor_id" id="contralor_id" value="">
                        </div>
                    <?php endif; ?>

                    <!-- Botón de Votar -->
                    <div class="mt-12 text-center">
                        <button type="submit" class="btn-primary text-xl px-12 py-4" id="btn-votar" disabled>
                            Confirmar Voto
                        </button>
                        <p class="text-gray-500 text-sm mt-4">Selecciona tus candidatos para habilitar el botón</p>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </main>

    <script>
        function selectCandidate(card, type, id) {
            document.querySelectorAll(`.candidate-card[data-type="${type}"]`).forEach(c => {
                c.classList.remove('selected');
            });

            card.classList.add('selected');
            document.getElementById(`${type}_id`).value = id;
            checkVoteButton();
        }

        function checkVoteButton() {
            const personeroId = document.getElementById('personero_id')?.value;
            const contralorId = document.getElementById('contralor_id')?.value;
            const btnVotar = document.getElementById('btn-votar');

            if (btnVotar) {
                btnVotar.disabled = !(personeroId || contralorId);
            }
        }

        document.getElementById('votacion-form')?.addEventListener('submit', function (e) {
            if (!confirm('¿Estás seguro de confirmar tu voto? Esta acción no se puede deshacer.')) {
                e.preventDefault();
            }
        });
    </script>
</body>

</html><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/votacion/publica.blade.php ENDPATH**/ ?>