<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Votación <?php echo e($sede->nombre); ?> - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            min-height: 100vh;
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #43A047 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            width: 100%;
            max-width: 360px;
        }

        .logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: white;
            padding: 4px;
            margin: 0 auto 12px;
            object-fit: contain;
        }

        .title {
            font-size: 1.1rem;
            font-weight: 700;
            color: white;
            margin-bottom: 2px;
        }

        .subtitle {
            font-size: 0.75rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 16px;
        }

        .card {
            background: white;
            border-radius: 20px;
            padding: 24px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }

        .card-title {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 4px;
        }

        .card-subtitle {
            font-size: 0.7rem;
            color: #888;
            margin-bottom: 16px;
        }

        .input {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 1.1rem;
            text-align: center;
            letter-spacing: 2px;
            margin-bottom: 12px;
            transition: border-color 0.2s;
        }

        .input:focus {
            outline: none;
            border-color: #2E7D32;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #2E7D32, #43A047);
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(46, 125, 50, 0.4);
        }

        .alert {
            background: #fee2e2;
            color: #b91c1c;
            padding: 10px 14px;
            border-radius: 10px;
            font-size: 0.75rem;
            margin-bottom: 12px;
        }

        .candidates {
            margin-top: 16px;
            padding-top: 16px;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            font-size: 0.65rem;
            color: rgba(255, 255, 255, 0.8);
        }

        .candidates strong {
            display: block;
            font-size: 0.7rem;
            margin-bottom: 4px;
        }

        .admin-link {
            display: block;
            text-align: center;
            margin-top: 16px;
            font-size: 0.65rem;
            color: rgba(255, 255, 255, 0.5);
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container text-center">
        <img src="<?php echo e(asset('logo.jpg')); ?>" alt="Logo" class="logo">
        <div class="title">I.E. Las Huacas</div>
        <div class="subtitle"><?php echo e($sede->nombre); ?></div>

        <?php if(session('error')): ?>
            <div class="alert"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-title">Ingresa tu Documento</div>
            <div class="card-subtitle">Para acceder a la votación</div>

            <form action="<?php echo e(route('sede.votar.verificar', $sede)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="text" name="documento" class="input" placeholder="Ej: 1001234567" autofocus required>
                <button type="submit" class="btn">Ingresar</button>
            </form>
        </div>

        <a href="<?php echo e(route('home')); ?>"
            style="display: block; text-align: center; margin-top: 16px; color: rgba(255,255,255,0.7); font-size: 0.85rem; text-decoration: none;">
            ← Regresar
        </a>

    </div>
</body>

</html><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/votacion/sede.blade.php ENDPATH**/ ?>