<?php $__env->startSection('title', 'Gestión de Candidatos'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <div class="flex items-center justify-between">
            <h1 class="text-3xl font-bold text-gray-800">Candidatos</h1>
            <a href="<?php echo e(route('admin.candidatos.create')); ?>" class="btn-primary">+ Nuevo Candidato</a>
        </div>

        <div class="table-container overflow-x-auto">
            <table class="w-full">
                <thead class="table-header">
                    <tr>
                        <th>Foto</th>
                        <th>Nombre</th>
                        <th>Tipo</th>
                        <th>Sede</th>
                        <th>Votos</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $candidatos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="table-row">
                            <td>
                                <?php if($candidato->foto): ?>
                                    <img src="<?php echo e(asset('storage/' . $candidato->foto)); ?>"
                                        class="w-12 h-12 rounded-full object-cover">
                                <?php else: ?>
                                    <div
                                        class="w-12 h-12 rounded-full bg-gradient-to-br <?php echo e($candidato->tipo === 'personero' ? 'from-green-400 to-green-600' : 'from-yellow-400 to-yellow-600'); ?> flex items-center justify-center text-white font-bold">
                                        <?php echo e(strtoupper(substr($candidato->nombre, 0, 2))); ?>

                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="font-semibold"><?php echo e($candidato->nombre); ?></td>
                            <td>
                                <span class="badge <?php echo e($candidato->tipo === 'personero' ? 'badge-green' : 'badge-yellow'); ?>">
                                    <?php echo e(ucfirst($candidato->tipo)); ?>

                                </span>
                            </td>
                            <td><?php echo e($candidato->sede->nombre); ?></td>
                            <td class="font-bold"><?php echo e($candidato->votos_count); ?></td>
                            <td>
                                <span class="badge <?php echo e($candidato->activo ? 'badge-green' : 'badge-red'); ?>">
                                    <?php echo e($candidato->activo ? 'Activo' : 'Inactivo'); ?>

                                </span>
                            </td>
                            <td class="flex gap-2">
                                <a href="<?php echo e(route('admin.candidatos.edit', $candidato)); ?>"
                                    class="btn-secondary text-sm px-3 py-1">Editar</a>
                                <form action="<?php echo e(route('admin.candidatos.destroy', $candidato)); ?>" method="POST"
                                    onsubmit="return confirm('¿Eliminar este candidato?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-danger text-sm px-3 py-1">Eliminar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-8 text-gray-500">No hay candidatos registrados</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/candidatos/index.blade.php ENDPATH**/ ?>