<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Votación - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            min-height: 100vh;
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #43A047 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }

        .container {
            width: 100%;
            max-width: 500px;
            text-align: center;
        }

        .logo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: white;
            padding: 6px;
            margin: 0 auto 14px;
            object-fit: contain;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .title {
            font-size: 1.4rem;
            font-weight: 700;
            color: white;
        }

        .subtitle {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.85);
            margin-bottom: 6px;
        }

        .motto {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
            font-style: italic;
            margin-bottom: 20px;
        }

        .card {
            background: white;
            border-radius: 20px;
            padding: 28px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }

        .card-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 16px;
        }

        .sede-btn {
            display: block;
            width: 100%;
            padding: 16px 20px;
            margin-bottom: 12px;
            background: linear-gradient(135deg, #f8fafc, #f1f5f9);
            border: 2px solid #e2e8f0;
            border-radius: 14px;
            font-size: 1rem;
            font-weight: 600;
            color: #1e293b;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            text-align: center;
        }

        .sede-btn:hover {
            background: linear-gradient(135deg, #2E7D32, #43A047);
            border-color: #2E7D32;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(46, 125, 50, 0.3);
        }

        .sede-btn:last-child {
            margin-bottom: 0;
        }

        .winner-card {
            background: linear-gradient(135deg, #f0fdf4, #fefce8);
            border: 2px solid #86efac;
            border-radius: 16px;
            padding: 20px;
            margin-bottom: 16px;
        }

        .winner-photo {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #22c55e;
            margin: 0 auto 8px;
        }

        .closed-badge {
            background: #ef4444;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            display: inline-block;
            margin-bottom: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        <img src="<?php echo e(asset('logo.jpg')); ?>" alt="Logo" class="logo">
        <div class="title">I.E. Las Huacas</div>
        <div class="subtitle">Elecciones Estudiantiles 2026</div>
        <div class="motto">"Armonía - Ciencia - Trabajo"</div>

        <?php if($votacionAbierta): ?>
            <!-- Votación Abierta - Selección de Sede -->
            <div class="card">
                <div class="card-title">Selecciona tu Sede</div>

                <?php $__empty_1 = true; $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('sede.votar', $sede)); ?>" class="sede-btn">
                        🏫 <?php echo e($sede->nombre); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p style="color: #888; font-size: 0.9rem;">No hay sedes disponibles para votar.</p>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <!-- Votación Cerrada - Mostrar Resultados -->
            <div class="closed-badge">🔒 Votación Cerrada</div>

            <div class="card">
                <div class="card-title">🏆 Resultados Oficiales</div>

                <?php $__currentLoopData = $resultados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="winner-card">
                        <h3 style="font-weight: 700; color: #1f2937; margin-bottom: 12px;"><?php echo e($data['sede']->nombre); ?></h3>

                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
                            <!-- Personero Ganador -->
                            <div style="text-align: center;">
                                <div style="font-size: 0.7rem; color: #16a34a; font-weight: 600; margin-bottom: 6px;">🎓
                                    PERSONERO</div>
                                <?php if($data['personero']): ?>
                                    <?php if($data['personero']->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $data['personero']->foto)); ?>" class="winner-photo">
                                    <?php else: ?>
                                        <div class="winner-photo"
                                            style="background: linear-gradient(135deg, #22c55e, #16a34a); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 1.2rem;">
                                            <?php echo e(strtoupper(substr($data['personero']->nombre, 0, 2))); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div style="font-weight: 600; font-size: 0.9rem;"><?php echo e($data['personero']->nombre); ?></div>
                                    <div style="color: #16a34a; font-size: 0.8rem;"><?php echo e($data['personero']->votos_count); ?> votos
                                    </div>
                                <?php else: ?>
                                    <div style="color: #9ca3af; font-size: 0.8rem;">Sin candidatos</div>
                                <?php endif; ?>
                            </div>

                            <!-- Contralor Ganador -->
                            <div style="text-align: center;">
                                <div style="font-size: 0.7rem; color: #ca8a04; font-weight: 600; margin-bottom: 6px;">📋
                                    CONTRALOR</div>
                                <?php if($data['contralor']): ?>
                                    <?php if($data['contralor']->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $data['contralor']->foto)); ?>" class="winner-photo"
                                            style="border-color: #eab308;">
                                    <?php else: ?>
                                        <div class="winner-photo"
                                            style="border-color: #eab308; background: linear-gradient(135deg, #eab308, #ca8a04); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 1.2rem;">
                                            <?php echo e(strtoupper(substr($data['contralor']->nombre, 0, 2))); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div style="font-weight: 600; font-size: 0.9rem;"><?php echo e($data['contralor']->nombre); ?></div>
                                    <div style="color: #ca8a04; font-size: 0.8rem;"><?php echo e($data['contralor']->votos_count); ?> votos
                                    </div>
                                <?php else: ?>
                                    <div style="color: #9ca3af; font-size: 0.8rem;">Sin candidatos</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</body>

</html><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/welcome.blade.php ENDPATH**/ ?>