<?php $__env->startSection('title', 'Editar Estudiante'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Editar Estudiante</h1>

        <form action="<?php echo e(route('admin.estudiantes.update', $estudiante)); ?>" method="POST" class="card space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="name" value="<?php echo e(old('name', $estudiante->name)); ?>" class="form-input" required>
            </div>

            <div>
                <label class="form-label">Número de Documento *</label>
                <input type="text" name="documento" value="<?php echo e(old('documento', $estudiante->documento)); ?>"
                    class="form-input" required>
            </div>

            <div>
                <label class="form-label">Correo Electrónico</label>
                <input type="email" name="email" value="<?php echo e(old('email', $estudiante->email)); ?>" class="form-input">
            </div>

            <div>
                <label class="form-label">Grado *</label>
                <select name="grado_id" class="form-input" required>
                    <?php $__currentLoopData = $grados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($grado->id); ?>" <?php echo e($estudiante->grado_id == $grado->id ? 'selected' : ''); ?>>
                            <?php echo e($grado->nombre); ?> - <?php echo e($grado->sede->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="habilitado" value="1" <?php echo e($estudiante->habilitado ? 'checked' : ''); ?>

                        class="w-5 h-5 rounded">
                    <span class="font-medium">Habilitar para votar</span>
                </label>
            </div>

            <!-- Estado de Votación -->
            <div class="p-4 bg-gray-50 rounded-xl">
                <h3 class="font-semibold mb-3">Estado de Votación</h3>
                <div class="space-y-2">
                    <div class="flex items-center justify-between">
                        <span>Voto Personero:</span>
                        <?php if($estudiante->ha_votado_personero): ?>
                            <span class="badge badge-green">✓ Registrado</span>
                        <?php else: ?>
                            <span class="badge badge-yellow">Pendiente</span>
                        <?php endif; ?>
                    </div>
                    <div class="flex items-center justify-between">
                        <span>Voto Contralor:</span>
                        <?php if($estudiante->ha_votado_contralor): ?>
                            <span class="badge badge-green">✓ Registrado</span>
                        <?php else: ?>
                            <span class="badge badge-yellow">Pendiente</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Actualizar Estudiante</button>
                <a href="<?php echo e(route('admin.estudiantes.index')); ?>" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/estudiantes/edit.blade.php ENDPATH**/ ?>