<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="space-y-6">
        <!-- Estado de Votación -->
        <div
            class="card flex items-center justify-between <?php echo e($votacionAbierta ? 'bg-green-50 border-green-200' : 'bg-red-50 border-red-200'); ?> border-2">
            <div class="flex items-center gap-4">
                <div class="text-4xl"><?php echo e($votacionAbierta ? '🟢' : '🔴'); ?></div>
                <div>
                    <h2 class="font-bold text-lg"><?php echo e($votacionAbierta ? 'Votación Abierta' : 'Votación Cerrada'); ?></h2>
                    <p class="text-sm text-gray-600">
                        <?php echo e($votacionAbierta ? 'Los estudiantes pueden votar' : 'Los resultados son públicos'); ?></p>
                </div>
            </div>
            <form action="<?php echo e(route('admin.toggle-votacion')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit"
                    class="<?php echo e($votacionAbierta ? 'bg-red-500 hover:bg-red-600' : 'bg-green-500 hover:bg-green-600'); ?> text-white font-bold py-3 px-6 rounded-xl transition-colors"
                    onclick="return confirm('<?php echo e($votacionAbierta ? '¿Cerrar votación? Los resultados se harán públicos.' : '¿Abrir votación nuevamente?'); ?>')">
                    <?php echo e($votacionAbierta ? '🔒 Cerrar Votación' : '🔓 Abrir Votación'); ?>

                </button>
            </form>
        </div>

        <!-- Gráficas de Estadísticas -->
        <div class="grid md:grid-cols-2 gap-6">
            <!-- Gráfica de Participación -->
            <div class="card">
                <h3 class="font-bold text-gray-700 mb-4">📊 Participación General</h3>
                <canvas id="participacionChart" height="200"></canvas>
            </div>

            <!-- Gráfica de Votos -->
            <div class="card">
                <h3 class="font-bold text-gray-700 mb-4">🗳️ Votos Emitidos</h3>
                <canvas id="votosChart" height="200"></canvas>
            </div>
        </div>

        <!-- Ganadores por Sede -->
        <div class="card">
            <h2 class="text-xl font-bold text-gray-800 mb-4">🏆 Ganadores por Sede</h2>

            <div class="grid md:grid-cols-2 gap-6">
                <?php $__currentLoopData = $resultadosPorSede; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-4 bg-gradient-to-br from-green-50 to-yellow-50 rounded-2xl border border-green-100">
                        <h3 class="font-bold text-lg text-gray-800 mb-4 text-center"><?php echo e($data['sede']->nombre); ?></h3>

                        <div class="grid grid-cols-2 gap-4">
                            <!-- Ganador Personero -->
                            <div class="text-center">
                                <div class="text-xs text-green-600 font-semibold uppercase mb-2">🎓 Personero</div>
                                <?php $ganadorP = $data['personeros']->first(); ?>
                                <?php if($ganadorP): ?>
                                    <?php if($ganadorP->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $ganadorP->foto)); ?>"
                                            class="w-20 h-20 rounded-full mx-auto mb-2 object-cover border-4 border-green-400 shadow-lg">
                                    <?php else: ?>
                                        <div
                                            class="w-20 h-20 rounded-full mx-auto mb-2 bg-gradient-to-br from-green-400 to-green-600 flex items-center justify-center text-white text-2xl font-bold border-4 border-green-400 shadow-lg">
                                            <?php echo e(strtoupper(substr($ganadorP->nombre, 0, 2))); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="font-bold text-gray-800"><?php echo e($ganadorP->nombre); ?></div>
                                    <div class="text-green-600 font-semibold"><?php echo e($ganadorP->votos_count); ?> votos</div>
                                <?php else: ?>
                                    <div
                                        class="w-20 h-20 rounded-full mx-auto mb-2 bg-gray-200 flex items-center justify-center text-gray-400">
                                        ?
                                    </div>
                                    <div class="text-gray-400 text-sm">Sin candidatos</div>
                                <?php endif; ?>
                            </div>

                            <!-- Ganador Contralor -->
                            <div class="text-center">
                                <div class="text-xs text-yellow-600 font-semibold uppercase mb-2">📋 Contralor</div>
                                <?php $ganadorC = $data['contralores']->first(); ?>
                                <?php if($ganadorC): ?>
                                    <?php if($ganadorC->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $ganadorC->foto)); ?>"
                                            class="w-20 h-20 rounded-full mx-auto mb-2 object-cover border-4 border-yellow-400 shadow-lg">
                                    <?php else: ?>
                                        <div
                                            class="w-20 h-20 rounded-full mx-auto mb-2 bg-gradient-to-br from-yellow-400 to-yellow-600 flex items-center justify-center text-white text-2xl font-bold border-4 border-yellow-400 shadow-lg">
                                            <?php echo e(strtoupper(substr($ganadorC->nombre, 0, 2))); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="font-bold text-gray-800"><?php echo e($ganadorC->nombre); ?></div>
                                    <div class="text-yellow-600 font-semibold"><?php echo e($ganadorC->votos_count); ?> votos</div>
                                <?php else: ?>
                                    <div
                                        class="w-20 h-20 rounded-full mx-auto mb-2 bg-gray-200 flex items-center justify-center text-gray-400">
                                        ?
                                    </div>
                                    <div class="text-gray-400 text-sm">Sin candidatos</div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Participación -->
                        <div class="mt-4 pt-4 border-t border-green-200">
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-gray-500">Participación</span>
                                <span class="font-bold text-green-600"><?php echo e($data['porcentaje']); ?>%</span>
                            </div>
                            <div class="w-full bg-gray-200 rounded-full h-2 mt-1">
                                <div class="bg-green-500 h-2 rounded-full" style="width: <?php echo e($data['porcentaje']); ?>%"></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Resultados por Grado -->
        <div class="card">
            <h2 class="text-xl font-bold text-gray-800 mb-4">📚 Participación por Grado</h2>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Grado</th>
                            <th class="px-4 py-3 text-left text-sm font-semibold text-gray-600">Sede</th>
                            <th class="px-4 py-3 text-center text-sm font-semibold text-gray-600">Estudiantes</th>
                            <th class="px-4 py-3 text-center text-sm font-semibold text-gray-600">Votaron</th>
                            <th class="px-4 py-3 text-center text-sm font-semibold text-gray-600">Participación</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__empty_1 = true; $__currentLoopData = $resultadosPorGrado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 font-medium"><?php echo e($data['grado']->nombre); ?></td>
                                <td class="px-4 py-3 text-gray-600"><?php echo e($data['sede']); ?></td>
                                <td class="px-4 py-3 text-center"><?php echo e($data['estudiantes']); ?></td>
                                <td class="px-4 py-3 text-center">
                                    <span class="badge badge-blue"><?php echo e($data['votaron']); ?></span>
                                </td>
                                <td class="px-4 py-3">
                                    <div class="flex items-center gap-2">
                                        <div class="flex-1 bg-gray-200 rounded-full h-2">
                                            <div class="bg-green-500 h-2 rounded-full"
                                                style="width: <?php echo e($data['porcentaje']); ?>%"></div>
                                        </div>
                                        <span class="text-sm font-medium text-gray-700 w-12"><?php echo e($data['porcentaje']); ?>%</span>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="px-4 py-8 text-center text-gray-500">No hay grados con estudiantes</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Links públicos de votación -->
        <div class="card">
            <h2 class="text-xl font-bold text-gray-800 mb-4">🔗 Links Públicos de Votación</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($sede->slug): ?>
                        <div class="p-4 bg-green-50 rounded-xl">
                            <h3 class="font-semibold mb-2"><?php echo e($sede->nombre); ?></h3>
                            <a href="<?php echo e(route('sede.votar', $sede)); ?>" target="_blank"
                                class="text-green-600 text-sm hover:underline break-all">
                                <?php echo e(url('/sede/' . $sede->slug)); ?>

                            </a>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Gráfica de Participación (Dona)
        new Chart(document.getElementById('participacionChart'), {
            type: 'doughnut',
            data: {
                labels: ['Han Votado', 'No Han Votado', 'No Habilitados'],
                datasets: [{
                    data: [
                            <?php echo e($estudiantesQueVotaron); ?>,
                            <?php echo e($estudiantesHabilitados - $estudiantesQueVotaron); ?>,
                        <?php echo e($totalEstudiantes - $estudiantesHabilitados); ?>

                    ],
                    backgroundColor: ['#22c55e', '#fbbf24', '#e5e7eb'],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'bottom' }
                }
            }
        });

        // Gráfica de Votos (Barras)
        new Chart(document.getElementById('votosChart'), {
            type: 'bar',
            data: {
                labels: ['Personero', 'Contralor'],
                datasets: [{
                    label: 'Votos',
                    data: [<?php echo e($totalVotosPersonero); ?>, <?php echo e($totalVotosContralor); ?>],
                    backgroundColor: ['#22c55e', '#eab308'],
                    borderRadius: 8
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>