<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Iniciar Sesión - I.E. Las Huacas</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="antialiased min-h-screen flex items-center justify-center"
    style="background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 50%, #4CAF50 100%);">
    <div class="w-full max-w-md px-6">
        <!-- Logo y Título -->
        <div class="text-center mb-8">
            <a href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset('logo.jpg')); ?>" alt="Logo I.E. Las Huacas"
                    class="w-24 h-24 mx-auto rounded-full bg-white p-2 shadow-lg object-contain mb-4">
            </a>
            <h1 class="text-2xl font-bold text-white">Acceso Administradores</h1>
            <p class="text-white/70">I.E. Las Huacas</p>
        </div>

        <!-- Formulario -->
        <div class="bg-white rounded-3xl p-8 shadow-2xl">
            <h2 class="text-xl font-bold text-gray-800 mb-6 text-center">Iniciar Sesión</h2>

            <!-- Session Status -->
            <?php if(session('status')): ?>
                <div class="alert alert-success mb-4">
                    <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>" class="space-y-5">
                <?php echo csrf_field(); ?>

                <!-- Email -->
                <div>
                    <label for="email" class="form-label">Correo Electrónico</label>
                    <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>" class="form-input" required
                        autofocus autocomplete="username">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" id="password" name="password" class="form-input" required
                        autocomplete="current-password">
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Remember Me -->
                <div class="flex items-center justify-between">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="remember"
                            class="w-4 h-4 rounded border-gray-300 text-green-600 focus:ring-green-500">
                        <span class="text-sm text-gray-600">Recordarme</span>
                    </label>

                    <?php if(Route::has('password.request')): ?>
                        <a href="<?php echo e(route('password.request')); ?>"
                            class="text-sm text-green-600 hover:text-green-800 underline">
                            ¿Olvidaste tu contraseña?
                        </a>
                    <?php endif; ?>
                </div>

                <!-- Submit -->
                <button type="submit" class="btn-primary w-full py-3">
                    Ingresar
                </button>
            </form>
        </div>

        <!-- Link de regreso -->
        <div class="text-center mt-6">
            <a href="<?php echo e(route('home')); ?>" class="text-white/80 hover:text-white underline text-sm">
                ← Volver a la página principal
            </a>
        </div>
    </div>
</body>

</html><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/auth/login.blade.php ENDPATH**/ ?>