<?php $__env->startSection('title', 'Nuevo Estudiante'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-2xl mx-auto">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Nuevo Estudiante</h1>

        <form action="<?php echo e(route('admin.estudiantes.store')); ?>" method="POST" class="card space-y-6">
            <?php echo csrf_field(); ?>

            <div>
                <label class="form-label">Nombre Completo *</label>
                <input type="text" name="name" value="<?php echo e(old('name')); ?>" class="form-input" required>
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Número de Documento *</label>
                <input type="text" name="documento" value="<?php echo e(old('documento')); ?>" class="form-input" required>
                <p class="text-gray-500 text-sm mt-1">Este será también la contraseña del estudiante.</p>
                <?php $__errorArgs = ['documento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Sede *</label>
                <select name="sede_id" id="sede_id" class="form-input" required onchange="filtrarGrados()">
                    <option value="">Seleccionar sede</option>
                    <?php $__currentLoopData = $sedes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sede): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sede->id); ?>" <?php echo e(old('sede_id') == $sede->id ? 'selected' : ''); ?>>
                            <?php echo e($sede->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['sede_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="form-label">Grado *</label>
                <select name="grado_id" id="grado_id" class="form-input" required>
                    <option value="">Primero selecciona una sede</option>
                    <?php $__currentLoopData = $grados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($grado->id); ?>" data-sede="<?php echo e($grado->sede_id); ?>" <?php echo e(old('grado_id') == $grado->id ? 'selected' : ''); ?> style="display: none;">
                            <?php echo e($grado->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['grado_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="flex items-center gap-3">
                    <input type="checkbox" name="habilitado" value="1" <?php echo e(old('habilitado') ? 'checked' : ''); ?>

                        class="w-5 h-5 rounded">
                    <span class="font-medium">Habilitar para votar</span>
                </label>
            </div>

            <div class="flex gap-4 pt-4">
                <button type="submit" class="btn-primary">Guardar Estudiante</button>
                <a href="<?php echo e(route('admin.estudiantes.index')); ?>" class="btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>

    <script>
        function filtrarGrados() {
            const sedeId = document.getElementById('sede_id').value;
            const gradoSelect = document.getElementById('grado_id');
            const opciones = gradoSelect.querySelectorAll('option[data-sede]');

            gradoSelect.value = '';

            opciones.forEach(opt => {
                if (opt.dataset.sede === sedeId) {
                    opt.style.display = '';
                } else {
                    opt.style.display = 'none';
                }
            });

            if (sedeId) {
                gradoSelect.querySelector('option:first-child').textContent = 'Seleccionar grado';
            } else {
                gradoSelect.querySelector('option:first-child').textContent = 'Primero selecciona una sede';
            }
        }

        // Ejecutar al cargar si hay valor previo
        if (document.getElementById('sede_id').value) {
            filtrarGrados();
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/alejandrolopezmurillo/Documents/sislashuacas/resources/views/admin/estudiantes/create.blade.php ENDPATH**/ ?>